/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusFactory;
import com.intellij.util.pico.IdeaPicoContainer;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;

public class MockComponentManager
extends UserDataHolderBase
implements ComponentManager {
    private final MessageBus myMessageBus = MessageBusFactory.newMessageBus((Object)((Object)this));
    private final MutablePicoContainer myPicoContainer;
    private final Map<Class, Object> myComponents = new HashMap<Class, Object>();

    public MockComponentManager(@Nullable PicoContainer parent) {
        this.myPicoContainer = new IdeaPicoContainer(parent){

            @Nullable
            public Object getComponentInstance(Object componentKey) {
                Object o = super.getComponentInstance(componentKey);
                if (o instanceof Disposable && o != MockComponentManager.this) {
                    Disposer.register((Disposable)MockComponentManager.this, (Disposable)((Disposable)o));
                }
                return o;
            }
        };
        this.myPicoContainer.registerComponentInstance((Object)this);
    }

    public BaseComponent getComponent(String name) {
        return null;
    }

    public <T> void registerService(Class<T> serviceInterface, Class<? extends T> serviceImplementation) {
        this.myPicoContainer.unregisterComponent((Object)serviceInterface.getName());
        this.myPicoContainer.registerComponentImplementation((Object)serviceInterface.getName(), serviceImplementation);
    }

    public <T> void registerService(Class<T> serviceImplementation) {
        this.registerService(serviceImplementation, (T)serviceImplementation);
    }

    public <T> void registerService(Class<T> serviceInterface, T serviceImplementation) {
        this.myPicoContainer.registerComponentInstance((Object)serviceInterface.getName(), serviceImplementation);
    }

    public <T> void addComponent(Class<T> interfaceClass, T instance) {
        this.myComponents.put(interfaceClass, instance);
    }

    public <T> T getComponent(Class<T> interfaceClass) {
        Object o = this.myPicoContainer.getComponentInstance(interfaceClass);
        return (T)(o != null ? o : this.myComponents.get(interfaceClass));
    }

    public <T> T getComponent(Class<T> interfaceClass, T defaultImplementation) {
        return this.getComponent(interfaceClass);
    }

    @NotNull
    public Class[] getComponentInterfaces() {
        if (ArrayUtil.EMPTY_CLASS_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockComponentManager.getComponentInterfaces must not return null");
        }
        return ArrayUtil.EMPTY_CLASS_ARRAY;
    }

    public boolean hasComponent(@NotNull Class interfaceClass) {
        if (interfaceClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockComponentManager.hasComponent must not be null");
        }
        return false;
    }

    @NotNull
    public <T> T[] getComponents(Class<T> baseClass) {
        List list = this.myPicoContainer.getComponentInstancesOfType(baseClass);
        Object[] objectArray = list.toArray((Object[])Array.newInstance(baseClass, 0));
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockComponentManager.getComponents must not return null");
        }
        return objectArray;
    }

    @NotNull
    public MutablePicoContainer getPicoContainer() {
        MutablePicoContainer mutablePicoContainer = this.myPicoContainer;
        if (mutablePicoContainer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockComponentManager.getPicoContainer must not return null");
        }
        return mutablePicoContainer;
    }

    public MessageBus getMessageBus() {
        return this.myMessageBus;
    }

    public boolean isDisposed() {
        return false;
    }

    @NotNull
    public ComponentConfig[] getComponentConfigurations() {
        ComponentConfig[] componentConfigArray = new ComponentConfig[]{};
        if (componentConfigArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockComponentManager.getComponentConfigurations must not return null");
        }
        return componentConfigArray;
    }

    @Nullable
    public Object getComponent(ComponentConfig componentConfig) {
        return null;
    }

    public void dispose() {
    }

    public <T> T[] getExtensions(ExtensionPointName<T> extensionPointName) {
        throw new UnsupportedOperationException("getExtensions()");
    }

    public ComponentConfig getConfig(Class componentImplementation) {
        throw new UnsupportedOperationException("Method getConfig not implemented in " + ((Object)((Object)this)).getClass());
    }
}

