/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class ApplyPatchContext {
    private final VirtualFile myBaseDir;
    private final int mySkipTopDirs;
    private final boolean myCreateDirectories;
    private final boolean myAllowRename;
    private Map<VirtualFile, String> myPendingRenames = null;
    private final Map<VirtualFile, FilePath> myPathsBeforeRename = new HashMap<VirtualFile, FilePath>();
    private final TreeSet<String> myMissingDirectories = new TreeSet();
    private final List<FilePath> myAffectedFiles = new ArrayList<FilePath>();

    public ApplyPatchContext(VirtualFile baseDir, int skipTopDirs, boolean createDirectories, boolean allowRename) {
        this.myBaseDir = baseDir;
        this.mySkipTopDirs = skipTopDirs;
        this.myCreateDirectories = createDirectories;
        this.myAllowRename = allowRename;
    }

    public VirtualFile getBaseDir() {
        return this.myBaseDir;
    }

    public int getSkipTopDirs() {
        return this.mySkipTopDirs;
    }

    public boolean isAllowRename() {
        return this.myAllowRename;
    }

    public boolean isCreateDirectories() {
        return this.myCreateDirectories;
    }

    public ApplyPatchContext getPrepareContext() {
        return new ApplyPatchContext(this.myBaseDir, this.mySkipTopDirs, false, false);
    }

    public void addPendingRename(VirtualFile file, String newName) {
        if (this.myPendingRenames == null) {
            this.myPendingRenames = new HashMap<VirtualFile, String>();
        }
        this.myPendingRenames.put(file, newName);
    }

    public void applyPendingRenames() throws IOException {
        if (this.myPendingRenames != null) {
            for (Map.Entry<VirtualFile, String> entry : this.myPendingRenames.entrySet()) {
                VirtualFile file = entry.getKey();
                this.registerBeforeRename(file);
                file.rename(FilePatch.class, entry.getValue());
                this.addAffectedFile(file);
            }
            this.myPendingRenames = null;
        }
    }

    public void registerMissingDirectory(VirtualFile existingDir, String[] pathNameComponents, int firstMissingIndex) {
        String path = existingDir.getPath();
        for (int i = firstMissingIndex; i < pathNameComponents.length - 1; ++i) {
            path = path + "/" + pathNameComponents[i];
            this.myMissingDirectories.add(FileUtil.toSystemDependentName((String)path));
        }
    }

    public Collection<String> getMissingDirectories() {
        return Collections.unmodifiableSet(this.myMissingDirectories);
    }

    public void addAffectedFile(FilePath filePath) {
        this.myAffectedFiles.add(filePath);
    }

    public List<FilePath> getAffectedFiles() {
        return Collections.unmodifiableList(this.myAffectedFiles);
    }

    public void registerBeforeRename(VirtualFile file) {
        FilePathImpl path = new FilePathImpl(new File(file.getPath()), file.isDirectory());
        this.addAffectedFile(path);
        this.myPathsBeforeRename.put(file, path);
    }

    public FilePath getPathBeforeRename(VirtualFile file) {
        FilePath path = this.myPathsBeforeRename.get(file);
        if (path != null) {
            return path;
        }
        return new FilePathImpl(file);
    }

    public void addAffectedFile(VirtualFile file) {
        this.addAffectedFile(new FilePathImpl(new File(file.getPath()), file.isDirectory()));
    }
}

