/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;

public class DeleteToWordStartAction
extends TextComponentEditorAction {
    public DeleteToWordStartAction() {
        super((EditorActionHandler)new Handler());
    }

    private static void deleteToWordStart(Editor editor) {
        int endOffset = editor.getCaretModel().getOffset();
        EditorActionUtil.moveCaretToPreviousWord(editor, false);
        int startOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        document.deleteString(startOffset, endOffset);
    }

    private static class Handler
    extends EditorWriteActionHandler {
        private Handler() {
        }

        public void executeWriteAction(Editor editor, DataContext dataContext) {
            CommandProcessor.getInstance().setCurrentCommandGroupId(EditorActionUtil.DELETE_COMMAND_GROUP);
            DeleteToWordStartAction.deleteToWordStart(editor);
        }
    }
}

