/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Rectangle;
import java.util.concurrent.CopyOnWriteArrayList;

public class CaretModelImpl
implements CaretModel,
PrioritizedDocumentListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.CaretModelImpl");
    private final EditorImpl myEditor;
    private final CopyOnWriteArrayList<CaretListener> myCaretListeners = ContainerUtil.createEmptyCOWList();
    private LogicalPosition myLogicalCaret;
    private VisualPosition myVisibleCaret;
    private int myOffset;
    private int myVisualLineStart;
    private int myVisualLineEnd;
    private TextAttributes myTextAttributes;
    private boolean myIsInUpdate;

    public CaretModelImpl(EditorImpl editor) {
        this.myEditor = editor;
        this.myLogicalCaret = new LogicalPosition(0, 0);
        this.myVisibleCaret = new VisualPosition(0, 0);
        this.myOffset = 0;
        this.myVisualLineStart = 0;
        Document doc = editor.getDocument();
        this.myVisualLineEnd = doc.getLineCount() > 1 ? doc.getLineStartOffset(1) : (doc.getLineCount() == 0 ? 0 : doc.getLineEndOffset(0));
    }

    public void moveToVisualPosition(VisualPosition pos) {
        EditorSettings editorSettings;
        int lastLine;
        this.assertIsDispatchThread();
        this.validateCallContext();
        int column = pos.column;
        int line = pos.line;
        if (column < 0) {
            column = 0;
        }
        if (line < 0) {
            line = 0;
        }
        if ((lastLine = this.myEditor.getVisibleLineCount() - 1) <= 0) {
            lastLine = 0;
        }
        if (line > lastLine) {
            line = lastLine;
        }
        if (!(editorSettings = this.myEditor.getSettings()).isVirtualSpace() && line <= lastLine) {
            int lineEndColumn = EditorUtil.getLastVisualLineColumnNumber(this.myEditor, line);
            if (column > lineEndColumn) {
                column = lineEndColumn;
            }
            if (column < 0 && line > 0) {
                column = EditorUtil.getLastVisualLineColumnNumber(this.myEditor, --line);
            }
        }
        int oldY = this.myEditor.visibleLineNumberToYPosition(this.myVisibleCaret.line);
        this.myVisibleCaret = new VisualPosition(line, column);
        LogicalPosition oldPosition = this.myLogicalCaret;
        this.myLogicalCaret = this.myEditor.visualToLogicalPosition(this.myVisibleCaret);
        this.myOffset = this.myEditor.logicalPositionToOffset(this.myLogicalCaret);
        LOG.assertTrue(this.myOffset >= 0 && this.myOffset <= this.myEditor.getDocument().getTextLength());
        this.myVisualLineStart = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(new VisualPosition(this.myVisibleCaret.line, 0)));
        this.myVisualLineEnd = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(new VisualPosition(this.myVisibleCaret.line + 1, 0)));
        ((FoldingModelImpl)this.myEditor.getFoldingModel()).flushCaretPosition();
        this.myEditor.setLastColumnNumber(this.myVisibleCaret.column);
        this.myEditor.updateCaretCursor();
        this.requestRepaint(oldY);
        if (oldPosition.column != this.myLogicalCaret.column || oldPosition.line != this.myLogicalCaret.line) {
            CaretEvent event = new CaretEvent((Editor)this.myEditor, oldPosition, this.myLogicalCaret);
            for (CaretListener listener : this.myCaretListeners) {
                listener.caretPositionChanged(event);
            }
        }
    }

    private void assertIsDispatchThread() {
        this.myEditor.assertIsDispatchThread();
    }

    public void moveToOffset(int offset) {
        this.assertIsDispatchThread();
        this.validateCallContext();
        this.moveToLogicalPosition(this.myEditor.offsetToLogicalPosition(offset));
        if (!this.myEditor.offsetToLogicalPosition(this.myOffset).equals((Object)this.myEditor.offsetToLogicalPosition(offset))) {
            LOG.error("caret moved to wrong offset. Requested:" + offset + " but actual:" + this.myOffset);
        }
    }

    public void moveCaretRelatively(int columnShift, int lineShift, boolean withSelection, boolean blockSelection, boolean scrollToCaret) {
        this.assertIsDispatchThread();
        SelectionModel selectionModel = this.myEditor.getSelectionModel();
        int selectionStart = selectionModel.getLeadSelectionOffset();
        LogicalPosition blockSelectionStart = selectionModel.hasBlockSelection() ? selectionModel.getBlockStart() : this.getLogicalPosition();
        EditorSettings editorSettings = this.myEditor.getSettings();
        VisualPosition visualCaret = this.getVisualPosition();
        int newColumnNumber = visualCaret.column + columnShift;
        int newLineNumber = visualCaret.line + lineShift;
        if (!editorSettings.isVirtualSpace() && columnShift == 0) {
            newColumnNumber = this.myEditor.getLastColumnNumber();
        } else if (!editorSettings.isVirtualSpace() && lineShift == 0 && columnShift == 1) {
            int lastLine = this.myEditor.getDocument().getLineCount() - 1;
            if (lastLine < 0) {
                lastLine = 0;
            }
            if (EditorModificationUtil.calcAfterLineEnd((Editor)this.myEditor) >= 0 && newLineNumber < this.myEditor.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)lastLine, (int)0)).line) {
                newColumnNumber = 0;
                ++newLineNumber;
            }
        } else if (!editorSettings.isVirtualSpace() && lineShift == 0 && columnShift == -1 && newColumnNumber < 0 && newLineNumber > 0) {
            newColumnNumber = EditorUtil.getLastVisualLineColumnNumber(this.myEditor, --newLineNumber);
        }
        if (newColumnNumber < 0) {
            newColumnNumber = 0;
        }
        if (newLineNumber < 0) {
            newLineNumber = 0;
        }
        int lastColumnNumber = newColumnNumber;
        if (!editorSettings.isCaretInsideTabs()) {
            LogicalPosition log = this.myEditor.visualToLogicalPosition(new VisualPosition(newLineNumber, newColumnNumber));
            int offset = this.myEditor.logicalPositionToOffset(log);
            CharSequence text = this.myEditor.getDocument().getCharsSequence();
            if (offset >= 0 && offset < this.myEditor.getDocument().getTextLength() && text.charAt(offset) == '\t') {
                if (columnShift <= 0) {
                    newColumnNumber = this.myEditor.offsetToVisualPosition((int)offset).column;
                } else if (this.myEditor.offsetToVisualPosition((int)offset).column < newColumnNumber) {
                    newColumnNumber = this.myEditor.offsetToVisualPosition((int)(offset + 1)).column;
                }
            }
        }
        VisualPosition pos = new VisualPosition(newLineNumber, newColumnNumber);
        this.moveToVisualPosition(pos);
        if (!editorSettings.isVirtualSpace() && columnShift == 0) {
            this.myEditor.setLastColumnNumber(lastColumnNumber);
        }
        if (withSelection) {
            if (blockSelection) {
                selectionModel.setBlockSelection(blockSelectionStart, this.getLogicalPosition());
            } else {
                selectionModel.setSelection(selectionStart, this.getOffset());
            }
        } else {
            selectionModel.removeSelection();
        }
        if (scrollToCaret) {
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    public void moveToLogicalPosition(LogicalPosition pos) {
        int lineCount;
        this.assertIsDispatchThread();
        this.validateCallContext();
        int column = pos.column;
        int line = pos.line;
        Document doc = this.myEditor.getDocument();
        if (column < 0) {
            column = 0;
        }
        if (line < 0) {
            line = 0;
        }
        if ((lineCount = doc.getLineCount()) == 0) {
            line = 0;
        } else if (line > lineCount - 1) {
            line = lineCount - 1;
        }
        EditorSettings editorSettings = this.myEditor.getSettings();
        if (!editorSettings.isVirtualSpace() && line < lineCount) {
            int lineEndOffset = doc.getLineEndOffset(line);
            int lineEndColumnNumber = this.myEditor.offsetToLogicalPosition((int)lineEndOffset).column;
            if (column > lineEndColumnNumber) {
                column = lineEndColumnNumber;
            }
        }
        ((FoldingModelImpl)this.myEditor.getFoldingModel()).flushCaretPosition();
        int oldY = this.myEditor.visibleLineNumberToYPosition(this.myVisibleCaret.line);
        LogicalPosition oldCaretPosition = this.myLogicalCaret;
        this.myLogicalCaret = new LogicalPosition(line, column);
        final int offset = this.myEditor.logicalPositionToOffset(this.myLogicalCaret);
        FoldRegion collapsedAt = this.myEditor.getFoldingModel().getCollapsedRegionAtOffset(offset);
        if (collapsedAt != null && offset > collapsedAt.getStartOffset()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    FoldRegion[] allCollapsedAt;
                    for (FoldRegion foldRange : allCollapsedAt = ((FoldingModelImpl)CaretModelImpl.this.myEditor.getFoldingModel()).fetchCollapsedAt(offset)) {
                        foldRange.setExpanded(true);
                    }
                }
            };
            this.myEditor.getFoldingModel().runBatchFoldingOperation(runnable);
        }
        this.myEditor.setLastColumnNumber(this.myLogicalCaret.column);
        this.myVisibleCaret = this.myEditor.logicalToVisualPosition(this.myLogicalCaret);
        this.myOffset = this.myEditor.logicalPositionToOffset(this.myLogicalCaret);
        LOG.assertTrue(this.myOffset >= 0 && this.myOffset <= this.myEditor.getDocument().getTextLength());
        this.myVisualLineStart = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(new VisualPosition(this.myVisibleCaret.line, 0)));
        this.myVisualLineEnd = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(new VisualPosition(this.myVisibleCaret.line + 1, 0)));
        this.myEditor.updateCaretCursor();
        this.requestRepaint(oldY);
        if (oldCaretPosition.column != this.myLogicalCaret.column || oldCaretPosition.line != this.myLogicalCaret.line) {
            CaretEvent event = new CaretEvent((Editor)this.myEditor, oldCaretPosition, this.myLogicalCaret);
            for (CaretListener listener : this.myCaretListeners) {
                listener.caretPositionChanged(event);
            }
        }
    }

    private void requestRepaint(int oldY) {
        int newY = this.myEditor.visibleLineNumberToYPosition(this.myVisibleCaret.line);
        int lineHeight = this.myEditor.getLineHeight();
        Rectangle visibleRect = this.myEditor.getScrollingModel().getVisibleArea();
        EditorGutterComponentEx gutter = this.myEditor.getGutterComponentEx();
        EditorComponentImpl content = (EditorComponentImpl)this.myEditor.getContentComponent();
        int updateWidth = this.myEditor.getScrollPane().getHorizontalScrollBar().getValue() + visibleRect.width;
        if (Math.abs(newY - oldY) <= 2 * lineHeight) {
            int minY = Math.min(oldY, newY);
            int maxY = Math.max(oldY + lineHeight, newY + lineHeight);
            content.repaintEditorComponent(0, minY, updateWidth, maxY - minY);
            gutter.repaint(0, minY, gutter.getWidth(), maxY - minY);
        } else {
            content.repaintEditorComponent(0, oldY, updateWidth, 2 * lineHeight);
            gutter.repaint(0, oldY, updateWidth, 2 * lineHeight);
            content.repaintEditorComponent(0, newY, updateWidth, 2 * lineHeight);
            gutter.repaint(0, newY, updateWidth, 2 * lineHeight);
        }
    }

    public LogicalPosition getLogicalPosition() {
        this.validateCallContext();
        return this.myLogicalCaret;
    }

    private void validateCallContext() {
        LOG.assertTrue(!this.myIsInUpdate, (Object)"Caret model is in its update process. All requests are illegal at this point.");
    }

    public VisualPosition getVisualPosition() {
        this.validateCallContext();
        return this.myVisibleCaret;
    }

    public int getOffset() {
        this.validateCallContext();
        return this.myOffset;
    }

    public int getVisualLineStart() {
        return this.myVisualLineStart;
    }

    public int getVisualLineEnd() {
        return this.myVisualLineEnd;
    }

    public void addCaretListener(CaretListener listener) {
        this.myCaretListeners.add(listener);
    }

    public void removeCaretListener(CaretListener listener) {
        boolean success = this.myCaretListeners.remove(listener);
        LOG.assertTrue(success);
    }

    public TextAttributes getTextAttributes() {
        if (this.myTextAttributes == null) {
            this.myTextAttributes = new TextAttributes();
            this.myTextAttributes.setBackgroundColor(this.myEditor.getColorsScheme().getColor(EditorColors.CARET_ROW_COLOR));
        }
        return this.myTextAttributes;
    }

    public void reinitSettings() {
        this.myTextAttributes = null;
    }

    public void documentChanged(DocumentEvent e) {
        this.myIsInUpdate = false;
        DocumentEventImpl event = (DocumentEventImpl)e;
        Document document = this.myEditor.getDocument();
        if (event.isWholeTextReplaced()) {
            int newLength = document.getTextLength();
            if (this.myOffset == newLength - e.getNewLength() + e.getOldLength() || newLength == 0) {
                this.moveToOffset(newLength);
            } else {
                int line = event.translateLineViaDiff(this.myLogicalCaret.line);
                this.moveToLogicalPosition(new LogicalPosition(line, this.myLogicalCaret.column));
            }
        } else {
            if (document instanceof DocumentEx && ((DocumentEx)document).isInBulkUpdate()) {
                return;
            }
            int startOffset = e.getOffset();
            int oldEndOffset = startOffset + e.getOldLength();
            int newOffset = this.myOffset;
            if (this.myOffset > oldEndOffset || this.myOffset == oldEndOffset && this.needToShiftWhitespaces(e)) {
                newOffset += e.getNewLength() - e.getOldLength();
            } else if (this.myOffset >= startOffset && this.myOffset <= oldEndOffset) {
                newOffset = Math.min(newOffset, startOffset + e.getNewLength());
            }
            newOffset = Math.min(newOffset, document.getTextLength());
            this.moveToOffset(newOffset);
        }
        this.myVisualLineStart = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(new VisualPosition(this.myVisibleCaret.line, 0)));
        this.myVisualLineEnd = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(new VisualPosition(this.myVisibleCaret.line + 1, 0)));
    }

    private boolean needToShiftWhitespaces(DocumentEvent e) {
        if (!CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)e.getNewFragment()) || CharArrayUtil.containLineBreaks((CharSequence)e.getNewFragment())) {
            return e.getOldLength() > 0;
        }
        if (e.getOffset() == 0) {
            return false;
        }
        char charBefore = this.myEditor.getDocument().getCharsSequence().charAt(e.getOffset() - 1);
        return Character.isWhitespace(charBefore);
    }

    public void beforeDocumentChange(DocumentEvent e) {
        this.myIsInUpdate = true;
    }

    @Override
    public int getPriority() {
        return 3;
    }
}

