/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileTextField;
import com.intellij.openapi.fileChooser.ex.FileLookup;
import com.intellij.openapi.fileChooser.ex.LocalFsFinder;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.LazyUiDisposable;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileTextFieldImpl
implements FileLookup,
Disposable,
FileTextField {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileChooser.ex.FileTextFieldImpl");
    private JTextField myPathTextField;
    private CompletionResult myCurrentCompletion;
    private JBPopup myCurrentPopup;
    private JBPopup myNoSuggestionsPopup;
    private JList myList;
    private MergingUpdateQueue myUiUpdater;
    private boolean myPathIsUpdating;
    private FileLookup.Finder myFinder;
    private FileLookup.LookupFilter myFilter;
    private String myCompletionBase;
    private int myCurrentCompletionsPos = 1;
    private String myFileSpitRegExp;
    public static final String KEY = "fileTextField";
    private boolean myAutopopup = false;
    private CancelAction myCancelAction;
    private Set<Action> myDisabledTextActions;
    private Map<String, String> myMacroMap;

    public FileTextFieldImpl(FileLookup.Finder finder, FileLookup.LookupFilter filter, Map<String, String> macroMap) {
        this(new JTextField(), finder, filter, macroMap, null);
    }

    public FileTextFieldImpl(JTextField field, FileLookup.Finder finder, FileLookup.LookupFilter filter, Map<String, String> macroMap, Disposable parent) {
        this.myPathTextField = field;
        this.myMacroMap = new TreeMap<String, String>();
        this.myMacroMap.putAll(macroMap);
        InputMap listMap = (InputMap)UIManager.getDefaults().get("List.focusInputMap");
        KeyStroke[] listKeys = listMap.keys();
        this.myDisabledTextActions = new HashSet<Action>();
        for (KeyStroke eachListStroke : listKeys) {
            Action textAction;
            String textActionID;
            String listActionID = (String)listMap.get(eachListStroke);
            if (!"selectNextRow".equals(listActionID) && !"selectPreviousRow".equals(listActionID) || (textActionID = (String)field.getInputMap().get(eachListStroke)) == null || (textAction = field.getActionMap().get(textActionID)) == null) continue;
            this.myDisabledTextActions.add(textAction);
        }
        FileTextFieldImpl assigned = (FileTextFieldImpl)this.myPathTextField.getClientProperty(KEY);
        if (assigned != null) {
            assigned.myFinder = finder;
            assigned.myFilter = filter;
            return;
        }
        this.myPathTextField.putClientProperty(KEY, this);
        boolean headless = ApplicationManager.getApplication().isUnitTestMode();
        this.myUiUpdater = new MergingUpdateQueue("FileTextField.UiUpdater", 200, false, (JComponent)this.myPathTextField);
        if (!headless) {
            new UiNotifyConnector((Component)this.myPathTextField, (Activatable)this.myUiUpdater);
        }
        this.myFinder = finder;
        this.myFilter = filter;
        this.myFileSpitRegExp = this.myFinder.getSeparator().replaceAll("\\\\", "\\\\\\\\");
        this.myPathTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FileTextFieldImpl.this.processTextChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FileTextFieldImpl.this.processTextChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FileTextFieldImpl.this.processTextChanged();
            }
        });
        this.myPathTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                FileTextFieldImpl.this.processListSelection(e);
            }
        });
        this.myPathTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                FileTextFieldImpl.this.closePopup();
            }
        });
        this.myCancelAction = new CancelAction();
        new LazyUiDisposable<FileTextFieldImpl>(parent, (JComponent)field, this){

            protected void initialize(@NotNull Disposable parent, @NotNull FileTextFieldImpl child, @Nullable Project project) {
                if (parent == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileChooser/ex/FileTextFieldImpl$4.initialize must not be null");
                }
                if (child == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileChooser/ex/FileTextFieldImpl$4.initialize must not be null");
                }
                Disposer.register((Disposable)child, (Disposable)FileTextFieldImpl.this.myUiUpdater);
            }
        };
    }

    public void dispose() {
    }

    private void processTextChanged() {
        if (this.myAutopopup && !this.isPathUpdating()) {
            this.suggestCompletion(false, false);
        }
        this.onTextChanged(this.getTextFieldText());
    }

    protected void onTextChanged(String newValue) {
    }

    private void suggestCompletion(final boolean selectReplacedText, final boolean isExplicitCall) {
        int index;
        if (isExplicitCall) {
            this.myAutopopup = true;
        }
        if (!this.getField().isFocusOwner()) {
            return;
        }
        final CompletionResult result = new CompletionResult();
        if (this.myList != null && this.myCurrentCompletion != null && (index = this.myList.getSelectedIndex()) >= 0 && index < this.myList.getModel().getSize()) {
            result.myPreselected = (FileLookup.LookupFile)this.myList.getSelectedValue();
        }
        this.myUiUpdater.queue(new Update("textField.suggestCompletion"){

            public void run() {
                result.myCompletionBase = FileTextFieldImpl.this.getCompletionBase();
                if (result.myCompletionBase == null) {
                    return;
                }
                result.myFieldText = FileTextFieldImpl.this.myPathTextField.getText();
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        FileTextFieldImpl.this.processCompletion(result);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (!result.myCompletionBase.equals(FileTextFieldImpl.this.getCompletionBase())) {
                                    return;
                                }
                                int pos = FileTextFieldImpl.this.selectCompletionRemoveText(result, selectReplacedText);
                                FileTextFieldImpl.this.showCompletionPopup(result, pos, isExplicitCall);
                            }
                        });
                    }
                });
            }
        });
    }

    private int selectCompletionRemoveText(CompletionResult result, boolean selectReplacedText) {
        int pos = this.myPathTextField.getCaretPosition();
        if (result.myToComplete.size() > 0 && selectReplacedText) {
            this.myPathTextField.setCaretPosition(this.myPathTextField.getText().length());
            this.myPathTextField.moveCaretPosition(pos);
        }
        return pos;
    }

    @Nullable
    public String getAdText(CompletionResult result) {
        if (result.myCompletionBase == null) {
            return null;
        }
        if (result.myCompletionBase.length() == result.myFieldText.length()) {
            return null;
        }
        String strokeText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("EditorChooseLookupItemReplace"));
        return IdeBundle.message((String)"file.chooser.completion.ad.text", (Object[])new Object[]{strokeText});
    }

    private void showCompletionPopup(CompletionResult result, int position, boolean isExplicit) {
        if (this.myList == null) {
            this.myList = new JList();
            this.myList.setSelectionMode(0);
            this.myList.setCellRenderer(new GroupedItemsListRenderer(new ListItemDescriptor(){

                public String getTextFor(Object value) {
                    FileLookup.LookupFile file = (FileLookup.LookupFile)value;
                    if (file.getMacro() != null) {
                        return file.getMacro();
                    }
                    return (FileTextFieldImpl.this.myCurrentCompletion != null && ((FileTextFieldImpl)FileTextFieldImpl.this).myCurrentCompletion.myKidsAfterSeparator.contains(file) ? FileTextFieldImpl.this.myFinder.getSeparator() : "") + file.getName();
                }

                public String getTooltipFor(Object value) {
                    return null;
                }

                public Icon getIconFor(Object value) {
                    return null;
                }

                private Separator getSeparatorAboveOf(Object value) {
                    FileLookup.LookupFile prev;
                    if (FileTextFieldImpl.this.myCurrentCompletion == null) {
                        return null;
                    }
                    FileLookup.LookupFile file = (FileLookup.LookupFile)value;
                    int fileIndex = ((FileTextFieldImpl)FileTextFieldImpl.this).myCurrentCompletion.myToComplete.indexOf(file);
                    if (fileIndex > 0 && !((FileTextFieldImpl)FileTextFieldImpl.this).myCurrentCompletion.myMacros.contains(file) && ((FileTextFieldImpl)FileTextFieldImpl.this).myCurrentCompletion.myMacros.contains(prev = ((FileTextFieldImpl)FileTextFieldImpl.this).myCurrentCompletion.myToComplete.get(fileIndex - 1))) {
                        return new Separator("");
                    }
                    if (((FileTextFieldImpl)FileTextFieldImpl.this).myCurrentCompletion.myKidsAfterSeparator.indexOf(file) == 0 && ((FileTextFieldImpl)FileTextFieldImpl.this).myCurrentCompletion.mySiblings.size() > 0) {
                        FileLookup.LookupFile parent = file.getParent();
                        return parent == null ? new Separator("") : new Separator(parent.getName());
                    }
                    if (((FileTextFieldImpl)FileTextFieldImpl.this).myCurrentCompletion.myMacros.size() > 0 && fileIndex == 0) {
                        return new Separator(IdeBundle.message((String)"file.chooser.completion.path.variables.text", (Object[])new Object[0]));
                    }
                    return null;
                }

                public boolean hasSeparatorAboveOf(Object value) {
                    return this.getSeparatorAboveOf(value) != null;
                }

                public String getCaptionAboveOf(Object value) {
                    Separator separator = this.getSeparatorAboveOf(value);
                    return separator != null ? separator.getText() : null;
                }
            }));
        }
        if (this.myCurrentPopup != null) {
            this.closePopup();
        }
        this.myCurrentCompletion = result;
        this.myCurrentCompletionsPos = position;
        if (this.myCurrentCompletion.myToComplete.size() == 0) {
            this.showNoSuggestions(isExplicit);
            return;
        }
        this.myList.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return ((FileTextFieldImpl)FileTextFieldImpl.this).myCurrentCompletion.myToComplete.size();
            }

            @Override
            public Object getElementAt(int index) {
                return ((FileTextFieldImpl)FileTextFieldImpl.this).myCurrentCompletion.myToComplete.get(index);
            }
        });
        this.myList.getSelectionModel().clearSelection();
        PopupChooserBuilder builder = JBPopupFactory.getInstance().createListPopupBuilder(this.myList);
        builder.addListener(new JBPopupListener(){

            public void beforeShown(LightweightWindowEvent event) {
                FileTextFieldImpl.this.myPathTextField.registerKeyboardAction(FileTextFieldImpl.this.myCancelAction, KeyStroke.getKeyStroke(27, 0), 2);
                for (Action each : FileTextFieldImpl.this.myDisabledTextActions) {
                    each.setEnabled(false);
                }
            }

            public void onClosed(LightweightWindowEvent event) {
                FileTextFieldImpl.this.myPathTextField.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
                for (Action each : FileTextFieldImpl.this.myDisabledTextActions) {
                    each.setEnabled(true);
                }
            }
        });
        this.myCurrentPopup = builder.setRequestFocus(false).setAdText(this.getAdText(this.myCurrentCompletion)).setAutoSelectIfEmpty(false).setResizable(false).setCancelCallback((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                int caret = FileTextFieldImpl.this.myPathTextField.getCaretPosition();
                FileTextFieldImpl.this.myPathTextField.setSelectionStart(caret);
                FileTextFieldImpl.this.myPathTextField.setSelectionEnd(caret);
                FileTextFieldImpl.this.myPathTextField.setFocusTraversalKeysEnabled(true);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FileTextFieldImpl.this.getField().requestFocus();
                    }
                });
                return Boolean.TRUE;
            }
        }).setItemChoosenCallback(new Runnable(){

            @Override
            public void run() {
                FileTextFieldImpl.this.processChosenFromCompletion(true, false);
            }
        }).setCancelKeyEnabled(false).setAlpha(0.1f).setFocusOwners(new Component[]{this.myPathTextField}).createPopup();
        if (result.myPreselected != null) {
            this.myList.setSelectedValue(result.myPreselected, false);
        }
        this.myPathTextField.setFocusTraversalKeysEnabled(false);
        this.myCurrentPopup.showInScreenCoordinates((Component)this.getField(), FileTextFieldImpl.getLocationForCaret(this.myPathTextField));
    }

    private void showNoSuggestions(boolean isExplicit) {
        this.hideCurrentPopup();
        if (!isExplicit) {
            return;
        }
        JLabel message = HintUtil.createErrorLabel(IdeBundle.message((String)"file.chooser.completion.no.suggestions", (Object[])new Object[0]));
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)message, (JComponent)message);
        builder.setRequestFocus(false).setResizable(false).setAlpha(0.1f).setFocusOwners(new Component[]{this.myPathTextField});
        this.myNoSuggestionsPopup = builder.createPopup();
        this.myNoSuggestionsPopup.showInScreenCoordinates((Component)this.getField(), FileTextFieldImpl.getLocationForCaret(this.myPathTextField));
    }

    private void hideCurrentPopup() {
        if (this.myCurrentPopup != null) {
            this.myCurrentPopup.cancel();
            this.myCurrentPopup = null;
        }
        if (this.myNoSuggestionsPopup != null) {
            this.myNoSuggestionsPopup.cancel();
            this.myNoSuggestionsPopup = null;
        }
    }

    public static Point getLocationForCaret(JTextComponent pathTextField) {
        Point point;
        int position = pathTextField.getCaretPosition();
        try {
            Rectangle rec = pathTextField.modelToView(position);
            point = new Point((int)rec.getMaxX(), (int)rec.getMaxY());
        }
        catch (BadLocationException e) {
            point = pathTextField.getCaret().getMagicCaretPosition();
        }
        SwingUtilities.convertPointToScreen(point, pathTextField);
        point.y += 2;
        return point;
    }

    public void processCompletion(final CompletionResult result) {
        result.myToComplete = new ArrayList<FileLookup.LookupFile>();
        result.mySiblings = new ArrayList<FileLookup.LookupFile>();
        result.myKidsAfterSeparator = new ArrayList<FileLookup.LookupFile>();
        String typed = result.myCompletionBase;
        if (typed == null || typed.length() == 0) {
            return;
        }
        this.addMacroPaths(result, typed);
        String typedText = this.myFinder.normalize(typed);
        result.myClosestParent = result.current = this.getClosestParent(typed);
        if (result.current != null) {
            String currentGrandparentText;
            result.currentParentMatch = SystemInfo.isFileSystemCaseSensitive ? typedText.equals(result.current.getAbsolutePath()) : typedText.equalsIgnoreCase(result.current.getAbsolutePath());
            result.closedPath = typed.endsWith(this.myFinder.getSeparator()) && typedText.length() > this.myFinder.getSeparator().length();
            String currentParentText = result.current.getAbsolutePath();
            if (!typedText.toUpperCase().startsWith(currentParentText.toUpperCase())) {
                return;
            }
            String prefix = typedText.substring(currentParentText.length());
            if (prefix.startsWith(this.myFinder.getSeparator())) {
                prefix = prefix.substring(this.myFinder.getSeparator().length());
            } else if (typed.endsWith(this.myFinder.getSeparator())) {
                prefix = "";
            }
            result.effectivePrefix = prefix.toUpperCase();
            result.currentGrandparent = result.current.getParent();
            if (result.currentGrandparent != null && result.currentParentMatch && !result.closedPath && StringUtil.startsWithConcatenationOf((String)typedText, (String)(currentGrandparentText = result.currentGrandparent.getAbsolutePath()), (String)this.myFinder.getSeparator())) {
                result.grandparentPrefix = currentParentText.substring(currentGrandparentText.length() + this.myFinder.getSeparator().length()).toUpperCase();
            }
        } else {
            result.effectivePrefix = typedText.toUpperCase();
        }
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                if (result.current != null) {
                    result.myToComplete.addAll(result.current.getChildren(new FileLookup.LookupFilter(){

                        @Override
                        public boolean isAccepted(FileLookup.LookupFile file) {
                            return FileTextFieldImpl.this.myFilter.isAccepted(file) && file.getName().toUpperCase().startsWith(result.effectivePrefix);
                        }
                    }));
                    if (result.currentParentMatch && !result.closedPath) {
                        result.myKidsAfterSeparator.addAll(result.myToComplete);
                    }
                    if (result.grandparentPrefix != null) {
                        List<FileLookup.LookupFile> siblings = result.currentGrandparent.getChildren(new FileLookup.LookupFilter(){

                            @Override
                            public boolean isAccepted(FileLookup.LookupFile file) {
                                return !file.equals(result.current) && FileTextFieldImpl.this.myFilter.isAccepted(file) && file.getName().toUpperCase().startsWith(result.grandparentPrefix);
                            }
                        });
                        result.myToComplete.addAll(0, siblings);
                        result.mySiblings.addAll(siblings);
                    }
                }
                int currentDiff = Integer.MIN_VALUE;
                FileLookup.LookupFile toPreselect = result.myPreselected;
                if (toPreselect == null || !result.myToComplete.contains(toPreselect)) {
                    boolean toPreselectFixed = false;
                    if (result.effectivePrefix.length() > 0) {
                        for (FileLookup.LookupFile each : result.myToComplete) {
                            int diff;
                            String eachName = each.getName().toUpperCase();
                            if (!eachName.startsWith(result.effectivePrefix) || (currentDiff = Math.max(diff = result.effectivePrefix.compareTo(eachName), currentDiff)) != diff) continue;
                            toPreselect = each;
                            toPreselectFixed = true;
                        }
                        if (!toPreselectFixed) {
                            toPreselect = null;
                        }
                    } else {
                        toPreselect = null;
                    }
                    if (toPreselect == null) {
                        if (result.myToComplete.size() == 1) {
                            toPreselect = result.myToComplete.get(0);
                        } else if (result.effectivePrefix.length() == 0 && result.mySiblings.size() > 0) {
                            toPreselect = result.mySiblings.get(0);
                        }
                        if (toPreselect == null && !result.myToComplete.contains(toPreselect) && result.myToComplete.size() > 0) {
                            toPreselect = result.myToComplete.get(0);
                        }
                    }
                }
                if (result.currentParentMatch && result.mySiblings.size() > 0) {
                    toPreselect = null;
                }
                result.myPreselected = toPreselect;
            }
        });
    }

    private void addMacroPaths(CompletionResult result, String typedText) {
        result.myMacros = new ArrayList<FileLookup.LookupFile>();
        for (String eachMacro : this.myMacroMap.keySet()) {
            FileLookup.LookupFile macroFile;
            String eachPath;
            if (!eachMacro.toUpperCase().startsWith(typedText.toUpperCase()) || (eachPath = this.myMacroMap.get(eachMacro)) == null || (macroFile = this.myFinder.find(eachPath)) == null || !macroFile.exists()) continue;
            result.myMacros.add(macroFile);
            result.myToComplete.add(macroFile);
            macroFile.setMacro(eachMacro);
        }
    }

    @Nullable
    private FileLookup.LookupFile getClosestParent(String typed) {
        if (typed == null) {
            return null;
        }
        FileLookup.LookupFile lastFound = this.myFinder.find(typed);
        if (lastFound == null) {
            return null;
        }
        if (lastFound.exists()) {
            return lastFound;
        }
        String[] splits = this.myFinder.normalize(typed).split(this.myFileSpitRegExp);
        StringBuffer fullPath = new StringBuffer();
        for (int i = 0; i < splits.length; ++i) {
            FileLookup.LookupFile file;
            String each = splits[i];
            fullPath.append(each);
            if (i < splits.length - 1) {
                fullPath.append(this.myFinder.getSeparator());
            }
            if ((file = this.myFinder.find(fullPath.toString())) == null || !file.exists()) {
                return lastFound;
            }
            lastFound = file;
        }
        return lastFound;
    }

    @Nullable
    public FileLookup.LookupFile getFile() {
        String text = this.getTextFieldText();
        if (text == null) {
            return null;
        }
        return this.myFinder.find(text);
    }

    private void processChosenFromCompletion(boolean closePath, boolean nameOnly) {
        block19: {
            FileLookup.LookupFile file = this.getSelectedFileFromCompletionPopup();
            if (file == null) {
                return;
            }
            if (nameOnly) {
                try {
                    int newPos;
                    boolean toRemoveExistingName;
                    int end;
                    int start;
                    int caretPos;
                    Document doc = this.myPathTextField.getDocument();
                    if (this.myFinder.getSeparator().equals(doc.getText(caretPos, 1))) {
                        for (caretPos = this.myPathTextField.getCaretPosition(); caretPos < doc.getLength(); ++caretPos) {
                            String eachChar = doc.getText(caretPos, 1);
                            if (!this.myFinder.getSeparator().equals(eachChar)) break;
                        }
                    }
                    int n = start = caretPos > 0 ? caretPos - 1 : caretPos;
                    while (start >= 0) {
                        String each = doc.getText(start, 1);
                        if (this.myFinder.getSeparator().equals(each)) {
                            ++start;
                            break;
                        }
                        --start;
                    }
                    int n2 = end = start < caretPos ? caretPos : start;
                    while (end <= doc.getLength()) {
                        String each = doc.getText(end, 1);
                        if (this.myFinder.getSeparator().equals(each)) break;
                        ++end;
                    }
                    if (end > doc.getLength()) {
                        end = doc.getLength();
                    }
                    if (start > end || start < 0 || end > doc.getLength()) {
                        this.setTextToFile(file, closePath);
                        break block19;
                    }
                    this.myPathTextField.setSelectionStart(0);
                    this.myPathTextField.setSelectionEnd(0);
                    String name = file.getName();
                    String prefix = "";
                    if (caretPos >= start) {
                        prefix = doc.getText(start, caretPos - start);
                        if (prefix.length() == 0) {
                            prefix = doc.getText(start, end - start);
                        }
                        toRemoveExistingName = SystemInfo.isFileSystemCaseSensitive ? name.startsWith(prefix) && prefix.length() > 0 : name.toUpperCase().startsWith(prefix.toUpperCase()) && prefix.length() > 0;
                    } else {
                        toRemoveExistingName = true;
                    }
                    if (toRemoveExistingName) {
                        doc.remove(start, end - start);
                        doc.insertString(start, name, doc.getDefaultRootElement().getAttributes());
                        newPos = start + name.length();
                    } else {
                        doc.insertString(caretPos, name, doc.getDefaultRootElement().getAttributes());
                        newPos = caretPos + name.length();
                    }
                    if (file.isDirectory() && !this.myFinder.getSeparator().equals(doc.getText(newPos, 1))) {
                        doc.insertString(newPos, this.myFinder.getSeparator(), doc.getDefaultRootElement().getAttributes());
                        ++newPos;
                    }
                    if (newPos < doc.getLength() && this.myFinder.getSeparator().equals(doc.getText(newPos, 1))) {
                        ++newPos;
                    }
                    this.myPathTextField.setCaretPosition(newPos);
                }
                catch (BadLocationException e) {
                    LOG.error((Throwable)e);
                }
            } else {
                this.setTextToFile(file, closePath);
            }
        }
    }

    private String toFileName(String name) {
        return SystemInfo.isFileSystemCaseSensitive ? name : name.toUpperCase();
    }

    private void setTextToFile(FileLookup.LookupFile file, boolean closePath) {
        String text = file.getAbsolutePath();
        if (closePath && file.isDirectory() && !text.endsWith(this.myFinder.getSeparator())) {
            text = text + this.myFinder.getSeparator();
        }
        this.myPathTextField.setText(text);
    }

    private void processListSelection(KeyEvent e) {
        Action action;
        Object object;
        if (this.togglePopup(e)) {
            return;
        }
        if (!this.isPopupShowing()) {
            return;
        }
        InputMap map = this.myPathTextField.getInputMap(2);
        if (map != null && (object = map.get(KeyStroke.getKeyStrokeForEvent(e))) instanceof Action && (action = (Action)object).isEnabled()) {
            action.actionPerformed(new ActionEvent(this, 1001, "action"));
            e.consume();
            return;
        }
        Object action2 = FileTextFieldImpl.getAction(e, this.myList);
        if ("selectNextRow".equals(action2)) {
            if (this.ensureSelectionExists()) {
                ListScrollingUtil.moveDown((JList)this.myList, (int)e.getModifiersEx());
            }
        } else if ("selectPreviousRow".equals(action2)) {
            ListScrollingUtil.moveUp((JList)this.myList, (int)e.getModifiersEx());
        } else if ("scrollDown".equals(action2)) {
            ListScrollingUtil.movePageDown((JList)this.myList);
        } else if ("scrollUp".equals(action2)) {
            ListScrollingUtil.movePageUp((JList)this.myList);
        } else if (this.getSelectedFileFromCompletionPopup() != null && (e.getKeyCode() == 10 || e.getKeyCode() == 9) && e.getModifiers() == 0) {
            this.hideCurrentPopup();
            e.consume();
            this.processChosenFromCompletion(true, e.getKeyCode() == 9);
        }
    }

    @Nullable
    private FileLookup.LookupFile getSelectedFileFromCompletionPopup() {
        if (this.myList == null) {
            return null;
        }
        return (FileLookup.LookupFile)this.myList.getSelectedValue();
    }

    private boolean ensureSelectionExists() {
        if ((this.myList.getSelectedIndex() < 0 || this.myList.getSelectedIndex() >= this.myList.getModel().getSize()) && this.myList.getModel().getSize() >= 0) {
            this.myList.setSelectedIndex(0);
            return false;
        }
        return true;
    }

    private boolean togglePopup(KeyEvent e) {
        KeyStroke stroke = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers());
        Object action = ((InputMap)UIManager.get("ComboBox.ancestorInputMap")).get(stroke);
        if ("selectNext".equals(action)) {
            if (!this.isPopupShowing()) {
                this.suggestCompletion(true, true);
                return true;
            }
            return false;
        }
        if ("togglePopup".equals(action)) {
            if (this.isPopupShowing()) {
                this.closePopup();
            } else {
                this.suggestCompletion(true, true);
            }
            return true;
        }
        Keymap active = KeymapManager.getInstance().getActiveKeymap();
        String[] ids = active.getActionIds(stroke);
        if (ids.length > 0 && "CodeCompletion".equals(ids[0])) {
            this.suggestCompletion(true, true);
        }
        return false;
    }

    private static Object getAction(KeyEvent e, JComponent comp) {
        KeyStroke stroke = KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers());
        return comp.getInputMap().get(stroke);
    }

    public JTextField getField() {
        return this.myPathTextField;
    }

    private boolean isPopupShowing() {
        return this.myCurrentPopup != null && this.myList != null && this.myList.isShowing();
    }

    private void closePopup() {
        this.hideCurrentPopup();
        this.myCurrentCompletion = null;
    }

    @Nullable
    public String getTextFieldText() {
        String text = this.myPathTextField.getText();
        if (text == null) {
            return null;
        }
        return text;
    }

    public final void setText(final String text, boolean now, final @Nullable Runnable onDone) {
        Update update = new Update("pathFromTree"){

            public void run() {
                FileTextFieldImpl.this.myPathIsUpdating = true;
                FileTextFieldImpl.this.getField().setText(text);
                FileTextFieldImpl.this.myPathIsUpdating = false;
                if (onDone != null) {
                    onDone.run();
                }
            }
        };
        if (now) {
            update.run();
        } else {
            this.myUiUpdater.queue(update);
        }
    }

    public boolean isPathUpdating() {
        return this.myPathIsUpdating;
    }

    @Nullable
    public String getCompletionBase() {
        String text = this.getTextFieldText();
        if (text == null) {
            return null;
        }
        int pos = this.myPathTextField.getCaretPosition();
        return pos < text.length() ? text.substring(0, pos) : text;
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FileTextFieldImpl.this.myCurrentPopup != null) {
                FileTextFieldImpl.this.myAutopopup = false;
                FileTextFieldImpl.this.hideCurrentPopup();
            }
        }
    }

    public static class Vfs
    extends FileTextFieldImpl {
        public Vfs(FileLookup.LookupFilter filter, Map<String, String> macroMap) {
            super(new LocalFsFinder(), filter, macroMap);
        }

        public Vfs(FileChooserDescriptor filter, boolean showHidden, JTextField field, Map<String, String> macroMap, Disposable parent) {
            super(field, new LocalFsFinder(), new LocalFsFinder.FileChooserFilter(filter, showHidden), macroMap, parent);
        }

        public Vfs(FileChooserDescriptor filter, boolean showHidden, Map<String, String> macroMap, Disposable parent) {
            super(new JTextField(), new LocalFsFinder(), new LocalFsFinder.FileChooserFilter(filter, showHidden), macroMap, parent);
        }

        public VirtualFile getSelectedFile() {
            FileLookup.LookupFile lookupFile = this.getFile();
            return lookupFile != null ? ((LocalFsFinder.VfsFile)lookupFile).getFile() : null;
        }
    }

    private class Separator {
        private final String myText;

        private Separator(String text) {
            this.myText = text;
        }

        public String getText() {
            return this.myText;
        }
    }

    public static class CompletionResult {
        public List<FileLookup.LookupFile> myMacros;
        public List<FileLookup.LookupFile> myToComplete;
        public List<FileLookup.LookupFile> mySiblings;
        public List<FileLookup.LookupFile> myKidsAfterSeparator;
        public String myCompletionBase;
        public FileLookup.LookupFile myClosestParent;
        public FileLookup.LookupFile myPreselected;
        public FileLookup.LookupFile current;
        public boolean currentParentMatch;
        public String effectivePrefix;
        public FileLookup.LookupFile currentGrandparent;
        public String grandparentPrefix;
        public boolean closedPath;
        public String myFieldText;
    }
}

