/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.util.text.CharArrayUtil;

public final class TrailingSpacesStripper
extends FileDocumentManagerAdapter {
    public void beforeDocumentSaving(final Document document) {
        if (!document.isWritable()) {
            return;
        }
        final EditorSettingsExternalizable settings = EditorSettingsExternalizable.getInstance();
        if (settings == null) {
            return;
        }
        final boolean doStrip = !settings.getStripTrailingSpaces().equals("None");
        final boolean ensureEOL = settings.isEnsureNewLineAtEOF();
        if (!doStrip && !ensureEOL) {
            return;
        }
        CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(){

            @Override
            public void run() {
                int end;
                int start;
                int lines;
                if (doStrip) {
                    boolean inChangedLinesOnly = !settings.getStripTrailingSpaces().equals("Whole");
                    ((DocumentEx)document).stripTrailingSpaces(inChangedLinesOnly);
                }
                if (ensureEOL && (lines = document.getLineCount()) > 0 && (start = document.getLineStartOffset(lines - 1)) != (end = document.getLineEndOffset(lines - 1))) {
                    CharSequence content = document.getCharsSequence();
                    if (CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)content.subSequence(start, end))) {
                        document.deleteString(start, end);
                    } else {
                        document.insertString(end, (CharSequence)"\n");
                    }
                }
            }
        });
    }
}

