/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapExtension;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NonNls;

public class ActionsTreeUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.keymap.impl.ui.ActionsTreeUtil");
    public static final String MAIN_MENU_TITLE = KeyMapBundle.message((String)"main.menu.action.title", (Object[])new Object[0]);
    public static final String MAIN_TOOLBAR = KeyMapBundle.message((String)"main.toolbar.title", (Object[])new Object[0]);
    public static final String EDITOR_POPUP = KeyMapBundle.message((String)"editor.popup.menu.title", (Object[])new Object[0]);
    private static final Icon MAIN_MENU_ICON = IconLoader.getIcon((String)"/nodes/keymapMainMenu.png");
    private static final Icon EDITOR_ICON = IconLoader.getIcon((String)"/nodes/keymapEditor.png");
    private static final Icon EDITOR_OPEN_ICON = IconLoader.getIcon((String)"/nodes/keymapEditorOpen.png");
    private static final Icon OTHER_ICON = IconLoader.getIcon((String)"/nodes/keymapOther.png");
    public static final String EDITOR_TAB_POPUP = KeyMapBundle.message((String)"editor.tab.popup.menu.title", (Object[])new Object[0]);
    public static final String FAVORITES_POPUP = KeyMapBundle.message((String)"favorites.popup.title", (Object[])new Object[0]);
    public static final String PROJECT_VIEW_POPUP = KeyMapBundle.message((String)"project.view.popup.menu.title", (Object[])new Object[0]);
    public static final String COMMANDER_POPUP = KeyMapBundle.message((String)"commender.view.popup.menu.title", (Object[])new Object[0]);
    public static final String J2EE_POPUP = KeyMapBundle.message((String)"j2ee.view.popup.menu.title", (Object[])new Object[0]);
    @NonNls
    private static final String EDITOR_PREFIX = "Editor";
    @NonNls
    private static final String TOOL_ACTION_PREFIX = "Tool_";

    private ActionsTreeUtil() {
    }

    private static Group createPluginsActionsGroup(Condition<AnAction> filtered, Group otherGroup) {
        Group pluginsGroup = new Group(KeyMapBundle.message((String)"plugins.group.title", (Object[])new Object[0]), null, null);
        KeymapManagerEx keymapManager = KeymapManagerEx.getInstanceEx();
        ActionManagerEx managerEx = ActionManagerEx.getInstanceEx();
        ArrayList plugins = new ArrayList();
        Collections.addAll(plugins, ApplicationManager.getApplication().getPlugins());
        Collections.sort(plugins, new Comparator<IdeaPluginDescriptor>(){

            @Override
            public int compare(IdeaPluginDescriptor o1, IdeaPluginDescriptor o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (IdeaPluginDescriptor plugin : plugins) {
            if (plugin.getName().equals("IDEA CORE")) continue;
            Group pluginGroup = new Group(plugin.getName(), null, null);
            String[] pluginActions = managerEx.getPluginActions(plugin.getPluginId());
            if (pluginActions == null || pluginActions.length == 0) continue;
            Arrays.sort(pluginActions, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return ActionsTreeUtil.getTextToCompare(o1).compareTo(ActionsTreeUtil.getTextToCompare(o2));
                }
            });
            for (String pluginAction : pluginActions) {
                if (keymapManager.getBoundActions().contains(pluginAction)) continue;
                AnAction anAction = managerEx.getActionOrStub(pluginAction);
                if (filtered != null && !filtered.value((Object)anAction)) continue;
                pluginGroup.addActionId(pluginAction);
            }
            if (pluginGroup.getSize() <= 0 || pluginGroup == otherGroup) continue;
            pluginsGroup.addGroup(pluginGroup);
        }
        return pluginsGroup;
    }

    private static Group createMainMenuGroup(Condition<AnAction> filtered) {
        Group group = new Group(MAIN_MENU_TITLE, "MainMenu", MAIN_MENU_ICON, MAIN_MENU_ICON);
        ActionGroup mainMenuGroup = (ActionGroup)ActionManager.getInstance().getActionOrStub("MainMenu");
        ActionsTreeUtil.fillGroupIgnorePopupFlag(mainMenuGroup, group, filtered);
        return group;
    }

    private static void fillGroupIgnorePopupFlag(ActionGroup actionGroup, Group group, Condition<AnAction> filtered) {
        AnAction[] mainMenuTopGroups;
        for (AnAction action : mainMenuTopGroups = actionGroup instanceof DefaultActionGroup ? ((DefaultActionGroup)actionGroup).getChildActionsOrStubs() : actionGroup.getChildren(null)) {
            Group subGroup = ActionsTreeUtil.createGroup((ActionGroup)action, false, filtered);
            if (subGroup.getSize() <= 0) continue;
            group.addGroup(subGroup);
        }
    }

    public static Group createGroup(ActionGroup actionGroup, boolean ignore, Condition<AnAction> filtered) {
        return ActionsTreeUtil.createGroup(actionGroup, ActionsTreeUtil.getName((AnAction)actionGroup), null, null, ignore, filtered);
    }

    private static String getName(AnAction action) {
        String name = action.getTemplatePresentation().getText();
        return name != null ? name : ActionManager.getInstance().getId(action);
    }

    public static Group createGroup(ActionGroup actionGroup, String groupName, Icon icon, Icon openIcon, boolean ignore, Condition<AnAction> filtered) {
        return ActionsTreeUtil.createGroup(actionGroup, groupName, icon, openIcon, ignore, filtered, true);
    }

    public static Group createGroup(ActionGroup actionGroup, String groupName, Icon icon, Icon openIcon, boolean ignore, Condition<AnAction> filtered, boolean normalizeSeparators) {
        ActionManager actionManager = ActionManager.getInstance();
        Group group = new Group(groupName, actionManager.getId((AnAction)actionGroup), icon, openIcon);
        AnAction[] children = actionGroup instanceof DefaultActionGroup ? ((DefaultActionGroup)actionGroup).getChildActionsOrStubs() : actionGroup.getChildren(null);
        for (int i = 0; i < children.length; ++i) {
            String id;
            AnAction action = children[i];
            LOG.assertTrue(action != null, (Object)(groupName + " contains null actions"));
            if (action instanceof ActionGroup) {
                Group subGroup = ActionsTreeUtil.createGroup((ActionGroup)action, ActionsTreeUtil.getName(action), null, null, ignore, filtered, normalizeSeparators);
                if (subGroup.getSize() > 0) {
                    if (!ignore && !((ActionGroup)action).isPopup()) {
                        group.addAll(subGroup);
                        continue;
                    }
                    group.addGroup(subGroup);
                    continue;
                }
                if (filtered != null && !filtered.value((Object)actionGroup)) continue;
                group.addGroup(subGroup);
                continue;
            }
            if (action instanceof Separator) {
                group.addSeparator();
                continue;
            }
            if (action == null) continue;
            String string = id = action instanceof ActionStub ? ((ActionStub)action).getId() : actionManager.getId(action);
            if (id == null || id.startsWith(TOOL_ACTION_PREFIX) || filtered != null && !filtered.value((Object)action)) continue;
            group.addActionId(id);
        }
        if (normalizeSeparators) {
            group.normalizeSeparators();
        }
        return group;
    }

    private static Group createEditorActionsGroup(Condition<AnAction> filtered) {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup editorGroup = (DefaultActionGroup)actionManager.getActionOrStub("EditorActions");
        ArrayList<String> ids = new ArrayList<String>();
        ActionsTreeUtil.addEditorActions(filtered, editorGroup, ids);
        Collections.sort(ids);
        Group group = new Group(KeyMapBundle.message((String)"editor.actions.group.title", (Object[])new Object[0]), "EditorActions", EDITOR_ICON, EDITOR_OPEN_ICON);
        for (String id : ids) {
            group.addActionId(id);
        }
        return group;
    }

    private static void addEditorActions(Condition<AnAction> filtered, DefaultActionGroup editorGroup, ArrayList<String> ids) {
        AnAction[] editorActions = editorGroup.getChildActionsOrStubs();
        ActionManager actionManager = ActionManager.getInstance();
        for (AnAction editorAction : editorActions) {
            AnAction action;
            String actionId;
            if (editorAction instanceof DefaultActionGroup) {
                ActionsTreeUtil.addEditorActions(filtered, (DefaultActionGroup)editorAction, ids);
                continue;
            }
            String string = actionId = editorAction instanceof ActionStub ? ((ActionStub)editorAction).getId() : actionManager.getId(editorAction);
            if (actionId == null || actionId.startsWith(EDITOR_PREFIX) && (action = actionManager.getActionOrStub('$' + actionId.substring(6))) != null || filtered != null && !filtered.value((Object)editorAction)) continue;
            ids.add(actionId);
        }
    }

    private static Group createExtensionGroup(Condition<AnAction> filtered, Project project, KeymapExtension provider) {
        return (Group)provider.createGroup(filtered, project);
    }

    private static Group createMacrosGroup(Condition<AnAction> filtered) {
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        Object[] ids = actionManager.getActionIds("Macro.");
        Arrays.sort(ids);
        Group group = new Group(KeyMapBundle.message((String)"macros.group.title", (Object[])new Object[0]), null, null);
        for (Object id : ids) {
            if (filtered != null && !filtered.value((Object)actionManager.getActionOrStub((String)id))) continue;
            group.addActionId((String)id);
        }
        return group;
    }

    private static Group createQuickListsGroup(Condition<AnAction> filtered, String filter, boolean forceFiltering, QuickList[] quickLists) {
        Arrays.sort(quickLists, new Comparator<QuickList>(){

            @Override
            public int compare(QuickList l1, QuickList l2) {
                return l1.getActionId().compareTo(l2.getActionId());
            }
        });
        Group group = new Group(KeyMapBundle.message((String)"quick.lists.group.title", (Object[])new Object[0]), null, null);
        for (QuickList quickList : quickLists) {
            if (filtered != null && filtered.value((Object)ActionManagerEx.getInstanceEx().getAction(quickList.getActionId()))) {
                group.addQuickList(quickList);
                continue;
            }
            if (SearchUtil.isComponentHighlighted(quickList.getDisplayName(), filter, forceFiltering, null)) {
                group.addQuickList(quickList);
                continue;
            }
            if (filtered != null || !StringUtil.isEmpty((String)filter)) continue;
            group.addQuickList(quickList);
        }
        return group;
    }

    private static Group createOtherGroup(Condition<AnAction> filtered, Group addedActions, Keymap keymap) {
        String[] registeredActionIds;
        addedActions.initIds();
        ArrayList<String> result = new ArrayList<String>();
        if (keymap != null) {
            String[] actionIds;
            for (String id : actionIds = keymap.getActionIds()) {
                AnAction action;
                if (id.startsWith(EDITOR_PREFIX) && (action = ActionManager.getInstance().getActionOrStub("$" + id.substring(6))) != null || id.startsWith("QuickList.") || addedActions.containsId(id)) continue;
                result.add(id);
            }
        }
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        KeymapManagerEx keymapManager = KeymapManagerEx.getInstanceEx();
        for (String id : registeredActionIds = actionManager.getActionIds("")) {
            if (actionManager.getActionOrStub(id) instanceof ActionGroup || id.startsWith("QuickList.") || addedActions.containsId(id) || result.contains(id) || keymapManager.getBoundActions().contains(id)) continue;
            result.add(id);
        }
        ActionsTreeUtil.filterOtherActionsGroup(result);
        ContainerUtil.quickSort(result, (Comparator)new Comparator<String>(){

            @Override
            public int compare(String id1, String id2) {
                return ActionsTreeUtil.getTextToCompare(id1).compareToIgnoreCase(ActionsTreeUtil.getTextToCompare(id2));
            }
        });
        Group group = new Group(KeyMapBundle.message((String)"other.group.title", (Object[])new Object[0]), OTHER_ICON, OTHER_ICON);
        for (String id : result) {
            if (filtered != null && !filtered.value((Object)actionManager.getActionOrStub(id))) continue;
            group.addActionId(id);
        }
        return group;
    }

    private static String getTextToCompare(String id) {
        AnAction action = ActionManager.getInstance().getActionOrStub(id);
        if (action == null) {
            return id;
        }
        String text = action.getTemplatePresentation().getText();
        return text != null ? text : id;
    }

    private static void filterOtherActionsGroup(ArrayList<String> actions) {
        ActionsTreeUtil.filterOutGroup(actions, "GenerateGroup");
        ActionsTreeUtil.filterOutGroup(actions, "NewGroup");
        ActionsTreeUtil.filterOutGroup(actions, "ChangeScheme");
    }

    private static void filterOutGroup(ArrayList<String> actions, String groupId) {
        if (groupId == null) {
            throw new IllegalArgumentException();
        }
        ActionManager actionManager = ActionManager.getInstance();
        AnAction action = actionManager.getActionOrStub(groupId);
        if (action instanceof DefaultActionGroup) {
            AnAction[] children;
            DefaultActionGroup group = (DefaultActionGroup)action;
            for (AnAction child : children = group.getChildActionsOrStubs()) {
                String childId;
                String string = childId = child instanceof ActionStub ? ((ActionStub)child).getId() : actionManager.getId(child);
                if (childId == null) continue;
                if (child instanceof DefaultActionGroup) {
                    ActionsTreeUtil.filterOutGroup(actions, childId);
                    continue;
                }
                actions.remove(childId);
            }
        }
    }

    public static DefaultMutableTreeNode createNode(Group group) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(group);
        for (Object child : group.getChildren()) {
            if (child instanceof Group) {
                DefaultMutableTreeNode childNode = ActionsTreeUtil.createNode((Group)child);
                node.add(childNode);
                continue;
            }
            node.add(new DefaultMutableTreeNode(child));
        }
        return node;
    }

    public static Group createMainGroup(Project project, Keymap keymap, QuickList[] quickLists) {
        return ActionsTreeUtil.createMainGroup(project, keymap, quickLists, null, false, null);
    }

    public static Group createMainGroup(Project project, Keymap keymap, QuickList[] quickLists, String filter, boolean forceFiltering, Condition<AnAction> filtered) {
        Group group;
        Group mainGroup = new Group(KeyMapBundle.message((String)"all.actions.group.title", (Object[])new Object[0]), null, null);
        mainGroup.addGroup(ActionsTreeUtil.createEditorActionsGroup(filtered));
        mainGroup.addGroup(ActionsTreeUtil.createMainMenuGroup(filtered));
        for (KeymapExtension extension : (KeymapExtension[])Extensions.getExtensions((ExtensionPointName)KeymapExtension.EXTENSION_POINT_NAME)) {
            group = ActionsTreeUtil.createExtensionGroup(filtered, project, extension);
            if (group == null) continue;
            mainGroup.addGroup(group);
        }
        mainGroup.addGroup(ActionsTreeUtil.createMacrosGroup(filtered));
        mainGroup.addGroup(ActionsTreeUtil.createQuickListsGroup(filtered, filter, forceFiltering, quickLists));
        Group otherGroup = ActionsTreeUtil.createOtherGroup(filtered, mainGroup, keymap);
        mainGroup.addGroup(otherGroup);
        mainGroup.addGroup(ActionsTreeUtil.createPluginsActionsGroup(filtered, otherGroup));
        if (!StringUtil.isEmpty((String)filter) || filtered != null) {
            ArrayList<Object> list = mainGroup.getChildren();
            Iterator<Object> i = list.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof Group) || (group = (Group)o).getSize() != 0 || SearchUtil.isComponentHighlighted(group.getName(), filter, forceFiltering, null)) continue;
                i.remove();
            }
        }
        return mainGroup;
    }

    public static Condition<AnAction> isActionFiltered(final String filter, final boolean force) {
        return new Condition<AnAction>(){

            public boolean value(AnAction action) {
                String description;
                if (filter == null) {
                    return true;
                }
                if (action == null) {
                    return false;
                }
                String insensitiveFilter = filter.toLowerCase();
                String text = action.getTemplatePresentation().getText();
                if (text != null) {
                    String lowerText = text.toLowerCase();
                    if (SearchUtil.isComponentHighlighted(lowerText, insensitiveFilter, force, null)) {
                        return true;
                    }
                    if (lowerText.indexOf(insensitiveFilter) != -1) {
                        return true;
                    }
                }
                if ((description = action.getTemplatePresentation().getDescription()) != null) {
                    String insensitiveDescription = description.toLowerCase();
                    if (SearchUtil.isComponentHighlighted(insensitiveDescription, insensitiveFilter, force, null)) {
                        return true;
                    }
                    if (insensitiveDescription.indexOf(insensitiveFilter) != -1) {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public static Condition<AnAction> isActionFiltered(final ActionManager actionManager, final Keymap keymap, final KeyboardShortcut keyboardShortcut) {
        return new Condition<AnAction>(){

            public boolean value(AnAction action) {
                Shortcut[] actionShortcuts;
                if (keyboardShortcut == null) {
                    return true;
                }
                if (action == null) {
                    return false;
                }
                for (Shortcut shortcut : actionShortcuts = keymap.getShortcuts(action instanceof ActionStub ? ((ActionStub)action).getId() : actionManager.getId(action))) {
                    KeyboardShortcut keyboardActionShortcut;
                    if (!(shortcut instanceof KeyboardShortcut) || !Comparing.equal((Object)(keyboardActionShortcut = (KeyboardShortcut)shortcut), (Object)keyboardShortcut)) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

