/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.module.ProjectLoadingErrorsNotifier;
import com.intellij.openapi.module.UnknownModuleType;
import com.intellij.openapi.module.impl.ModuleImpl;
import com.intellij.openapi.module.impl.ModuleLoadingErrorDescription;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageHandler;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ProjectModuleManager", storages={@Storage(id="default", file="$PROJECT_FILE$"), @Storage(id="dir", file="$PROJECT_CONFIG_DIR$/modules.xml", scheme=StorageScheme.DIRECTORY_BASED)})
public class ModuleManagerImpl
extends ModuleManager
implements ProjectComponent,
PersistentStateComponent<Element>,
ModificationTracker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.module.impl.ModuleManagerImpl");
    public static final Key<String> DISPOSED_MODULE_NAME = Key.create((String)"DisposedNeverAddedModuleName");
    private final Project myProject;
    private volatile ModuleModelImpl myModuleModel = new ModuleModelImpl();
    @NonNls
    public static final String COMPONENT_NAME = "ProjectModuleManager";
    private static final String MODULE_GROUP_SEPARATOR = "/";
    private List<ModulePath> myModulePaths;
    private final List<ModulePath> myFailedModulePaths = new ArrayList<ModulePath>();
    @NonNls
    public static final String ELEMENT_MODULES = "modules";
    @NonNls
    public static final String ELEMENT_MODULE = "module";
    @NonNls
    private static final String ATTRIBUTE_FILEURL = "fileurl";
    @NonNls
    public static final String ATTRIBUTE_FILEPATH = "filepath";
    @NonNls
    private static final String ATTRIBUTE_GROUP = "group";
    private long myModificationCount;
    private final MessageBusConnection myConnection;
    private final MessageBus myMessageBus;
    private final Map<ModuleListener, MessageBusConnection> myAdapters = new HashMap();
    private Module[] myCachedSortedModules = null;
    private Comparator<Module> myCachedModuleComparator = null;

    public static ModuleManagerImpl getInstanceImpl(Project project) {
        return (ModuleManagerImpl)ModuleManagerImpl.getInstance((Project)project);
    }

    private void cleanCachedStuff() {
        this.myCachedModuleComparator = null;
        this.myCachedSortedModules = null;
    }

    public ModuleManagerImpl(Project project, MessageBus bus) {
        this.myProject = project;
        this.myMessageBus = bus;
        this.myConnection = bus.connect((Disposable)project);
        this.myConnection.setDefaultHandler(new MessageHandler(){

            public void handle(Method event, Object ... params) {
                ModuleManagerImpl.this.cleanCachedStuff();
            }
        });
        this.myConnection.subscribe(ProjectTopics.PROJECT_ROOTS);
        this.myConnection.subscribe(ProjectLifecycleListener.TOPIC, (Object)new ProjectLifecycleListener.Adapter(){

            @Override
            public void projectComponentsInitialized(Project project) {
                ModuleManagerImpl.this.loadModules(ModuleManagerImpl.this.myModuleModel);
            }
        });
    }

    @NotNull
    public String getComponentName() {
        if (COMPONENT_NAME == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/module/impl/ModuleManagerImpl.getComponentName must not return null");
        }
        return COMPONENT_NAME;
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        this.myModuleModel.disposeModel();
    }

    public long getModificationCount() {
        return this.myModificationCount;
    }

    public Element getState() {
        Element e = new Element("state");
        this.writeExternal(e);
        return e;
    }

    public void loadState(Element state) {
        List<ModulePath> prevPaths = this.myModulePaths;
        this.readExternal(state);
        if (prevPaths != null) {
            Module[] existingModules;
            ModifiableModuleModel model = this.getModifiableModel();
            for (Module existingModule : existingModules = model.getModules()) {
                Object[] group;
                ModulePath correspondingPath = this.findCorrespondingPath(existingModule);
                if (correspondingPath == null) {
                    model.disposeModule(existingModule);
                    continue;
                }
                this.myModulePaths.remove(correspondingPath);
                String groupStr = correspondingPath.getModuleGroup();
                Object[] objectArray = group = groupStr != null ? groupStr.split(MODULE_GROUP_SEPARATOR) : null;
                if (Arrays.equals(group, model.getModuleGroupPath(existingModule))) continue;
                model.setModuleGroupPath(existingModule, (String[])group);
            }
            this.loadModules((ModuleModelImpl)model);
            model.commit();
        }
    }

    private ModulePath findCorrespondingPath(Module existingModule) {
        for (ModulePath modulePath : this.myModulePaths) {
            if (!modulePath.getPath().equals(existingModule.getModuleFilePath())) continue;
            return modulePath;
        }
        return null;
    }

    public static ModulePath[] getPathsToModuleFiles(Element element) {
        ArrayList<ModulePath> paths = new ArrayList<ModulePath>();
        Element modules = element.getChild(ELEMENT_MODULES);
        if (modules != null) {
            for (Object value : modules.getChildren(ELEMENT_MODULE)) {
                Element moduleElement = (Element)value;
                String fileUrlValue = moduleElement.getAttributeValue(ATTRIBUTE_FILEURL);
                String filepath = fileUrlValue != null ? VirtualFileManager.extractPath((String)fileUrlValue).replace('/', File.separatorChar) : moduleElement.getAttributeValue(ATTRIBUTE_FILEPATH).replace('/', File.separatorChar);
                String group = moduleElement.getAttributeValue(ATTRIBUTE_GROUP);
                paths.add(new ModulePath(filepath, group));
            }
        }
        return paths.toArray(new ModulePath[paths.size()]);
    }

    public void readExternal(Element element) {
        this.myModulePaths = new ArrayList<ModulePath>(Arrays.asList(ModuleManagerImpl.getPathsToModuleFiles(element)));
    }

    private void loadModules(final ModuleModelImpl moduleModel) {
        if (this.myModulePaths != null && this.myModulePaths.size() > 0) {
            final Application app = ApplicationManager.getApplication();
            Runnable swingRunnable = new Runnable(){

                @Override
                public void run() {
                    ModuleManagerImpl.this.myFailedModulePaths.clear();
                    ModuleManagerImpl.this.myFailedModulePaths.addAll(ModuleManagerImpl.this.myModulePaths);
                    ArrayList<Module> modulesWithUnknownTypes = new ArrayList<Module>();
                    ArrayList<ModuleLoadingErrorDescription> errors = new ArrayList<ModuleLoadingErrorDescription>();
                    for (ModulePath modulePath : ModuleManagerImpl.this.myModulePaths) {
                        try {
                            String groupPathString;
                            Module module = moduleModel.loadModuleInternal(modulePath.getPath());
                            if (module.getModuleType() instanceof UnknownModuleType) {
                                modulesWithUnknownTypes.add(module);
                            }
                            if ((groupPathString = modulePath.getModuleGroup()) != null) {
                                String[] groupPath = groupPathString.split(ModuleManagerImpl.MODULE_GROUP_SEPARATOR);
                                moduleModel.setModuleGroupPath(module, groupPath);
                            }
                            ModuleManagerImpl.this.myFailedModulePaths.remove(modulePath);
                        }
                        catch (IOException e) {
                            errors.add(ModuleLoadingErrorDescription.create(ProjectBundle.message((String)"module.cannot.load.error", (Object[])new Object[]{modulePath.getPath(), e.getMessage()}), modulePath, ModuleManagerImpl.this));
                        }
                        catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
                            errors.add(ModuleLoadingErrorDescription.create(moduleWithNameAlreadyExists.getMessage(), modulePath, ModuleManagerImpl.this));
                        }
                        catch (StateStorage.StateStorageException e) {
                            errors.add(ModuleLoadingErrorDescription.create(ProjectBundle.message((String)"module.cannot.load.error", (Object[])new Object[]{modulePath.getPath(), e.getMessage()}), modulePath, ModuleManagerImpl.this));
                        }
                    }
                    ModuleManagerImpl.this.fireErrors(errors);
                    if (!app.isHeadlessEnvironment() && !modulesWithUnknownTypes.isEmpty()) {
                        String message;
                        if (modulesWithUnknownTypes.size() == 1) {
                            message = ProjectBundle.message((String)"module.unknown.type.single.error", (Object[])new Object[]{((Module)modulesWithUnknownTypes.get(0)).getName()});
                        } else {
                            StringBuilder modulesBuilder = new StringBuilder();
                            for (Module module : modulesWithUnknownTypes) {
                                modulesBuilder.append("\n\"");
                                modulesBuilder.append(module.getName());
                                modulesBuilder.append("\"");
                            }
                            message = ProjectBundle.message((String)"module.unknown.type.multiple.error", (Object[])new Object[]{modulesBuilder.toString()});
                        }
                        Messages.showWarningDialog((Project)ModuleManagerImpl.this.myProject, (String)message, (String)ProjectBundle.message((String)"module.unknown.type.title", (Object[])new Object[0]));
                    }
                }
            };
            if (app.isDispatchThread() || app.isHeadlessEnvironment()) {
                swingRunnable.run();
            } else {
                app.invokeAndWait(swingRunnable, ModalityState.defaultModalityState());
            }
        }
    }

    private void fireErrors(List<ModuleLoadingErrorDescription> errors) {
        if (errors.isEmpty()) {
            return;
        }
        ModuleModelImpl.access$902(this.myModuleModel, null);
        for (ModuleLoadingErrorDescription error : errors) {
            Module module = (Module)this.myModuleModel.myPathToModule.remove(FileUtil.toSystemIndependentName((String)error.getModulePath().getPath()));
            if (module == null) continue;
            Disposer.dispose((Disposable)module);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            throw new RuntimeException(errors.get(0).getDescription());
        }
        ProjectLoadingErrorsNotifier.getInstance(this.myProject).registerErrors(errors);
    }

    public void removeFailedModulePath(@NotNull ModulePath modulePath) {
        if (modulePath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/ModuleManagerImpl.removeFailedModulePath must not be null");
        }
        this.myFailedModulePaths.remove(modulePath);
    }

    @NotNull
    public ModifiableModuleModel getModifiableModel() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ModuleModelImpl moduleModelImpl = new ModuleModelImpl(this.myModuleModel);
        if (moduleModelImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/module/impl/ModuleManagerImpl.getModifiableModel must not return null");
        }
        return moduleModelImpl;
    }

    public void writeExternal(Element element) {
        Element modules = new Element(ELEMENT_MODULES);
        Module[] collection = this.getModules();
        ArrayList<SaveItem> sorted = new ArrayList<SaveItem>(collection.length + this.myFailedModulePaths.size());
        for (Module module : collection) {
            sorted.add(new ModuleSaveItem(module));
        }
        for (ModulePath modulePath : this.myFailedModulePaths) {
            sorted.add(new ModulePathSaveItem(modulePath));
        }
        Collections.sort(sorted, new Comparator<SaveItem>(){

            @Override
            public int compare(SaveItem item1, SaveItem item2) {
                return item1.getModuleName().compareTo(item2.getModuleName());
            }
        });
        for (SaveItem saveItem : sorted) {
            saveItem.writeExternal(modules);
        }
        element.addContent(modules);
    }

    private void fireModuleAdded(Module module) {
        ((ModuleListener)this.myMessageBus.syncPublisher(ProjectTopics.MODULES)).moduleAdded(this.myProject, module);
    }

    private void fireModuleRemoved(Module module) {
        ((ModuleListener)this.myMessageBus.syncPublisher(ProjectTopics.MODULES)).moduleRemoved(this.myProject, module);
    }

    private void fireBeforeModuleRemoved(Module module) {
        ((ModuleListener)this.myMessageBus.syncPublisher(ProjectTopics.MODULES)).beforeModuleRemoved(this.myProject, module);
    }

    public void addModuleListener(@NotNull ModuleListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/ModuleManagerImpl.addModuleListener must not be null");
        }
        MessageBusConnection connection = this.myMessageBus.connect();
        connection.subscribe(ProjectTopics.MODULES, (Object)listener);
        this.myAdapters.put(listener, connection);
    }

    public void addModuleListener(@NotNull ModuleListener listener, Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/ModuleManagerImpl.addModuleListener must not be null");
        }
        MessageBusConnection connection = this.myMessageBus.connect(parentDisposable);
        connection.subscribe(ProjectTopics.MODULES, (Object)listener);
    }

    public void removeModuleListener(@NotNull ModuleListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/ModuleManagerImpl.removeModuleListener must not be null");
        }
        MessageBusConnection adapter = this.myAdapters.remove(listener);
        if (adapter != null) {
            adapter.disconnect();
        }
    }

    @NotNull
    public Module newModule(@NotNull String filePath, @NotNull ModuleType moduleType) {
        if (filePath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/ModuleManagerImpl.newModule must not be null");
        }
        if (moduleType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/module/impl/ModuleManagerImpl.newModule must not be null");
        }
        ++this.myModificationCount;
        ModifiableModuleModel modifiableModel = this.getModifiableModel();
        Module module = modifiableModel.newModule(filePath, moduleType);
        modifiableModel.commit();
        Module module2 = module;
        if (module2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/module/impl/ModuleManagerImpl.newModule must not return null");
        }
        return module2;
    }

    @NotNull
    public Module loadModule(@NotNull String filePath) throws InvalidDataException, IOException, JDOMException, ModuleWithNameAlreadyExists {
        if (filePath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/ModuleManagerImpl.loadModule must not be null");
        }
        ++this.myModificationCount;
        ModifiableModuleModel modifiableModel = this.getModifiableModel();
        Module module = modifiableModel.loadModule(filePath);
        modifiableModel.commit();
        Module module2 = module;
        if (module2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/module/impl/ModuleManagerImpl.loadModule must not return null");
        }
        return module2;
    }

    public void disposeModule(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/ModuleManagerImpl.disposeModule must not be null");
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                ModifiableModuleModel modifiableModel = ModuleManagerImpl.this.getModifiableModel();
                modifiableModel.disposeModule(module);
                modifiableModel.commit();
            }
        });
    }

    @NotNull
    public Module[] getModules() {
        if (this.myModuleModel.myIsWritable) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
        Module[] moduleArray = this.myModuleModel.getModules();
        if (moduleArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/module/impl/ModuleManagerImpl.getModules must not return null");
        }
        return moduleArray;
    }

    @NotNull
    public Module[] getSortedModules() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.myConnection.deliverImmediately();
        if (this.myCachedSortedModules == null) {
            this.myCachedSortedModules = this.myModuleModel.getSortedModules();
        }
        if (this.myCachedSortedModules == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/module/impl/ModuleManagerImpl.getSortedModules must not return null");
        }
        return this.myCachedSortedModules;
    }

    public Module findModuleByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/ModuleManagerImpl.findModuleByName must not be null");
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.myModuleModel.findModuleByName(name);
    }

    @NotNull
    public Comparator<Module> moduleDependencyComparator() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.myConnection.deliverImmediately();
        if (this.myCachedModuleComparator == null) {
            this.myCachedModuleComparator = this.myModuleModel.moduleDependencyComparator();
        }
        Comparator<Module> comparator = this.myCachedModuleComparator;
        if (comparator == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/module/impl/ModuleManagerImpl.moduleDependencyComparator must not return null");
        }
        return comparator;
    }

    @NotNull
    public Graph<Module> moduleGraph() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Graph graph = this.myModuleModel.moduleGraph();
        if (graph == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/module/impl/ModuleManagerImpl.moduleGraph must not return null");
        }
        return graph;
    }

    @NotNull
    public List<Module> getModuleDependentModules(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/ModuleManagerImpl.getModuleDependentModules must not be null");
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        List list = this.myModuleModel.getModuleDependentModules(module);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/module/impl/ModuleManagerImpl.getModuleDependentModules must not return null");
        }
        return list;
    }

    public boolean isModuleDependent(@NotNull Module module, @NotNull Module onModule) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/ModuleManagerImpl.isModuleDependent must not be null");
        }
        if (onModule == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/module/impl/ModuleManagerImpl.isModuleDependent must not be null");
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.myModuleModel.isModuleDependent(module, onModule);
    }

    public void projectOpened() {
        Runnable runnableWithProgress = new Runnable(){

            @Override
            public void run() {
                for (final Module module : ModuleManagerImpl.this.myModuleModel.myPathToModule.values()) {
                    final Application app = ApplicationManager.getApplication();
                    Runnable swingRunnable = new Runnable(){

                        @Override
                        public void run() {
                            app.runWriteAction(new Runnable(){

                                @Override
                                public void run() {
                                    ((ModuleImpl)module).moduleAdded();
                                    ModuleManagerImpl.this.fireModuleAdded(module);
                                }
                            });
                        }
                    };
                    if (app.isDispatchThread() || app.isHeadlessEnvironment()) {
                        swingRunnable.run();
                        continue;
                    }
                    app.invokeAndWait(swingRunnable, ModalityState.defaultModalityState());
                }
            }
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(runnableWithProgress, "Loading modules", false, this.myProject);
        this.myModuleModel.projectOpened();
    }

    public void projectClosed() {
        this.myModuleModel.projectClosed();
    }

    public static void commitModelWithRunnable(ModifiableModuleModel model, Runnable runnable) {
        ((ModuleModelImpl)model).commitWithRunnable(runnable);
    }

    private void commitModel(final ModuleModelImpl moduleModel, final Runnable runnable) {
        ModuleModelImpl.access$902(this.myModuleModel, null);
        ++this.myModificationCount;
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Collection oldModules = this.myModuleModel.myPathToModule.values();
        Collection newModules = moduleModel.myPathToModule.values();
        final ArrayList removedModules = new ArrayList(oldModules);
        removedModules.removeAll(newModules);
        final ArrayList addedModules = new ArrayList(newModules);
        addedModules.removeAll(oldModules);
        ProjectRootManagerEx.getInstanceEx(this.myProject).makeRootsChange(new Runnable(){

            @Override
            public void run() {
                for (Module removedModule : removedModules) {
                    ModuleManagerImpl.this.fireBeforeModuleRemoved(removedModule);
                    ModuleManagerImpl.this.cleanCachedStuff();
                }
                ArrayList neverAddedModules = new ArrayList(moduleModel.myModulesToDispose);
                neverAddedModules.removeAll(ModuleManagerImpl.this.myModuleModel.myPathToModule.values());
                for (Module neverAddedModule : neverAddedModules) {
                    ModuleImpl module = (ModuleImpl)neverAddedModule;
                    module.putUserData(DISPOSED_MODULE_NAME, module.getName());
                    Disposer.dispose((Disposable)module);
                }
                if (runnable != null) {
                    runnable.run();
                }
                Map modulesToNewNamesMap = moduleModel.myModuleToNewName;
                Set modulesToBeRenamed = modulesToNewNamesMap.keySet();
                modulesToBeRenamed.removeAll(moduleModel.myModulesToDispose);
                ArrayList<ModuleImpl> modules = new ArrayList<ModuleImpl>();
                for (Module aModulesToBeRenamed : modulesToBeRenamed) {
                    ModuleImpl module = (ModuleImpl)aModulesToBeRenamed;
                    moduleModel.myPathToModule.remove(module.getModuleFilePath());
                    modules.add(module);
                    module.rename((String)modulesToNewNamesMap.get(module));
                    moduleModel.myPathToModule.put(module.getModuleFilePath(), module);
                }
                moduleModel.myIsWritable = false;
                ModuleManagerImpl.this.myModuleModel = moduleModel;
                for (Module module : removedModules) {
                    ModuleManagerImpl.this.fireModuleRemoved(module);
                    ModuleManagerImpl.this.cleanCachedStuff();
                    Disposer.dispose((Disposable)module);
                    ModuleManagerImpl.this.cleanCachedStuff();
                }
                for (Module addedModule : addedModules) {
                    ((ModuleImpl)addedModule).moduleAdded();
                    ModuleManagerImpl.this.cleanCachedStuff();
                    ModuleManagerImpl.this.fireModuleAdded(addedModule);
                    ModuleManagerImpl.this.cleanCachedStuff();
                }
                ModuleManagerImpl.this.cleanCachedStuff();
                ModuleManagerImpl.this.fireModulesRenamed(modules);
                ModuleManagerImpl.this.cleanCachedStuff();
            }
        }, false, true);
    }

    private void fireModulesRenamed(List<Module> modules) {
        if (!modules.isEmpty()) {
            ((ModuleListener)this.myMessageBus.syncPublisher(ProjectTopics.MODULES)).modulesRenamed(this.myProject, modules);
        }
    }

    void fireModuleRenamedByVfsEvent(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/ModuleManagerImpl.fireModuleRenamedByVfsEvent must not be null");
        }
        ProjectRootManagerEx.getInstanceEx(this.myProject).makeRootsChange(new Runnable(){

            @Override
            public void run() {
                ModuleManagerImpl.this.fireModulesRenamed(Collections.singletonList(module));
            }
        }, false, true);
    }

    public String[] getModuleGroupPath(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/ModuleManagerImpl.getModuleGroupPath must not be null");
        }
        return this.myModuleModel.getModuleGroupPath(module);
    }

    public void setModuleGroupPath(Module module, String[] groupPath) {
        this.myModuleModel.setModuleGroupPath(module, groupPath);
    }

    class ModuleModelImpl
    implements ModifiableModuleModel {
        private final Map<String, Module> myPathToModule = new LinkedHashMap<String, Module>();
        private Module[] myModulesCache;
        private final List<Module> myModulesToDispose = new ArrayList<Module>();
        private final Map<Module, String> myModuleToNewName = new HashMap();
        private final Map<String, Module> myNewNameToModule = new HashMap();
        private boolean myIsWritable;
        private Map<Module, String[]> myModuleGroupPath;

        ModuleModelImpl() {
            this.myIsWritable = false;
        }

        ModuleModelImpl(ModuleModelImpl that) {
            this.myPathToModule.putAll(that.myPathToModule);
            Map<Module, String[]> groupPath = that.myModuleGroupPath;
            if (groupPath != null) {
                this.myModuleGroupPath = new THashMap();
                this.myModuleGroupPath.putAll(that.myModuleGroupPath);
            }
            this.myIsWritable = true;
        }

        private void assertWritable() {
            LOG.assertTrue(this.myIsWritable, (Object)"Attempt to modify committed ModifiableModuleModel");
        }

        @NotNull
        public Module[] getModules() {
            if (this.myModulesCache == null) {
                Collection<Module> modules = this.myPathToModule.values();
                this.myModulesCache = modules.toArray(new Module[modules.size()]);
            }
            if (this.myModulesCache == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl.getModules must not return null");
            }
            return this.myModulesCache;
        }

        private Module[] getSortedModules() {
            Module[] allModules = this.getModules();
            Arrays.sort(allModules, this.moduleDependencyComparator());
            return allModules;
        }

        public void renameModule(@NotNull Module module, @NotNull String newName) throws ModuleWithNameAlreadyExists {
            if (module == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl.renameModule must not be null");
            }
            if (newName == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl.renameModule must not be null");
            }
            Module oldModule = this.getModuleByNewName(newName);
            this.myNewNameToModule.remove(this.myModuleToNewName.get(module));
            if (module.getName().equals(newName)) {
                this.myModuleToNewName.remove(module);
                this.myNewNameToModule.remove(newName);
            } else {
                this.myModuleToNewName.put(module, newName);
                this.myNewNameToModule.put(newName, module);
            }
            if (oldModule != null) {
                throw new ModuleWithNameAlreadyExists(ProjectBundle.message((String)"module.already.exists.error", (Object[])new Object[]{newName}), newName);
            }
        }

        public Module getModuleToBeRenamed(@NotNull String newName) {
            if (newName == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl.getModuleToBeRenamed must not be null");
            }
            return this.myNewNameToModule.get(newName);
        }

        public Module getModuleByNewName(String newName) {
            Module moduleToBeRenamed = this.getModuleToBeRenamed(newName);
            if (moduleToBeRenamed != null) {
                return moduleToBeRenamed;
            }
            Module moduleWithOldName = this.findModuleByName(newName);
            if (this.myModuleToNewName.get(moduleWithOldName) == null) {
                return moduleWithOldName;
            }
            return null;
        }

        public String getNewName(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl.getNewName must not be null");
            }
            return this.myModuleToNewName.get(module);
        }

        @NotNull
        public Module newModule(@NotNull String filePath, @NotNull ModuleType moduleType) {
            if (filePath == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl.newModule must not be null");
            }
            if (moduleType == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl.newModule must not be null");
            }
            Module module = this.newModule(filePath, moduleType, null);
            if (module == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl.newModule must not return null");
            }
            return module;
        }

        @NotNull
        public Module newModule(@NotNull String filePath, @NotNull ModuleType moduleType, @Nullable Map<String, String> options) {
            if (filePath == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl.newModule must not be null");
            }
            if (moduleType == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl.newModule must not be null");
            }
            this.assertWritable();
            filePath = this.resolveShortWindowsName(filePath);
            ModuleImpl module = this.getModuleByFilePath(filePath);
            if (module == null) {
                module = new ModuleImpl(filePath, ModuleManagerImpl.this.myProject);
                module.setModuleType(moduleType);
                if (options != null) {
                    for (Map.Entry<String, String> option : options.entrySet()) {
                        module.setOption(option.getKey(), option.getValue());
                    }
                }
                module.loadModuleComponents();
                this.initModule(module);
            }
            ModuleImpl moduleImpl = module;
            if (moduleImpl == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl.newModule must not return null");
            }
            return moduleImpl;
        }

        private String resolveShortWindowsName(String filePath) {
            try {
                filePath = FileUtil.resolveShortWindowsName((String)filePath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return filePath;
        }

        private ModuleImpl getModuleByFilePath(String filePath) {
            Collection<Module> modules = this.myPathToModule.values();
            for (Module module : modules) {
                if (!filePath.equals(module.getModuleFilePath())) continue;
                return (ModuleImpl)module;
            }
            return null;
        }

        @NotNull
        public Module loadModule(@NotNull String filePath) throws InvalidDataException, IOException, ModuleWithNameAlreadyExists {
            Module module;
            if (filePath == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl.loadModule must not be null");
            }
            this.assertWritable();
            try {
                module = this.loadModuleInternal(filePath);
            }
            catch (StateStorage.StateStorageException e) {
                throw new IOException(ProjectBundle.message((String)"module.corrupted.file.error", (Object[])new Object[]{FileUtil.toSystemDependentName((String)filePath), e.getMessage()}));
            }
            if (module == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl.loadModule must not return null");
            }
            return module;
        }

        private Module loadModuleInternal(String filePath) throws ModuleWithNameAlreadyExists, IOException, StateStorage.StateStorageException {
            File moduleFile = new File(filePath);
            filePath = this.resolveShortWindowsName(filePath);
            String name = moduleFile.getName();
            if (name.endsWith(".iml")) {
                String moduleName = name.substring(0, name.length() - 4);
                for (Module module : this.myPathToModule.values()) {
                    if (!module.getName().equals(moduleName)) continue;
                    throw new ModuleWithNameAlreadyExists(ProjectBundle.message((String)"module.already.exists.error", (Object[])new Object[]{moduleName}), moduleName);
                }
            }
            if (!moduleFile.exists()) {
                throw new IOException(ProjectBundle.message((String)"module.file.does.not.exist.error", (Object[])new Object[]{moduleFile.getPath()}));
            }
            ModuleImpl module = this.getModuleByFilePath(filePath);
            if (module == null) {
                module = new ModuleImpl(filePath, ModuleManagerImpl.this.myProject);
                module.getStateStore().load();
                module.loadModuleComponents();
                this.initModule(module);
            }
            return module;
        }

        private void initModule(ModuleImpl module) {
            String path = module.getModuleFilePath();
            this.myModulesCache = null;
            this.myPathToModule.put(path, module);
            module.init();
        }

        public void disposeModule(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl.disposeModule must not be null");
            }
            this.assertWritable();
            this.myModulesCache = null;
            if (this.myPathToModule.values().contains(module)) {
                this.myPathToModule.remove(module.getModuleFilePath());
                this.myModulesToDispose.add(module);
            }
            if (this.myModuleGroupPath != null) {
                this.myModuleGroupPath.remove(module);
            }
        }

        public Module findModuleByName(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl.findModuleByName must not be null");
            }
            for (Module module : this.myPathToModule.values()) {
                if (module.isDisposed() || !module.getName().equals(name)) continue;
                return module;
            }
            return null;
        }

        private Comparator<Module> moduleDependencyComparator() {
            DFSTBuilder builder = new DFSTBuilder(this.moduleGraph());
            return builder.comparator();
        }

        private Graph<Module> moduleGraph() {
            return GraphGenerator.create((GraphGenerator.SemiGraph)CachingSemiGraph.create((GraphGenerator.SemiGraph)new GraphGenerator.SemiGraph<Module>(){

                public Collection<Module> getNodes() {
                    return ModuleModelImpl.this.myPathToModule.values();
                }

                public Iterator<Module> getIn(Module m) {
                    Module[] dependentModules = ModuleRootManager.getInstance((Module)m).getDependencies();
                    return Arrays.asList(dependentModules).iterator();
                }
            }));
        }

        @NotNull
        private List<Module> getModuleDependentModules(Module module) {
            ArrayList<Module> result = new ArrayList<Module>();
            for (Module aModule : this.myPathToModule.values()) {
                if (!this.isModuleDependent(aModule, module)) continue;
                result.add(aModule);
            }
            ArrayList<Module> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/module/impl/ModuleManagerImpl$ModuleModelImpl.getModuleDependentModules must not return null");
            }
            return arrayList;
        }

        private boolean isModuleDependent(Module module, Module onModule) {
            return ModuleRootManager.getInstance((Module)module).isDependsOn(onModule);
        }

        public void commit() {
            ProjectRootManagerEx.getInstanceEx(ModuleManagerImpl.this.myProject).multiCommit(this, new ModifiableRootModel[0]);
        }

        public void commitWithRunnable(Runnable runnable) {
            ModuleManagerImpl.this.commitModel(this, runnable);
            this.clearRenamingStuff();
        }

        private void clearRenamingStuff() {
            this.myModuleToNewName.clear();
            this.myNewNameToModule.clear();
        }

        public void dispose() {
            this.assertWritable();
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            Collection<Module> list = ((ModuleManagerImpl)ModuleManagerImpl.this).myModuleModel.myPathToModule.values();
            Collection<Module> thisModules = this.myPathToModule.values();
            for (Module thisModule1 : thisModules) {
                ModuleImpl thisModule = (ModuleImpl)thisModule1;
                if (list.contains(thisModule)) continue;
                Disposer.dispose((Disposable)thisModule);
            }
            for (Module moduleToDispose : this.myModulesToDispose) {
                if (list.contains(moduleToDispose)) continue;
                Disposer.dispose((Disposable)moduleToDispose);
            }
            this.clearRenamingStuff();
        }

        public boolean isChanged() {
            HashSet thatModules;
            if (!this.myIsWritable) {
                return false;
            }
            HashSet thisModules = new HashSet(this.myPathToModule.values());
            return !thisModules.equals(thatModules = new HashSet(((ModuleManagerImpl)ModuleManagerImpl.this).myModuleModel.myPathToModule.values())) || !Comparing.equal(((ModuleManagerImpl)ModuleManagerImpl.this).myModuleModel.myModuleGroupPath, this.myModuleGroupPath);
        }

        private void disposeModel() {
            this.myModulesCache = null;
            for (Module module : this.myPathToModule.values()) {
                Disposer.dispose((Disposable)module);
            }
            this.myPathToModule.clear();
            this.myModuleGroupPath = null;
        }

        public void projectOpened() {
            Collection<Module> collection = this.myPathToModule.values();
            for (Module aCollection : collection) {
                ModuleImpl module = (ModuleImpl)aCollection;
                module.projectOpened();
            }
        }

        public void projectClosed() {
            Collection<Module> collection = this.myPathToModule.values();
            for (Module aCollection : collection) {
                ModuleImpl module = (ModuleImpl)aCollection;
                module.projectClosed();
            }
        }

        public String[] getModuleGroupPath(Module module) {
            return this.myModuleGroupPath == null ? null : this.myModuleGroupPath.get(module);
        }

        public boolean hasModuleGroups() {
            return this.myModuleGroupPath != null && !this.myModuleGroupPath.isEmpty();
        }

        public void setModuleGroupPath(Module module, String[] groupPath) {
            if (this.myModuleGroupPath == null) {
                this.myModuleGroupPath = new THashMap();
            }
            if (groupPath == null) {
                this.myModuleGroupPath.remove(module);
            } else {
                this.myModuleGroupPath.put(module, groupPath);
            }
        }

        static /* synthetic */ Module[] access$902(ModuleModelImpl x0, Module[] x1) {
            x0.myModulesCache = x1;
            return x1;
        }
    }

    private static class ModulePathSaveItem
    extends SaveItem {
        private final ModulePath myModulePath;
        private final String myFilePath;
        private final String myName;

        public ModulePathSaveItem(ModulePath modulePath) {
            this.myModulePath = modulePath;
            this.myFilePath = modulePath.getPath().replace(File.separatorChar, '/');
            int slashIndex = this.myFilePath.lastIndexOf(47);
            int startIndex = slashIndex >= 0 && slashIndex + 1 < this.myFilePath.length() ? slashIndex + 1 : 0;
            int endIndex = this.myFilePath.endsWith(".iml") ? this.myFilePath.length() - ".iml".length() : this.myFilePath.length();
            this.myName = this.myFilePath.substring(startIndex, endIndex);
        }

        @Override
        protected String getModuleName() {
            return this.myName;
        }

        @Override
        protected String getGroupPathString() {
            return this.myModulePath.getModuleGroup();
        }

        @Override
        protected String getModuleFilePath() {
            return this.myFilePath;
        }
    }

    private class ModuleSaveItem
    extends SaveItem {
        private final Module myModule;

        public ModuleSaveItem(Module module) {
            this.myModule = module;
        }

        @Override
        protected String getModuleName() {
            return this.myModule.getName();
        }

        @Override
        protected String getGroupPathString() {
            String[] groupPath = ModuleManagerImpl.this.getModuleGroupPath(this.myModule);
            return groupPath != null ? StringUtil.join((String[])groupPath, (String)ModuleManagerImpl.MODULE_GROUP_SEPARATOR) : null;
        }

        @Override
        protected String getModuleFilePath() {
            return this.myModule.getModuleFilePath().replace(File.separatorChar, '/');
        }
    }

    private static abstract class SaveItem {
        private SaveItem() {
        }

        protected abstract String getModuleName();

        protected abstract String getGroupPathString();

        protected abstract String getModuleFilePath();

        public final void writeExternal(Element parentElement) {
            Element moduleElement = new Element(ModuleManagerImpl.ELEMENT_MODULE);
            String moduleFilePath = this.getModuleFilePath();
            String url = VirtualFileManager.constructUrl((String)"file", (String)moduleFilePath);
            moduleElement.setAttribute(ModuleManagerImpl.ATTRIBUTE_FILEURL, url);
            moduleElement.setAttribute(ModuleManagerImpl.ATTRIBUTE_FILEPATH, moduleFilePath);
            String groupPath = this.getGroupPathString();
            if (groupPath != null) {
                moduleElement.setAttribute(ModuleManagerImpl.ATTRIBUTE_GROUP, groupPath);
            }
            parentElement.addContent(moduleElement);
        }
    }

    public static final class ModulePath {
        private final String myPath;
        private final String myModuleGroup;

        public ModulePath(String path, String moduleGroup) {
            this.myPath = path;
            this.myModuleGroup = moduleGroup;
        }

        public String getPath() {
            return this.myPath;
        }

        public String getModuleGroup() {
            return this.myModuleGroup;
        }
    }
}

