/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.util.Alarm;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;

public class SingleConfigurableEditor
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.options.ex.SingleConfigurableEditor");
    private Project myProject;
    private Component myParentComponent;
    private Configurable myConfigurable;
    private JComponent myCenterPanel;
    private String myDimensionKey;
    private boolean myChangesWereApplied;

    public SingleConfigurableEditor(Project project, Configurable configurable, @NonNls String dimensionKey) {
        super(project, true);
        this.myDimensionKey = dimensionKey;
        this.setTitle(SingleConfigurableEditor.createTitleString(configurable));
        this.myProject = project;
        this.myConfigurable = configurable;
        this.init();
        this.myConfigurable.reset();
    }

    public SingleConfigurableEditor(Component parent, Configurable configurable, String dimensionServiceKey) {
        super(parent, true);
        this.myDimensionKey = dimensionServiceKey;
        this.setTitle(SingleConfigurableEditor.createTitleString(configurable));
        this.myParentComponent = parent;
        this.myConfigurable = configurable;
        this.init();
        this.myConfigurable.reset();
    }

    public Configurable getConfigurable() {
        return this.myConfigurable;
    }

    public Project getProject() {
        return this.myProject;
    }

    public SingleConfigurableEditor(Project project, Configurable configurable) {
        this(project, configurable, null);
    }

    public SingleConfigurableEditor(Component parent, Configurable configurable) {
        this(parent, configurable, null);
    }

    private static String createTitleString(Configurable configurable) {
        String displayName = configurable.getDisplayName();
        LOG.assertTrue(displayName != null, (Object)configurable.getClass().getName());
        return displayName.replaceAll("\n", " ");
    }

    protected String getDimensionServiceKey() {
        if (this.myDimensionKey == null) {
            return super.getDimensionServiceKey();
        }
        return this.myDimensionKey;
    }

    protected Action[] createActions() {
        if (this.myConfigurable.getHelpTopic() != null) {
            return new Action[]{this.getOKAction(), this.getCancelAction(), new ApplyAction(), this.getHelpAction()};
        }
        return new Action[]{this.getOKAction(), this.getCancelAction(), new ApplyAction()};
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(this.myConfigurable.getHelpTopic());
    }

    public void doCancelAction() {
        if (this.myChangesWereApplied) {
            ApplicationManager.getApplication().saveAll();
        }
        super.doCancelAction();
    }

    protected void doOKAction() {
        try {
            if (this.myConfigurable.isModified()) {
                this.myConfigurable.apply();
            }
            ApplicationManager.getApplication().saveAll();
        }
        catch (ConfigurationException e) {
            if (e.getMessage() != null) {
                if (this.myProject != null) {
                    Messages.showMessageDialog((Project)this.myProject, (String)e.getMessage(), (String)e.getTitle(), (Icon)Messages.getErrorIcon());
                } else {
                    Messages.showMessageDialog((Component)this.myParentComponent, (String)e.getMessage(), (String)e.getTitle(), (Icon)Messages.getErrorIcon());
                }
            }
            return;
        }
        super.doOKAction();
    }

    protected static String createDimensionKey(Configurable configurable) {
        String displayName = configurable.getDisplayName();
        displayName = displayName.replaceAll("\n", "_").replaceAll(" ", "_");
        return "#" + displayName;
    }

    protected JComponent createCenterPanel() {
        this.myCenterPanel = this.myConfigurable.createComponent();
        return this.myCenterPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        JComponent preferred;
        if (this.myConfigurable instanceof BaseConfigurable && (preferred = ((BaseConfigurable)this.myConfigurable).getPreferredFocusedComponent()) != null) {
            return preferred;
        }
        return IdeFocusTraversalPolicy.getPreferredFocusedComponent(this.myCenterPanel);
    }

    public void dispose() {
        super.dispose();
        this.myConfigurable.disposeUIResources();
        this.myConfigurable = null;
    }

    protected class ApplyAction
    extends AbstractAction {
        private final Alarm myUpdateAlarm;

        public ApplyAction() {
            super(CommonBundle.getApplyButtonText());
            this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
            final Runnable updateRequest = new Runnable(){

                @Override
                public void run() {
                    if (!SingleConfigurableEditor.this.isShowing()) {
                        return;
                    }
                    try {
                        ApplyAction.this.setEnabled(SingleConfigurableEditor.this.myConfigurable != null && SingleConfigurableEditor.this.myConfigurable.isModified());
                    }
                    catch (IndexNotReadyException indexNotReadyException) {
                        // empty catch block
                    }
                    ApplyAction.this.addUpdateRequest(this);
                }
            };
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ApplyAction.this.addUpdateRequest(updateRequest);
                }
            });
        }

        private void addUpdateRequest(Runnable updateRequest) {
            this.myUpdateAlarm.addRequest(updateRequest, 500, ModalityState.stateForComponent((Component)SingleConfigurableEditor.this.getWindow()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent event) {
            if (SingleConfigurableEditor.this.myPerformAction) {
                return;
            }
            try {
                SingleConfigurableEditor.this.myPerformAction = true;
                if (SingleConfigurableEditor.this.myConfigurable.isModified()) {
                    SingleConfigurableEditor.this.myConfigurable.apply();
                    SingleConfigurableEditor.this.myChangesWereApplied = true;
                    SingleConfigurableEditor.this.setCancelButtonText(CommonBundle.getCloseButtonText());
                }
            }
            catch (ConfigurationException e) {
                if (SingleConfigurableEditor.this.myProject != null) {
                    Messages.showMessageDialog((Project)SingleConfigurableEditor.this.myProject, (String)e.getMessage(), (String)e.getTitle(), (Icon)Messages.getErrorIcon());
                } else {
                    Messages.showMessageDialog((Component)SingleConfigurableEditor.this.myParentComponent, (String)e.getMessage(), (String)e.getTitle(), (Icon)Messages.getErrorIcon());
                }
            }
            finally {
                SingleConfigurableEditor.this.myPerformAction = false;
            }
        }
    }
}

