/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.AppTopics;
import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CollectionQuery;
import com.intellij.util.FilteredQuery;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryFactory;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.HashMap;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectoryIndexImpl
extends DirectoryIndex
implements ProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.DirectoryIndexImpl");
    private final Project myProject;
    private volatile boolean myInitialized = false;
    private volatile boolean myDisposed = false;
    private Map<VirtualFile, Set<String>> myExcludeRootsMap;
    private Set<VirtualFile> myProjectExcludeRoots;
    private Map<VirtualFile, DirectoryInfo> myDirToInfoMap = new ConcurrentHashMap();
    private Map<String, List<VirtualFile>> myPackageNameToDirsMap = new ConcurrentHashMap();
    private Map<VirtualFile, String> myDirToPackageName = new ConcurrentHashMap();
    private final DirectoryIndexExcludePolicy[] myExcludePolicies;
    private final MessageBusConnection myConnection;
    private final PackageSink mySink = new PackageSink();
    private static final Condition<VirtualFile> IS_VALID = new Condition<VirtualFile>(){

        public boolean value(VirtualFile virtualFile) {
            return virtualFile.isValid();
        }
    };

    public DirectoryIndexImpl(Project project, StartupManager startupManager) {
        this.myProject = project;
        this.myConnection = project.getMessageBus().connect((Disposable)project);
        startupManager.registerPreStartupActivity(new Runnable(){

            @Override
            public void run() {
                DirectoryIndexImpl.this.initialize();
            }
        });
        this.myExcludePolicies = (DirectoryIndexExcludePolicy[])Extensions.getExtensions(DirectoryIndexExcludePolicy.EP_NAME, (AreaInstance)this.myProject);
    }

    @NotNull
    public String getComponentName() {
        if ("DirectoryIndex" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/DirectoryIndexImpl.getComponentName must not return null");
        }
        return "DirectoryIndex";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        this.myDisposed = true;
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    @Override
    public void checkConsistency() {
        this.doCheckConsistency(false);
        this.doCheckConsistency(true);
    }

    private void doCheckConsistency(boolean reverseAllSets) {
        assert (this.myInitialized);
        assert (!this.myDisposed);
        Map<VirtualFile, DirectoryInfo> oldDirToInfoMap = this.myDirToInfoMap;
        this.myDirToInfoMap = new THashMap();
        Map<String, List<VirtualFile>> oldPackageNameToDirsMap = this.myPackageNameToDirsMap;
        this.myPackageNameToDirsMap = new THashMap();
        this.doInitialize(reverseAllSets);
        Set<VirtualFile> keySet = this.myDirToInfoMap.keySet();
        assert (keySet.size() == oldDirToInfoMap.keySet().size());
        for (VirtualFile virtualFile : keySet) {
            DirectoryInfo info1 = this.myDirToInfoMap.get(virtualFile);
            DirectoryInfo info2 = oldDirToInfoMap.get(virtualFile);
            assert (info1.equals(info2));
        }
        assert (this.myPackageNameToDirsMap.keySet().size() == oldPackageNameToDirsMap.keySet().size());
        for (Map.Entry entry : this.myPackageNameToDirsMap.entrySet()) {
            String packageName = (String)entry.getKey();
            List dirs = (List)entry.getValue();
            List<VirtualFile> dirs1 = oldPackageNameToDirsMap.get(packageName);
            HashSet set1 = new HashSet();
            set1.addAll(dirs);
            HashSet<VirtualFile> set2 = new HashSet<VirtualFile>();
            set2.addAll(dirs1);
            assert (set1.equals(set2));
        }
    }

    @Override
    public boolean isInitialized() {
        return this.myInitialized;
    }

    public void initialize() {
        if (this.myInitialized) {
            LOG.error("Directory index is already initialized.");
            return;
        }
        if (this.myDisposed) {
            LOG.error("Directory index is already disposed for this project");
            return;
        }
        this.myInitialized = true;
        this.subscribeToFileChanges();
        this.doInitialize();
    }

    private void subscribeToFileChanges() {
        this.myConnection.subscribe(AppTopics.FILE_TYPES, (Object)new FileTypeListener(){

            public void beforeFileTypesChanged(FileTypeEvent event) {
            }

            public void fileTypesChanged(FileTypeEvent event) {
                DirectoryIndexImpl.this.doInitialize();
            }
        });
        this.myConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void beforeRootsChange(ModuleRootEvent event) {
            }

            public void rootsChanged(ModuleRootEvent event) {
                DirectoryIndexImpl.this.doInitialize();
            }
        });
        this.myConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter((VirtualFileListener)new MyVirtualFileListener()));
    }

    private void doInitialize() {
        this.doInitialize(false);
    }

    private void doInitialize(boolean reverseAllSets) {
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        if (progress == null) {
            progress = new EmptyProgressIndicator();
        }
        progress.pushState();
        progress.checkCanceled();
        progress.setText(ProjectBundle.message((String)"project.index.scanning.files.progress", (Object[])new Object[0]));
        this.cleanAllMaps();
        Object[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
        if (reverseAllSets) {
            modules = (Module[])ArrayUtil.reverseArray((Object[])modules);
        }
        this.initExcludedDirMap((Module[])modules, progress);
        for (Object module : modules) {
            this.initModuleContents((Module)module, reverseAllSets, progress);
        }
        for (Object module : modules) {
            this.initModuleSources((Module)module, reverseAllSets, progress);
            this.initLibrarySources((Module)module, progress);
            this.initLibraryClasses((Module)module, progress);
        }
        progress.checkCanceled();
        progress.setText2("");
        for (Object module : modules) {
            this.initOrderEntries((Module)module);
        }
        progress.popState();
    }

    private void cleanAllMaps() {
        this.myDirToInfoMap.clear();
        this.myPackageNameToDirsMap.clear();
        this.myDirToPackageName.clear();
    }

    private void initExcludedDirMap(Module[] modules, ProgressIndicator progress) {
        progress.checkCanceled();
        progress.setText2(ProjectBundle.message((String)"project.index.building.exclude.roots.progress", (Object[])new Object[0]));
        THashMap result = new THashMap();
        HashSet<VirtualFile> projectExcludeRoots = new HashSet<VirtualFile>();
        for (Module module : modules) {
            for (ContentEntry contentEntry : DirectoryIndexImpl.getContentEntries(module)) {
                ExcludeFolder[] excludeRoots;
                VirtualFile contentRoot = contentEntry.getFile();
                if (contentRoot == null) continue;
                for (ExcludeFolder excludeRoot : excludeRoots = contentEntry.getExcludeFolders()) {
                    if (excludeRoot.getFile() != null && !contentRoot.getUrl().startsWith(excludeRoot.getUrl()) && this.isExcludeRootForModule(module, excludeRoot.getFile())) {
                        DirectoryIndexImpl.putForFileAndAllAncestors((Map<VirtualFile, Set<String>>)result, excludeRoot.getFile(), excludeRoot.getUrl());
                    }
                    DirectoryIndexImpl.putForFileAndAllAncestors((Map<VirtualFile, Set<String>>)result, contentRoot, excludeRoot.getUrl());
                }
            }
        }
        for (DirectoryIndexExcludePolicy directoryIndexExcludePolicy : this.myExcludePolicies) {
            for (ContentEntry contentEntry : directoryIndexExcludePolicy.getExcludeRootsForProject()) {
                DirectoryIndexImpl.putForFileAndAllAncestors((Map<VirtualFile, Set<String>>)result, (VirtualFile)contentEntry, contentEntry.getUrl());
                projectExcludeRoots.add((VirtualFile)contentEntry);
            }
        }
        this.myExcludeRootsMap = result;
        this.myProjectExcludeRoots = projectExcludeRoots;
    }

    private static void putForFileAndAllAncestors(Map<VirtualFile, Set<String>> map, VirtualFile file, String value) {
        do {
            Set<String> set;
            if ((set = map.get(file)) == null) {
                set = new HashSet<String>();
                map.put(file, set);
            }
            set.add(value);
        } while ((file = file.getParent()) != null);
    }

    private boolean isExcludeRootForModule(Module module, VirtualFile excludeRoot) {
        for (DirectoryIndexExcludePolicy policy : this.myExcludePolicies) {
            if (!policy.isExcludeRootForModule(module, excludeRoot)) continue;
            return true;
        }
        return false;
    }

    private static ContentEntry[] getContentEntries(Module module) {
        return ModuleRootManager.getInstance((Module)module).getContentEntries();
    }

    private static OrderEntry[] getOrderEntries(Module module) {
        return ModuleRootManager.getInstance((Module)module).getOrderEntries();
    }

    private void initModuleContents(Module module, boolean reverseAllSets, ProgressIndicator progress) {
        progress.checkCanceled();
        progress.setText2(ProjectBundle.message((String)"project.index.processing.module.content.progress", (Object[])new Object[]{module.getName()}));
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        Object[] contentRoots = rootManager.getContentRoots();
        if (reverseAllSets) {
            contentRoots = (VirtualFile[])ArrayUtil.reverseArray((Object[])contentRoots);
        }
        for (Object contentRoot : contentRoots) {
            this.fillMapWithModuleContent((VirtualFile)contentRoot, module, (VirtualFile)contentRoot);
        }
    }

    private void fillMapWithModuleContent(VirtualFile dir, Module module, VirtualFile contentRoot) {
        VirtualFile[] children;
        DirectoryInfo parentInfo;
        if (this.isExcluded(contentRoot, dir)) {
            return;
        }
        if (DirectoryIndexImpl.isIgnored(dir)) {
            return;
        }
        DirectoryInfo info = this.getOrCreateDirInfo(dir);
        if (!(info.module == null || (parentInfo = this.myDirToInfoMap.get(dir.getParent())) != null && info.module.equals(parentInfo.module))) {
            return;
        }
        for (VirtualFile child : children = dir.getChildren()) {
            if (!child.isDirectory()) continue;
            this.fillMapWithModuleContent(child, module, contentRoot);
        }
        info.module = module;
        info.contentRoot = contentRoot;
    }

    private boolean isExcluded(VirtualFile root, VirtualFile dir) {
        Set<String> excludes = this.myExcludeRootsMap.get(root);
        return excludes != null && excludes.contains(dir.getUrl());
    }

    private void initModuleSources(Module module, boolean reverseAllSets, ProgressIndicator progress) {
        progress.checkCanceled();
        progress.setText2(ProjectBundle.message((String)"project.index.processing.module.sources.progress", (Object[])new Object[]{module.getName()}));
        Object[] contentEntries = DirectoryIndexImpl.getContentEntries(module);
        if (reverseAllSets) {
            contentEntries = (ContentEntry[])ArrayUtil.reverseArray((Object[])contentEntries);
        }
        for (Object contentEntry : contentEntries) {
            Object[] sourceFolders = contentEntry.getSourceFolders();
            if (reverseAllSets) {
                sourceFolders = (SourceFolder[])ArrayUtil.reverseArray((Object[])sourceFolders);
            }
            for (Object sourceFolder : sourceFolders) {
                VirtualFile dir = sourceFolder.getFile();
                if (dir == null) continue;
                this.fillMapWithModuleSource(dir, module, sourceFolder.getPackagePrefix(), dir, sourceFolder.isTestSource());
            }
        }
    }

    private void fillMapWithModuleSource(VirtualFile dir, Module module, String packageName, VirtualFile sourceRoot, boolean isTestSource) {
        VirtualFile[] children;
        String definedPackage;
        DirectoryInfo info = this.myDirToInfoMap.get(dir);
        if (info == null) {
            return;
        }
        if (!module.equals(info.module)) {
            return;
        }
        if (info.isInModuleSource && (definedPackage = this.myDirToPackageName.get(dir)) != null && definedPackage.length() == 0) {
            return;
        }
        info.isInModuleSource = true;
        info.isTestSource = isTestSource;
        info.sourceRoot = sourceRoot;
        this.setPackageName(dir, packageName);
        for (VirtualFile child : children = dir.getChildren()) {
            if (!child.isDirectory()) continue;
            String childPackageName = DirectoryIndexImpl.getPackageNameForSubdir(packageName, child.getName());
            this.fillMapWithModuleSource(child, module, childPackageName, sourceRoot, isTestSource);
        }
    }

    private void initLibrarySources(Module module, ProgressIndicator progress) {
        progress.checkCanceled();
        progress.setText2(ProjectBundle.message((String)"project.index.processing.library.sources.progress", (Object[])new Object[]{module.getName()}));
        for (OrderEntry orderEntry : DirectoryIndexImpl.getOrderEntries(module)) {
            VirtualFile[] sourceRoots;
            boolean isLibrary;
            boolean bl = isLibrary = orderEntry instanceof LibraryOrderEntry || orderEntry instanceof JdkOrderEntry;
            if (!isLibrary) continue;
            for (VirtualFile sourceRoot : sourceRoots = orderEntry.getFiles(OrderRootType.SOURCES)) {
                this.fillMapWithLibrarySources(sourceRoot, "", sourceRoot);
            }
        }
    }

    private void fillMapWithLibrarySources(VirtualFile dir, String packageName, VirtualFile sourceRoot) {
        VirtualFile[] children;
        String definedPackage;
        if (DirectoryIndexImpl.isIgnored(dir)) {
            return;
        }
        DirectoryInfo info = this.getOrCreateDirInfo(dir);
        if (info.isInLibrarySource && (definedPackage = this.myDirToPackageName.get(dir)) != null && definedPackage.length() == 0) {
            return;
        }
        info.isInModuleSource = false;
        info.isInLibrarySource = true;
        info.sourceRoot = sourceRoot;
        this.setPackageName(dir, packageName);
        for (VirtualFile child : children = dir.getChildren()) {
            if (!child.isDirectory()) continue;
            String childPackageName = DirectoryIndexImpl.getPackageNameForSubdir(packageName, child.getName());
            this.fillMapWithLibrarySources(child, childPackageName, sourceRoot);
        }
    }

    private void initLibraryClasses(Module module, ProgressIndicator progress) {
        progress.checkCanceled();
        progress.setText2(ProjectBundle.message((String)"project.index.processing.library.classes.progress", (Object[])new Object[]{module.getName()}));
        for (OrderEntry orderEntry : DirectoryIndexImpl.getOrderEntries(module)) {
            VirtualFile[] classRoots;
            boolean isLibrary;
            boolean bl = isLibrary = orderEntry instanceof LibraryOrderEntry || orderEntry instanceof JdkOrderEntry;
            if (!isLibrary) continue;
            for (VirtualFile classRoot : classRoots = orderEntry.getFiles(OrderRootType.CLASSES)) {
                this.fillMapWithLibraryClasses(classRoot, "", classRoot);
            }
        }
    }

    private void fillMapWithLibraryClasses(VirtualFile dir, String packageName, VirtualFile classRoot) {
        VirtualFile[] children;
        String definedPackage;
        if (DirectoryIndexImpl.isIgnored(dir)) {
            return;
        }
        DirectoryInfo info = this.getOrCreateDirInfo(dir);
        if (info.libraryClassRoot != null && (definedPackage = this.myDirToPackageName.get(dir)) != null && definedPackage.length() == 0) {
            return;
        }
        info.libraryClassRoot = classRoot;
        if (!info.isInModuleSource && !info.isInLibrarySource) {
            this.setPackageName(dir, packageName);
        }
        for (VirtualFile child : children = dir.getChildren()) {
            if (!child.isDirectory()) continue;
            String childPackageName = DirectoryIndexImpl.getPackageNameForSubdir(packageName, child.getName());
            this.fillMapWithLibraryClasses(child, childPackageName, classRoot);
        }
    }

    private void initOrderEntries(Module module) {
        List entries;
        HashMap depEntries = new HashMap();
        HashMap libClassRootEntries = new HashMap();
        HashMap libSourceRootEntries = new HashMap();
        for (OrderEntry orderEntry : DirectoryIndexImpl.getOrderEntries(module)) {
            VirtualFile[] classRoots;
            VirtualFile[] sourceRoots;
            if (orderEntry instanceof ModuleOrderEntry) {
                VirtualFile[] importedClassRoots;
                for (VirtualFile importedClassRoot : importedClassRoots = orderEntry.getFiles(OrderRootType.COMPILATION_CLASSES)) {
                    DirectoryIndexImpl.addEntryToMap(importedClassRoot, orderEntry, (Map<VirtualFile, List<OrderEntry>>)depEntries);
                }
                for (VirtualFile sourceRoot : sourceRoots = orderEntry.getFiles(OrderRootType.SOURCES)) {
                    DirectoryIndexImpl.addEntryToMap(sourceRoot, orderEntry, (Map<VirtualFile, List<OrderEntry>>)depEntries);
                }
                continue;
            }
            if (orderEntry instanceof ModuleSourceOrderEntry) {
                VirtualFile[] sourceRoots2;
                List<OrderEntry> oneEntryList = Arrays.asList(orderEntry);
                Module entryModule = orderEntry.getOwnerModule();
                for (VirtualFile sourceRoot : sourceRoots2 = orderEntry.getFiles(OrderRootType.SOURCES)) {
                    this.fillMapWithOrderEntries(sourceRoot, oneEntryList, entryModule, null, null, null, null);
                }
                continue;
            }
            if (!(orderEntry instanceof LibraryOrderEntry) && !(orderEntry instanceof JdkOrderEntry)) continue;
            for (VirtualFile classRoot : classRoots = orderEntry.getFiles(OrderRootType.CLASSES)) {
                DirectoryIndexImpl.addEntryToMap(classRoot, orderEntry, (Map<VirtualFile, List<OrderEntry>>)libClassRootEntries);
            }
            for (VirtualFile sourceRoot : sourceRoots = orderEntry.getFiles(OrderRootType.SOURCES)) {
                DirectoryIndexImpl.addEntryToMap(sourceRoot, orderEntry, (Map<VirtualFile, List<OrderEntry>>)libSourceRootEntries);
            }
        }
        for (Map.Entry mapEntry : depEntries.entrySet()) {
            VirtualFile vRoot = (VirtualFile)mapEntry.getKey();
            entries = (List)mapEntry.getValue();
            this.fillMapWithOrderEntries(vRoot, entries, null, null, null, null, null);
        }
        for (Map.Entry mapEntry : libClassRootEntries.entrySet()) {
            VirtualFile vRoot = (VirtualFile)mapEntry.getKey();
            entries = (List)mapEntry.getValue();
            this.fillMapWithOrderEntries(vRoot, entries, null, vRoot, null, null, null);
        }
        for (Map.Entry mapEntry : libSourceRootEntries.entrySet()) {
            VirtualFile vRoot = (VirtualFile)mapEntry.getKey();
            entries = (List)mapEntry.getValue();
            this.fillMapWithOrderEntries(vRoot, entries, null, null, vRoot, null, null);
        }
    }

    private static void addEntryToMap(VirtualFile vRoot, OrderEntry entry, Map<VirtualFile, List<OrderEntry>> map) {
        List<OrderEntry> list = map.get(vRoot);
        if (list == null) {
            list = new ArrayList<OrderEntry>();
            map.put(vRoot, list);
        }
        list.add(entry);
    }

    private void fillMapWithOrderEntries(VirtualFile dir, List<OrderEntry> orderEntries, Module module, VirtualFile libraryClassRoot, VirtualFile librarySourceRoot, DirectoryInfo parentInfo, List<OrderEntry> oldParentEntries) {
        VirtualFile[] children;
        if (DirectoryIndexImpl.isIgnored(dir)) {
            return;
        }
        DirectoryInfo info = this.myDirToInfoMap.get(dir);
        if (info == null) {
            return;
        }
        if (module != null) {
            if (info.module != module) {
                return;
            }
            if (!info.isInModuleSource) {
                return;
            }
        } else if (libraryClassRoot != null) {
            if (info.libraryClassRoot != libraryClassRoot) {
                return;
            }
            if (info.isInModuleSource) {
                return;
            }
        } else if (librarySourceRoot != null) {
            if (!info.isInLibrarySource) {
                return;
            }
            if (info.sourceRoot != librarySourceRoot) {
                return;
            }
            if (info.libraryClassRoot != null) {
                return;
            }
        }
        List<OrderEntry> oldEntries = info.getOrderEntries();
        info.addOrderEntries(orderEntries, parentInfo, oldParentEntries);
        for (VirtualFile child : children = dir.getChildren()) {
            if (!child.isDirectory()) continue;
            this.fillMapWithOrderEntries(child, orderEntries, module, libraryClassRoot, librarySourceRoot, info, oldEntries);
        }
    }

    private static boolean isIgnored(VirtualFile f) {
        return FileTypeManager.getInstance().isFileIgnored(f.getName());
    }

    @Override
    public DirectoryInfo getInfoForDirectory(VirtualFile dir) {
        this.checkAvailability();
        this.dispatchPendingEvents();
        return this.myDirToInfoMap.get(dir);
    }

    @Override
    public boolean isProjectExcludeRoot(VirtualFile dir) {
        this.checkAvailability();
        return this.myProjectExcludeRoots.contains(dir);
    }

    @Override
    @NotNull
    public Query<VirtualFile> getDirectoriesByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        if (packageName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/DirectoryIndexImpl.getDirectoriesByPackageName must not be null");
        }
        this.checkAvailability();
        Query<VirtualFile> query = this.mySink.search(packageName, includeLibrarySources);
        if (query == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/DirectoryIndexImpl.getDirectoriesByPackageName must not return null");
        }
        return query;
    }

    @Override
    public String getPackageName(VirtualFile dir) {
        return this.myDirToPackageName.get(dir);
    }

    @NotNull
    private List<VirtualFile> doGetDirectoriesByPackageName(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/DirectoryIndexImpl.doGetDirectoriesByPackageName must not be null");
        }
        this.dispatchPendingEvents();
        List<VirtualFile> dirs = this.myPackageNameToDirsMap.get(packageName);
        List<Object> list = dirs != null ? dirs : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/DirectoryIndexImpl.doGetDirectoriesByPackageName must not return null");
        }
        return list;
    }

    private void dispatchPendingEvents() {
        this.myConnection.deliverImmediately();
    }

    private void checkAvailability() {
        if (!this.myInitialized) {
            LOG.error("Directory index is not initialized yet for " + this.myProject);
        }
        if (this.myDisposed) {
            LOG.error("Directory index is already disposed for " + this.myProject);
        }
    }

    private DirectoryInfo getOrCreateDirInfo(VirtualFile dir) {
        DirectoryInfo info = this.myDirToInfoMap.get(dir);
        if (info == null) {
            info = new DirectoryInfo();
            this.myDirToInfoMap.put(dir, info);
        }
        return info;
    }

    private void setPackageName(VirtualFile dir, String newPackageName) {
        assert (dir != null);
        String oldPackageName = this.myDirToPackageName.get(dir);
        if (oldPackageName != null) {
            List<VirtualFile> oldPackageDirs = this.myPackageNameToDirsMap.get(oldPackageName);
            boolean removed = oldPackageDirs.remove(dir);
            assert (removed);
            if (oldPackageDirs.size() == 0) {
                this.myPackageNameToDirsMap.remove(oldPackageName);
            }
        }
        if (newPackageName != null) {
            SmartList newPackageDirs = this.myPackageNameToDirsMap.get(newPackageName);
            if (newPackageDirs == null) {
                newPackageDirs = new SmartList();
                this.myPackageNameToDirsMap.put(newPackageName, (List<VirtualFile>)newPackageDirs);
            }
            newPackageDirs.add((VirtualFile)dir);
            this.myDirToPackageName.put(dir, newPackageName);
        } else {
            this.myDirToPackageName.remove(dir);
        }
    }

    @Nullable
    private static String getPackageNameForSubdir(String parentPackageName, String subdirName) {
        if (parentPackageName == null) {
            return null;
        }
        return parentPackageName.length() > 0 ? parentPackageName + "." + subdirName : subdirName;
    }

    private class MyVirtualFileListener
    extends VirtualFileAdapter {
        private final Key<List<VirtualFile>> FILES_TO_RELEASE_KEY = Key.create((String)"DirectoryIndexImpl.MyVirtualFileListener.FILES_TO_RELEASE_KEY");

        private MyVirtualFileListener() {
        }

        public void fileCreated(VirtualFileEvent event) {
            VirtualFile file = event.getFile();
            if (!file.isDirectory()) {
                return;
            }
            VirtualFile parent = file.getParent();
            if (parent == null) {
                return;
            }
            if (DirectoryIndexImpl.isIgnored(file)) {
                return;
            }
            DirectoryInfo parentInfo = (DirectoryInfo)DirectoryIndexImpl.this.myDirToInfoMap.get(parent);
            if (parentInfo == null) {
                return;
            }
            Module module = parentInfo.module;
            for (DirectoryIndexExcludePolicy policy : DirectoryIndexImpl.this.myExcludePolicies) {
                if (!policy.isExcludeRoot(file)) continue;
                return;
            }
            DirectoryIndexImpl.this.fillMapWithModuleContent(file, module, parentInfo.contentRoot);
            String parentPackage = (String)DirectoryIndexImpl.this.myDirToPackageName.get(parent);
            if (module != null && parentInfo.isInModuleSource) {
                String newDirPackageName = DirectoryIndexImpl.getPackageNameForSubdir(parentPackage, file.getName());
                DirectoryIndexImpl.this.fillMapWithModuleSource(file, module, newDirPackageName, parentInfo.sourceRoot, parentInfo.isTestSource);
            }
            if (parentInfo.libraryClassRoot != null) {
                String newDirPackageName = DirectoryIndexImpl.getPackageNameForSubdir(parentPackage, file.getName());
                DirectoryIndexImpl.this.fillMapWithLibraryClasses(file, newDirPackageName, parentInfo.libraryClassRoot);
            }
            if (parentInfo.isInLibrarySource) {
                String newDirPackageName = DirectoryIndexImpl.getPackageNameForSubdir(parentPackage, file.getName());
                DirectoryIndexImpl.this.fillMapWithLibrarySources(file, newDirPackageName, parentInfo.sourceRoot);
            }
            if (!parentInfo.getOrderEntries().isEmpty()) {
                DirectoryIndexImpl.this.fillMapWithOrderEntries(file, parentInfo.getOrderEntries(), null, null, null, parentInfo, null);
            }
        }

        public void beforeFileDeletion(VirtualFileEvent event) {
            VirtualFile file = event.getFile();
            if (!file.isDirectory()) {
                return;
            }
            if (!DirectoryIndexImpl.this.myDirToInfoMap.containsKey(file)) {
                return;
            }
            ArrayList<VirtualFile> list = new ArrayList<VirtualFile>();
            this.addDirsRecursively(list, file);
            file.putUserData(this.FILES_TO_RELEASE_KEY, list);
        }

        private void addDirsRecursively(ArrayList<VirtualFile> list, VirtualFile dir) {
            if (!DirectoryIndexImpl.this.myDirToInfoMap.containsKey(dir) || !(dir instanceof NewVirtualFile)) {
                return;
            }
            list.add(dir);
            for (VirtualFile child : ((NewVirtualFile)dir).getCachedChildren()) {
                if (!child.isDirectory()) continue;
                this.addDirsRecursively(list, child);
            }
        }

        public void fileDeleted(VirtualFileEvent event) {
            VirtualFile file = event.getFile();
            List list = (List)file.getUserData(this.FILES_TO_RELEASE_KEY);
            if (list == null) {
                return;
            }
            for (VirtualFile dir : list) {
                DirectoryInfo info = (DirectoryInfo)DirectoryIndexImpl.this.myDirToInfoMap.remove(dir);
                if (info == null) continue;
                DirectoryIndexImpl.this.setPackageName(dir, null);
            }
        }

        public void fileMoved(VirtualFileMoveEvent event) {
            VirtualFile file = event.getFile();
            if (file.isDirectory()) {
                DirectoryIndexImpl.this.doInitialize();
            }
        }

        public void propertyChanged(VirtualFilePropertyEvent event) {
            VirtualFile file;
            if ("name".equals(event.getPropertyName()) && (file = event.getFile()).isDirectory()) {
                DirectoryIndexImpl.this.doInitialize();
            }
        }
    }

    private class PackageSink
    extends QueryFactory<VirtualFile, List<VirtualFile>> {
        private PackageSink() {
            this.registerExecutor((QueryExecutor)new QueryExecutor<VirtualFile, List<VirtualFile>>(){

                public boolean execute(List<VirtualFile> allDirs, Processor<VirtualFile> consumer) {
                    for (VirtualFile dir : allDirs) {
                        DirectoryInfo info = DirectoryIndexImpl.this.getInfoForDirectory(dir);
                        assert (info != null);
                        if (info.isInLibrarySource && info.libraryClassRoot == null || consumer.process((Object)dir)) continue;
                        return false;
                    }
                    return true;
                }
            });
        }

        public Query<VirtualFile> search(@NotNull String packageName, boolean includeLibrarySources) {
            if (packageName == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/DirectoryIndexImpl$PackageSink.search must not be null");
            }
            List allDirs = DirectoryIndexImpl.this.doGetDirectoriesByPackageName(packageName);
            return new FilteredQuery((Query)(includeLibrarySources ? new CollectionQuery((Collection)allDirs) : this.createQuery(allDirs)), IS_VALID);
        }
    }
}

