/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.PersistentOrderRootType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.RootProviderBaseImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryTableBase;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.HashMap;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryImpl
implements LibraryEx.ModifiableModelEx,
LibraryEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.impl.LibraryImpl");
    @NonNls
    public static final String LIBRARY_NAME_ATTR = "name";
    @NonNls
    private static final String ROOT_PATH_ELEMENT = "root";
    @NonNls
    public static final String ELEMENT = "library";
    @NonNls
    private static final String JAR_DIRECTORY_ELEMENT = "jarDirectory";
    @NonNls
    private static final String URL_ATTR = "url";
    @NonNls
    private static final String RECURSIVE_ATTR = "recursive";
    private String myName;
    private final LibraryTable myLibraryTable;
    private final Map<OrderRootType, VirtualFilePointerContainer> myRoots;
    private final Map<String, Boolean> myJarDirectories = new HashMap();
    private final List<LocalFileSystem.WatchRequest> myWatchRequests = new ArrayList<LocalFileSystem.WatchRequest>();
    private final LibraryImpl mySource;
    private final MyRootProviderImpl myRootProvider = new MyRootProviderImpl();
    private final ModifiableRootModel myRootModel;
    private MessageBusConnection myBusConnection = null;
    private boolean myDisposed;
    private final Disposable myPointersDisposable = Disposer.newDisposable();

    LibraryImpl(LibraryTable table, Element element, ModifiableRootModel rootModel) throws InvalidDataException {
        this.myLibraryTable = table;
        this.myRootModel = rootModel;
        this.mySource = null;
        this.readName(element);
        this.readJarDirectories(element);
        this.myRoots = this.initRoots();
        this.readRoots(element);
        this.updateWatchedRoots();
    }

    LibraryImpl(String name, LibraryTable table, ModifiableRootModel rootModel) {
        this.myName = name;
        this.myLibraryTable = table;
        this.myRootModel = rootModel;
        this.myRoots = this.initRoots();
        this.mySource = null;
    }

    private LibraryImpl(LibraryImpl from, LibraryImpl newSource, ModifiableRootModel rootModel) {
        assert (!from.isDisposed());
        this.myRootModel = rootModel;
        this.myName = from.myName;
        this.myRoots = this.initRoots();
        this.mySource = newSource;
        this.myLibraryTable = from.myLibraryTable;
        for (OrderRootType rootType : OrderRootType.getAllTypes()) {
            VirtualFilePointerContainer thisContainer = this.myRoots.get(rootType);
            VirtualFilePointerContainer thatContainer = from.myRoots.get(rootType);
            thisContainer.addAll(thatContainer);
        }
        this.myJarDirectories.putAll(from.myJarDirectories);
    }

    public void dispose() {
        assert (!this.isDisposed());
        if (!this.myWatchRequests.isEmpty()) {
            LocalFileSystem.getInstance().removeWatchedRoots(this.myWatchRequests);
            this.myWatchRequests.clear();
        }
        if (this.myBusConnection != null) {
            this.myBusConnection.disconnect();
            this.myBusConnection = null;
        }
        this.myDisposed = true;
    }

    @Override
    public boolean isDisposed() {
        return this.myDisposed;
    }

    public String getName() {
        return this.myName;
    }

    @NotNull
    public String[] getUrls(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/libraries/LibraryImpl.getUrls must not be null");
        }
        assert (!this.isDisposed());
        VirtualFilePointerContainer result = this.myRoots.get(rootType);
        String[] stringArray = result.getUrls();
        if (stringArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/libraries/LibraryImpl.getUrls must not return null");
        }
        return stringArray;
    }

    @NotNull
    public VirtualFile[] getFiles(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/libraries/LibraryImpl.getFiles must not be null");
        }
        assert (!this.isDisposed());
        ArrayList<VirtualFile> expanded = new ArrayList<VirtualFile>();
        for (VirtualFile file : this.myRoots.get(rootType).getFiles()) {
            Boolean expandRecursively;
            if (file.isDirectory() && (expandRecursively = this.myJarDirectories.get(file.getUrl())) != null) {
                LibraryImpl.addChildren(file, expanded, expandRecursively);
                continue;
            }
            expanded.add(file);
        }
        VirtualFile[] virtualFileArray = VfsUtil.toVirtualFileArray(expanded);
        if (virtualFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/libraries/LibraryImpl.getFiles must not return null");
        }
        return virtualFileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addChildren(VirtualFile dir, List<VirtualFile> container, boolean recursively) {
        for (VirtualFile child : dir.getChildren()) {
            FileType fileType = child.getFileType();
            if (FileTypes.ARCHIVE.equals(fileType)) {
                StringBuilder builder = StringBuilderSpinAllocator.alloc();
                try {
                    builder.append(VirtualFileManager.constructUrl((String)"jar", (String)child.getPath()));
                    builder.append("!/");
                    VirtualFile jarRoot = VirtualFileManager.getInstance().findFileByUrl(builder.toString());
                    if (jarRoot == null) continue;
                    container.add(jarRoot);
                    continue;
                }
                finally {
                    StringBuilderSpinAllocator.dispose((StringBuilder)builder);
                }
            }
            if (!recursively || !child.isDirectory()) continue;
            LibraryImpl.addChildren(child, container, recursively);
        }
    }

    public void setName(String name) {
        LOG.assertTrue(this.isWritable());
        this.myName = name;
    }

    @NotNull
    public Library.ModifiableModel getModifiableModel() {
        assert (!this.isDisposed());
        LibraryImpl libraryImpl = new LibraryImpl(this, this, this.myRootModel);
        if (libraryImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/libraries/LibraryImpl.getModifiableModel must not return null");
        }
        return libraryImpl;
    }

    @Override
    public Library cloneLibrary(RootModelImpl rootModel) {
        LOG.assertTrue(this.myLibraryTable == null);
        LibraryImpl clone = new LibraryImpl(this, null, (ModifiableRootModel)rootModel);
        clone.updateWatchedRoots();
        return clone;
    }

    @Override
    public boolean allPathsValid(OrderRootType type) {
        List pointers = this.myRoots.get(type).getList();
        for (VirtualFilePointer pointer : pointers) {
            if (pointer.isValid()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public RootProvider getRootProvider() {
        MyRootProviderImpl myRootProviderImpl = this.myRootProvider;
        if (myRootProviderImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/libraries/LibraryImpl.getRootProvider must not return null");
        }
        return myRootProviderImpl;
    }

    private Map<OrderRootType, VirtualFilePointerContainer> initRoots() {
        Disposer.register((Disposable)this, (Disposable)this.myPointersDisposable);
        HashMap result = new HashMap(5);
        for (OrderRootType rootType : OrderRootType.getAllTypes()) {
            result.put(rootType, VirtualFilePointerManager.getInstance().createContainer(this.myPointersDisposable));
        }
        result.put(OrderRootType.COMPILATION_CLASSES, result.get(OrderRootType.CLASSES));
        result.put(OrderRootType.PRODUCTION_COMPILATION_CLASSES, result.get(OrderRootType.CLASSES));
        result.put(OrderRootType.CLASSES_AND_OUTPUT, result.get(OrderRootType.CLASSES));
        return result;
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.readName(element);
        this.readRoots(element);
        this.readJarDirectories(element);
        this.updateWatchedRoots();
    }

    private void readName(Element element) {
        this.myName = element.getAttributeValue(LIBRARY_NAME_ATTR);
    }

    private void readRoots(Element element) throws InvalidDataException {
        for (OrderRootType rootType : OrderRootType.getAllTypes()) {
            Element rootChild = element.getChild(rootType.name());
            if (rootChild == null) continue;
            VirtualFilePointerContainer roots = this.myRoots.get(rootType);
            roots.readExternal(rootChild, ROOT_PATH_ELEMENT);
        }
    }

    private void readJarDirectories(Element element) {
        this.myJarDirectories.clear();
        List jarDirs = element.getChildren(JAR_DIRECTORY_ELEMENT);
        for (Object item : jarDirs) {
            Element jarDir = (Element)item;
            String url = jarDir.getAttributeValue(URL_ATTR);
            String recursive = jarDir.getAttributeValue(RECURSIVE_ATTR);
            if (url == null) continue;
            this.myJarDirectories.put(url, Boolean.parseBoolean(recursive));
        }
    }

    public void writeExternal(Element rootElement) {
        LOG.assertTrue(!this.isDisposed(), (Object)"Already disposed!");
        Element element = new Element(ELEMENT);
        if (this.myName != null) {
            element.setAttribute(LIBRARY_NAME_ATTR, this.myName);
        }
        for (PersistentOrderRootType rootType : OrderRootType.getSortedRootTypes()) {
            VirtualFilePointerContainer roots = this.myRoots.get(rootType);
            if (roots.size() == 0 && rootType.skipWriteIfEmpty()) continue;
            Element rootTypeElement = new Element(rootType.name());
            roots.writeExternal(rootTypeElement, ROOT_PATH_ELEMENT);
            element.addContent(rootTypeElement);
        }
        ArrayList<String> urls = new ArrayList<String>(this.myJarDirectories.keySet());
        Collections.sort(urls, new Comparator<String>(){

            @Override
            public int compare(String url1, String url2) {
                return url1.compareToIgnoreCase(url2);
            }
        });
        for (String url : urls) {
            Element jarDirElement = new Element(JAR_DIRECTORY_ELEMENT);
            jarDirElement.setAttribute(URL_ATTR, url);
            jarDirElement.setAttribute(RECURSIVE_ATTR, this.myJarDirectories.get(url).toString());
            element.addContent(jarDirElement);
        }
        rootElement.addContent(element);
    }

    private boolean isWritable() {
        return this.mySource != null;
    }

    public void addRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/libraries/LibraryImpl.addRoot must not be null");
        }
        if (rootType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/impl/libraries/LibraryImpl.addRoot must not be null");
        }
        LOG.assertTrue(this.isWritable());
        assert (!this.isDisposed());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        container.add(url);
    }

    public void addRoot(@NotNull VirtualFile file, @NotNull OrderRootType rootType) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/libraries/LibraryImpl.addRoot must not be null");
        }
        if (rootType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/impl/libraries/LibraryImpl.addRoot must not be null");
        }
        LOG.assertTrue(this.isWritable());
        assert (!this.isDisposed());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        container.add(file);
    }

    public void addJarDirectory(@NotNull String url, boolean recursive) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/libraries/LibraryImpl.addJarDirectory must not be null");
        }
        assert (!this.isDisposed());
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(OrderRootType.CLASSES);
        container.add(url);
        this.myJarDirectories.put(url, recursive);
    }

    public void addJarDirectory(@NotNull VirtualFile file, boolean recursive) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/libraries/LibraryImpl.addJarDirectory must not be null");
        }
        assert (!this.isDisposed());
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(OrderRootType.CLASSES);
        container.add(file);
        this.myJarDirectories.put(file.getUrl(), recursive);
    }

    public boolean isJarDirectory(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/libraries/LibraryImpl.isJarDirectory must not be null");
        }
        return this.myJarDirectories.containsKey(url);
    }

    public boolean isValid(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/libraries/LibraryImpl.isValid must not be null");
        }
        if (rootType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/impl/libraries/LibraryImpl.isValid must not be null");
        }
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        VirtualFilePointer fp = container.findByUrl(url);
        return fp != null && fp.isValid();
    }

    public boolean removeRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/libraries/LibraryImpl.removeRoot must not be null");
        }
        if (rootType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/impl/libraries/LibraryImpl.removeRoot must not be null");
        }
        assert (!this.isDisposed());
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        VirtualFilePointer byUrl = container.findByUrl(url);
        if (byUrl != null) {
            container.remove(byUrl);
            this.myJarDirectories.remove(url);
            return true;
        }
        return false;
    }

    public void moveRootUp(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/libraries/LibraryImpl.moveRootUp must not be null");
        }
        if (rootType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/impl/libraries/LibraryImpl.moveRootUp must not be null");
        }
        assert (!this.isDisposed());
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        container.moveUp(url);
    }

    public void moveRootDown(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/libraries/LibraryImpl.moveRootDown must not be null");
        }
        if (rootType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/impl/libraries/LibraryImpl.moveRootDown must not be null");
        }
        assert (!this.isDisposed());
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        container.moveDown(url);
    }

    public boolean isChanged() {
        return !this.mySource.equals(this);
    }

    private boolean areRootsChanged(LibraryImpl that) {
        return !that.equals(this);
    }

    public Library getSource() {
        return this.mySource;
    }

    public void commit() {
        assert (!this.isDisposed());
        this.mySource.commit(this);
        Disposer.dispose((Disposable)this);
    }

    private void commit(@NotNull LibraryImpl fromModel) {
        if (fromModel == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/libraries/LibraryImpl.commit must not be null");
        }
        if (this.myLibraryTable != null) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
        }
        if (!Comparing.equal((String)fromModel.myName, (String)this.myName)) {
            this.myName = fromModel.myName;
            if (this.myLibraryTable instanceof LibraryTableBase) {
                ((LibraryTableBase)this.myLibraryTable).fireLibraryRenamed(this);
            }
        }
        if (this.areRootsChanged(fromModel)) {
            this.disposeMyPointers();
            this.copyRootsFrom(fromModel);
            this.myJarDirectories.clear();
            this.myJarDirectories.putAll(fromModel.myJarDirectories);
            this.updateWatchedRoots();
            this.myRootProvider.fireRootSetChanged();
        }
    }

    private void copyRootsFrom(LibraryImpl fromModel) {
        this.myRoots.clear();
        for (Map.Entry<OrderRootType, VirtualFilePointerContainer> entry : fromModel.myRoots.entrySet()) {
            OrderRootType rootType = entry.getKey();
            VirtualFilePointerContainer container = entry.getValue();
            VirtualFilePointerContainer clone = container.clone(this.myPointersDisposable);
            this.myRoots.put(rootType, clone);
        }
    }

    private void disposeMyPointers() {
        for (VirtualFilePointerContainer container : new THashSet(this.myRoots.values())) {
            container.killAll();
        }
        Disposer.dispose((Disposable)this.myPointersDisposable);
        Disposer.register((Disposable)this, (Disposable)this.myPointersDisposable);
    }

    private void updateWatchedRoots() {
        LocalFileSystem fs = LocalFileSystem.getInstance();
        if (!this.myWatchRequests.isEmpty()) {
            fs.removeWatchedRoots(this.myWatchRequests);
            this.myWatchRequests.clear();
        }
        if (!this.myJarDirectories.isEmpty()) {
            VirtualFileManager fm = VirtualFileManager.getInstance();
            for (Map.Entry<String, Boolean> entry : this.myJarDirectories.entrySet()) {
                String url = entry.getKey();
                if (!(fm.getFileSystem(VirtualFileManager.extractProtocol((String)url)) instanceof LocalFileSystem)) continue;
                boolean watchRecursively = entry.getValue();
                LocalFileSystem.WatchRequest request = fs.addRootToWatch(VirtualFileManager.extractPath((String)url), watchRecursively);
                this.myWatchRequests.add(request);
            }
            if (this.myBusConnection == null) {
                this.myBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
                this.myBusConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

                    public void before(List<? extends VFileEvent> events) {
                    }

                    public void after(List<? extends VFileEvent> events) {
                        boolean changesDetected = false;
                        for (VFileEvent vFileEvent : events) {
                            VFileCreateEvent createEvent;
                            if (vFileEvent instanceof VFileCopyEvent) {
                                VFileCopyEvent copyEvent = (VFileCopyEvent)vFileEvent;
                                if (!this.isUnderJarDirectory(copyEvent.getNewParent() + "/" + copyEvent.getNewChildName()) && !this.isUnderJarDirectory(copyEvent.getFile().getUrl())) continue;
                                changesDetected = true;
                                break;
                            }
                            if (vFileEvent instanceof VFileMoveEvent) {
                                VFileMoveEvent moveEvent = (VFileMoveEvent)vFileEvent;
                                VirtualFile file = moveEvent.getFile();
                                if (!this.isUnderJarDirectory(file.getUrl()) && !this.isUnderJarDirectory(moveEvent.getOldParent().getUrl() + "/" + file.getName())) continue;
                                changesDetected = true;
                                break;
                            }
                            if (vFileEvent instanceof VFileDeleteEvent) {
                                VFileDeleteEvent deleteEvent = (VFileDeleteEvent)vFileEvent;
                                if (!this.isUnderJarDirectory(deleteEvent.getFile().getUrl())) continue;
                                changesDetected = true;
                                break;
                            }
                            if (!(vFileEvent instanceof VFileCreateEvent) || !this.isUnderJarDirectory((createEvent = (VFileCreateEvent)vFileEvent).getParent().getUrl() + "/" + createEvent.getChildName())) continue;
                            changesDetected = true;
                            break;
                        }
                        if (changesDetected) {
                            LibraryImpl.this.myRootProvider.fireRootSetChanged();
                        }
                    }

                    private boolean isUnderJarDirectory(String url) {
                        for (String rootUrl : LibraryImpl.this.myJarDirectories.keySet()) {
                            if (!FileUtil.startsWith((String)url, (String)rootUrl)) continue;
                            return true;
                        }
                        return false;
                    }
                });
            }
        } else {
            MessageBusConnection connection = this.myBusConnection;
            if (connection != null) {
                this.myBusConnection = null;
                connection.disconnect();
            }
        }
    }

    public LibraryTable getTable() {
        return this.myLibraryTable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LibraryImpl library = (LibraryImpl)o;
        if (!((Object)this.myJarDirectories).equals(library.myJarDirectories)) {
            return false;
        }
        if (this.myName != null ? !this.myName.equals(library.myName) : library.myName != null) {
            return false;
        }
        return !(this.myRoots != null ? !((Object)this.myRoots).equals(library.myRoots) : library.myRoots != null);
    }

    public int hashCode() {
        int result = this.myName != null ? this.myName.hashCode() : 0;
        result = 31 * result + (this.myRoots != null ? ((Object)this.myRoots).hashCode() : 0);
        result = 31 * result + (this.myJarDirectories != null ? ((Object)this.myJarDirectories).hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Library: name:" + this.myName + "; jars:" + this.myJarDirectories.keySet() + "; roots:" + this.myRoots.values();
    }

    @Nullable(value="will return non-null value only for module level libraries")
    public Module getModule() {
        return this.myRootModel == null ? null : this.myRootModel.getModule();
    }

    private class MyRootProviderImpl
    extends RootProviderBaseImpl {
        private MyRootProviderImpl() {
        }

        @NotNull
        public String[] getUrls(@NotNull OrderRootType rootType) {
            if (rootType == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/libraries/LibraryImpl$MyRootProviderImpl.getUrls must not be null");
            }
            LinkedHashSet<String> originalUrls = new LinkedHashSet<String>(Arrays.asList(LibraryImpl.this.getUrls(rootType)));
            for (VirtualFile file : this.getFiles(rootType)) {
                originalUrls.add(file.getUrl());
            }
            String[] stringArray = ArrayUtil.toStringArray(originalUrls);
            if (stringArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/libraries/LibraryImpl$MyRootProviderImpl.getUrls must not return null");
            }
            return stringArray;
        }

        @NotNull
        public VirtualFile[] getFiles(@NotNull OrderRootType rootType) {
            if (rootType == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/impl/libraries/LibraryImpl$MyRootProviderImpl.getFiles must not be null");
            }
            VirtualFile[] virtualFileArray = LibraryImpl.this.getFiles(rootType);
            if (virtualFileArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/impl/libraries/LibraryImpl$MyRootProviderImpl.getFiles must not return null");
            }
            return virtualFileArray;
        }

        @Override
        public void fireRootSetChanged() {
            super.fireRootSetChanged();
        }
    }
}

