/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.configuration.LibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibrariesContainerFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory");
    private static final Library[] EMPTY_LIBRARIES_ARRAY = new Library[0];

    private LibrariesContainerFactory() {
    }

    @NotNull
    public static LibrariesContainer createContainer(@Nullable Project project) {
        LibrariesContainerImpl librariesContainerImpl = new LibrariesContainerImpl(project, null, null);
        if (librariesContainerImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory.createContainer must not return null");
        }
        return librariesContainerImpl;
    }

    @NotNull
    public static LibrariesContainer createContainer(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory.createContainer must not be null");
        }
        LibrariesContainerImpl librariesContainerImpl = new LibrariesContainerImpl(module.getProject(), module, null);
        if (librariesContainerImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory.createContainer must not return null");
        }
        return librariesContainerImpl;
    }

    @NotNull
    public static LibrariesContainer createContainer(@NotNull ModifiableRootModel rootModel) {
        if (rootModel == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory.createContainer must not be null");
        }
        Module module = rootModel.getModule();
        LibrariesContainerImpl librariesContainerImpl = new LibrariesContainerImpl(module.getProject(), module, rootModel);
        if (librariesContainerImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory.createContainer must not return null");
        }
        return librariesContainerImpl;
    }

    @NotNull
    public static LibrariesContainer createContainer() {
        LibrariesContainerImpl librariesContainerImpl = new LibrariesContainerImpl(null, null, null);
        if (librariesContainerImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory.createContainer must not return null");
        }
        return librariesContainerImpl;
    }

    public static LibrariesContainer createContainer(@NotNull Project project, StructureConfigurableContext context) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory.createContainer must not be null");
        }
        return new StructureConfigurableLibrariesContainer(project, context);
    }

    public static Library createLibrary(@Nullable LibrariesContainer container1, @NotNull LibrariesContainer container2, @NotNull @NonNls String name, @NotNull LibrariesContainer.LibraryLevel level, @NotNull VirtualFile[] classRoots, @NotNull VirtualFile[] sourceRoots) {
        if (container2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory.createLibrary must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory.createLibrary must not be null");
        }
        if (level == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory.createLibrary must not be null");
        }
        if (classRoots == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory.createLibrary must not be null");
        }
        if (sourceRoots == null) {
            throw new IllegalArgumentException("Argument 5 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory.createLibrary must not be null");
        }
        if (container1 != null && container1.canCreateLibrary(level)) {
            return container1.createLibrary(name, level, classRoots, sourceRoots);
        }
        return container2.createLibrary(name, level, classRoots, sourceRoots);
    }

    @NotNull
    public static Library createLibraryInTable(@NonNls String name, VirtualFile[] roots, VirtualFile[] sources, LibraryTable table) {
        LibraryTable.ModifiableModel modifiableModel = table.getModifiableModel();
        Library library = modifiableModel.createLibrary(LibrariesContainerFactory.getUniqueLibraryName(name, modifiableModel));
        Library.ModifiableModel model = library.getModifiableModel();
        for (VirtualFile root : roots) {
            model.addRoot(root, OrderRootType.CLASSES);
        }
        for (VirtualFile root : sources) {
            model.addRoot(root, OrderRootType.SOURCES);
        }
        model.commit();
        modifiableModel.commit();
        Library library2 = library;
        if (library2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory.createLibraryInTable must not return null");
        }
        return library2;
    }

    private static String getUniqueLibraryName(String baseName, LibraryTable.ModifiableModel model) {
        String name = baseName;
        int count = 2;
        while (model.getLibraryByName(name) != null) {
            name = baseName + " (" + count++ + ")";
        }
        return name;
    }

    private static class StructureConfigurableLibrariesContainer
    extends LibrariesContainerBase {
        private final Project myProject;
        private final StructureConfigurableContext myContext;

        public StructureConfigurableLibrariesContainer(Project project, StructureConfigurableContext context) {
            this.myProject = project;
            this.myContext = context;
        }

        @Override
        public Library createLibrary(@NotNull @NonNls String name, @NotNull LibrariesContainer.LibraryLevel level, @NotNull VirtualFile[] classRoots, @NotNull VirtualFile[] sourceRoots) {
            if (name == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$StructureConfigurableLibrariesContainer.createLibrary must not be null");
            }
            if (level == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$StructureConfigurableLibrariesContainer.createLibrary must not be null");
            }
            if (classRoots == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$StructureConfigurableLibrariesContainer.createLibrary must not be null");
            }
            if (sourceRoots == null) {
                throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$StructureConfigurableLibrariesContainer.createLibrary must not be null");
            }
            LibraryTableModifiableModelProvider provider = this.getProvider(level);
            if (provider == null) {
                LOG.error("cannot create module library in this context");
            }
            LibraryTable.ModifiableModel model = provider.getModifiableModel();
            Library library = model.createLibrary(LibrariesContainerFactory.getUniqueLibraryName(name, model));
            LibraryEditor libraryEditor = ((LibrariesModifiableModel)model).getLibraryEditor(library);
            for (VirtualFile root : classRoots) {
                libraryEditor.addRoot(root, OrderRootType.CLASSES);
            }
            for (VirtualFile source : sourceRoots) {
                libraryEditor.addRoot(source, OrderRootType.SOURCES);
            }
            return library;
        }

        @Override
        @Nullable
        public Project getProject() {
            return this.myProject;
        }

        @Override
        @NotNull
        public Library[] getLibraries(@NotNull LibrariesContainer.LibraryLevel libraryLevel) {
            if (libraryLevel == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$StructureConfigurableLibrariesContainer.getLibraries must not be null");
            }
            LibraryTableModifiableModelProvider provider = this.getProvider(libraryLevel);
            Library[] libraryArray = provider != null ? provider.getModifiableModel().getLibraries() : EMPTY_LIBRARIES_ARRAY;
            if (libraryArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$StructureConfigurableLibrariesContainer.getLibraries must not return null");
            }
            return libraryArray;
        }

        @Nullable
        private LibraryTableModifiableModelProvider getProvider(LibrariesContainer.LibraryLevel libraryLevel) {
            if (libraryLevel == LibrariesContainer.LibraryLevel.PROJECT) {
                return this.myContext.getProjectLibrariesProvider(false);
            }
            if (libraryLevel == LibrariesContainer.LibraryLevel.GLOBAL) {
                return this.myContext.getGlobalLibrariesProvider(false);
            }
            return null;
        }

        @Override
        public boolean canCreateLibrary(@NotNull LibrariesContainer.LibraryLevel level) {
            if (level == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$StructureConfigurableLibrariesContainer.canCreateLibrary must not be null");
            }
            return level == LibrariesContainer.LibraryLevel.GLOBAL || level == LibrariesContainer.LibraryLevel.PROJECT;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public VirtualFile[] getLibraryFiles(@NotNull Library library, @NotNull OrderRootType rootType) {
            VirtualFile[] virtualFileArray;
            if (library == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$StructureConfigurableLibrariesContainer.getLibraryFiles must not be null");
            }
            if (rootType == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$StructureConfigurableLibrariesContainer.getLibraryFiles must not be null");
            }
            LibrariesModifiableModel projectLibrariesModel = (LibrariesModifiableModel)this.myContext.getProjectLibrariesProvider(false).getModifiableModel();
            if (projectLibrariesModel.hasLibraryEditor(library)) {
                LibraryEditor libraryEditor = projectLibrariesModel.getLibraryEditor(library);
                virtualFileArray = libraryEditor.getFiles(rootType);
                if (virtualFileArray == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$StructureConfigurableLibrariesContainer.getLibraryFiles must not return null");
                return virtualFileArray;
            }
            LibrariesModifiableModel globalLibraries = (LibrariesModifiableModel)this.myContext.getGlobalLibrariesProvider(false).getModifiableModel();
            if (globalLibraries.hasLibraryEditor(library)) {
                LibraryEditor libraryEditor = globalLibraries.getLibraryEditor(library);
                virtualFileArray = libraryEditor.getFiles(rootType);
                if (virtualFileArray == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$StructureConfigurableLibrariesContainer.getLibraryFiles must not return null");
                return virtualFileArray;
            }
            virtualFileArray = library.getFiles(rootType);
            if (virtualFileArray != null) return virtualFileArray;
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$StructureConfigurableLibrariesContainer.getLibraryFiles must not return null");
        }
    }

    private static class LibrariesContainerImpl
    extends LibrariesContainerBase {
        @Nullable
        private final Project myProject;
        @Nullable
        private final Module myModule;
        @Nullable
        private final ModifiableRootModel myRootModel;

        private LibrariesContainerImpl(@Nullable Project project, @Nullable Module module, @Nullable ModifiableRootModel rootModel) {
            this.myProject = project;
            this.myModule = module;
            this.myRootModel = rootModel;
        }

        @Override
        @Nullable
        public Project getProject() {
            return this.myProject;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @NotNull
        public Library[] getLibraries(@NotNull LibrariesContainer.LibraryLevel libraryLevel) {
            Library[] libraryArray;
            if (libraryLevel == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerImpl.getLibraries must not be null");
            }
            if (libraryLevel == LibrariesContainer.LibraryLevel.MODULE && this.myModule != null) {
                libraryArray = this.getModuleLibraries();
                if (libraryArray == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerImpl.getLibraries must not return null");
                return libraryArray;
            }
            LibraryTablesRegistrar registrar = LibraryTablesRegistrar.getInstance();
            if (libraryLevel == LibrariesContainer.LibraryLevel.GLOBAL) {
                libraryArray = registrar.getLibraryTable().getLibraries();
                if (libraryArray == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerImpl.getLibraries must not return null");
                return libraryArray;
            }
            if (libraryLevel == LibrariesContainer.LibraryLevel.PROJECT && this.myProject != null) {
                libraryArray = registrar.getLibraryTable(this.myProject).getLibraries();
                if (libraryArray == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerImpl.getLibraries must not return null");
                return libraryArray;
            }
            libraryArray = EMPTY_LIBRARIES_ARRAY;
            if (libraryArray != null) return libraryArray;
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerImpl.getLibraries must not return null");
        }

        private Library[] getModuleLibraries() {
            if (this.myRootModel != null) {
                return this.myRootModel.getModuleLibraryTable().getLibraries();
            }
            OrderEntry[] orderEntries = ModuleRootManager.getInstance((Module)this.myModule).getOrderEntries();
            ArrayList<Library> libraries = new ArrayList<Library>();
            for (OrderEntry orderEntry : orderEntries) {
                LibraryOrderEntry entry;
                if (!(orderEntry instanceof LibraryOrderEntry) || !(entry = (LibraryOrderEntry)orderEntry).isModuleLevel()) continue;
                libraries.add(entry.getLibrary());
            }
            return libraries.toArray(new Library[libraries.size()]);
        }

        @Override
        @NotNull
        public VirtualFile[] getLibraryFiles(@NotNull Library library, @NotNull OrderRootType rootType) {
            if (library == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerImpl.getLibraryFiles must not be null");
            }
            if (rootType == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerImpl.getLibraryFiles must not be null");
            }
            VirtualFile[] virtualFileArray = library.getFiles(rootType);
            if (virtualFileArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerImpl.getLibraryFiles must not return null");
            }
            return virtualFileArray;
        }

        @Override
        public boolean canCreateLibrary(@NotNull LibrariesContainer.LibraryLevel level) {
            if (level == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerImpl.canCreateLibrary must not be null");
            }
            if (level == LibrariesContainer.LibraryLevel.MODULE) {
                return this.myRootModel != null;
            }
            return level == LibrariesContainer.LibraryLevel.GLOBAL || this.myProject != null;
        }

        @Override
        public Library createLibrary(@NotNull @NonNls String name, @NotNull LibrariesContainer.LibraryLevel level, @NotNull VirtualFile[] classRoots, @NotNull VirtualFile[] sourceRoots) {
            LibraryTable table;
            if (name == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerImpl.createLibrary must not be null");
            }
            if (level == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerImpl.createLibrary must not be null");
            }
            if (classRoots == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerImpl.createLibrary must not be null");
            }
            if (sourceRoots == null) {
                throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerImpl.createLibrary must not be null");
            }
            if (level == LibrariesContainer.LibraryLevel.MODULE && this.myRootModel != null) {
                return LibrariesContainerFactory.createLibraryInTable(name, classRoots, sourceRoots, this.myRootModel.getModuleLibraryTable());
            }
            LibraryTablesRegistrar registrar = LibraryTablesRegistrar.getInstance();
            if (level == LibrariesContainer.LibraryLevel.GLOBAL) {
                table = registrar.getLibraryTable();
            } else if (level == LibrariesContainer.LibraryLevel.PROJECT && this.myProject != null) {
                table = registrar.getLibraryTable(this.myProject);
            } else {
                return null;
            }
            return LibrariesContainerFactory.createLibraryInTable(name, classRoots, sourceRoots, table);
        }
    }

    private static abstract class LibrariesContainerBase
    implements LibrariesContainer {
        private LibrariesContainerBase() {
        }

        @Override
        @NotNull
        public Library[] getAllLibraries() {
            Object[] moduleLibraries;
            Object[] libraries = this.getLibraries(LibrariesContainer.LibraryLevel.GLOBAL);
            Object[] projectLibraries = this.getLibraries(LibrariesContainer.LibraryLevel.PROJECT);
            if (projectLibraries.length > 0) {
                libraries = (Library[])ArrayUtil.mergeArrays((Object[])libraries, (Object[])projectLibraries, Library.class);
            }
            if ((moduleLibraries = this.getLibraries(LibrariesContainer.LibraryLevel.MODULE)).length > 0) {
                libraries = (Library[])ArrayUtil.mergeArrays((Object[])libraries, (Object[])moduleLibraries, Library.class);
            }
            if (libraries == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesContainerFactory$LibrariesContainerBase.getAllLibraries must not return null");
            }
            return libraries;
        }
    }
}

