/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolder;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.SdkProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.UsageInModuleClasspath;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ModuleProjectStructureElement
extends ProjectStructureElement {
    private Module myModule;

    public ModuleProjectStructureElement(@NotNull StructureConfigurableContext context, @NotNull Module module) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ModuleProjectStructureElement.<init> must not be null");
        }
        if (module == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ModuleProjectStructureElement.<init> must not be null");
        }
        super(context);
        this.myModule = module;
    }

    public Module getModule() {
        return this.myModule;
    }

    @Override
    public void check(ProjectStructureProblemsHolder problemsHolder) {
        OrderEntry[] entries;
        ModuleRootModel rootModel;
        ModifiableModuleModel moduleModel = this.myContext.getModulesConfigurator().getModuleModel();
        Object[] all = moduleModel.getModules();
        if (!ArrayUtil.contains((Object)this.myModule, (Object[])all)) {
            return;
        }
        for (Object each : all) {
            if (each == this.myModule || !this.myContext.getRealName((Module)each).equals(this.myContext.getRealName(this.myModule))) continue;
            problemsHolder.registerError(ProjectBundle.message((String)"project.roots.module.duplicate.name.message", (Object[])new Object[0]));
            break;
        }
        if ((rootModel = this.myContext.getModulesConfigurator().getRootModel(this.myModule)) == null) {
            return;
        }
        for (OrderEntry entry : entries = rootModel.getOrderEntries()) {
            if (entry.isValid()) continue;
            if (entry instanceof JdkOrderEntry && ((JdkOrderEntry)entry).getJdkName() == null) {
                problemsHolder.registerError(ProjectBundle.message((String)"project.roots.module.jdk.problem.message", (Object[])new Object[0]));
                continue;
            }
            problemsHolder.registerError(ProjectBundle.message((String)"project.roots.library.problem.message", (Object[])new Object[]{entry.getPresentableName()}));
        }
    }

    @Override
    public List<ProjectStructureElementUsage> getUsagesInElement() {
        ArrayList<ProjectStructureElementUsage> usages = new ArrayList<ProjectStructureElementUsage>();
        ModuleEditor moduleEditor = this.myContext.getModulesConfigurator().getModuleEditor(this.myModule);
        if (moduleEditor != null) {
            for (OrderEntry entry : moduleEditor.getOrderEntries()) {
                Sdk jdk;
                if (entry instanceof ModuleOrderEntry) {
                    Module module = ((ModuleOrderEntry)entry).getModule();
                    if (module == null) continue;
                    usages.add(new UsageInModuleClasspath(this.myContext, this, new ModuleProjectStructureElement(this.myContext, module)));
                    continue;
                }
                if (entry instanceof LibraryOrderEntry) {
                    Library library = ((LibraryOrderEntry)entry).getLibrary();
                    if (library == null) continue;
                    usages.add(new UsageInModuleClasspath(this.myContext, this, new LibraryProjectStructureElement(this.myContext, library)));
                    continue;
                }
                if (!(entry instanceof JdkOrderEntry) || (jdk = ((JdkOrderEntry)entry).getJdk()) == null) continue;
                usages.add(new UsageInModuleClasspath(this.myContext, this, new SdkProjectStructureElement(this.myContext, jdk)));
            }
        }
        return usages;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleProjectStructureElement)) {
            return false;
        }
        return this.myModule.equals(((ModuleProjectStructureElement)o).myModule);
    }

    @Override
    public int hashCode() {
        return this.myModule.hashCode();
    }

    public String toString() {
        return "module:" + this.myModule.getName();
    }

    @Override
    public boolean highlightIfUnused() {
        return false;
    }
}

