/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.AbstractShowDiffAction;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.DiffActionExecutor;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.actions.VcsRevisionListCellRenderer;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.HistoryAsTreeProvider;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistoryProviderBackgroundableProxy;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.impl.VcsBackgroundableActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TableUtil;
import com.intellij.ui.dualView.TreeTableView;
import com.intellij.ui.table.TableView;
import com.intellij.ui.treeStructure.treetable.ListTreeTableModelOnColumns;
import com.intellij.util.Consumer;
import com.intellij.util.TreeItem;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nullable;

public class CompareWithSelectedRevisionAction
extends AbstractVcsAction {
    private static final ColumnInfo<TreeNodeAdapter, String> BRANCH_COLUMN = new ColumnInfo<TreeNodeAdapter, String>(VcsBundle.message((String)"column.name.revisions.list.branch", (Object[])new Object[0])){

        public String valueOf(TreeNodeAdapter object) {
            return object.getRevision().getBranchName();
        }
    };
    private static final ColumnInfo<TreeNodeAdapter, String> REVISION_COLUMN = new ColumnInfo<TreeNodeAdapter, String>(VcsBundle.message((String)"column.name.revision.list.revision", (Object[])new Object[0])){

        public String valueOf(TreeNodeAdapter object) {
            return object.getRevision().getRevisionNumber().asString();
        }
    };
    private static final ColumnInfo<TreeNodeAdapter, String> DATE_COLUMN = new ColumnInfo<TreeNodeAdapter, String>(VcsBundle.message((String)"column.name.revisions.list.filter", (Object[])new Object[0])){

        public String valueOf(TreeNodeAdapter object) {
            return VcsRevisionListCellRenderer.DATE_FORMAT.format(object.getRevision().getRevisionDate());
        }
    };
    private static final ColumnInfo<TreeNodeAdapter, String> AUTHOR_COLUMN = new ColumnInfo<TreeNodeAdapter, String>(VcsBundle.message((String)"column.name.revision.list.author", (Object[])new Object[0])){

        public String valueOf(TreeNodeAdapter object) {
            return object.getRevision().getAuthor();
        }
    };
    private static final ColumnInfo<VcsFileRevision, String> REVISION_TABLE_COLUMN = new ColumnInfo<VcsFileRevision, String>(VcsBundle.message((String)"column.name.revision.list.revision", (Object[])new Object[0])){

        public String valueOf(VcsFileRevision vcsFileRevision) {
            return vcsFileRevision.getRevisionNumber().asString();
        }
    };
    private static final ColumnInfo<VcsFileRevision, String> DATE_TABLE_COLUMN = new ColumnInfo<VcsFileRevision, String>(VcsBundle.message((String)"column.name.revision.list.revision", (Object[])new Object[0])){

        public String valueOf(VcsFileRevision vcsFileRevision) {
            Date date = vcsFileRevision.getRevisionDate();
            return date == null ? "" : VcsRevisionListCellRenderer.DATE_FORMAT.format(date);
        }
    };
    private static final ColumnInfo<VcsFileRevision, String> AUTHOR_TABLE_COLUMN = new ColumnInfo<VcsFileRevision, String>(VcsBundle.message((String)"column.name.revision.list.author", (Object[])new Object[0])){

        public String valueOf(VcsFileRevision vcsFileRevision) {
            return vcsFileRevision.getAuthor();
        }
    };
    private static final ColumnInfo<VcsFileRevision, String> BRANCH_TABLE_COLUMN = new ColumnInfo<VcsFileRevision, String>(VcsBundle.message((String)"column.name.revisions.list.branch", (Object[])new Object[0])){

        public String valueOf(VcsFileRevision vcsFileRevision) {
            return vcsFileRevision.getBranchName();
        }
    };

    @Override
    public void update(VcsContext e, Presentation presentation) {
        AbstractShowDiffAction.updateDiffAction(presentation, e, VcsBackgroundableActions.COMPARE_WITH);
    }

    protected boolean forceSyncUpdate(AnActionEvent e) {
        return true;
    }

    @Override
    protected void actionPerformed(VcsContext vcsContext) {
        final VirtualFile file = vcsContext.getSelectedFiles()[0];
        final Project project = vcsContext.getProject();
        final AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)project).getVcsFor(file);
        VcsHistoryProvider vcsHistoryProvider = vcs.getVcsHistoryProvider();
        new VcsHistoryProviderBackgroundableProxy(project, vcsHistoryProvider).createSessionFor(new FilePathImpl(file), new Consumer<VcsHistorySession>(){

            public void consume(VcsHistorySession session) {
                if (session == null) {
                    return;
                }
                List revisions = session.getRevisionList();
                HistoryAsTreeProvider treeHistoryProvider = session.getHistoryAsTreeProvider();
                if (treeHistoryProvider != null) {
                    CompareWithSelectedRevisionAction.showTreePopup(treeHistoryProvider.createTreeOn(revisions), file, project, vcs.getDiffProvider());
                } else {
                    CompareWithSelectedRevisionAction.showListPopup(revisions, project, new Consumer<VcsFileRevision>(){

                        public void consume(VcsFileRevision revision) {
                            DiffActionExecutor.showDiff(vcs.getDiffProvider(), revision.getRevisionNumber(), file, project, VcsBackgroundableActions.COMPARE_WITH);
                        }
                    }, true);
                }
            }
        }, VcsBackgroundableActions.COMPARE_WITH, false);
    }

    private static void showTreePopup(List<TreeItem<VcsFileRevision>> roots, final VirtualFile file, final Project project, final DiffProvider diffProvider) {
        final TreeTableView treeTable = new TreeTableView(new ListTreeTableModelOnColumns((TreeNode)new TreeNodeAdapter(null, null, roots), new ColumnInfo[]{BRANCH_COLUMN, REVISION_COLUMN, DATE_COLUMN, AUTHOR_COLUMN}));
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int index = treeTable.getSelectionModel().getMinSelectionIndex();
                if (index == -1) {
                    return;
                }
                VcsFileRevision revision = CompareWithSelectedRevisionAction.getRevisionAt(treeTable, index);
                if (revision != null) {
                    DiffActionExecutor.showDiff(diffProvider, revision.getRevisionNumber(), file, project, VcsBackgroundableActions.COMPARE_WITH);
                }
            }
        };
        treeTable.setSelectionMode(0);
        new PopupChooserBuilder((JTable)treeTable).setTitle(VcsBundle.message((String)"lookup.title.vcs.file.revisions", (Object[])new Object[0])).setItemChoosenCallback(runnable).setSouthComponent((JComponent)CompareWithSelectedRevisionAction.createCommentsPanel(treeTable)).setResizable(true).setDimensionServiceKey("Vcs.CompareWithSelectedRevision.Popup").createPopup().showCenteredInCurrentWindow(project);
    }

    @Nullable
    private static VcsFileRevision getRevisionAt(TreeTableView treeTable, int index) {
        List items = treeTable.getItems();
        if (items.size() <= index) {
            return null;
        }
        return ((TreeNodeAdapter)items.get(index)).getRevision();
    }

    private static JPanel createCommentsPanel(final TreeTableView treeTable) {
        JPanel panel = new JPanel(new BorderLayout());
        final JTextArea textArea = CompareWithSelectedRevisionAction.createTextArea();
        treeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = treeTable.getSelectionModel().getMinSelectionIndex();
                if (index == -1) {
                    textArea.setText("");
                } else {
                    VcsFileRevision revision = CompareWithSelectedRevisionAction.getRevisionAt(treeTable, index);
                    if (revision != null) {
                        textArea.setText(revision.getCommitMessage());
                    } else {
                        textArea.setText("");
                    }
                }
            }
        });
        JScrollPane textScrollPane = new JScrollPane(textArea);
        panel.add((Component)textScrollPane, "Center");
        textScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.lightGray), VcsBundle.message((String)"border.selected.revision.commit.message", (Object[])new Object[0])));
        return panel;
    }

    private static JTextArea createTextArea() {
        JTextArea textArea = new JTextArea();
        textArea.setRows(5);
        textArea.setEditable(false);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        return textArea;
    }

    public static void showListPopup(final List<VcsFileRevision> revisions, Project project, final Consumer<VcsFileRevision> selectedRevisionConsumer, boolean showComments) {
        ColumnInfo[] columns = new ColumnInfo[]{REVISION_TABLE_COLUMN, DATE_TABLE_COLUMN, AUTHOR_TABLE_COLUMN};
        for (VcsFileRevision revision : revisions) {
            if (revision.getBranchName() == null) continue;
            columns = new ColumnInfo[]{REVISION_TABLE_COLUMN, BRANCH_TABLE_COLUMN, DATE_TABLE_COLUMN, AUTHOR_TABLE_COLUMN};
            break;
        }
        final TableView table = new TableView(new ListTableModel(columns, revisions, 0));
        table.setShowHorizontalLines(false);
        table.setTableHeader(null);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                VcsFileRevision revision = (VcsFileRevision)table.getSelectedObject();
                if (revision != null) {
                    selectedRevisionConsumer.consume((Object)revision);
                }
            }
        };
        if (table.getModel().getRowCount() == 0) {
            table.clearSelection();
        }
        new SpeedSearchBase<TableView>(table){

            @Override
            protected int getSelectedIndex() {
                return table.getSelectedRow();
            }

            @Override
            protected Object[] getAllElements() {
                return revisions.toArray();
            }

            @Override
            protected String getElementText(Object element) {
                VcsFileRevision revision = (VcsFileRevision)element;
                return revision.getRevisionNumber().asString() + " " + revision.getBranchName() + " " + revision.getAuthor();
            }

            @Override
            protected void selectElement(Object element, String selectedText) {
                VcsFileRevision revision = (VcsFileRevision)element;
                TableUtil.selectRows((JTable)((JTable)this.myComponent), (int[])new int[]{revisions.indexOf(revision)});
                TableUtil.scrollSelectionToVisible((JTable)((JTable)this.myComponent));
            }
        };
        table.setMinimumSize(new Dimension(300, 50));
        PopupChooserBuilder builder = new PopupChooserBuilder((JTable)table);
        if (showComments) {
            builder.setSouthComponent((JComponent)CompareWithSelectedRevisionAction.createCommentsPanel((TableView<VcsFileRevision>)table));
        }
        builder.setTitle(VcsBundle.message((String)"lookup.title.vcs.file.revisions", (Object[])new Object[0])).setItemChoosenCallback(runnable).setResizable(true).setDimensionServiceKey("Vcs.CompareWithSelectedRevision.Popup").setMinSize(new Dimension(300, 300));
        JBPopup popup = builder.createPopup();
        popup.showCenteredInCurrentWindow(project);
    }

    private static JPanel createCommentsPanel(final TableView<VcsFileRevision> table) {
        final JTextArea textArea = CompareWithSelectedRevisionAction.createTextArea();
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                VcsFileRevision revision = (VcsFileRevision)table.getSelectedObject();
                if (revision == null) {
                    textArea.setText("");
                } else {
                    textArea.setText(revision.getCommitMessage());
                    textArea.select(0, 0);
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        JScrollPane textScrollPane = new JScrollPane(textArea);
        textScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.lightGray), VcsBundle.message((String)"border.selected.revision.commit.message", (Object[])new Object[0])));
        jPanel.add((Component)textScrollPane, "South");
        jPanel.setPreferredSize(new Dimension(300, 100));
        return jPanel;
    }

    private static class TreeNodeAdapter
    extends DefaultMutableTreeNode {
        private final TreeItem<VcsFileRevision> myRevision;

        public TreeNodeAdapter(TreeNodeAdapter parent, TreeItem<VcsFileRevision> revision, List<TreeItem<VcsFileRevision>> children) {
            if (parent != null) {
                parent.add(this);
            }
            this.myRevision = revision;
            for (TreeItem<VcsFileRevision> treeItem : children) {
                new TreeNodeAdapter(this, treeItem, treeItem.getChildren());
            }
        }

        public VcsFileRevision getRevision() {
            return (VcsFileRevision)this.myRevision.getData();
        }
    }
}

