/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class RepositoryLocationCache {
    private final Project myProject;
    private final Map<Pair<String, String>, RepositoryLocation> myMap;

    public RepositoryLocationCache(Project project) {
        this.myProject = project;
        this.myMap = Collections.synchronizedMap(new HashMap());
    }

    public RepositoryLocation getLocation(AbstractVcs vcs, FilePath filePath, boolean silent) {
        Pair key = new Pair((Object)vcs.getName(), (Object)filePath.getIOFile().getAbsolutePath());
        RepositoryLocation location = this.myMap.get(key);
        if (location != null) {
            return location;
        }
        location = this.getUnderProgress(vcs, filePath, silent);
        this.myMap.put((Pair<String, String>)key, location);
        return location;
    }

    private RepositoryLocation getUnderProgress(AbstractVcs vcs, FilePath filePath, boolean silent) {
        MyLoader loader = new MyLoader(vcs, filePath);
        if (!silent && ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously((Runnable)loader, "Discovering location of " + filePath.getPresentableUrl(), true, this.myProject);
        } else {
            loader.run();
        }
        return loader.getLocation();
    }

    private class MyLoader
    implements Runnable {
        private final AbstractVcs myVcs;
        private final FilePath myFilePath;
        private RepositoryLocation myLocation;

        private MyLoader(@NotNull AbstractVcs vcs, FilePath filePath) {
            if (vcs == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/committed/RepositoryLocationCache$MyLoader.<init> must not be null");
            }
            if (filePath == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vcs/changes/committed/RepositoryLocationCache$MyLoader.<init> must not be null");
            }
            this.myVcs = vcs;
            this.myFilePath = filePath;
        }

        @Override
        public void run() {
            CommittedChangesProvider committedChangesProvider = this.myVcs.getCommittedChangesProvider();
            if (committedChangesProvider != null) {
                this.myLocation = committedChangesProvider.getLocationFor(this.myFilePath);
            }
        }

        public RepositoryLocation getLocation() {
            return this.myLocation;
        }
    }
}

