/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.diff.impl.patch.ApplyPatchException;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.patch.DefaultPatchBaseVersionProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import org.jetbrains.annotations.Nullable;

public class ApplyPatchForBaseRevisionTexts {
    private CharSequence myLocal;
    private CharSequence myBase;
    private String myPatched;
    private ApplyPatchStatus myStatus;
    private VcsException myException;

    @Nullable
    public static ApplyPatchForBaseRevisionTexts create(Project project, VirtualFile file, FilePath pathBeforeRename, TextFilePatch patch) {
        String beforeVersionId = patch.getBeforeVersionId();
        if (beforeVersionId == null) {
            return null;
        }
        DefaultPatchBaseVersionProvider provider = new DefaultPatchBaseVersionProvider(project, file, beforeVersionId);
        if (provider.canProvideContent()) {
            return new ApplyPatchForBaseRevisionTexts(provider, pathBeforeRename, patch, file);
        }
        return null;
    }

    ApplyPatchForBaseRevisionTexts(DefaultPatchBaseVersionProvider provider, FilePath pathBeforeRename, final TextFilePatch patch, VirtualFile file) {
        this.myLocal = LoadTextUtil.loadText(file);
        final StringBuilder newText = new StringBuilder();
        try {
            provider.getBaseVersionContent(pathBeforeRename, new Processor<CharSequence>(){

                public boolean process(CharSequence text) {
                    newText.setLength(0);
                    try {
                        ApplyPatchForBaseRevisionTexts.this.myStatus = ApplyFilePatchBase.applyModifications(patch, text, newText);
                    }
                    catch (ApplyPatchException ex) {
                        return true;
                    }
                    ApplyPatchForBaseRevisionTexts.this.myBase = text;
                    return false;
                }
            });
        }
        catch (VcsException vcsEx) {
            this.myException = vcsEx;
            this.myStatus = ApplyPatchStatus.FAILURE;
        }
        this.myPatched = newText.toString();
    }

    public CharSequence getLocal() {
        return this.myLocal;
    }

    public CharSequence getBase() {
        return this.myBase;
    }

    public String getPatched() {
        return this.myPatched;
    }

    public ApplyPatchStatus getStatus() {
        return this.myStatus;
    }

    public VcsException getException() {
        return this.myException;
    }
}

