/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.diff.impl.patch.PatchSyntaxException;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.TextPatchBuilder;
import com.intellij.openapi.diff.impl.patch.UnifiedDiffWriter;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.diff.impl.patch.formove.CustomBinaryPatchApplier;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.options.StreamProvider;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.shelf.CompoundShelfFileProcesor;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.ui.RollbackWorker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.text.CharArrayCharSequence;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelveChangesManager
implements ProjectComponent,
JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager");
    @NonNls
    private static final String PATCH_EXTENSION = "patch";
    private final Project myProject;
    private final MessageBus myBus;
    private final List<ShelvedChangeList> myShelvedChangeLists = new ArrayList<ShelvedChangeList>();
    private final List<ShelvedChangeList> myRecycledShelvedChangeLists = new ArrayList<ShelvedChangeList>();
    @NonNls
    private static final String ATTRIBUTE_SHOW_RECYCLED = "show_recycled";
    private final CompoundShelfFileProcesor myFileProcessor;
    public static final Topic<ChangeListener> SHELF_TOPIC = new Topic("shelf updates", ChangeListener.class);
    private boolean myShowRecycled;

    public static ShelveChangesManager getInstance(Project project) {
        return (ShelveChangesManager)project.getComponent(ShelveChangesManager.class);
    }

    public ShelveChangesManager(Project project, MessageBus bus) {
        this.myProject = project;
        this.myBus = bus;
        this.myFileProcessor = !project.isDefault() ? new CompoundShelfFileProcesor("shelf") : new CompoundShelfFileProcesor(new StreamProvider[0], PathManager.getConfigPath() + File.separator + "shelf");
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("ShelveChangesManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager.getComponentName must not return null");
        }
        return "ShelveChangesManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void readExternal(Element element) throws InvalidDataException {
        String showRecycled = element.getAttributeValue(ATTRIBUTE_SHOW_RECYCLED);
        this.myShowRecycled = showRecycled != null ? Boolean.parseBoolean(showRecycled) : true;
        ShelveChangesManager.readExternal(element, this.myShelvedChangeLists, this.myRecycledShelvedChangeLists);
    }

    private static void readList(List<Element> children, List<ShelvedChangeList> sink) throws InvalidDataException {
        for (Element child : children) {
            ShelvedChangeList data = new ShelvedChangeList();
            data.readExternal(child);
            if (!new File(data.PATH).exists()) continue;
            sink.add(data);
        }
    }

    public static void readExternal(Element element, List<ShelvedChangeList> changes, List<ShelvedChangeList> recycled) throws InvalidDataException {
        changes.addAll(ShelvedChangeList.readChanges(element, false, true));
        recycled.addAll(ShelvedChangeList.readChanges(element, true, true));
    }

    public void writeExternal(Element element) throws WriteExternalException {
        element.setAttribute(ATTRIBUTE_SHOW_RECYCLED, Boolean.toString(this.myShowRecycled));
        ShelvedChangeList.writeChanges(this.myShelvedChangeLists, this.myRecycledShelvedChangeLists, element);
    }

    public List<ShelvedChangeList> getShelvedChangeLists() {
        return Collections.unmodifiableList(this.myShelvedChangeLists);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShelvedChangeList shelveChanges(Collection<Change> changes, String commitMessage) throws IOException, VcsException {
        ShelvedChangeList changeList;
        ArrayList<Change> textChanges = new ArrayList<Change>();
        ArrayList<ShelvedBinaryFile> binaryFiles = new ArrayList<ShelvedBinaryFile>();
        for (Change change : changes) {
            if (ChangesUtil.getFilePath((Change)change).isDirectory()) continue;
            if (change.getBeforeRevision() instanceof BinaryContentRevision || change.getAfterRevision() instanceof BinaryContentRevision) {
                binaryFiles.add(this.shelveBinaryFile(change));
                continue;
            }
            textChanges.add(change);
        }
        ProgressIndicator ind = ProgressManager.getInstance().getProgressIndicator();
        try {
            File patchPath = this.getPatchPath(commitMessage);
            if (ind != null && ind.isCanceled()) {
                throw new ProcessCanceledException();
            }
            final List patches = TextPatchBuilder.buildPatch(textChanges, (String)this.myProject.getBaseDir().getPresentableUrl(), (boolean)false);
            if (ind != null && ind.isCanceled()) {
                throw new ProcessCanceledException();
            }
            this.myFileProcessor.savePathFile(new CompoundShelfFileProcesor.ContentProvider(){

                @Override
                public void writeContentTo(Writer writer) throws IOException {
                    UnifiedDiffWriter.write((Collection)patches, (Writer)writer, (String)"\n");
                }
            }, patchPath);
            changeList = new ShelvedChangeList(patchPath.toString(), commitMessage.replace('\n', ' '), binaryFiles);
            this.myShelvedChangeLists.add(changeList);
            if (ind != null && ind.isCanceled()) {
                throw new ProcessCanceledException();
            }
            new RollbackWorker(this.myProject, false).doRollback(changes, true, null, VcsBundle.message((String)"shelve.changes.action", (Object[])new Object[0]));
        }
        finally {
            this.notifyStateChanged();
        }
        return changeList;
    }

    private ShelvedBinaryFile shelveBinaryFile(Change change) throws IOException {
        ContentRevision beforeRevision = change.getBeforeRevision();
        ContentRevision afterRevision = change.getAfterRevision();
        File beforeFile = beforeRevision == null ? null : beforeRevision.getFile().getIOFile();
        File afterFile = afterRevision == null ? null : afterRevision.getFile().getIOFile();
        String shelvedPath = null;
        if (afterFile != null) {
            String shelvedName = FileUtil.getNameWithoutExtension((String)afterFile.getName());
            String shelvedExt = FileUtil.getExtension((String)afterFile.getName());
            File shelvedFile = FileUtil.findSequentNonexistentFile((File)this.myFileProcessor.getBaseIODir(), (String)shelvedName, (String)shelvedExt);
            this.myFileProcessor.saveFile(afterRevision.getFile().getIOFile(), shelvedFile);
            shelvedPath = shelvedFile.getPath();
        }
        String beforePath = ChangesUtil.getProjectRelativePath((Project)this.myProject, (File)beforeFile);
        String afterPath = ChangesUtil.getProjectRelativePath((Project)this.myProject, (File)afterFile);
        return new ShelvedBinaryFile(beforePath, afterPath, shelvedPath);
    }

    private void notifyStateChanged() {
        ((ChangeListener)this.myBus.syncPublisher(SHELF_TOPIC)).stateChanged(new ChangeEvent(this));
    }

    private File getPatchPath(@NonNls String commitMessage) {
        File file = this.myFileProcessor.getBaseIODir();
        if (!file.exists()) {
            file.mkdirs();
        }
        return ShelveChangesManager.suggestPatchName(commitMessage.length() > 100 ? commitMessage.substring(0, 100) : commitMessage, file);
    }

    public static File suggestPatchName(String commitMessage, File file) {
        String defaultPath = PathUtil.suggestFileName((String)commitMessage);
        if (defaultPath.length() == 0) {
            defaultPath = "unnamed";
        }
        return FileUtil.findSequentNonexistentFile((File)file, (String)defaultPath, (String)PATCH_EXTENSION);
    }

    public void unshelveChangeList(ShelvedChangeList changeList, @Nullable List<ShelvedChange> changes, @Nullable List<ShelvedBinaryFile> binaryFiles, LocalChangeList targetChangeList) {
        List<TextFilePatch> textFilePatches;
        ArrayList<FilePatch> remainingPatches = new ArrayList<FilePatch>();
        try {
            textFilePatches = ShelveChangesManager.loadTextPatches(changeList, changes, remainingPatches);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            PatchApplier.showError(this.myProject, "Cannot load patch(es): " + e.getMessage(), true);
            return;
        }
        catch (PatchSyntaxException e) {
            PatchApplier.showError(this.myProject, "Cannot load patch(es): " + e.getMessage(), true);
            LOG.info((Throwable)e);
            return;
        }
        ArrayList<TextFilePatch> patches = new ArrayList<TextFilePatch>(textFilePatches);
        ArrayList<ShelvedBinaryFile> remainingBinaries = new ArrayList<ShelvedBinaryFile>();
        List<ShelvedBinaryFile> binaryFilesToUnshelve = ShelveChangesManager.getBinaryFilesToUnshelve(changeList, binaryFiles, remainingBinaries);
        for (ShelvedBinaryFile shelvedBinaryFile : binaryFilesToUnshelve) {
            patches.add((TextFilePatch)new ShelvedBinaryFilePatch(shelvedBinaryFile));
        }
        BinaryPatchApplier binaryPatchApplier = new BinaryPatchApplier(binaryFilesToUnshelve.size());
        PatchApplier<ShelvedBinaryFilePatch> patchApplier = new PatchApplier<ShelvedBinaryFilePatch>(this.myProject, this.myProject.getBaseDir(), patches, targetChangeList, binaryPatchApplier);
        patchApplier.execute();
        remainingPatches.addAll(patchApplier.getRemainingPatches());
        if (remainingPatches.size() == 0 && remainingBinaries.isEmpty()) {
            this.recycleChangeList(changeList);
        } else {
            this.saveRemainingPatches(changeList, remainingPatches, remainingBinaries);
        }
    }

    private static List<TextFilePatch> loadTextPatches(ShelvedChangeList changeList, List<ShelvedChange> changes, List<FilePatch> remainingPatches) throws IOException, PatchSyntaxException {
        List<TextFilePatch> textFilePatches = ShelveChangesManager.loadPatches(changeList.PATH);
        if (changes != null) {
            Iterator<TextFilePatch> iterator = textFilePatches.iterator();
            while (iterator.hasNext()) {
                TextFilePatch patch = iterator.next();
                if (ShelveChangesManager.needUnshelve((FilePatch)patch, changes)) continue;
                remainingPatches.add((FilePatch)patch);
                iterator.remove();
            }
        }
        return textFilePatches;
    }

    private static List<ShelvedBinaryFile> getBinaryFilesToUnshelve(ShelvedChangeList changeList, List<ShelvedBinaryFile> binaryFiles, List<ShelvedBinaryFile> remainingBinaries) {
        if (binaryFiles == null) {
            return new ArrayList<ShelvedBinaryFile>(changeList.getBinaryFiles());
        }
        ArrayList<ShelvedBinaryFile> result = new ArrayList<ShelvedBinaryFile>();
        for (ShelvedBinaryFile file : changeList.getBinaryFiles()) {
            if (binaryFiles.contains(file)) {
                result.add(file);
                continue;
            }
            remainingBinaries.add(file);
        }
        return result;
    }

    @Nullable
    private FilePath unshelveBinaryFile(ShelvedBinaryFile file, final @NotNull VirtualFile patchTarget) throws IOException {
        if (patchTarget == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager.unshelveBinaryFile must not be null");
        }
        final Ref result = new Ref();
        final Ref ex = new Ref();
        final Ref patchedFileRef = new Ref();
        final File shelvedFile = file.SHELVED_PATH == null ? null : new File(file.SHELVED_PATH);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    result.set((Object)new FilePathImpl(patchTarget));
                    if (shelvedFile == null) {
                        patchTarget.delete((Object)this);
                    } else {
                        patchTarget.setBinaryContent(FileUtil.loadFileBytes((File)shelvedFile));
                        patchedFileRef.set((Object)patchTarget);
                    }
                }
                catch (IOException e) {
                    ex.set((Object)e);
                }
            }
        });
        if (!ex.isNull()) {
            throw (IOException)ex.get();
        }
        return (FilePath)result.get();
    }

    private static boolean needUnshelve(FilePatch patch, List<ShelvedChange> changes) {
        for (ShelvedChange change : changes) {
            if (!Comparing.equal((String)patch.getBeforeName(), (String)change.getBeforePath())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePatchesToFile(String path, List<FilePatch> remainingPatches) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(path));
            try {
                UnifiedDiffWriter.write(remainingPatches, (Writer)writer, (String)"\n");
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    void saveRemainingPatches(ShelvedChangeList changeList, List<FilePatch> remainingPatches, List<ShelvedBinaryFile> remainingBinaries) {
        File newPath = this.getPatchPath(changeList.DESCRIPTION);
        try {
            FileUtil.copy((File)new File(changeList.PATH), (File)newPath);
        }
        catch (IOException e) {
            return;
        }
        ShelvedChangeList listCopy = new ShelvedChangeList(newPath.getAbsolutePath(), changeList.DESCRIPTION, new ArrayList<ShelvedBinaryFile>(changeList.getBinaryFiles()));
        listCopy.DATE = changeList.DATE == null ? null : new Date(changeList.DATE.getTime());
        ShelveChangesManager.writePatchesToFile(changeList.PATH, remainingPatches);
        changeList.getBinaryFiles().retainAll(remainingBinaries);
        changeList.clearLoadedChanges();
        this.recycleChangeList(listCopy, changeList);
        this.notifyStateChanged();
    }

    public void restoreList(ShelvedChangeList changeList) {
        this.myShelvedChangeLists.add(changeList);
        this.myRecycledShelvedChangeLists.remove(changeList);
        changeList.setRecycled(false);
        this.notifyStateChanged();
    }

    public List<ShelvedChangeList> getRecycledShelvedChangeLists() {
        return this.myRecycledShelvedChangeLists;
    }

    public void clearRecycled() {
        for (ShelvedChangeList list : this.myRecycledShelvedChangeLists) {
            this.deleteListImpl(list);
        }
        this.myRecycledShelvedChangeLists.clear();
        this.notifyStateChanged();
    }

    private void recycleChangeList(ShelvedChangeList listCopy, ShelvedChangeList newList) {
        if (newList != null) {
            Iterator<ShelvedBinaryFile> shelvedChangeListIterator = listCopy.getBinaryFiles().iterator();
            while (shelvedChangeListIterator.hasNext()) {
                ShelvedBinaryFile binaryFile = shelvedChangeListIterator.next();
                for (ShelvedBinaryFile newBinary : newList.getBinaryFiles()) {
                    if (!Comparing.equal((String)newBinary.BEFORE_PATH, (String)binaryFile.BEFORE_PATH) || !Comparing.equal((String)newBinary.AFTER_PATH, (String)binaryFile.AFTER_PATH)) continue;
                    shelvedChangeListIterator.remove();
                }
            }
            Iterator<ShelvedChange> iterator = listCopy.getChanges().iterator();
            while (iterator.hasNext()) {
                ShelvedChange change = iterator.next();
                for (ShelvedChange newChange : newList.getChanges()) {
                    if (!Comparing.equal((String)change.getBeforePath(), (String)newChange.getBeforePath()) || !Comparing.equal((String)change.getAfterPath(), (String)newChange.getAfterPath())) continue;
                    iterator.remove();
                }
            }
            try {
                ArrayList<FilePatch> patches = new ArrayList<FilePatch>();
                for (ShelvedChange change : listCopy.getChanges()) {
                    patches.add((FilePatch)change.loadFilePatch());
                }
                ShelveChangesManager.writePatchesToFile(listCopy.PATH, patches);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
            catch (PatchSyntaxException e) {
                LOG.info((Throwable)e);
            }
        }
        if (!listCopy.getBinaryFiles().isEmpty() || !listCopy.getChanges().isEmpty()) {
            listCopy.setRecycled(true);
            this.myRecycledShelvedChangeLists.add(listCopy);
            this.notifyStateChanged();
        }
    }

    private void recycleChangeList(ShelvedChangeList changeList) {
        this.recycleChangeList(changeList, null);
        this.myShelvedChangeLists.remove(changeList);
        this.notifyStateChanged();
    }

    public void deleteChangeList(ShelvedChangeList changeList) {
        this.deleteListImpl(changeList);
        if (!changeList.isRecycled()) {
            this.myShelvedChangeLists.remove(changeList);
        } else {
            this.myRecycledShelvedChangeLists.remove(changeList);
        }
        this.notifyStateChanged();
    }

    private void deleteListImpl(ShelvedChangeList changeList) {
        File file = new File(changeList.PATH);
        this.myFileProcessor.delete(file.getName());
        for (ShelvedBinaryFile binaryFile : changeList.getBinaryFiles()) {
            String path = binaryFile.SHELVED_PATH;
            if (path == null) continue;
            File binFile = new File(path);
            this.myFileProcessor.delete(binFile.getName());
        }
    }

    public void renameChangeList(ShelvedChangeList changeList, String newName) {
        changeList.DESCRIPTION = newName;
        this.notifyStateChanged();
    }

    public static List<TextFilePatch> loadPatches(String patchPath) throws IOException, PatchSyntaxException {
        char[] text = FileUtil.loadFileText((File)new File(patchPath));
        PatchReader reader = new PatchReader((CharSequence)new CharArrayCharSequence(text));
        return reader.readAllPatches();
    }

    public boolean isShowRecycled() {
        return this.myShowRecycled;
    }

    public void setShowRecycled(boolean showRecycled) {
        this.myShowRecycled = showRecycled;
        this.notifyStateChanged();
    }

    public static class ShelvedBinaryFilePatch
    extends FilePatch {
        private final ShelvedBinaryFile myShelvedBinaryFile;

        public ShelvedBinaryFilePatch(ShelvedBinaryFile shelvedBinaryFile) {
            this.myShelvedBinaryFile = shelvedBinaryFile;
            this.setBeforeName(this.myShelvedBinaryFile.BEFORE_PATH);
            this.setAfterName(this.myShelvedBinaryFile.AFTER_PATH);
        }

        public String getBeforeFileName() {
            String[] pathNameComponents = this.myShelvedBinaryFile.BEFORE_PATH.replace(File.separatorChar, '/').split("/");
            return pathNameComponents[pathNameComponents.length - 1];
        }

        public String getAfterFileName() {
            String[] pathNameComponents = this.myShelvedBinaryFile.AFTER_PATH.replace(File.separatorChar, '/').split("/");
            return pathNameComponents[pathNameComponents.length - 1];
        }

        public boolean isNewFile() {
            return this.myShelvedBinaryFile.BEFORE_PATH == null;
        }

        public boolean isDeletedFile() {
            return this.myShelvedBinaryFile.AFTER_PATH == null;
        }

        public ShelvedBinaryFile getShelvedBinaryFile() {
            return this.myShelvedBinaryFile;
        }
    }

    private class BinaryPatchApplier
    implements CustomBinaryPatchApplier<ShelvedBinaryFilePatch> {
        private final List<FilePatch> myAppliedPatches = new ArrayList<FilePatch>();

        private BinaryPatchApplier(int binaryCount) {
        }

        @Override
        @NotNull
        public ApplyPatchStatus apply(List<Pair<VirtualFile, ApplyFilePatchBase<ShelvedBinaryFilePatch>>> patches) throws IOException {
            for (Pair<VirtualFile, ApplyFilePatchBase<ShelvedBinaryFilePatch>> patch : patches) {
                ShelvedBinaryFilePatch shelvedPatch = (ShelvedBinaryFilePatch)((Object)((ApplyFilePatchBase)patch.getSecond()).getPatch());
                ShelveChangesManager.this.unshelveBinaryFile(shelvedPatch.getShelvedBinaryFile(), (VirtualFile)patch.getFirst());
                this.myAppliedPatches.add(shelvedPatch);
            }
            ApplyPatchStatus applyPatchStatus = ApplyPatchStatus.SUCCESS;
            if (applyPatchStatus == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager$BinaryPatchApplier.apply must not return null");
            }
            return applyPatchStatus;
        }

        @Override
        @NotNull
        public List<FilePatch> getAppliedPatches() {
            List<FilePatch> list = this.myAppliedPatches;
            if (list == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/shelf/ShelveChangesManager$BinaryPatchApplier.getAppliedPatches must not return null");
            }
            return list;
        }
    }
}

