/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ui.RollbackProgressModifier;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RollbackWorker {
    private final Project myProject;
    private final List<VcsException> myExceptions;
    private ProgressIndicator myIndicator;

    public RollbackWorker(Project project, boolean synchronous) {
        this.myProject = project;
        this.myExceptions = new ArrayList<VcsException>(0);
    }

    public void doRollback(Collection<Change> changes, boolean deleteLocallyAddedFiles, final Runnable afterVcsRefreshInAwt, String localHistoryActionName) {
        final ChangeListManager changeListManager = ChangeListManagerImpl.getInstance((Project)this.myProject);
        final Runnable notifier = changeListManager.prepareForChangeDeletion(changes);
        Runnable afterRefresh = new Runnable(){

            @Override
            public void run() {
                changeListManager.invokeAfterUpdate(new Runnable(){

                    @Override
                    public void run() {
                        notifier.run();
                        if (afterVcsRefreshInAwt != null) {
                            afterVcsRefreshInAwt.run();
                        }
                    }
                }, InvokeAfterUpdateMode.SILENT, "Refresh change lists after update", ModalityState.current());
            }
        };
        final MyRollbackRunnable rollbackAction = new MyRollbackRunnable(changes, deleteLocallyAddedFiles, afterRefresh, localHistoryActionName);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, VcsBundle.message((String)"changes.action.rollback.text", (Object[])new Object[0]), true, new PerformInBackgroundOption(){

                public boolean shouldStartInBackground() {
                    return VcsConfiguration.getInstance((Project)((RollbackWorker)RollbackWorker.this).myProject).PERFORM_ROLLBACK_IN_BACKGROUND;
                }

                public void processSentToBackground() {
                    VcsConfiguration.getInstance((Project)((RollbackWorker)RollbackWorker.this).myProject).PERFORM_ROLLBACK_IN_BACKGROUND = true;
                }
            }){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/changes/ui/RollbackWorker$3.run must not be null");
                    }
                    rollbackAction.run();
                }
            });
        } else {
            rollbackAction.run();
        }
        ((ChangeListManagerImpl)changeListManager).showLocalChangesInvalidated();
    }

    private class MyRollbackRunnable
    implements Runnable {
        private final Collection<Change> myChanges;
        private final boolean myDeleteLocallyAddedFiles;
        private final Runnable myAfterRefresh;
        private final String myLocalHistoryActionName;

        private MyRollbackRunnable(Collection<Change> changes, boolean deleteLocallyAddedFiles, Runnable afterRefresh, String localHistoryActionName) {
            this.myChanges = changes;
            this.myDeleteLocallyAddedFiles = deleteLocallyAddedFiles;
            this.myAfterRefresh = afterRefresh;
            this.myLocalHistoryActionName = localHistoryActionName;
        }

        @Override
        public void run() {
            RollbackWorker.this.myIndicator = ProgressManager.getInstance().getProgressIndicator();
            final ArrayList<Change> changesToRefresh = new ArrayList<Change>();
            try {
                ChangesUtil.processChangesByVcs((Project)RollbackWorker.this.myProject, this.myChanges, (ChangesUtil.PerVcsProcessor)new ChangesUtil.PerVcsProcessor<Change>(){

                    public void process(AbstractVcs vcs, List<Change> changes) {
                        RollbackEnvironment environment = vcs.getRollbackEnvironment();
                        if (environment != null) {
                            changesToRefresh.addAll(changes);
                            if (RollbackWorker.this.myIndicator != null) {
                                RollbackWorker.this.myIndicator.setText(vcs.getDisplayName() + ": performing rollback...");
                                RollbackWorker.this.myIndicator.setIndeterminate(false);
                                RollbackWorker.this.myIndicator.checkCanceled();
                            }
                            environment.rollbackChanges(changes, RollbackWorker.this.myExceptions, (RollbackProgressListener)new RollbackProgressModifier(changes.size(), RollbackWorker.this.myIndicator));
                            if (RollbackWorker.this.myIndicator != null) {
                                RollbackWorker.this.myIndicator.setText2("");
                                RollbackWorker.this.myIndicator.checkCanceled();
                            }
                            if (RollbackWorker.this.myExceptions.isEmpty() && MyRollbackRunnable.this.myDeleteLocallyAddedFiles) {
                                MyRollbackRunnable.this.deleteAddedFilesLocally(changes);
                            }
                        }
                    }
                });
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
            if (RollbackWorker.this.myIndicator != null) {
                RollbackWorker.this.myIndicator.startNonCancelableSection();
                RollbackWorker.this.myIndicator.setIndeterminate(true);
                RollbackWorker.this.myIndicator.setText2("");
                RollbackWorker.this.myIndicator.setText(VcsBundle.message((String)"progress.text.synchronizing.files", (Object[])new Object[0]));
            }
            this.doRefresh(RollbackWorker.this.myProject, changesToRefresh);
            AbstractVcsHelper.getInstanceChecked((Project)RollbackWorker.this.myProject).showErrors(RollbackWorker.this.myExceptions, VcsBundle.message((String)"changes.action.rollback.text", (Object[])new Object[0]));
        }

        private void doRefresh(final Project project, final List<Change> changesToRefresh) {
            final String actionName = VcsBundle.message((String)"changes.action.rollback.text", (Object[])new Object[0]);
            final LocalHistoryAction action = LocalHistory.startAction((Project)project, (String)actionName);
            Runnable forAwtThread = new Runnable(){

                @Override
                public void run() {
                    action.finish();
                    PeriodicalTasksCloser.safeGetComponent(project, LocalHistory.class).putSystemLabel(MyRollbackRunnable.this.myLocalHistoryActionName == null ? actionName : MyRollbackRunnable.this.myLocalHistoryActionName, -1);
                    VcsDirtyScopeManager manager = PeriodicalTasksCloser.safeGetComponent(project, VcsDirtyScopeManager.class);
                    for (Change change : changesToRefresh) {
                        FilePath parent;
                        if (!change.isIsReplaced() && Comparing.equal((Object)change.getBeforeRevision(), (Object)change.getAfterRevision())) {
                            manager.fileDirty(change.getBeforeRevision().getFile());
                            continue;
                        }
                        if (change.getBeforeRevision() != null && (parent = change.getBeforeRevision().getFile().getParentPath()) != null) {
                            manager.dirDirtyRecursively(parent);
                        }
                        if (change.getAfterRevision() == null || (parent = change.getAfterRevision().getFile().getParentPath()) == null) continue;
                        manager.dirDirtyRecursively(parent);
                    }
                    MyRollbackRunnable.this.myAfterRefresh.run();
                }
            };
            RefreshVFsSynchronously.updateChangesForRollback(changesToRefresh);
            ApplicationManager.getApplication().invokeLater(forAwtThread);
        }

        private void deleteAddedFilesLocally(List<Change> changes) {
            if (RollbackWorker.this.myIndicator != null) {
                RollbackWorker.this.myIndicator.setText("Deleting added files locally...");
                RollbackWorker.this.myIndicator.setFraction(0.0);
            }
            int changesSize = changes.size();
            for (int i = 0; i < changesSize; ++i) {
                Change c = changes.get(i);
                if (c.getType() != Change.Type.NEW) continue;
                ContentRevision rev = c.getAfterRevision();
                assert (rev != null);
                File ioFile = rev.getFile().getIOFile();
                if (RollbackWorker.this.myIndicator != null) {
                    RollbackWorker.this.myIndicator.setText2(ioFile.getAbsolutePath());
                    RollbackWorker.this.myIndicator.setFraction((double)i / (double)changesSize);
                }
                FileUtil.delete((File)ioFile);
            }
            if (RollbackWorker.this.myIndicator != null) {
                RollbackWorker.this.myIndicator.setText2("");
            }
        }
    }
}

