/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinMetaHandler;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class StandardBeforeCheckinHandler
extends CheckinHandler
implements CheckinMetaHandler {
    protected final Project myProject;
    private final CheckinProjectPanel myPanel;

    public StandardBeforeCheckinHandler(Project project, CheckinProjectPanel panel) {
        this.myProject = project;
        this.myPanel = panel;
    }

    @Nullable
    public RefreshableOnComponent getBeforeCheckinConfigurationPanel() {
        final JCheckBox optimizeBox = new JCheckBox(VcsBundle.message((String)"checkbox.checkin.options.optimize.imports", (Object[])new Object[0]));
        final JCheckBox reformatBox = new JCheckBox(VcsBundle.message((String)"checkbox.checkin.options.reformat.code", (Object[])new Object[0]));
        return new RefreshableOnComponent(){

            public JComponent getComponent() {
                JPanel panel = new JPanel(new GridLayout(2, 0));
                panel.add(optimizeBox);
                panel.add(reformatBox);
                return panel;
            }

            public void refresh() {
            }

            public void saveState() {
                StandardBeforeCheckinHandler.this.getSettings().OPTIMIZE_IMPORTS_BEFORE_PROJECT_COMMIT = optimizeBox.isSelected();
                StandardBeforeCheckinHandler.this.getSettings().REFORMAT_BEFORE_PROJECT_COMMIT = reformatBox.isSelected();
            }

            public void restoreState() {
                optimizeBox.setSelected(StandardBeforeCheckinHandler.this.getSettings().OPTIMIZE_IMPORTS_BEFORE_PROJECT_COMMIT);
                reformatBox.setSelected(StandardBeforeCheckinHandler.this.getSettings().REFORMAT_BEFORE_PROJECT_COMMIT);
            }
        };
    }

    protected VcsConfiguration getSettings() {
        return VcsConfiguration.getInstance((Project)this.myProject);
    }

    public void runCheckinHandlers(final Runnable finishAction) {
        final VcsConfiguration configuration = VcsConfiguration.getInstance((Project)this.myProject);
        final Collection files = this.myPanel.getVirtualFiles();
        final Runnable performCheckoutAction = new Runnable(){

            @Override
            public void run() {
                FileDocumentManager.getInstance().saveAllDocuments();
                finishAction.run();
            }
        };
        Runnable reformatCodeAndPerformCheckout = new Runnable(){

            @Override
            public void run() {
                if (StandardBeforeCheckinHandler.reformat(configuration, true)) {
                    new ReformatCodeProcessor(StandardBeforeCheckinHandler.this.myProject, StandardBeforeCheckinHandler.this.getPsiFiles(files), performCheckoutAction).run();
                } else {
                    performCheckoutAction.run();
                }
            }
        };
        if (configuration.OPTIMIZE_IMPORTS_BEFORE_PROJECT_COMMIT) {
            new OptimizeImportsProcessor(this.myProject, this.getPsiFiles(files), reformatCodeAndPerformCheckout).run();
        } else {
            reformatCodeAndPerformCheckout.run();
        }
    }

    private static boolean reformat(VcsConfiguration configuration, boolean checkinProject) {
        return checkinProject ? configuration.REFORMAT_BEFORE_PROJECT_COMMIT : configuration.REFORMAT_BEFORE_FILE_COMMIT;
    }

    private PsiFile[] getPsiFiles(Collection<VirtualFile> selectedFiles) {
        VirtualFile baseDir;
        ArrayList<PsiFile> result = new ArrayList<PsiFile>();
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        VirtualFile projectFileDir = null;
        StorageScheme storageScheme = ((ProjectEx)this.myProject).getStateStore().getStorageScheme();
        if (StorageScheme.DIRECTORY_BASED.equals((Object)storageScheme) && (baseDir = this.myProject.getBaseDir()) != null) {
            projectFileDir = baseDir.findChild(".idea");
        }
        for (VirtualFile file : selectedFiles) {
            PsiFile psiFile;
            if (!file.isValid() || projectFileDir != null && VfsUtil.isAncestor((VirtualFile)projectFileDir, (VirtualFile)file, (boolean)false) || (psiFile = psiManager.findFile(file)) == null) continue;
            result.add(psiFile);
        }
        return result.toArray(new PsiFile[result.size()]);
    }
}

