/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictConfigurable;
import com.intellij.openapi.vcs.changes.ui.IgnoredSettingsPanel;
import com.intellij.openapi.vcs.configurable.IssueNavigationConfigurationPanel;
import com.intellij.openapi.vcs.configurable.ModuleVcsListener;
import com.intellij.openapi.vcs.configurable.VcsBackgroundOperationsConfigurationPanel;
import com.intellij.openapi.vcs.configurable.VcsDirectoryConfigurationPanel;
import com.intellij.openapi.vcs.configurable.VcsGeneralConfigurationPanel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;

public class VcsManagerConfigurable
extends SearchableConfigurable.Parent.Abstract {
    public static final Icon ICON = IconLoader.getIcon((String)"/general/configurableVcs.png");
    private final Project myProject;
    private VcsDirectoryConfigurationPanel myMappings;
    private VcsGeneralConfigurationPanel myGeneralPanel;

    public VcsManagerConfigurable(Project project) {
        this.myProject = project;
    }

    public JComponent createComponent() {
        this.myMappings = new VcsDirectoryConfigurationPanel(this.myProject);
        if (this.myGeneralPanel != null) {
            this.addListenerToGeneralPanel();
        }
        return this.myMappings;
    }

    public boolean hasOwnContent() {
        return true;
    }

    public boolean isModified() {
        return this.myMappings != null && this.myMappings.isModified();
    }

    public void apply() throws ConfigurationException {
        super.apply();
        this.myMappings.apply();
    }

    public void reset() {
        super.reset();
        this.myMappings.reset();
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        this.myMappings = null;
    }

    public String getDisplayName() {
        return VcsBundle.message((String)"version.control.main.configurable.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "project.propVCSSupport.Mappings";
    }

    public Icon getIcon() {
        return ICON;
    }

    public String getId() {
        return this.getHelpTopic();
    }

    protected Configurable[] buildConfigurables() {
        this.myGeneralPanel = new VcsGeneralConfigurationPanel(this.myProject){

            @Override
            public void disposeUIResources() {
                super.disposeUIResources();
                VcsManagerConfigurable.this.myGeneralPanel = null;
            }
        };
        if (this.myMappings != null) {
            this.myGeneralPanel.updateAvailableOptions(this.myMappings.getActiveVcses());
            this.addListenerToGeneralPanel();
        } else {
            this.myGeneralPanel.updateAvailableOptions(Arrays.asList(ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllActiveVcss()));
        }
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(this.myGeneralPanel);
        result.add(new VcsBackgroundOperationsConfigurationPanel(this.myProject));
        result.add(new IgnoredSettingsPanel(this.myProject));
        result.add(new IssueNavigationConfigurationPanel(this.myProject));
        result.add(new ChangelistConflictConfigurable(ChangeListManagerImpl.getInstanceImpl(this.myProject)));
        AbstractVcs[] vcses = ProjectLevelVcsManager.getInstance((Project)this.myProject).getAllVcss();
        if (vcses.length > 0) {
            result.add(this.createVcsComposeConfigurable(vcses));
        }
        return result.toArray(new Configurable[result.size()]);
    }

    private void addListenerToGeneralPanel() {
        this.myMappings.addVcsListener(new ModuleVcsListener(){

            @Override
            public void activeVcsSetChanged(Collection<AbstractVcs> activeVcses) {
                VcsManagerConfigurable.this.myGeneralPanel.updateAvailableOptions(activeVcses);
            }
        });
    }

    private Configurable createVcsComposeConfigurable(final AbstractVcs[] vcses) {
        return new SearchableConfigurable.Parent.Abstract(){

            protected Configurable[] buildConfigurables() {
                ArrayList<Configurable> result = new ArrayList<Configurable>();
                for (AbstractVcs vcs : vcses) {
                    result.add(VcsManagerConfigurable.this.createVcsConfigurableWrapper(vcs));
                }
                return result.toArray(new Configurable[result.size()]);
            }

            public String getId() {
                return "project.propVCSSupport.vcses";
            }

            @Nls
            public String getDisplayName() {
                return "VCSs";
            }

            public Icon getIcon() {
                return null;
            }

            public String getHelpTopic() {
                return "project.propVCSSupport.VCSs";
            }
        };
    }

    private Configurable createVcsConfigurableWrapper(final AbstractVcs vcs) {
        final Configurable delegate = vcs.getConfigurable();
        return new SearchableConfigurable(){

            @Nls
            public String getDisplayName() {
                return vcs.getDisplayName();
            }

            public Icon getIcon() {
                return null;
            }

            public String getHelpTopic() {
                return delegate.getHelpTopic();
            }

            public JComponent createComponent() {
                return delegate.createComponent();
            }

            public boolean isModified() {
                return delegate.isModified();
            }

            public void apply() throws ConfigurationException {
                delegate.apply();
            }

            public void reset() {
                delegate.reset();
            }

            public void disposeUIResources() {
                delegate.disposeUIResources();
            }

            public String getId() {
                return this.getHelpTopic();
            }

            public Runnable enableSearch(String option) {
                return null;
            }
        };
    }
}

