/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.diagnostic.Logger;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringReader;

public class TextTransferrable
implements Transferable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.history.TextTransferrable");
    private final String myHtmlContent;
    private final String myPlainContent;
    private static DataFlavor html;
    private static DataFlavor[] flavors;

    private static DataFlavor[] getFlavours() {
        if (flavors == null) {
            DataFlavor[] dataFlavorArray;
            try {
                html = new DataFlavor("text/html;class=java.lang.String");
            }
            catch (ClassNotFoundException e) {
                LOG.error((Throwable)e);
                html = null;
            }
            if (html == null) {
                DataFlavor[] dataFlavorArray2 = new DataFlavor[2];
                dataFlavorArray2[0] = DataFlavor.stringFlavor;
                dataFlavorArray = dataFlavorArray2;
                dataFlavorArray2[1] = DataFlavor.plainTextFlavor;
            } else {
                DataFlavor[] dataFlavorArray3 = new DataFlavor[3];
                dataFlavorArray3[0] = DataFlavor.stringFlavor;
                dataFlavorArray3[1] = DataFlavor.plainTextFlavor;
                dataFlavorArray = dataFlavorArray3;
                dataFlavorArray3[2] = html;
            }
            flavors = dataFlavorArray;
        }
        return flavors;
    }

    public TextTransferrable(String htmlContent, String plainContent) {
        this.myHtmlContent = htmlContent;
        this.myPlainContent = plainContent;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])TextTransferrable.getFlavours().clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (DataFlavor flavor1 : TextTransferrable.getFlavours()) {
            if (!flavor.equals(flavor1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(html)) {
            return this.myHtmlContent;
        }
        if (flavor.equals(DataFlavor.plainTextFlavor)) {
            return new StringReader(this.myPlainContent == null ? "" : this.myPlainContent);
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return this.myPlainContent;
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

