/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.changes.DirtBuilder;
import com.intellij.openapi.vcs.changes.FilePathUnderVcs;
import com.intellij.openapi.vcs.changes.VcsGuess;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.projectlevelman.NewMappings;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ProjectBaseDirectory;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class BasicDefaultVcsRootPolicy
extends DefaultVcsRootPolicy {
    private final Project myProject;
    private final VirtualFile myBaseDir;

    public BasicDefaultVcsRootPolicy(Project project) {
        this.myProject = project;
        this.myBaseDir = project.getBaseDir();
    }

    @Override
    public void addDefaultVcsRoots(NewMappings mappingList, AbstractVcs vcs, List<VirtualFile> result) {
        VirtualFile baseDir = ProjectBaseDirectory.getInstance(this.myProject).getBaseDir(this.myBaseDir);
        if (baseDir != null && vcs.getName().equals(mappingList.getVcsFor(baseDir))) {
            result.add(baseDir);
        }
    }

    @Override
    public boolean matchesDefaultMapping(VirtualFile file, Object matchContext) {
        return VfsUtil.isAncestor((VirtualFile)ProjectBaseDirectory.getInstance(this.myProject).getBaseDir(this.myBaseDir), (VirtualFile)file, (boolean)false);
    }

    @Override
    @Nullable
    public Object getMatchContext(VirtualFile file) {
        return null;
    }

    @Override
    @Nullable
    public VirtualFile getVcsRootFor(VirtualFile file) {
        return ProjectBaseDirectory.getInstance(this.myProject).getBaseDir(this.myBaseDir);
    }

    @Override
    public void markDefaultRootsDirty(DirtBuilder builder, VcsGuess vcsGuess) {
        FilePathImpl fp = new FilePathImpl(ProjectBaseDirectory.getInstance(this.myProject).getBaseDir(this.myBaseDir));
        AbstractVcs vcs = vcsGuess.getVcsForDirty(fp);
        if (vcs != null) {
            builder.addDirtyDirRecursively(new FilePathUnderVcs(fp, vcs));
        }
    }
}

