/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl.projectlevelman;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractFilterChildren;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.changes.ui.ChangesViewBalloonProblemNotifier;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcses;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcsesI;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.Convertor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewMappings {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.impl.projectlevelman.NewMappings");
    private final Object myLock;
    private final Map<String, List<VcsDirectoryMapping>> myVcsToPaths;
    private AbstractVcs[] myActiveVcses;
    private VcsDirectoryMapping[] mySortedMappings;
    private final Map<VcsDirectoryMapping, LocalFileSystem.WatchRequest> myDirectoryMappingWatches;
    private final DefaultVcsRootPolicy myDefaultVcsRootPolicy;
    private final EventDispatcher<VcsListener> myEventDispatcher;
    private final FileStatusManager myFileStatusManager;
    private final Project myProject;
    private boolean myActivated;

    public NewMappings(Project project, EventDispatcher<VcsListener> eventDispatcher, ProjectLevelVcsManagerImpl vcsManager, FileStatusManager fileStatusManager) {
        this.myProject = project;
        this.myFileStatusManager = fileStatusManager;
        this.myLock = new Object();
        this.myVcsToPaths = new HashMap<String, List<VcsDirectoryMapping>>();
        this.myDirectoryMappingWatches = new HashMap<VcsDirectoryMapping, LocalFileSystem.WatchRequest>();
        this.myDefaultVcsRootPolicy = DefaultVcsRootPolicy.getInstance(project);
        this.myActiveVcses = new AbstractVcs[0];
        this.myEventDispatcher = eventDispatcher;
        ArrayList<VcsDirectoryMapping> listStr = new ArrayList<VcsDirectoryMapping>();
        VcsDirectoryMapping mapping = new VcsDirectoryMapping("", "");
        listStr.add(mapping);
        this.myVcsToPaths.put("", listStr);
        this.mySortedMappings = new VcsDirectoryMapping[]{mapping};
        this.myActivated = false;
        vcsManager.addInitializationRequest(VcsInitObject.MAPPINGS, (Runnable)new DumbAwareRunnable(){

            public void run() {
                NewMappings.this.activateActiveVcses();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractVcs[] getActiveVcses() {
        Object object = this.myLock;
        synchronized (object) {
            AbstractVcs[] result = new AbstractVcs[this.myActiveVcses.length];
            System.arraycopy(this.myActiveVcses, 0, result, 0, this.myActiveVcses.length);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateActiveVcses() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myActivated) {
                return;
            }
            this.myActivated = true;
        }
        this.keepActiveVcs(EmptyRunnable.getInstance());
        this.mappingsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Modification
    public void setMapping(final String path, final String activeVcsName) {
        LOG.debug("setMapping path = '" + path + "' vcs = " + activeVcsName);
        final VcsDirectoryMapping newMapping = new VcsDirectoryMapping(path, activeVcsName);
        Object object = this.myLock;
        synchronized (object) {
            List<VcsDirectoryMapping> vcsDirectoryMappings;
            if (this.myVcsToPaths.containsKey(activeVcsName) && (vcsDirectoryMappings = this.myVcsToPaths.get(activeVcsName)) != null && vcsDirectoryMappings.contains(newMapping)) {
                return;
            }
        }
        final LocalFileSystem.WatchRequest request = NewMappings.addWatchRequest(newMapping);
        final Ref switched = new Ref((Object)Boolean.FALSE);
        this.keepActiveVcs(new Runnable(){

            @Override
            public void run() {
                switched.set((Object)NewMappings.this.trySwitchVcs(path, activeVcsName));
                if (!((Boolean)switched.get()).booleanValue()) {
                    List newList = NewMappings.this.listForVcsFromMap(newMapping.getVcs());
                    newList.add(newMapping);
                    NewMappings.this.sortedMappingsByMap();
                    if (request != null) {
                        NewMappings.this.myDirectoryMappingWatches.put(newMapping, request);
                    }
                }
            }
        });
        if (((Boolean)switched.get()).booleanValue() && request != null) {
            LocalFileSystem.getInstance().removeWatchedRoot(request);
        }
        this.mappingsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void keepActiveVcs(Runnable runnable) {
        MyVcsActivator activator;
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myActivated) {
                runnable.run();
                return;
            }
            HashSet<String> old = new HashSet<String>();
            for (AbstractVcs activeVcs : this.myActiveVcses) {
                old.add(activeVcs.getName());
            }
            activator = new MyVcsActivator(old);
            runnable.run();
            this.restoreActiveVcses();
        }
        activator.activate(this.myVcsToPaths.keySet(), AllVcses.getInstance(this.myProject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreActiveVcses() {
        Object object = this.myLock;
        synchronized (object) {
            Set<String> set = this.myVcsToPaths.keySet();
            ArrayList<AbstractVcs> list = new ArrayList<AbstractVcs>(set.size());
            for (String s : set) {
                AbstractVcs vcs;
                if (s.trim().length() == 0 || (vcs = AllVcses.getInstance(this.myProject).getByName(s)) == null) continue;
                list.add(vcs);
            }
            this.myActiveVcses = list.toArray(new AbstractVcs[list.size()]);
        }
    }

    public void mappingsChanged() {
        ((VcsListener)this.myEventDispatcher.getMulticaster()).directoryMappingChanged();
        this.myFileStatusManager.fileStatusesChanged();
    }

    @Modification
    public void setDirectoryMappings(List<VcsDirectoryMapping> items) {
        LOG.debug("setDirectoryMappings, size: " + items.size());
        MySetMappingsPreProcessor setMappingsPreProcessor = new MySetMappingsPreProcessor(items);
        setMappingsPreProcessor.invoke();
        final List<VcsDirectoryMapping> itemsCopy = setMappingsPreProcessor.getItemsCopy();
        Map<VcsDirectoryMapping, LocalFileSystem.WatchRequest> requests = setMappingsPreProcessor.getRequests();
        final ArrayList toRemove = new ArrayList();
        this.keepActiveVcs(new Runnable(){

            @Override
            public void run() {
                toRemove.addAll(NewMappings.this.myDirectoryMappingWatches.values());
                NewMappings.this.myDirectoryMappingWatches.clear();
                NewMappings.this.myVcsToPaths.clear();
                for (VcsDirectoryMapping mapping : itemsCopy) {
                    NewMappings.this.listForVcsFromMap(mapping.getVcs()).add(mapping);
                }
                NewMappings.this.sortedMappingsByMap();
            }
        });
        toRemove.removeAll(requests.values());
        LocalFileSystem.getInstance().removeWatchedRoots(toRemove);
        this.mappingsChanged();
    }

    @Nullable
    public VcsDirectoryMapping getMappingFor(VirtualFile file) {
        if (file == null) {
            return null;
        }
        if (!file.isInLocalFileSystem()) {
            return null;
        }
        return this.getMappingFor(file, this.myDefaultVcsRootPolicy.getMatchContext(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VcsDirectoryMapping getMappingFor(VirtualFile file, Object matchContext) {
        String path = file.getPath();
        String systemIndependPath = FileUtil.toSystemIndependentName((String)(file.isDirectory() && !path.endsWith("/") ? path + "/" : path));
        Object object = this.myLock;
        synchronized (object) {
            for (int i = this.mySortedMappings.length - 1; i >= 0; --i) {
                VcsDirectoryMapping mapping = this.mySortedMappings[i];
                if (!this.fileMatchesMapping(file, matchContext, systemIndependPath, mapping)) continue;
                return mapping;
            }
            return null;
        }
    }

    @Nullable
    public String getVcsFor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/impl/projectlevelman/NewMappings.getVcsFor must not be null");
        }
        VcsDirectoryMapping mapping = this.getMappingFor(file);
        if (mapping == null) {
            return null;
        }
        return mapping.getVcs();
    }

    private boolean fileMatchesMapping(VirtualFile file, Object matchContext, String systemIndependPath, VcsDirectoryMapping mapping) {
        if (mapping.getDirectory().length() == 0) {
            return this.myDefaultVcsRootPolicy.matchesDefaultMapping(file, matchContext);
        }
        return FileUtil.startsWith((String)systemIndependPath, (String)mapping.systemIndependentPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<VirtualFile> getMappingsAsFilesUnderVcs(AbstractVcs vcs) {
        ArrayList<VcsDirectoryMapping> mappings;
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        String vcsName = vcs.getName();
        Object object = this.myLock;
        synchronized (object) {
            List<VcsDirectoryMapping> vcsMappings = this.myVcsToPaths.get(vcsName);
            if (vcsMappings == null) {
                return result;
            }
            mappings = new ArrayList<VcsDirectoryMapping>(vcsMappings);
        }
        for (VcsDirectoryMapping mapping : mappings) {
            if (mapping.isDefaultMapping()) {
                this.myDefaultVcsRootPolicy.addDefaultVcsRoots(this, vcs, result);
                continue;
            }
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(mapping.getDirectory());
            if (file == null) continue;
            result.add(file);
        }
        return result;
    }

    @Modification
    public void disposeMe() {
        LOG.debug("dipose me");
        this.clearImpl();
    }

    @Modification
    public void clear() {
        LOG.debug("clear");
        this.clearImpl();
        this.mappingsChanged();
    }

    private void clearImpl() {
        if (this.myActiveVcses == null || this.myActiveVcses.length == 0) {
            return;
        }
        final ArrayList toRemove = new ArrayList();
        this.keepActiveVcs(new Runnable(){

            @Override
            public void run() {
                toRemove.addAll(NewMappings.this.myDirectoryMappingWatches.values());
                NewMappings.this.myDirectoryMappingWatches.clear();
                NewMappings.this.myVcsToPaths.clear();
                NewMappings.access$502(NewMappings.this, new AbstractVcs[0]);
                NewMappings.access$602(NewMappings.this, new VcsDirectoryMapping[0]);
            }
        });
        if (!toRemove.isEmpty()) {
            LocalFileSystem.getInstance().removeWatchedRoots(toRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VcsDirectoryMapping> getDirectoryMappings() {
        Object object = this.myLock;
        synchronized (object) {
            return Arrays.asList(this.mySortedMappings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VcsDirectoryMapping> getDirectoryMappings(String vcsName) {
        Object object = this.myLock;
        synchronized (object) {
            List<VcsDirectoryMapping> mappings = this.myVcsToPaths.get(vcsName);
            return mappings == null ? new ArrayList<VcsDirectoryMapping>() : new ArrayList<VcsDirectoryMapping>(mappings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupMappings() {
        List<LocalFileSystem.WatchRequest> watchRequestList;
        Object object = this.myLock;
        synchronized (object) {
            watchRequestList = this.removeRedundantMappings();
        }
        LocalFileSystem.getInstance().removeWatchedRoots(watchRequestList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String haveDefaultMapping() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.mySortedMappings.length == 0) {
                return null;
            }
            return this.mySortedMappings[0].isDefaultMapping() ? this.mySortedMappings[0].getVcs() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.myLock;
        synchronized (object) {
            return this.mySortedMappings.length == 0;
        }
    }

    @Modification
    public void removeDirectoryMapping(final VcsDirectoryMapping mapping) {
        LOG.debug("remove mapping: " + mapping.getDirectory());
        final Ref request = new Ref();
        this.keepActiveVcs(new Runnable(){

            @Override
            public void run() {
                if (NewMappings.this.removeVcsFromMap(mapping, mapping.getVcs())) {
                    NewMappings.this.sortedMappingsByMap();
                    request.set(NewMappings.this.myDirectoryMappingWatches.remove(mapping));
                }
            }
        });
        if (!request.isNull()) {
            LocalFileSystem.getInstance().removeWatchedRoot((LocalFileSystem.WatchRequest)request.get());
        }
        this.mappingsChanged();
    }

    private List<LocalFileSystem.WatchRequest> removeRedundantMappings() {
        Set<Map.Entry<String, List<VcsDirectoryMapping>>> entries = this.myVcsToPaths.entrySet();
        final LocalFileSystem lfs = LocalFileSystem.getInstance();
        AllVcsesI allVcses = AllVcses.getInstance(this.myProject);
        LinkedList<LocalFileSystem.WatchRequest> removedRequests = new LinkedList<LocalFileSystem.WatchRequest>();
        Iterator<String> iterator = this.myVcsToPaths.keySet().iterator();
        while (iterator.hasNext()) {
            List filteredFiles;
            String vcsName = iterator.next();
            List<VcsDirectoryMapping> mappings = this.myVcsToPaths.get(vcsName);
            List<Pair<VirtualFile, VcsDirectoryMapping>> objects = ObjectsConvertor.convert(mappings, new Convertor<VcsDirectoryMapping, Pair<VirtualFile, VcsDirectoryMapping>>(){

                public Pair<VirtualFile, VcsDirectoryMapping> convert(VcsDirectoryMapping dm) {
                    VirtualFile vf = lfs.findFileByPath(dm.getDirectory());
                    if (vf == null) {
                        vf = lfs.refreshAndFindFileByPath(dm.getDirectory());
                    }
                    return vf == null ? null : new Pair((Object)vf, (Object)dm);
                }
            }, ObjectsConvertor.NOT_NULL);
            Convertor<Pair<VirtualFile, VcsDirectoryMapping>, VirtualFile> fileConvertor = new Convertor<Pair<VirtualFile, VcsDirectoryMapping>, VirtualFile>(){

                public VirtualFile convert(Pair<VirtualFile, VcsDirectoryMapping> o) {
                    return (VirtualFile)o.getFirst();
                }
            };
            if (StringUtil.isEmptyOrSpaces((String)vcsName)) {
                filteredFiles = AbstractVcs.filterUniqueRootsDefault(objects, (Convertor)fileConvertor);
            } else {
                AbstractVcs vcs = allVcses.getByName(vcsName);
                if (vcs == null) {
                    ChangesViewBalloonProblemNotifier.showMe(this.myProject, "VCS plugin not found for mapping to : '" + vcsName + "'", MessageType.ERROR);
                    continue;
                }
                filteredFiles = vcs.filterUniqueRoots(objects, (Convertor)fileConvertor);
            }
            List<VcsDirectoryMapping> filteredMappings = ObjectsConvertor.convert(filteredFiles, new Convertor<Pair<VirtualFile, VcsDirectoryMapping>, VcsDirectoryMapping>(){

                public VcsDirectoryMapping convert(Pair<VirtualFile, VcsDirectoryMapping> o) {
                    return (VcsDirectoryMapping)o.getSecond();
                }
            });
            mappings.removeAll(filteredMappings);
            for (VcsDirectoryMapping mapping : mappings) {
                removedRequests.add(this.myDirectoryMappingWatches.remove(mapping));
            }
            if (filteredMappings.isEmpty()) {
                iterator.remove();
                continue;
            }
            mappings.clear();
            mappings.addAll(filteredMappings);
        }
        this.sortedMappingsByMap();
        return removedRequests;
    }

    private boolean trySwitchVcs(String path, String activeVcsName) {
        String fixedPath = FileUtil.toSystemIndependentName((String)path);
        for (VcsDirectoryMapping mapping : this.mySortedMappings) {
            if (!mapping.systemIndependentPath().equals(fixedPath)) continue;
            String oldVcs = mapping.getVcs();
            if (!oldVcs.equals(activeVcsName)) {
                this.migrateVcs(activeVcsName, mapping, oldVcs);
            }
            return true;
        }
        return false;
    }

    private void sortedMappingsByMap() {
        ArrayList<VcsDirectoryMapping> list = new ArrayList<VcsDirectoryMapping>();
        for (List<VcsDirectoryMapping> mappingList : this.myVcsToPaths.values()) {
            list.addAll(mappingList);
        }
        this.mySortedMappings = list.toArray(new VcsDirectoryMapping[list.size()]);
        Arrays.sort(this.mySortedMappings, MyMappingsComparator.getInstance());
    }

    private void migrateVcs(String activeVcsName, VcsDirectoryMapping mapping, String oldVcs) {
        mapping.setVcs(activeVcsName);
        this.removeVcsFromMap(mapping, oldVcs);
        List<VcsDirectoryMapping> newList = this.listForVcsFromMap(activeVcsName);
        newList.add(mapping);
    }

    private boolean removeVcsFromMap(VcsDirectoryMapping mapping, String oldVcs) {
        List<VcsDirectoryMapping> oldList = this.myVcsToPaths.get(oldVcs);
        if (oldList == null) {
            return false;
        }
        boolean result = oldList.remove(mapping);
        if (oldList.isEmpty()) {
            this.myVcsToPaths.remove(oldVcs);
        }
        return result;
    }

    private List<VcsDirectoryMapping> listForVcsFromMap(String activeVcsName) {
        List<VcsDirectoryMapping> newList = this.myVcsToPaths.get(activeVcsName);
        if (newList == null) {
            newList = new ArrayList<VcsDirectoryMapping>();
            this.myVcsToPaths.put(activeVcsName, newList);
        }
        return newList;
    }

    @Nullable
    private static LocalFileSystem.WatchRequest addWatchRequest(VcsDirectoryMapping mapping) {
        if (!mapping.isDefaultMapping()) {
            return LocalFileSystem.getInstance().addRootToWatch(mapping.getDirectory(), true);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean haveActiveVcs(String name) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myVcsToPaths.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Modification
    public void beingUnregistered(final String name) {
        Object object = this.myLock;
        synchronized (object) {
            this.keepActiveVcs(new Runnable(){

                @Override
                public void run() {
                    List removed = (List)NewMappings.this.myVcsToPaths.remove(name);
                    NewMappings.this.sortedMappingsByMap();
                }
            });
        }
        this.mappingsChanged();
    }

    static /* synthetic */ AbstractVcs[] access$502(NewMappings x0, AbstractVcs[] x1) {
        x0.myActiveVcses = x1;
        return x1;
    }

    static /* synthetic */ VcsDirectoryMapping[] access$602(NewMappings x0, VcsDirectoryMapping[] x1) {
        x0.mySortedMappings = x1;
        return x1;
    }

    private static @interface Modification {
    }

    private static class MySetMappingsPreProcessor {
        private List<VcsDirectoryMapping> myItems;
        private List<VcsDirectoryMapping> myItemsCopy;
        private Map<VcsDirectoryMapping, LocalFileSystem.WatchRequest> myRequests;

        public MySetMappingsPreProcessor(List<VcsDirectoryMapping> items) {
            this.myItems = items;
        }

        public List<VcsDirectoryMapping> getItemsCopy() {
            return this.myItemsCopy;
        }

        public Map<VcsDirectoryMapping, LocalFileSystem.WatchRequest> getRequests() {
            return this.myRequests;
        }

        public void invoke() {
            if (this.myItems.isEmpty()) {
                this.myItemsCopy = Collections.singletonList(new VcsDirectoryMapping("", ""));
                this.myRequests = Collections.emptyMap();
            } else {
                this.myRequests = new HashMap<VcsDirectoryMapping, LocalFileSystem.WatchRequest>();
                for (VcsDirectoryMapping item : this.myItems) {
                    LocalFileSystem.WatchRequest request = NewMappings.addWatchRequest(item);
                    if (request == null) continue;
                    this.myRequests.put(item, request);
                }
                this.myItemsCopy = this.myItems;
            }
        }
    }

    private static class MyVcsActivator {
        private final Set<String> myOld;

        public MyVcsActivator(Set<String> old) {
            this.myOld = old;
        }

        public void activate(Set<String> newOne, AllVcsesI vcsesI) {
            AbstractVcs vcs;
            Set<String> toAdd = this.notInBottom(newOne, this.myOld);
            Set<String> toRemove = this.notInBottom(this.myOld, newOne);
            if (toAdd != null) {
                for (String s : toAdd) {
                    vcs = vcsesI.getByName(s);
                    if (vcs != null) {
                        try {
                            vcs.doActivate();
                        }
                        catch (VcsException e) {}
                        continue;
                    }
                    LOG.info("Error: activating non existing vcs: " + s);
                }
            }
            if (toRemove != null) {
                for (String s : toRemove) {
                    vcs = vcsesI.getByName(s);
                    if (vcs != null) {
                        try {
                            vcs.doDeactivate();
                        }
                        catch (VcsException e) {}
                        continue;
                    }
                    LOG.info("Error: removing non existing vcs: " + s);
                }
            }
        }

        @Nullable
        private Set<String> notInBottom(Set<String> top, Set<String> bottom) {
            HashSet<String> notInBottom = null;
            for (String topItem : top) {
                if (topItem.trim().length() == 0 || bottom.contains(topItem)) continue;
                if (notInBottom == null) {
                    notInBottom = new HashSet<String>();
                }
                notInBottom.add(topItem);
            }
            return notInBottom;
        }
    }

    private static class MyMappingsComparator
    implements Comparator<VcsDirectoryMapping> {
        private static final MyMappingsComparator ourInstance = new MyMappingsComparator();

        private MyMappingsComparator() {
        }

        public static MyMappingsComparator getInstance() {
            return ourInstance;
        }

        @Override
        public int compare(VcsDirectoryMapping m1, VcsDirectoryMapping m2) {
            return m1.getDirectory().compareTo(m2.getDirectory());
        }
    }

    private class MyMappingsFilter
    extends AbstractFilterChildren<VcsDirectoryMapping> {
        private final List<LocalFileSystem.WatchRequest> myRemovedRequests = new ArrayList<LocalFileSystem.WatchRequest>();

        private MyMappingsFilter() {
        }

        protected void sortAscending(List<VcsDirectoryMapping> vcsDirectoryMappings) {
            Collections.sort(vcsDirectoryMappings, MyMappingsComparator.getInstance());
        }

        protected void onRemove(VcsDirectoryMapping vcsDirectoryMapping) {
            LocalFileSystem.WatchRequest request = (LocalFileSystem.WatchRequest)NewMappings.this.myDirectoryMappingWatches.remove(vcsDirectoryMapping);
            if (request != null) {
                this.myRemovedRequests.add(request);
            }
        }

        protected boolean isAncestor(VcsDirectoryMapping parent, VcsDirectoryMapping child) {
            String fixedParentPath;
            if (!parent.getVcs().equals(child.getVcs())) {
                return false;
            }
            String parentPath = parent.systemIndependentPath();
            String string = fixedParentPath = parentPath.endsWith("/") ? parentPath : parentPath + "/";
            if (child.systemIndependentPath().length() < fixedParentPath.length()) {
                return child.systemIndependentPath().equals(parentPath);
            }
            return child.systemIndependentPath().startsWith(fixedParentPath);
        }

        public List<LocalFileSystem.WatchRequest> getRemovedRequests() {
            return this.myRemovedRequests;
        }
    }
}

