/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.history.ByteContent;
import com.intellij.history.Label;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.actions.ShowDiffAction;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.NotNullFunction;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowUpdatedDiffAction
extends AnAction
implements DumbAware {
    private static Icon ourIcon;
    private static String ourText;
    private static String ourDescription;

    private static void initData() {
        ourIcon = IconLoader.getIcon((String)"/actions/diff.png");
        ourText = VcsBundle.message((String)"updated.info.tree.show.diff.text", (Object[])new Object[0]);
        ourDescription = VcsBundle.message((String)"updated.info.tree.show.diff.description", (Object[])new Object[0]);
    }

    public void update(AnActionEvent e) {
        if (ourIcon == null) {
            ShowUpdatedDiffAction.initData();
        }
        DataContext dc = e.getDataContext();
        Presentation presentation = e.getPresentation();
        presentation.setIcon(ourIcon);
        presentation.setText(ourText);
        presentation.setDescription(ourDescription);
        presentation.setEnabled(this.isVisible(dc) && this.isEnabled(dc));
    }

    private boolean isVisible(DataContext dc) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dc);
        return project != null && VcsDataKeys.LABEL_BEFORE.getData(dc) != null && VcsDataKeys.LABEL_AFTER.getData(dc) != null;
    }

    private boolean isEnabled(DataContext dc) {
        Iterable iterable = (Iterable)VcsDataKeys.UPDATE_VIEW_FILES_ITERABLE.getData(dc);
        return iterable != null;
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dc = e.getDataContext();
        if (!this.isVisible(dc) || !this.isEnabled(dc)) {
            return;
        }
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dc);
        Iterable iterable = (Iterable)VcsDataKeys.UPDATE_VIEW_FILES_ITERABLE.getData(dc);
        Label before = (Label)VcsDataKeys.LABEL_BEFORE.getData(dc);
        Label after = (Label)VcsDataKeys.LABEL_AFTER.getData(dc);
        String selectedUrl = (String)VcsDataKeys.UPDATE_VIEW_SELECTED_PATH.getData(dc);
        ShowDiffAction.showDiffForChange(new MyIterableWrapper(iterable.iterator(), before, after), new MySelectionMarker(selectedUrl), project, ShowDiffAction.DiffExtendUIFactory.NONE, true);
    }

    private static class MyIteratorWrapper
    implements Iterator<Change> {
        private final MyLoader myBeforeLoader;
        private final MyLoader myAfterLoader;
        private final Iterator<VirtualFilePointer> myVfIterator;

        public MyIteratorWrapper(Iterator<VirtualFilePointer> vfIterator, Label before, Label after) {
            this.myVfIterator = vfIterator;
            this.myBeforeLoader = new MyLoader(before);
            this.myAfterLoader = new MyLoader(after);
        }

        @Override
        public boolean hasNext() {
            return this.myVfIterator.hasNext();
        }

        @Override
        public Change next() {
            VirtualFilePointer pointer = this.myVfIterator.next();
            return new Change((ContentRevision)new MyCheckpointContentRevision(pointer, this.myBeforeLoader, true), (ContentRevision)new MyCheckpointContentRevision(pointer, this.myAfterLoader, false));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class MyCheckpointContentRevision
    implements ContentRevision {
        private SoftReference<String> myContent;
        private final MyLoader myLoader;
        private final VirtualFilePointer myPointer;
        private final boolean myBefore;

        private MyCheckpointContentRevision(VirtualFilePointer pointer, MyLoader loader, boolean before) {
            this.myLoader = loader;
            this.myPointer = pointer;
            this.myBefore = before;
        }

        public String getContent() throws VcsException {
            String s;
            if (this.myContent != null && (s = this.myContent.get()) != null) {
                return s;
            }
            String loaded = this.myLoader.convert(this.myPointer);
            this.myContent = new SoftReference<String>(loaded);
            return loaded;
        }

        public String getUrl() {
            return this.myPointer.getUrl();
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public FilePath getFile() {
            FilePathImpl filePathImpl;
            VirtualFile vf = this.myPointer.getFile();
            if (vf != null) {
                filePathImpl = new FilePathImpl(vf);
                if (filePathImpl == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/update/ShowUpdatedDiffAction$MyCheckpointContentRevision.getFile must not return null");
                return filePathImpl;
            }
            filePathImpl = new FilePathImpl(new File(this.myPointer.getPresentableUrl()), false);
            if (filePathImpl != null) return filePathImpl;
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/update/ShowUpdatedDiffAction$MyCheckpointContentRevision.getFile must not return null");
        }

        @NotNull
        public VcsRevisionNumber getRevisionNumber() {
            VcsRevisionNumber vcsRevisionNumber = new VcsRevisionNumber(){

                public String asString() {
                    return MyCheckpointContentRevision.this.myBefore ? "Before update" : "After update";
                }

                public int compareTo(VcsRevisionNumber o) {
                    return MyCheckpointContentRevision.this.myBefore ? -1 : 1;
                }
            };
            if (vcsRevisionNumber == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/update/ShowUpdatedDiffAction$MyCheckpointContentRevision.getRevisionNumber must not return null");
            }
            return vcsRevisionNumber;
        }
    }

    private static class MyLoader {
        private final Label myLabel;

        private MyLoader(Label label) {
            this.myLabel = label;
        }

        @Nullable
        public String convert(VirtualFilePointer pointer) {
            String path = pointer.getPresentableUrl();
            ByteContent byteContent = this.myLabel.getByteContent(FileUtil.toSystemIndependentName((String)path));
            if (byteContent.isDirectory() || byteContent.getBytes() == null) {
                return null;
            }
            VirtualFile vf = pointer.getFile();
            if (vf == null) {
                return ((Object)LoadTextUtil.getTextByBinaryPresentation(byteContent.getBytes(), EncodingManager.getInstance().getDefaultCharset())).toString();
            }
            return ((Object)LoadTextUtil.getTextByBinaryPresentation(byteContent.getBytes(), vf)).toString();
        }
    }

    private static class MyIterableWrapper
    implements Iterable<Change> {
        private final Iterator<VirtualFilePointer> myVfIterator;
        private final Label myBefore;
        private final Label myAfter;

        private MyIterableWrapper(Iterator<VirtualFilePointer> vfIterator, Label before, Label after) {
            this.myVfIterator = vfIterator;
            this.myBefore = before;
            this.myAfter = after;
        }

        @Override
        public Iterator<Change> iterator() {
            return new MyIteratorWrapper(this.myVfIterator, this.myBefore, this.myAfter);
        }
    }

    private static class MySelectionMarker
    implements NotNullFunction<Change, Boolean> {
        private final String mySelectedPath;
        private boolean myFirstSelected;

        public MySelectionMarker(String selectedPath) {
            this.mySelectedPath = selectedPath;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public Boolean fun(Change change) {
            Boolean bl;
            if (this.mySelectedPath == null) {
                if (this.myFirstSelected) {
                    this.myFirstSelected = true;
                    bl = true;
                    if (bl == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/update/ShowUpdatedDiffAction$MySelectionMarker.fun must not return null");
                    return bl;
                } else {
                    bl = false;
                    if (bl == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/update/ShowUpdatedDiffAction$MySelectionMarker.fun must not return null");
                    return bl;
                }
            }
            String url = ((MyCheckpointContentRevision)change.getBeforeRevision()).getUrl();
            bl = this.mySelectedPath.equals(url);
            if (bl != null) return bl;
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/update/ShowUpdatedDiffAction$MySelectionMarker.fun must not return null");
        }
    }
}

