/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.update.FileGroup;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.util.Consumer;
import java.util.List;

public class UpdateFilesHelper {
    private UpdateFilesHelper() {
    }

    public static void iterateFileGroupFilesDeletedOnServerFirst(UpdatedFiles updatedFiles, Callback callback) {
        FileGroup changedOnServer = updatedFiles.getGroupById("CHANGED_ON_SERVER");
        if (changedOnServer != null) {
            List children = changedOnServer.getChildren();
            for (FileGroup child : children) {
                if (!"REMOVED_FROM_REPOSITORY".equals(child.getId())) continue;
                UpdateFilesHelper.iterateGroup(child, callback);
            }
        }
        List groups = updatedFiles.getTopLevelGroups();
        for (FileGroup group : groups) {
            UpdateFilesHelper.iterateGroup(group, callback);
            for (FileGroup childGroup : group.getChildren()) {
                if ("REMOVED_FROM_REPOSITORY".equals(childGroup.getId())) continue;
                UpdateFilesHelper.iterateGroup(childGroup, callback);
            }
        }
    }

    private static void iterateGroup(FileGroup group, Callback callback) {
        for (String file : group.getFiles()) {
            callback.onFile(file, group.getId());
        }
    }

    public static void iterateFileGroupFiles(UpdatedFiles updatedFiles, Callback callback) {
        List groups = updatedFiles.getTopLevelGroups();
        for (FileGroup group : groups) {
            UpdateFilesHelper.iterateGroup(group, callback);
            for (FileGroup childGroup : group.getChildren()) {
                UpdateFilesHelper.iterateGroup(childGroup, callback);
            }
        }
    }

    private static void iterateGroup(FileGroup group, Consumer<Pair<String, String>> callback) {
        for (FileGroup.UpdatedFile updatedFile : group.getUpdatedFiles()) {
            callback.consume((Object)new Pair((Object)updatedFile.getPath(), (Object)updatedFile.getVcsName()));
        }
    }

    public static void iterateAffectedFiles(UpdatedFiles updatedFiles, Consumer<Pair<String, String>> callback) {
        List groups = updatedFiles.getTopLevelGroups();
        for (FileGroup group : groups) {
            UpdateFilesHelper.iterateGroup(group, callback);
            for (FileGroup childGroup : group.getChildren()) {
                UpdateFilesHelper.iterateGroup(childGroup, callback);
            }
        }
    }

    public static interface Callback {
        public void onFile(String var1, String var2);
    }
}

