/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.ex.temp;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LocalTimeCounter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TempFileSystem
extends NewVirtualFileSystem {
    private final FSItem myRoot = new FSDir(null, "/");

    public static TempFileSystem getInstance() {
        return (TempFileSystem)((Object)ApplicationManager.getApplication().getComponent(TempFileSystem.class));
    }

    public boolean isCaseSensitive() {
        return true;
    }

    protected String extractRootPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/ex/temp/TempFileSystem.extractRootPath must not be null");
        }
        return path.startsWith("/") ? "/" : "";
    }

    public int getRank() {
        return 1;
    }

    @Nullable
    private FSItem convert(VirtualFile file) {
        VirtualFile parentFile = file.getParent();
        if (parentFile == null) {
            return this.myRoot;
        }
        FSItem parentItem = this.convert(parentFile);
        if (parentItem == null || !parentItem.isDirectory()) {
            return null;
        }
        return parentItem.findChild(file.getName());
    }

    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/ex/temp/TempFileSystem.copyFile must not be null");
        }
        if (newParent == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/ex/temp/TempFileSystem.copyFile must not be null");
        }
        if (copyName == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/vfs/ex/temp/TempFileSystem.copyFile must not be null");
        }
        return VfsUtil.copyFile((Object)requestor, (VirtualFile)file, (VirtualFile)newParent, (String)copyName);
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile parent, @NotNull String dir) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/ex/temp/TempFileSystem.createChildDirectory must not be null");
        }
        if (dir == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/ex/temp/TempFileSystem.createChildDirectory must not be null");
        }
        FSItem fsItem = this.convert(parent);
        assert (fsItem != null && fsItem.isDirectory());
        FSDir fsDir = (FSDir)fsItem;
        FSItem existingDir = fsDir.findChild(dir);
        if (existingDir == null) {
            fsDir.addChild(new FSDir(fsDir, dir));
        } else if (!existingDir.isDirectory()) {
            throw new IOException("Directory already contains a file named " + dir);
        }
        FakeVirtualFile fakeVirtualFile = new FakeVirtualFile(parent, dir);
        if (fakeVirtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/ex/temp/TempFileSystem.createChildDirectory must not return null");
        }
        return fakeVirtualFile;
    }

    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile parent, @NotNull String file) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/ex/temp/TempFileSystem.createChildFile must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/ex/temp/TempFileSystem.createChildFile must not be null");
        }
        FSItem fsItem = this.convert(parent);
        assert (fsItem != null) : "cannot find parent directory: " + parent.getPath();
        assert (fsItem.isDirectory()) : "parent is not a directory: " + parent.getPath();
        FSDir fsDir = (FSDir)fsItem;
        fsDir.addChild(new FSFile(fsDir, file));
        return new FakeVirtualFile(parent, file);
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/ex/temp/TempFileSystem.deleteFile must not be null");
        }
        FSItem fsItem = this.convert(file);
        assert (fsItem != null) : "failed to delete file " + file.getPath();
        fsItem.getParent().removeChild(fsItem);
    }

    public void moveFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile newParent) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/ex/temp/TempFileSystem.moveFile must not be null");
        }
        if (newParent == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/ex/temp/TempFileSystem.moveFile must not be null");
        }
        FSItem fsItem = this.convert(file);
        assert (fsItem != null) : "failed to move file " + file.getPath();
        FSItem newParentItem = this.convert(newParent);
        assert (newParentItem != null && newParentItem.isDirectory()) : "failed to find move target " + file.getPath();
        FSDir newDir = (FSDir)newParentItem;
        if (newDir.findChild(file.getName()) != null) {
            throw new IOException("Directory already contains a file named " + file.getName());
        }
        fsItem.getParent().removeChild(fsItem);
        ((FSDir)newParentItem).addChild(fsItem);
    }

    public void renameFile(Object requestor, @NotNull VirtualFile file, @NotNull String newName) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/ex/temp/TempFileSystem.renameFile must not be null");
        }
        if (newName == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/ex/temp/TempFileSystem.renameFile must not be null");
        }
        FSItem fsItem = this.convert(file);
        assert (fsItem != null);
        fsItem.setName(newName);
    }

    @NotNull
    public String getProtocol() {
        if ("temp" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/ex/temp/TempFileSystem.getProtocol must not return null");
        }
        return "temp";
    }

    public boolean exists(VirtualFile fileOrDirectory) {
        return this.convert(fileOrDirectory) != null;
    }

    public String[] list(VirtualFile file) {
        FSItem fsItem = this.convert(file);
        assert (fsItem != null);
        return fsItem.list();
    }

    public boolean isDirectory(VirtualFile file) {
        return this.convert(file) instanceof FSDir;
    }

    public long getTimeStamp(VirtualFile file) {
        FSItem fsItem = this.convert(file);
        assert (fsItem != null) : "cannot find item for path " + file.getPath();
        return fsItem.myTimestamp;
    }

    public void setTimeStamp(VirtualFile file, long modstamp) throws IOException {
        FSItem fsItem = this.convert(file);
        assert (fsItem != null);
        fsItem.myTimestamp = modstamp > 0L ? modstamp : LocalTimeCounter.currentTime();
    }

    public boolean isWritable(VirtualFile file) {
        FSItem fsItem = this.convert(file);
        assert (fsItem != null);
        return fsItem.myWritable;
    }

    public void setWritable(VirtualFile file, boolean writableFlag) throws IOException {
        FSItem fsItem = this.convert(file);
        assert (fsItem != null);
        fsItem.myWritable = writableFlag;
    }

    @NotNull
    public byte[] contentsToByteArray(VirtualFile file) throws IOException {
        FSItem fsItem = this.convert(file);
        if (fsItem == null) {
            throw new FileNotFoundException("Cannot find temp for " + file.getPath());
        }
        assert (fsItem instanceof FSFile);
        byte[] byArray = ((FSFile)fsItem).myContent;
        if (byArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/ex/temp/TempFileSystem.contentsToByteArray must not return null");
        }
        return byArray;
    }

    @NotNull
    public InputStream getInputStream(VirtualFile file) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.contentsToByteArray(file));
        if (byteArrayInputStream == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/ex/temp/TempFileSystem.getInputStream must not return null");
        }
        return byteArrayInputStream;
    }

    @NotNull
    public OutputStream getOutputStream(final VirtualFile file, Object requestor, final long modStamp, long timeStamp) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                FSItem fsItem = TempFileSystem.this.convert(file);
                assert (fsItem instanceof FSFile);
                FSFile.access$202((FSFile)fsItem, this.toByteArray());
                TempFileSystem.this.setTimeStamp(file, modStamp);
            }
        };
        if (byteArrayOutputStream == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/ex/temp/TempFileSystem.getOutputStream must not return null");
        }
        return byteArrayOutputStream;
    }

    public long getLength(VirtualFile file) {
        try {
            return this.contentsToByteArray(file).length;
        }
        catch (IOException e) {
            return 0L;
        }
    }

    private static class FSFile
    extends FSItem {
        private byte[] myContent = new byte[0];

        public FSFile(FSDir parent, String name) {
            super(parent, name);
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        static /* synthetic */ byte[] access$202(FSFile x0, byte[] x1) {
            x0.myContent = x1;
            return x1;
        }
    }

    private static class FSDir
    extends FSItem {
        private final List<FSItem> myChildren = new ArrayList<FSItem>();

        public FSDir(FSDir parent, String name) {
            super(parent, name);
        }

        @Override
        @Nullable
        public FSItem findChild(String name) {
            for (FSItem child : this.myChildren) {
                if (!name.equals(child.myName)) continue;
                return child;
            }
            return null;
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        public void addChild(FSItem item) {
            this.myChildren.add(item);
        }

        public void removeChild(FSItem fsItem) {
            if (fsItem.myName.equals("src") && this.getParent() == null) {
                throw new RuntimeException("removing src directory");
            }
            this.myChildren.remove(fsItem);
        }

        @Override
        public String[] list() {
            String[] names = ArrayUtil.newStringArray((int)this.myChildren.size());
            for (int i = 0; i < names.length; ++i) {
                names[i] = this.myChildren.get(i).myName;
            }
            return names;
        }
    }

    private static abstract class FSItem {
        private final FSDir myParent;
        private String myName;
        private long myTimestamp;
        private boolean myWritable;

        protected FSItem(FSDir parent, String name) {
            this.myParent = parent;
            this.myName = name;
            this.myTimestamp = LocalTimeCounter.currentTime();
            this.myWritable = true;
        }

        public abstract boolean isDirectory();

        @Nullable
        public FSItem findChild(String name) {
            return null;
        }

        public void setName(String name) {
            this.myName = name;
        }

        public FSDir getParent() {
            return this.myParent;
        }

        public String[] list() {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
    }
}

