/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import javax.swing.SwingUtilities;

public class RefreshProgress
extends ProgressIndicatorBase {
    private final String myMessage;

    public RefreshProgress(String message) {
        this.myMessage = message;
    }

    @Override
    public void start() {
        super.start();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ApplicationManager.getApplication().isDisposed()) {
                    return;
                }
                WindowManager windowManager = WindowManager.getInstance();
                if (windowManager == null) {
                    return;
                }
                Project[] projects = ProjectManager.getInstance().getOpenProjects();
                if (projects.length == 0) {
                    projects = new Project[]{null};
                }
                for (Project project : projects) {
                    StatusBarEx statusBar = (StatusBarEx)windowManager.getStatusBar(project);
                    if (statusBar == null) continue;
                    statusBar.startRefreshIndication(RefreshProgress.this.myMessage);
                }
            }
        });
    }

    @Override
    public void stop() {
        super.stop();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ApplicationManager.getApplication().isDisposed()) {
                    return;
                }
                WindowManager windowManager = WindowManager.getInstance();
                if (windowManager == null) {
                    return;
                }
                Project[] projects = ProjectManager.getInstance().getOpenProjects();
                if (projects.length == 0) {
                    projects = new Project[]{null};
                }
                for (Project project : projects) {
                    StatusBarEx statusBar = (StatusBarEx)windowManager.getStatusBar(project);
                    if (statusBar == null) continue;
                    statusBar.stopRefreshIndication();
                }
            }
        });
    }
}

