/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.WindowInfo;
import java.awt.Rectangle;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class WindowInfoImpl
implements Cloneable,
JDOMExternalizable,
WindowInfo {
    @NonNls
    static final String TAG = "window_info";
    static final float DEFAULT_WEIGHT = 0.33f;
    static final float DEFAULT_SIDE_WEIGHT = 0.5f;
    private boolean myActive = false;
    private ToolWindowAnchor myAnchor;
    private boolean myAutoHide = false;
    private Rectangle myFloatingBounds = null;
    private String myId;
    private ToolWindowType myInternalType;
    private ToolWindowType myType;
    private boolean myVisible;
    private float myWeight;
    private float mySideWeight;
    private boolean mySplitMode;
    private ToolWindowContentUiType myContentUiType = ToolWindowContentUiType.TABBED;
    private int myOrder;
    @NonNls
    static final String ID_ATTR = "id";
    @NonNls
    static final String ACTIVE_ATTR = "active";
    @NonNls
    static final String ANCHOR_ATTR = "anchor";
    @NonNls
    static final String AUTOHIDE_ATTR = "auto_hide";
    @NonNls
    static final String INTERNAL_TYPE_ATTR = "internal_type";
    @NonNls
    static final String TYPE_ATTR = "type";
    @NonNls
    static final String VISIBLE_ATTR = "visible";
    @NonNls
    static final String WEIGHT_ATTR = "weight";
    @NonNls
    static final String SIDE_WEIGHT_ATTR = "sideWeight";
    @NonNls
    static final String ORDER_ATTR = "order";
    @NonNls
    static final String X_ATTR = "x";
    @NonNls
    static final String Y_ATTR = "y";
    @NonNls
    static final String WIDTH_ATTR = "width";
    @NonNls
    static final String HEIGHT_ATTR = "height";
    @NonNls
    static final String SIDE_TOOL_ATTR = "side_tool";
    @NonNls
    static final String CONTENT_UI_ATTR = "content_ui";
    private boolean myWasRead;

    WindowInfoImpl(String id) {
        this.myAnchor = ToolWindowAnchor.LEFT;
        this.myId = id;
        this.setType(ToolWindowType.DOCKED);
        this.myVisible = false;
        this.myWeight = 0.33f;
        this.mySideWeight = 0.5f;
        this.myOrder = -1;
        this.mySplitMode = false;
    }

    public WindowInfoImpl copy() {
        WindowInfoImpl info = null;
        try {
            info = (WindowInfoImpl)this.clone();
            if (this.myFloatingBounds != null) {
                info.myFloatingBounds = (Rectangle)this.myFloatingBounds.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return info;
    }

    void copyFrom(WindowInfoImpl info) {
        this.myActive = info.myActive;
        this.myAnchor = info.myAnchor;
        this.myAutoHide = info.myAutoHide;
        this.myFloatingBounds = info.myFloatingBounds == null ? null : (Rectangle)info.myFloatingBounds.clone();
        this.myId = info.myId;
        this.myType = info.myType;
        this.myInternalType = info.myInternalType;
        this.myVisible = info.myVisible;
        this.myWeight = info.myWeight;
        this.mySideWeight = info.mySideWeight;
        this.myOrder = info.myOrder;
        this.mySplitMode = info.mySplitMode;
    }

    public ToolWindowAnchor getAnchor() {
        return this.myAnchor;
    }

    public ToolWindowContentUiType getContentUiType() {
        return this.myContentUiType;
    }

    void setContentUiType(ToolWindowContentUiType type) {
        this.myContentUiType = type;
    }

    public Rectangle getFloatingBounds() {
        return this.myFloatingBounds;
    }

    String getId() {
        return this.myId;
    }

    ToolWindowType getInternalType() {
        return this.myInternalType;
    }

    public ToolWindowType getType() {
        return this.myType;
    }

    float getWeight() {
        return this.myWeight;
    }

    float getSideWeight() {
        return this.mySideWeight;
    }

    public int getOrder() {
        return this.myOrder;
    }

    public void setOrder(int order) {
        this.myOrder = order;
    }

    public boolean isActive() {
        return this.myActive;
    }

    public boolean isAutoHide() {
        return this.myAutoHide;
    }

    public boolean isDocked() {
        return ToolWindowType.DOCKED == this.myType;
    }

    public boolean isFloating() {
        return ToolWindowType.FLOATING == this.myType;
    }

    public boolean isSliding() {
        return ToolWindowType.SLIDING == this.myType;
    }

    boolean isVisible() {
        return this.myVisible;
    }

    public boolean isSplit() {
        return this.mySplitMode;
    }

    public void setSplit(boolean sideTool) {
        this.mySplitMode = sideTool;
    }

    private static ToolWindowType parseToolWindowType(String text) {
        if (ToolWindowType.DOCKED.toString().equals(text)) {
            return ToolWindowType.DOCKED;
        }
        if (ToolWindowType.FLOATING.toString().equals(text)) {
            return ToolWindowType.FLOATING;
        }
        if (ToolWindowType.SLIDING.toString().equals(text)) {
            return ToolWindowType.SLIDING;
        }
        throw new IllegalArgumentException();
    }

    private static ToolWindowAnchor parseToolWindowAnchor(String text) {
        if (ToolWindowAnchor.TOP.toString().equals(text)) {
            return ToolWindowAnchor.TOP;
        }
        if (ToolWindowAnchor.LEFT.toString().equals(text)) {
            return ToolWindowAnchor.LEFT;
        }
        if (ToolWindowAnchor.BOTTOM.toString().equals(text)) {
            return ToolWindowAnchor.BOTTOM;
        }
        if (ToolWindowAnchor.RIGHT.toString().equals(text)) {
            return ToolWindowAnchor.RIGHT;
        }
        throw new IllegalArgumentException();
    }

    public void readExternal(Element element) {
        this.myId = element.getAttributeValue(ID_ATTR);
        this.myWasRead = true;
        try {
            this.myActive = Boolean.valueOf(element.getAttributeValue(ACTIVE_ATTR));
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        try {
            this.myAnchor = WindowInfoImpl.parseToolWindowAnchor(element.getAttributeValue(ANCHOR_ATTR));
        }
        catch (IllegalArgumentException ignored) {
            // empty catch block
        }
        this.myAutoHide = Boolean.valueOf(element.getAttributeValue(AUTOHIDE_ATTR));
        try {
            this.myInternalType = WindowInfoImpl.parseToolWindowType(element.getAttributeValue(INTERNAL_TYPE_ATTR));
        }
        catch (IllegalArgumentException ignored) {
            // empty catch block
        }
        try {
            this.myType = WindowInfoImpl.parseToolWindowType(element.getAttributeValue(TYPE_ATTR));
        }
        catch (IllegalArgumentException ignored) {
            // empty catch block
        }
        this.myVisible = Boolean.valueOf(element.getAttributeValue(VISIBLE_ATTR));
        try {
            this.myWeight = Float.parseFloat(element.getAttributeValue(WEIGHT_ATTR));
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        try {
            String value = element.getAttributeValue(SIDE_WEIGHT_ATTR);
            if (value != null) {
                this.mySideWeight = Float.parseFloat(value);
            }
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        try {
            this.myOrder = Integer.valueOf(element.getAttributeValue(ORDER_ATTR));
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        try {
            int x = Integer.parseInt(element.getAttributeValue(X_ATTR));
            int y = Integer.parseInt(element.getAttributeValue(Y_ATTR));
            int width = Integer.parseInt(element.getAttributeValue(WIDTH_ATTR));
            int height = Integer.parseInt(element.getAttributeValue(HEIGHT_ATTR));
            this.myFloatingBounds = new Rectangle(x, y, width, height);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.mySplitMode = Boolean.parseBoolean(element.getAttributeValue(SIDE_TOOL_ATTR));
        this.myContentUiType = ToolWindowContentUiType.getInstance((String)element.getAttributeValue(CONTENT_UI_ATTR));
    }

    void setAnchor(@NotNull ToolWindowAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/WindowInfoImpl.setAnchor must not be null");
        }
        this.myAnchor = anchor;
    }

    void setActive(boolean active) {
        this.myActive = active;
    }

    void setAutoHide(boolean autoHide) {
        this.myAutoHide = autoHide;
    }

    void setFloatingBounds(Rectangle floatingBounds) {
        this.myFloatingBounds = floatingBounds;
    }

    void setType(@NotNull ToolWindowType type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/WindowInfoImpl.setType must not be null");
        }
        if (ToolWindowType.DOCKED == type || ToolWindowType.SLIDING == type) {
            this.myInternalType = type;
        }
        this.myType = type;
    }

    void setVisible(boolean visible) {
        this.myVisible = visible;
    }

    void setWeight(float weight) {
        if (weight < 0.0f) {
            weight = 0.0f;
        } else if (weight > 1.0f) {
            weight = 1.0f;
        }
        this.myWeight = weight;
    }

    void setSideWeight(float weight) {
        if (weight < 0.0f) {
            weight = 0.0f;
        } else if (weight > 1.0f) {
            weight = 1.0f;
        }
        this.mySideWeight = weight;
    }

    public void writeExternal(Element element) {
        element.setAttribute(ID_ATTR, this.myId);
        element.setAttribute(ACTIVE_ATTR, this.myActive ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        element.setAttribute(ANCHOR_ATTR, this.myAnchor.toString());
        element.setAttribute(AUTOHIDE_ATTR, this.myAutoHide ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        element.setAttribute(INTERNAL_TYPE_ATTR, this.myInternalType.toString());
        element.setAttribute(TYPE_ATTR, this.myType.toString());
        element.setAttribute(VISIBLE_ATTR, this.myVisible ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        element.setAttribute(WEIGHT_ATTR, Float.toString(this.myWeight));
        element.setAttribute(SIDE_WEIGHT_ATTR, Float.toString(this.mySideWeight));
        element.setAttribute(ORDER_ATTR, Integer.toString(this.myOrder));
        element.setAttribute(SIDE_TOOL_ATTR, Boolean.toString(this.mySplitMode));
        element.setAttribute(CONTENT_UI_ATTR, this.myContentUiType.getName());
        if (this.myFloatingBounds != null) {
            element.setAttribute(X_ATTR, Integer.toString(this.myFloatingBounds.x));
            element.setAttribute(Y_ATTR, Integer.toString(this.myFloatingBounds.y));
            element.setAttribute(WIDTH_ATTR, Integer.toString(this.myFloatingBounds.width));
            element.setAttribute(HEIGHT_ATTR, Integer.toString(this.myFloatingBounds.height));
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WindowInfoImpl)) {
            return false;
        }
        WindowInfoImpl info = (WindowInfoImpl)obj;
        return this.myActive == info.myActive && this.myAnchor == info.myAnchor && this.myId.equals(info.myId) && this.myAutoHide == info.myAutoHide && Comparing.equal((Object)this.myFloatingBounds, (Object)info.myFloatingBounds) && this.myInternalType == info.myInternalType && this.myType == info.myType && this.myVisible == info.myVisible && this.myWeight == info.myWeight && this.mySideWeight == info.mySideWeight && this.myOrder == info.myOrder && this.mySplitMode == info.mySplitMode && this.myContentUiType == info.myContentUiType;
    }

    public int hashCode() {
        return this.myAnchor.hashCode() + this.myId.hashCode() + this.myType.hashCode() + this.myOrder;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getName()).append('[');
        buffer.append("myId=").append(this.myId).append("; ");
        buffer.append("myVisible=").append(this.myVisible).append("; ");
        buffer.append("myActive=").append(this.myActive).append("; ");
        buffer.append("myAnchor=").append(this.myAnchor).append("; ");
        buffer.append("myOrder=").append(this.myOrder).append("; ");
        buffer.append("myAutoHide=").append(this.myAutoHide).append("; ");
        buffer.append("myWeight=").append(this.myWeight).append("; ");
        buffer.append("mySideWeight=").append(this.mySideWeight).append("; ");
        buffer.append("myType=").append(this.myType).append("; ");
        buffer.append("myInternalType=").append(this.myInternalType).append("; ");
        buffer.append("myFloatingBounds=").append(this.myFloatingBounds).append("; ");
        buffer.append("mySplitMode=").append(this.mySplitMode);
        buffer.append(']');
        return buffer.toString();
    }

    public boolean wasRead() {
        return this.myWasRead;
    }
}

