/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.commands;

import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.impl.FloatingDecorator;
import com.intellij.openapi.wm.impl.commands.FinalizableCommand;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public final class RequestFocusInEditorComponentCmd
extends FinalizableCommand {
    private final FileEditorManagerEx myEditorManager;
    private final JComponent myComponent;
    private final boolean myForced;
    private final ActionCallback myDoneCallback;
    private IdeFocusManager myFocusManager;
    private Expirable myTimestamp;

    public RequestFocusInEditorComponentCmd(@NotNull FileEditorManagerEx editorManager, IdeFocusManager focusManager, Runnable finishCallBack, boolean forced) {
        if (editorManager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/commands/RequestFocusInEditorComponentCmd.<init> must not be null");
        }
        super(finishCallBack);
        this.myEditorManager = editorManager;
        this.myComponent = this.myEditorManager.getPreferredFocusedComponent();
        this.myForced = forced;
        this.myFocusManager = focusManager;
        this.myDoneCallback = new ActionCallback();
        this.myTimestamp = this.myFocusManager.getTimestamp(true);
    }

    public ActionCallback getDoneCallback() {
        return this.myDoneCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        try {
            Component owner;
            if (this.myTimestamp.isExpired()) {
                owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                if (owner != null && owner == this.myComponent) {
                    this.myDoneCallback.setDone();
                } else {
                    this.myDoneCallback.setRejected();
                }
            }
            if ((owner = SwingUtilities.getWindowAncestor(this.myEditorManager.getComponent())) == null) {
                return;
            }
            if (this.myComponent != null) {
                this.myFocusManager.requestFocus((Component)this.myComponent, this.myForced).notifyWhenDone(this.myDoneCallback).doWhenDone(new Runnable((Window)owner){
                    final /* synthetic */ Window val$owner;
                    {
                        this.val$owner = window;
                    }

                    @Override
                    public void run() {
                        Window activeWindow;
                        if (!this.val$owner.isActive() && ((activeWindow = RequestFocusInEditorComponentCmd.this.getActiveWindow(this.val$owner.getOwnedWindows())) == null || activeWindow instanceof FloatingDecorator)) {
                            this.val$owner.toFront();
                        }
                    }
                });
            } else {
                this.myDoneCallback.setRejected();
            }
        }
        finally {
            this.finish();
        }
    }

    private Window getActiveWindow(Window[] windows) {
        for (int i = 0; i < windows.length; ++i) {
            Window window = windows[i];
            if (window.isShowing() && window.isActive()) {
                return window;
            }
            if ((window = this.getActiveWindow(window.getOwnedWindows())) == null) continue;
            return window;
        }
        return null;
    }
}

