/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.references;

import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomReference;
import com.intellij.pom.references.PomReferenceUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.ResolveResult;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PomPsiReference
extends PomReference {
    private final PsiReference myDelegate;

    public PomPsiReference(PsiReference delegate) {
        super(delegate.getElement(), delegate.getRangeInElement());
        this.myDelegate = delegate;
    }

    @Nullable
    public PomTarget resolve() {
        PsiElement element = this.myDelegate.resolve();
        return element == null ? null : PomReferenceUtil.convertPsi2Target((PsiElement)element);
    }

    public PsiReference getDelegate() {
        return this.myDelegate;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PomTarget[] multiResolve() {
        PomTarget[] pomTargetArray;
        PomTarget[] pomTargetArray2;
        if (this.myDelegate instanceof PsiPolyVariantReference) {
            PsiPolyVariantReference reference = (PsiPolyVariantReference)this.myDelegate;
            List list = ContainerUtil.mapNotNull((Object[])reference.multiResolve(false), (Function)new NullableFunction<ResolveResult, PomTarget>(){

                public PomTarget fun(ResolveResult resolveResult) {
                    PsiElement element = resolveResult.getElement();
                    if (element == null) {
                        return null;
                    }
                    return PomReferenceUtil.convertPsi2Target((PsiElement)element);
                }
            });
            pomTargetArray2 = list.toArray(new PomTarget[list.size()]);
            if (pomTargetArray2 == null) throw new IllegalStateException("@NotNull method com/intellij/pom/references/PomPsiReference.multiResolve must not return null");
            return pomTargetArray2;
        }
        PomTarget target = this.resolve();
        if (target == null) {
            pomTargetArray = PomTarget.EMPTY_ARRAY;
        } else {
            PomTarget[] pomTargetArray3 = new PomTarget[1];
            pomTargetArray = pomTargetArray3;
            pomTargetArray3[0] = target;
        }
        pomTargetArray2 = pomTargetArray;
        if (pomTargetArray != null) return pomTargetArray2;
        throw new IllegalStateException("@NotNull method com/intellij/pom/references/PomPsiReference.multiResolve must not return null");
    }

    public void bindToElement(@NotNull PomTarget target) throws IncorrectOperationException {
        if (target == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/pom/references/PomPsiReference.bindToElement must not be null");
        }
        this.myDelegate.bindToElement(((PsiTarget)target).getNavigationElement());
    }

    public boolean isReferenceTo(@NotNull PomTarget target) {
        if (target == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/pom/references/PomPsiReference.isReferenceTo must not be null");
        }
        return this.myDelegate.isReferenceTo(((PsiTarget)target).getNavigationElement());
    }

    @NotNull
    public LookupElement[] getVariants() {
        LookupElement[] lookupElementArray = (LookupElement[])ContainerUtil.map2Array((Object[])this.myDelegate.getVariants(), LookupElement.class, (Function)new Function<Object, LookupElement>(){

            public LookupElement fun(Object o) {
                return CompletionData.objectToLookupItem(o);
            }
        });
        if (lookupElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/pom/references/PomPsiReference.getVariants must not return null");
        }
        return lookupElementArray;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PomPsiReference that = (PomPsiReference)((Object)o);
        return this.myDelegate.equals(that.myDelegate);
    }

    public int hashCode() {
        return this.myDelegate.hashCode();
    }
}

