/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.profile.codeInspection.ui.InspectionConfigTreeNode;
import java.util.Comparator;

public class InspectionsConfigTreeComparator
implements Comparator<InspectionConfigTreeNode> {
    @Override
    public int compare(InspectionConfigTreeNode o1, InspectionConfigTreeNode o2) {
        String s1 = null;
        String s2 = null;
        Object userObject1 = o1.getUserObject();
        Object userObject2 = o2.getUserObject();
        if (userObject1 instanceof String && userObject2 instanceof String) {
            s1 = (String)userObject1;
            s2 = (String)userObject2;
        }
        Descriptor descriptor1 = o1.getDesriptor();
        Descriptor descriptor2 = o2.getDesriptor();
        if (descriptor1 != null && descriptor2 != null) {
            s1 = descriptor1.getText();
            s2 = descriptor2.getText();
        }
        if (s1 != null && s2 != null) {
            return InspectionsConfigTreeComparator.getDisplayTextToSort(s1).compareToIgnoreCase(InspectionsConfigTreeComparator.getDisplayTextToSort(s2));
        }
        return -1;
    }

    public static String getDisplayTextToSort(String s) {
        if (s.length() == 0) {
            return s;
        }
        while (!Character.isLetterOrDigit(s.charAt(0))) {
            if ((s = s.substring(1)).length() != 0) continue;
            return s;
        }
        return s;
    }
}

