/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.PsiPackageImpl;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class NonClasspathClassFinder
extends PsiElementFinder {
    protected final Project myProject;

    public NonClasspathClassFinder(Project project) {
        this.myProject = project;
    }

    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/NonClasspathClassFinder.findClass must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/NonClasspathClassFinder.findClass must not be null");
        }
        List<VirtualFile> classRoots = this.getClassRoots();
        if (classRoots.isEmpty()) {
            return null;
        }
        for (VirtualFile classRoot : classRoots) {
            PsiClass[] classes;
            PsiFile file;
            VirtualFile classFile;
            if (!scope.contains(classRoot) || (classFile = classRoot.findFileByRelativePath(qualifiedName.replace('.', '/') + ".class")) == null || !((file = PsiManager.getInstance((Project)this.myProject).findFile(classFile)) instanceof PsiClassOwner) || (classes = ((PsiClassOwner)file).getClasses()).length != 1) continue;
            return classes[0];
        }
        return null;
    }

    protected abstract List<VirtualFile> getClassRoots();

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        PsiClass[] psiClassArray;
        if (psiPackage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/NonClasspathClassFinder.getClasses must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/NonClasspathClassFinder.getClasses must not be null");
        }
        List<VirtualFile> classRoots = this.getClassRoots();
        if (classRoots.isEmpty()) {
            psiClassArray = PsiClass.EMPTY_ARRAY;
            if (PsiClass.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/psi/NonClasspathClassFinder.getClasses must not return null");
            return psiClassArray;
        }
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        for (VirtualFile classRoot : classRoots) {
            String pkgName;
            VirtualFile dir;
            if (!scope.contains(classRoot) || (dir = classRoot.findFileByRelativePath((pkgName = psiPackage.getQualifiedName()).replace('.', '/'))) == null || !dir.isDirectory()) continue;
            for (VirtualFile file : dir.getChildren()) {
                PsiFile psi;
                if (file.isDirectory() || !((psi = PsiManager.getInstance((Project)this.myProject).findFile(file)) instanceof PsiClassOwner)) continue;
                result.addAll(Arrays.asList(((PsiClassOwner)psi).getClasses()));
            }
        }
        psiClassArray = result.toArray(new PsiClass[result.size()]);
        if (psiClassArray != null) return psiClassArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/NonClasspathClassFinder.getClasses must not return null");
    }

    public PsiPackage findPackage(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/NonClasspathClassFinder.findPackage must not be null");
        }
        List<VirtualFile> classRoots = this.getClassRoots();
        if (classRoots.isEmpty()) {
            return null;
        }
        for (VirtualFile classRoot : classRoots) {
            VirtualFile dir = classRoot.findFileByRelativePath(qualifiedName.replace('.', '/'));
            if (dir == null || !dir.isDirectory()) continue;
            return this.createPackage(qualifiedName);
        }
        return null;
    }

    private PsiPackageImpl createPackage(String qualifiedName) {
        return new PsiPackageImpl((PsiManagerEx)PsiManager.getInstance((Project)this.myProject), qualifiedName);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        PsiPackage[] psiPackageArray;
        if (psiPackage == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/NonClasspathClassFinder.getSubPackages must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/NonClasspathClassFinder.getSubPackages must not be null");
        }
        List<VirtualFile> classRoots = this.getClassRoots();
        if (classRoots.isEmpty()) {
            psiPackageArray = super.getSubPackages(psiPackage, scope);
            if (psiPackageArray == null) throw new IllegalStateException("@NotNull method com/intellij/psi/NonClasspathClassFinder.getSubPackages must not return null");
            return psiPackageArray;
        }
        ArrayList<PsiPackageImpl> result = new ArrayList<PsiPackageImpl>();
        for (VirtualFile classRoot : classRoots) {
            String pkgName;
            VirtualFile dir;
            if (!scope.contains(classRoot) || (dir = classRoot.findFileByRelativePath((pkgName = psiPackage.getQualifiedName()).replace('.', '/'))) == null || !dir.isDirectory()) continue;
            for (VirtualFile file : dir.getChildren()) {
                if (!file.isDirectory()) continue;
                result.add(this.createPackage(pkgName + "." + file.getName()));
            }
        }
        psiPackageArray = result.toArray(new PsiPackage[result.size()]);
        if (psiPackageArray != null) return psiPackageArray;
        throw new IllegalStateException("@NotNull method com/intellij/psi/NonClasspathClassFinder.getSubPackages must not return null");
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        PsiClass[] psiClassArray;
        if (qualifiedName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/NonClasspathClassFinder.findClasses must not be null");
        }
        if (scope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/NonClasspathClassFinder.findClasses must not be null");
        }
        PsiClass psiClass = this.findClass(qualifiedName, scope);
        if (psiClass == null) {
            psiClassArray = PsiClass.EMPTY_ARRAY;
        } else {
            PsiClass[] psiClassArray2 = new PsiClass[1];
            psiClassArray = psiClassArray2;
            psiClassArray2[0] = psiClass;
        }
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/NonClasspathClassFinder.findClasses must not return null");
        }
        return psiClassArray;
    }
}

