/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class ClsPrefixExpressionImpl
extends ClsElementImpl
implements PsiPrefixExpression {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.compiled.ClsPrefixExpressionImpl");
    private final ClsElementImpl myParent;
    private final PsiExpression myOperand;
    private final MySign mySign = new MySign();

    public ClsPrefixExpressionImpl(ClsElementImpl parent, PsiExpression operand) {
        this.myParent = parent;
        this.myOperand = operand;
    }

    public PsiExpression getOperand() {
        return this.myOperand;
    }

    @NotNull
    public PsiJavaToken getOperationSign() {
        MySign mySign = this.mySign;
        if (mySign == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsPrefixExpressionImpl.getOperationSign must not return null");
        }
        return mySign;
    }

    @NotNull
    public IElementType getOperationTokenType() {
        IElementType iElementType = this.getOperationSign().getTokenType();
        if (iElementType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsPrefixExpressionImpl.getOperationTokenType must not return null");
        }
        return iElementType;
    }

    public PsiType getType() {
        return this.myOperand.getType();
    }

    public PsiElement getParent() {
        return this.myParent;
    }

    @NotNull
    public PsiElement[] getChildren() {
        PsiElement[] psiElementArray = new PsiElement[]{this.getOperationSign(), this.getOperand()};
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsPrefixExpressionImpl.getChildren must not return null");
        }
        return psiElementArray;
    }

    @Override
    public String getText() {
        return "-" + this.myOperand.getText();
    }

    @Override
    public void appendMirrorText(int indentLevel, StringBuffer buffer) {
        buffer.append(this.getText());
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsPrefixExpressionImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, JavaElementType.PREFIX_EXPRESSION);
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsPrefixExpressionImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitPrefixExpression((PsiPrefixExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiPrefixExpression:" + this.getText();
    }

    private class MySign
    extends ClsElementImpl
    implements PsiJavaToken {
        private MySign() {
        }

        public IElementType getTokenType() {
            return JavaTokenType.MINUS;
        }

        @NotNull
        public PsiElement[] getChildren() {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsPrefixExpressionImpl$MySign.getChildren must not return null");
            }
            return EMPTY_ARRAY;
        }

        public PsiElement getParent() {
            return ClsPrefixExpressionImpl.this;
        }

        @Override
        public void appendMirrorText(int indentLevel, StringBuffer buffer) {
            buffer.append("-");
        }

        @Override
        public void setMirror(@NotNull TreeElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsPrefixExpressionImpl$MySign.setMirror must not be null");
            }
            this.setMirrorCheckingType(element, JavaTokenType.MINUS);
        }

        public void accept(@NotNull PsiElementVisitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsPrefixExpressionImpl$MySign.accept must not be null");
            }
            if (visitor instanceof JavaElementVisitor) {
                ((JavaElementVisitor)visitor).visitJavaToken((PsiJavaToken)this);
            } else {
                visitor.visitElement((PsiElement)this);
            }
        }
    }
}

