/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.ide.util.EditSourceUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiElementBase;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.file.PsiBinaryFileImpl;
import com.intellij.psi.impl.file.UpdateAddedFileProcessor;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiFileSystemItemProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Icons;
import com.intellij.util.IncorrectOperationException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiDirectoryImpl
extends PsiElementBase
implements PsiDirectory,
Queryable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.file.PsiDirectoryImpl");
    private final PsiManagerImpl myManager;
    private final VirtualFile myFile;

    public PsiDirectoryImpl(PsiManagerImpl manager, VirtualFile file) {
        this.myManager = manager;
        this.myFile = file;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiDirectoryImpl.getVirtualFile must not return null");
        }
        return virtualFile;
    }

    public boolean isDirectory() {
        return true;
    }

    public boolean isValid() {
        return this.myFile.isValid();
    }

    @NotNull
    public Language getLanguage() {
        Language language = Language.ANY;
        if (language == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiDirectoryImpl.getLanguage must not return null");
        }
        return language;
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    @NotNull
    public String getName() {
        String string = this.myFile.getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiDirectoryImpl.getName must not return null");
        }
        return string;
    }

    @NotNull
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.setName must not be null");
        }
        this.checkSetName(name);
        try {
            this.myFile.rename((Object)this.myManager, name);
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e.toString());
        }
        PsiDirectoryImpl psiDirectoryImpl = this;
        if (psiDirectoryImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiDirectoryImpl.setName must not return null");
        }
        return psiDirectoryImpl;
    }

    public void checkSetName(String name) throws IncorrectOperationException {
        CheckUtil.checkWritable(this);
        VirtualFile parentFile = this.myFile.getParent();
        if (parentFile == null) {
            throw new IncorrectOperationException(VfsBundle.message((String)"cannot.rename.root.directory", (Object[])new Object[0]));
        }
        VirtualFile child = parentFile.findChild(name);
        if (child != null && !child.equals(this.myFile)) {
            throw new IncorrectOperationException(VfsBundle.message((String)"file.already.exists.error", (Object[])new Object[]{child.getPresentableUrl()}));
        }
    }

    public PsiDirectory getParentDirectory() {
        VirtualFile parentFile = this.myFile.getParent();
        if (parentFile == null) {
            return null;
        }
        return this.myManager.findDirectory(parentFile);
    }

    @NotNull
    public PsiDirectory[] getSubdirectories() {
        VirtualFile[] files = this.myFile.getChildren();
        ArrayList<PsiDirectory> dirs = new ArrayList<PsiDirectory>();
        for (VirtualFile file : files) {
            PsiDirectory dir = this.myManager.findDirectory(file);
            if (dir == null) continue;
            dirs.add(dir);
        }
        PsiDirectory[] psiDirectoryArray = dirs.toArray(new PsiDirectory[dirs.size()]);
        if (psiDirectoryArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiDirectoryImpl.getSubdirectories must not return null");
        }
        return psiDirectoryArray;
    }

    @NotNull
    public PsiFile[] getFiles() {
        LOG.assertTrue(this.myFile.isValid());
        VirtualFile[] files = this.myFile.getChildren();
        ArrayList<PsiFile> psiFiles = new ArrayList<PsiFile>();
        for (VirtualFile file : files) {
            PsiFile psiFile = this.myManager.findFile(file);
            if (psiFile == null) continue;
            psiFiles.add(psiFile);
        }
        PsiFile[] psiFileArray = psiFiles.toArray(new PsiFile[psiFiles.size()]);
        if (psiFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiDirectoryImpl.getFiles must not return null");
        }
        return psiFileArray;
    }

    public PsiDirectory findSubdirectory(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.findSubdirectory must not be null");
        }
        VirtualFile childVFile = this.myFile.findChild(name);
        if (childVFile == null) {
            return null;
        }
        return this.myManager.findDirectory(childVFile);
    }

    public PsiFile findFile(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.findFile must not be null");
        }
        VirtualFile childVFile = this.myFile.findChild(name);
        if (childVFile == null) {
            return null;
        }
        return this.myManager.findFile(childVFile);
    }

    public boolean processChildren(PsiElementProcessor<PsiFileSystemItem> processor) {
        this.checkValid();
        ProgressManager.checkCanceled();
        for (VirtualFile vFile : this.myFile.getChildren()) {
            PsiFile file;
            PsiDirectory dir;
            if (processor instanceof PsiFileSystemItemProcessor && !((PsiFileSystemItemProcessor)processor).acceptItem(vFile.getName(), vFile.isDirectory()) || !(vFile.isDirectory() ? (dir = this.myManager.findDirectory(vFile)) != null && !processor.execute((PsiElement)dir) : (file = this.myManager.findFile(vFile)) != null && !processor.execute((PsiElement)file))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public PsiElement[] getChildren() {
        this.checkValid();
        VirtualFile[] files = this.myFile.getChildren();
        final ArrayList children = new ArrayList(files.length);
        this.processChildren(new PsiElementProcessor<PsiFileSystemItem>(){

            public boolean execute(PsiFileSystemItem element) {
                children.add(element);
                return true;
            }
        });
        PsiElement[] psiElementArray = children.toArray(new PsiElement[children.size()]);
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiDirectoryImpl.getChildren must not return null");
        }
        return psiElementArray;
    }

    private void checkValid() {
        if (!this.isValid()) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
    }

    public PsiDirectory getParent() {
        return this.getParentDirectory();
    }

    public PsiFile getContainingFile() {
        return null;
    }

    public TextRange getTextRange() {
        return null;
    }

    public int getStartOffsetInParent() {
        return -1;
    }

    public int getTextLength() {
        return -1;
    }

    public PsiElement findElementAt(int offset) {
        return null;
    }

    public int getTextOffset() {
        return -1;
    }

    public String getText() {
        return "";
    }

    @NotNull
    public char[] textToCharArray() {
        if (ArrayUtil.EMPTY_CHAR_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiDirectoryImpl.textToCharArray must not return null");
        }
        return ArrayUtil.EMPTY_CHAR_ARRAY;
    }

    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.textMatches must not be null");
        }
        return false;
    }

    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.textMatches must not be null");
        }
        return false;
    }

    public final boolean isWritable() {
        return this.myFile.isWritable();
    }

    public boolean isPhysical() {
        return !(this.myFile.getFileSystem() instanceof DummyFileSystem) && !(this.myFile.getFileSystem() instanceof TempFileSystem);
    }

    public PsiElement copy() {
        LOG.error("not implemented");
        return null;
    }

    @NotNull
    public PsiDirectory createSubdirectory(@NotNull String name) throws IncorrectOperationException {
        PsiDirectory psiDirectory;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.createSubdirectory must not be null");
        }
        this.checkCreateSubdirectory(name);
        try {
            VirtualFile file = this.getVirtualFile().createChildDirectory((Object)this.myManager, name);
            PsiDirectory directory = this.myManager.findDirectory(file);
            if (directory == null) {
                throw new IncorrectOperationException("Cannot find directory in '" + file.getPresentableUrl() + "'");
            }
            psiDirectory = directory;
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e.toString());
        }
        if (psiDirectory == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiDirectoryImpl.createSubdirectory must not return null");
        }
        return psiDirectory;
    }

    public void checkCreateSubdirectory(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.checkCreateSubdirectory must not be null");
        }
        VirtualFile existingFile = this.getVirtualFile().findChild(name);
        if (existingFile != null) {
            throw new IncorrectOperationException(VfsBundle.message((String)"file.already.exists.error", (Object[])new Object[]{existingFile.getPresentableUrl()}));
        }
        CheckUtil.checkWritable(this);
    }

    @NotNull
    public PsiFile createFile(@NotNull String name) throws IncorrectOperationException {
        PsiFile psiFile;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.createFile must not be null");
        }
        this.checkCreateFile(name);
        try {
            VirtualFile vFile = this.getVirtualFile().createChildData((Object)this.myManager, name);
            psiFile = this.myManager.findFile(vFile);
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e.toString());
        }
        if (psiFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiDirectoryImpl.createFile must not return null");
        }
        return psiFile;
    }

    @NotNull
    public PsiFile copyFileFrom(@NotNull String newName, @NotNull PsiFile originalFile) throws IncorrectOperationException {
        PsiFile psiFile;
        if (newName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.copyFileFrom must not be null");
        }
        if (originalFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.copyFileFrom must not be null");
        }
        this.checkCreateFile(newName);
        Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(originalFile);
        if (document != null) {
            FileDocumentManager.getInstance().saveDocument(document);
        }
        VirtualFile parent = this.getVirtualFile();
        try {
            VirtualFile vFile = originalFile.getVirtualFile();
            if (vFile == null) {
                throw new IncorrectOperationException("Cannot copy nonphysical file");
            }
            VirtualFile copyVFile = parent.getFileSystem() == vFile.getFileSystem() ? vFile.copy((Object)this, parent, newName) : VfsUtil.copyFile((Object)((Object)this), (VirtualFile)vFile, (VirtualFile)parent, (String)newName);
            PsiFile copyPsi = this.myManager.findFile(copyVFile);
            if (copyPsi == null) {
                LOG.error("Could not find file '" + copyVFile + "' after copying '" + vFile + "'");
            }
            PsiDirectoryImpl.updateAddedFile(copyPsi);
            psiFile = copyPsi;
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e.toString(), (Exception)e);
        }
        if (psiFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/file/PsiDirectoryImpl.copyFileFrom must not return null");
        }
        return psiFile;
    }

    private static void updateAddedFile(PsiFile copyPsi) throws IncorrectOperationException {
        UpdateAddedFileProcessor processor = UpdateAddedFileProcessor.forElement(copyPsi);
        if (processor != null) {
            TreeElement tree = (TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)copyPsi);
            if (tree != null) {
                ChangeUtil.encodeInformation(tree);
            }
            processor.update(copyPsi, null);
            if (tree != null) {
                ChangeUtil.decodeInformation(tree);
            }
        }
    }

    public void checkCreateFile(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.checkCreateFile must not be null");
        }
        VirtualFile existingFile = this.getVirtualFile().findChild(name);
        if (existingFile != null) {
            throw new IncorrectOperationException(VfsBundle.message((String)"file.already.exists.error", (Object[])new Object[]{existingFile.getPresentableUrl()}));
        }
        CheckUtil.checkWritable(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.add must not be null");
        }
        this.checkAdd(element);
        if (element instanceof PsiDirectory) {
            LOG.error("not implemented");
            return null;
        }
        if (element instanceof PsiFile) {
            PsiFile originalFile = (PsiFile)element;
            try {
                VirtualFile newVFile;
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.myManager.getProject());
                if (originalFile instanceof PsiFileImpl) {
                    newVFile = this.myFile.createChildData((Object)this.myManager, originalFile.getName());
                    String text = originalFile.getText();
                    PsiFile psiFile = this.getManager().findFile(newVFile);
                    Document document = psiFile == null ? null : psiDocumentManager.getDocument(psiFile);
                    FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
                    if (document != null) {
                        document.setText((CharSequence)text);
                        fileDocumentManager.saveDocument(document);
                    } else {
                        String lineSeparator = fileDocumentManager.getLineSeparator(newVFile, this.getProject());
                        if (!lineSeparator.equals("\n")) {
                            text = StringUtil.convertLineSeparators((String)text, (String)lineSeparator);
                        }
                        Writer writer = LoadTextUtil.getWriter(this.getProject(), newVFile, (Object)this.myManager, text, -1L);
                        try {
                            writer.write(text);
                        }
                        finally {
                            writer.close();
                        }
                    }
                } else {
                    byte[] storedContents = ((PsiBinaryFileImpl)originalFile).getStoredContents();
                    if (storedContents != null) {
                        newVFile = this.myFile.createChildData((Object)this.myManager, originalFile.getName());
                        newVFile.setBinaryContent(storedContents);
                    } else {
                        newVFile = VfsUtil.copyFile(null, (VirtualFile)originalFile.getVirtualFile(), (VirtualFile)this.myFile);
                    }
                }
                psiDocumentManager.commitAllDocuments();
                PsiFile newFile = this.myManager.findFile(newVFile);
                PsiDirectoryImpl.updateAddedFile(newFile);
                return newFile;
            }
            catch (IOException e) {
                throw new IncorrectOperationException(e.toString(), (Exception)e);
            }
        }
        LOG.assertTrue(false);
        return null;
    }

    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.checkAdd must not be null");
        }
        CheckUtil.checkWritable(this);
        if (element instanceof PsiDirectory) {
            PsiDirectory[] subpackages;
            String name = ((PsiDirectory)element).getName();
            for (PsiDirectory dir : subpackages = this.getSubdirectories()) {
                if (!Comparing.strEqual((String)dir.getName(), (String)name)) continue;
                throw new IncorrectOperationException(VfsBundle.message((String)"dir.already.exists.error", (Object[])new Object[]{dir.getVirtualFile().getPresentableUrl()}));
            }
        } else if (element instanceof PsiFile) {
            PsiFile[] files;
            String name = ((PsiFile)element).getName();
            for (PsiFile file : files = this.getFiles()) {
                if (!Comparing.strEqual((String)file.getName(), (String)name, (boolean)SystemInfo.isFileSystemCaseSensitive)) continue;
                throw new IncorrectOperationException(VfsBundle.message((String)"file.already.exists.error", (Object[])new Object[]{file.getVirtualFile().getPresentableUrl()}));
            }
        } else {
            throw new IncorrectOperationException();
        }
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.addBefore must not be null");
        }
        throw new IncorrectOperationException();
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.addAfter must not be null");
        }
        throw new IncorrectOperationException();
    }

    public void delete() throws IncorrectOperationException {
        this.checkDelete();
        try {
            this.myFile.delete((Object)this.myManager);
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e.toString(), (Exception)e);
        }
    }

    public void checkDelete() throws IncorrectOperationException {
        CheckUtil.checkDelete(this.myFile);
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.replace must not be null");
        }
        LOG.error("not implemented");
        return null;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/file/PsiDirectoryImpl.accept must not be null");
        }
        visitor.visitDirectory((PsiDirectory)this);
    }

    public String toString() {
        return "PsiDirectory:" + this.myFile.getPresentableUrl();
    }

    public ASTNode getNode() {
        return null;
    }

    @Override
    public boolean canNavigate() {
        return EditSourceUtil.canNavigate((PsiElement)this);
    }

    @Override
    public boolean canNavigateToSource() {
        return false;
    }

    @Override
    public void navigate(boolean requestFocus) {
    }

    @Override
    public FileStatus getFileStatus() {
        return this.myFile != null ? FileStatusManager.getInstance((Project)this.getProject()).getStatus(this.myFile) : FileStatus.NOT_CHANGED;
    }

    protected Icon getElementIcon(int flags) {
        return Icons.DIRECTORY_CLOSED_ICON;
    }

    public void putInfo(Map<String, String> info) {
        info.put("fileName", this.getName());
    }
}

