/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.include;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.psi.impl.include.FileIncludeInfoImpl;
import com.intellij.psi.impl.include.FileIncludeProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FileIncludeIndex
extends FileBasedIndexExtension<Key, List<FileIncludeInfoImpl>> {
    private final FileIncludeProvider[] myProviders = (FileIncludeProvider[])Extensions.getExtensions(FileIncludeProvider.EP_NAME);
    public static final ID<Key, List<FileIncludeInfoImpl>> INDEX_ID = ID.create((String)"fileIncludes");

    public static List<FileIncludeInfoImpl> getIncludes(VirtualFile file, GlobalSearchScope scope) {
        final ArrayList<FileIncludeInfoImpl> result = new ArrayList<FileIncludeInfoImpl>();
        FileBasedIndex.getInstance().processValues(INDEX_ID, new FileKey(file), file, new FileBasedIndex.ValueProcessor<List<FileIncludeInfoImpl>>(){

            @Override
            public boolean process(VirtualFile file, List<FileIncludeInfoImpl> value) {
                result.addAll(value);
                return true;
            }
        }, scope);
        return result;
    }

    public static MultiMap<VirtualFile, FileIncludeInfoImpl> getIncludingFileCandidates(String fileName, GlobalSearchScope scope) {
        final MultiMap result = new MultiMap();
        FileBasedIndex.getInstance().processValues(INDEX_ID, new IncludeKey(fileName), null, new FileBasedIndex.ValueProcessor<List<FileIncludeInfoImpl>>(){

            @Override
            public boolean process(VirtualFile file, List<FileIncludeInfoImpl> value) {
                result.put((Object)file, value);
                return true;
            }
        }, scope);
        return result;
    }

    @Override
    public ID<Key, List<FileIncludeInfoImpl>> getName() {
        return INDEX_ID;
    }

    @Override
    public DataIndexer<Key, List<FileIncludeInfoImpl>, FileContent> getIndexer() {
        return new DataIndexer<Key, List<FileIncludeInfoImpl>, FileContent>(){

            @Override
            @NotNull
            public Map<Key, List<FileIncludeInfoImpl>> map(FileContent inputData) {
                FactoryMap<Key, List<FileIncludeInfoImpl>> map = new FactoryMap<Key, List<FileIncludeInfoImpl>>(){

                    protected List<FileIncludeInfoImpl> create(Key key) {
                        return new ArrayList<FileIncludeInfoImpl>();
                    }
                };
                for (FileIncludeProvider provider : FileIncludeIndex.this.myProviders) {
                    FileIncludeInfo[] infos = provider.getIncludeInfos(inputData);
                    List infoList = (List)map.get(new FileKey(inputData.getFile()));
                    for (FileIncludeInfo info : infos) {
                        FileIncludeInfoImpl impl = new FileIncludeInfoImpl(info.path, info.offset, info.runtimeOnly, provider.getId());
                        ((List)map.get(new IncludeKey(info.fileName))).add(impl);
                        infoList.add(impl);
                    }
                }
                FactoryMap<Key, List<FileIncludeInfoImpl>> factoryMap = map;
                if (factoryMap == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/psi/impl/include/FileIncludeIndex$3.map must not return null");
                }
                return factoryMap;
            }
        };
    }

    @Override
    public KeyDescriptor<Key> getKeyDescriptor() {
        return new KeyDescriptor<Key>(){

            public int getHashCode(Key value) {
                return value.hashCode();
            }

            public boolean isEqual(Key val1, Key val2) {
                return val1.equals(val2);
            }

            public void save(DataOutput out, Key value) throws IOException {
                out.writeBoolean(value.isInclude());
                value.writeValue(out);
            }

            public Key read(DataInput in) throws IOException {
                boolean isInclude = in.readBoolean();
                return isInclude ? new IncludeKey(in.readUTF()) : new FileKey(in.readInt());
            }
        };
    }

    @Override
    public DataExternalizer<List<FileIncludeInfoImpl>> getValueExternalizer() {
        return new DataExternalizer<List<FileIncludeInfoImpl>>(){

            public void save(DataOutput out, List<FileIncludeInfoImpl> value) throws IOException {
                out.writeInt(value.size());
                for (FileIncludeInfoImpl info : value) {
                    out.writeUTF(info.path);
                    out.writeInt(info.offset);
                    out.writeBoolean(info.runtimeOnly);
                    out.writeUTF(info.providerId);
                }
            }

            public List<FileIncludeInfoImpl> read(DataInput in) throws IOException {
                int size = in.readInt();
                ArrayList<FileIncludeInfoImpl> infos = new ArrayList<FileIncludeInfoImpl>(size);
                for (int i = 0; i < size; ++i) {
                    infos.add(new FileIncludeInfoImpl(in.readUTF(), in.readInt(), in.readBoolean(), in.readUTF()));
                }
                return infos;
            }
        };
    }

    @Override
    public FileBasedIndex.InputFilter getInputFilter() {
        return new FileBasedIndex.InputFilter(){

            @Override
            public boolean acceptInput(VirtualFile file) {
                for (FileIncludeProvider provider : FileIncludeIndex.this.myProviders) {
                    if (!provider.acceptFile(file)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public boolean dependsOnFileContent() {
        return true;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    private static class FileKey
    implements Key {
        private final int myFileId;

        private FileKey(int fileId) {
            this.myFileId = fileId;
        }

        private FileKey(VirtualFile file) {
            this.myFileId = FileBasedIndex.getFileId(file);
        }

        @Override
        public boolean isInclude() {
            return false;
        }

        @Override
        public void writeValue(DataOutput out) throws IOException {
            out.writeInt(this.myFileId);
        }

        public int hashCode() {
            return this.myFileId;
        }

        public boolean equals(Object obj) {
            return obj instanceof FileKey && ((FileKey)obj).myFileId == this.myFileId;
        }
    }

    private static class IncludeKey
    implements Key {
        private final String myFileName;

        public IncludeKey(String fileName) {
            this.myFileName = fileName;
        }

        @Override
        public boolean isInclude() {
            return true;
        }

        @Override
        public void writeValue(DataOutput out) throws IOException {
            out.writeUTF(this.myFileName);
        }

        public int hashCode() {
            return this.myFileName.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof IncludeKey && ((IncludeKey)obj).myFileName.equals(this.myFileName);
        }
    }

    static interface Key {
        public boolean isInclude();

        public void writeValue(DataOutput var1) throws IOException;
    }
}

