/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.CommonBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ExternalInfo;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSchemes;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.io.File;
import java.io.IOException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CodeStyleSchemeImpl
implements JDOMExternalizable,
CodeStyleScheme,
ExternalizableScheme {
    @NonNls
    private static final String CODE_SCHEME = "code_scheme";
    @NonNls
    private static final String NAME = "name";
    @NonNls
    private static final String PARENT = "parent";
    @NonNls
    private static final String XML_EXTENSION = ".xml";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.codeStyle.CodeStyleSchemeImpl");
    private String myName;
    private Element myRootElement;
    private String myParentSchemeName;
    private final boolean myIsDefault;
    private CodeStyleSettings myCodeStyleSettings;
    private final ExternalInfo myExternalInfo = new ExternalInfo();

    public CodeStyleSchemeImpl(String name, String parentSchemeName, Element rootElement) {
        this.myName = name;
        this.myRootElement = rootElement;
        this.myIsDefault = false;
        this.myParentSchemeName = parentSchemeName;
    }

    public void init(CodeStyleSchemes schemesManager) {
        LOG.assertTrue(this.myCodeStyleSettings == null, (Object)"Already initialized");
        this.init(schemesManager.findSchemeByName(this.myParentSchemeName), this.myRootElement);
        this.myParentSchemeName = null;
        this.myRootElement = null;
    }

    public CodeStyleSchemeImpl(String name, boolean isDefault, CodeStyleScheme parentScheme) {
        this.myName = name;
        this.myIsDefault = isDefault;
        this.init(parentScheme, null);
    }

    private void init(CodeStyleScheme parentScheme, Element root) {
        CodeStyleSettings parentSettings;
        CodeStyleSettings codeStyleSettings = parentSettings = parentScheme == null ? null : parentScheme.getCodeStyleSettings();
        if (parentSettings == null) {
            this.myCodeStyleSettings = new CodeStyleSettings();
        } else {
            this.myCodeStyleSettings = parentSettings.clone();
            while (parentSettings.getParentSettings() != null) {
                parentSettings = parentSettings.getParentSettings();
            }
            this.myCodeStyleSettings.setParentSettings(parentSettings);
        }
        if (root != null) {
            try {
                this.readExternal(root);
            }
            catch (InvalidDataException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public CodeStyleSettings getCodeStyleSettings() {
        return this.myCodeStyleSettings;
    }

    public void setCodeStyleSettings(@NotNull CodeStyleSettings codeStyleSettings) {
        if (codeStyleSettings == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl.setCodeStyleSettings must not be null");
        }
        this.myCodeStyleSettings = codeStyleSettings;
    }

    public String getName() {
        return this.myName;
    }

    public boolean isDefault() {
        return this.myIsDefault;
    }

    public String toString() {
        return this.getName();
    }

    public void writeExternal(Element element) throws WriteExternalException {
        this.myCodeStyleSettings.writeExternal(element);
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myCodeStyleSettings.readExternal(element);
    }

    public static CodeStyleSchemeImpl readScheme(Document document) throws InvalidDataException, JDOMException, IOException {
        Element root = document.getRootElement();
        if (root == null) {
            throw new InvalidDataException();
        }
        String schemeName = root.getAttributeValue(NAME);
        String parentName = root.getAttributeValue(PARENT);
        if (schemeName == null) {
            throw new InvalidDataException();
        }
        return new CodeStyleSchemeImpl(schemeName, parentName, root);
    }

    public void save(File dir) throws WriteExternalException {
        Element newElement = new Element(CODE_SCHEME);
        newElement.setAttribute(NAME, this.getName());
        this.writeExternal(newElement);
        String filePath = dir.getAbsolutePath() + File.separator + this.getName() + XML_EXTENSION;
        try {
            JDOMUtil.writeDocument((Document)new Document(newElement), (String)filePath, (String)this.getCodeStyleSettings().getLineSeparator());
        }
        catch (IOException e) {
            Messages.showErrorDialog((String)PsiBundle.message((String)"codestyle.cannot.save.scheme.file", (Object[])new Object[]{filePath, e.getLocalizedMessage()}), (String)CommonBundle.getErrorTitle());
        }
    }

    public Document saveToDocument() throws WriteExternalException {
        Element newElement = new Element(CODE_SCHEME);
        newElement.setAttribute(NAME, this.getName());
        this.writeExternal(newElement);
        return new Document(newElement);
    }

    public void setName(String name) {
        this.myName = name;
    }

    @NotNull
    public ExternalInfo getExternalInfo() {
        ExternalInfo externalInfo = this.myExternalInfo;
        if (externalInfo == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/codeStyle/CodeStyleSchemeImpl.getExternalInfo must not return null");
        }
        return externalInfo;
    }
}

