/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.parsing;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lang.ASTFactory;
import com.intellij.lexer.FilterLexer;
import com.intellij.lexer.JavaLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.parsing.JavaParsingContext;
import com.intellij.psi.impl.source.parsing.ParseUtil;
import com.intellij.psi.impl.source.parsing.WhiteSpaceAndCommentsProcessor;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Parsing {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.parsing.Parsing");
    protected static final boolean DEEP_PARSE_BLOCKS_IN_STATEMENTS = false;
    protected final JavaParsingContext myContext;

    public Parsing(JavaParsingContext context) {
        this.myContext = context;
    }

    @Nullable
    public static CompositeElement parseJavaCodeReferenceText(PsiManager manager, @NotNull CharSequence buffer, CharTable table) {
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/parsing/Parsing.parseJavaCodeReferenceText must not be null");
        }
        return (CompositeElement)Parsing.parseJavaCodeReferenceText(manager, buffer, 0, buffer.length(), table, false);
    }

    @Nullable
    public static TreeElement parseJavaCodeReferenceText(PsiManager manager, CharSequence buffer, int startOffset, int endOffset, CharTable table, boolean eatAll) {
        JavaLexer originalLexer = new JavaLexer(LanguageLevelProjectExtension.getInstance((Project)manager.getProject()).getLanguageLevel());
        FilterLexer lexer = new FilterLexer((Lexer)originalLexer, (FilterLexer.Filter)new FilterLexer.SetFilter(StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET));
        lexer.start(buffer, startOffset, endOffset);
        JavaParsingContext context = new JavaParsingContext(table, LanguageLevelProjectExtension.getInstance((Project)manager.getProject()).getLanguageLevel());
        CompositeElement ref = context.getStatementParsing().parseJavaCodeReference((Lexer)lexer, false, true, false);
        FileElement dummyRoot = DummyHolderFactory.createHolder(manager, null, table).getTreeElement();
        if (ref == null) {
            if (!eatAll) {
                return null;
            }
        } else {
            dummyRoot.rawAddChildren(ref);
        }
        if (lexer.getTokenType() != null) {
            if (!eatAll) {
                return null;
            }
            CompositeElement errorElement = Factory.createErrorElement(JavaErrorMessages.message("unexpected.tokens", new Object[0]));
            while (lexer.getTokenType() != null) {
                TreeElement token = ParseUtil.createTokenElement((Lexer)lexer, context.getCharTable());
                errorElement.rawAddChildren(token);
                lexer.advance();
            }
            dummyRoot.rawAddChildren(errorElement);
        }
        ParseUtil.insertMissingTokens(dummyRoot, (Lexer)originalLexer, startOffset, endOffset, -1, WhiteSpaceAndCommentsProcessor.INSTANCE, context);
        return dummyRoot.getFirstChildNode();
    }

    public CompositeElement parseJavaCodeReference(Lexer lexer, boolean allowIncomplete, boolean parseParameterList, boolean parseAnnotations) {
        CompositeElement refElement = ASTFactory.composite(JavaElementType.JAVA_CODE_REFERENCE);
        LexerPosition beforeAnnos = lexer.getCurrentPosition();
        if (parseAnnotations) {
            this.parseAnnotationListTo(lexer, refElement);
        }
        if (lexer.getTokenType() != JavaTokenType.IDENTIFIER) {
            if (parseAnnotations) {
                lexer.restore(beforeAnnos);
            }
            return null;
        }
        TreeElement identifier = ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
        lexer.advance();
        refElement.rawAddChildren(identifier);
        CompositeElement parameterList = parseParameterList ? this.parseReferenceParameterList(lexer, true) : ASTFactory.composite(JavaElementType.REFERENCE_PARAMETER_LIST);
        refElement.rawAddChildren(parameterList);
        while (lexer.getTokenType() == JavaTokenType.DOT) {
            LexerPosition dotPos = lexer.getCurrentPosition();
            TreeElement dot = ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
            lexer.advance();
            if (lexer.getTokenType() == JavaTokenType.IDENTIFIER) {
                identifier = ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
                lexer.advance();
            } else {
                if (!allowIncomplete) {
                    lexer.restore(dotPos);
                    return refElement;
                }
                identifier = null;
            }
            CompositeElement refElement1 = ASTFactory.composite(JavaElementType.JAVA_CODE_REFERENCE);
            refElement1.rawAddChildren(refElement);
            refElement1.rawAddChildren(dot);
            if (identifier == null) {
                refElement1.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.identifier", new Object[0])));
                refElement1.rawAddChildren(ASTFactory.composite(JavaElementType.REFERENCE_PARAMETER_LIST));
                return refElement1;
            }
            refElement1.rawAddChildren(identifier);
            CompositeElement parameterList1 = parseParameterList ? this.parseReferenceParameterList(lexer, true) : ASTFactory.composite(JavaElementType.REFERENCE_PARAMETER_LIST);
            refElement1.rawAddChildren(parameterList1);
            refElement = refElement1;
        }
        return refElement;
    }

    public CompositeElement parseReferenceParameterList(Lexer lexer, boolean allowWildcard) {
        CompositeElement errorElement;
        CompositeElement list = ASTFactory.composite(JavaElementType.REFERENCE_PARAMETER_LIST);
        if (lexer.getTokenType() != JavaTokenType.LT) {
            return list;
        }
        TreeElement lt = ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
        list.rawAddChildren(lt);
        lexer.advance();
        while (true) {
            CompositeElement typeElement;
            if ((typeElement = this.parseType(lexer, true, allowWildcard)) != null) {
                list.rawAddChildren(typeElement);
            } else {
                errorElement = Factory.createErrorElement(JavaErrorMessages.message("expected.identifier", new Object[0]));
                list.rawAddChildren(errorElement);
            }
            if (lexer.getTokenType() == JavaTokenType.GT) {
                TreeElement gt = ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
                list.rawAddChildren(gt);
                lexer.advance();
                return list;
            }
            if (lexer.getTokenType() != JavaTokenType.COMMA) break;
            TreeElement comma = ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
            list.rawAddChildren(comma);
            lexer.advance();
        }
        errorElement = Factory.createErrorElement(JavaErrorMessages.message("expected.gt.or.comma", new Object[0]));
        list.rawAddChildren(errorElement);
        return list;
    }

    public static CompositeElement parseTypeText(PsiManager manager, CharSequence buffer, int startOffset, int endOffset, CharTable table) {
        JavaLexer originalLexer = new JavaLexer(LanguageLevelProjectExtension.getInstance((Project)manager.getProject()).getLanguageLevel());
        FilterLexer lexer = new FilterLexer((Lexer)originalLexer, (FilterLexer.Filter)new FilterLexer.SetFilter(StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET));
        lexer.start(buffer, startOffset, endOffset);
        JavaParsingContext context = new JavaParsingContext(table, LanguageLevelProjectExtension.getInstance((Project)manager.getProject()).getLanguageLevel());
        CompositeElement type = context.getStatementParsing().parseTypeWithEllipsis((Lexer)lexer);
        if (type == null) {
            return null;
        }
        if (lexer.getTokenType() != null) {
            return null;
        }
        FileElement dummyRoot = DummyHolderFactory.createHolder(manager, null, table).getTreeElement();
        dummyRoot.rawAddChildren(type);
        ParseUtil.insertMissingTokens(dummyRoot, (Lexer)originalLexer, startOffset, endOffset, -1, WhiteSpaceAndCommentsProcessor.INSTANCE, context);
        return type;
    }

    public CompositeElement parseTypeWithEllipsis(Lexer lexer, boolean eatLastDot, boolean allowWilcard) {
        CompositeElement type = this.parseType(lexer, eatLastDot, allowWilcard);
        if (type == null) {
            return null;
        }
        if (lexer.getTokenType() == JavaTokenType.ELLIPSIS) {
            CompositeElement type1 = ASTFactory.composite(JavaElementType.TYPE);
            type1.rawAddChildren(type);
            type1.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
            type = type1;
        }
        return type;
    }

    public CompositeElement parseTypeWithEllipsis(Lexer lexer) {
        return this.parseTypeWithEllipsis(lexer, true, true);
    }

    public CompositeElement parseType(Lexer lexer) {
        return this.parseType(lexer, true, true);
    }

    protected void parseAnnotationListTo(@NotNull Lexer lexer, @Nullable CompositeElement element) {
        if (lexer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/parsing/Parsing.parseAnnotationListTo must not be null");
        }
        IElementType tokenType = lexer.getTokenType();
        while (tokenType == JavaTokenType.AT) {
            CompositeElement anno = this.myContext.getDeclarationParsing().parseAnnotation(lexer);
            if (element != null) {
                element.rawAddChildren(anno);
            }
            tokenType = lexer.getTokenType();
        }
    }

    public CompositeElement parseType(Lexer lexer, boolean eatLastDot, boolean allowWildcard) {
        TreeElement refElement;
        IElementType tokenType = lexer.getTokenType();
        if (tokenType == null) {
            return null;
        }
        CompositeElement type = ASTFactory.composite(JavaElementType.TYPE);
        if (this.areTypeAnnotationsSupported()) {
            this.parseAnnotationListTo(lexer, type);
        }
        if (ElementType.PRIMITIVE_TYPE_BIT_SET.contains(tokenType = lexer.getTokenType())) {
            refElement = ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
            lexer.advance();
        } else if (tokenType == JavaTokenType.IDENTIFIER) {
            refElement = this.parseJavaCodeReference(lexer, eatLastDot, true, false);
        } else {
            if (allowWildcard && lexer.getTokenType() == JavaTokenType.QUEST) {
                return this.parseWildcardType(lexer);
            }
            return null;
        }
        type.rawAddChildren(refElement);
        CompositeElement arrayTypeElement = ASTFactory.composite(JavaElementType.TYPE);
        while (true) {
            if (this.areTypeAnnotationsSupported()) {
                this.parseAnnotationListTo(lexer, arrayTypeElement);
            }
            if (lexer.getTokenType() != JavaTokenType.LBRACKET) {
                if (arrayTypeElement.getFirstChildNode() == null) break;
                type.rawAddChildren(arrayTypeElement.getFirstChildNode());
                type.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.lbracket", new Object[0])));
                return type;
            }
            LexerPosition lbracketPos = lexer.getCurrentPosition();
            TreeElement lbracket = ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
            lexer.advance();
            if (lexer.getTokenType() != JavaTokenType.RBRACKET) {
                lexer.restore(lbracketPos);
                break;
            }
            if (arrayTypeElement.getFirstChildNode() == null) {
                arrayTypeElement.rawAddChildren(type);
            } else {
                arrayTypeElement.getFirstChildNode().rawInsertBeforeMe(type);
            }
            arrayTypeElement.rawAddChildren(lbracket);
            TreeElement rBracket = ParseUtil.createTokenElement(lexer, this.myContext.getCharTable());
            arrayTypeElement.rawAddChildren(rBracket);
            lexer.advance();
            type = arrayTypeElement;
            arrayTypeElement = ASTFactory.composite(JavaElementType.TYPE);
        }
        return type;
    }

    protected boolean areTypeAnnotationsSupported() {
        return this.myContext.getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_7);
    }

    private CompositeElement parseWildcardType(Lexer lexer) {
        LOG.assertTrue(lexer.getTokenType() == JavaTokenType.QUEST);
        CompositeElement type = ASTFactory.composite(JavaElementType.TYPE);
        type.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
        lexer.advance();
        if (lexer.getTokenType() == JavaTokenType.SUPER_KEYWORD || lexer.getTokenType() == JavaTokenType.EXTENDS_KEYWORD) {
            type.rawAddChildren(ParseUtil.createTokenElement(lexer, this.myContext.getCharTable()));
            lexer.advance();
            CompositeElement boundType = this.parseType(lexer, true, false);
            if (boundType != null) {
                type.rawAddChildren(boundType);
            } else {
                type.rawAddChildren(Factory.createErrorElement(JavaErrorMessages.message("expected.type", new Object[0])));
            }
        }
        return type;
    }

    public static TreeElement parseTypeText(PsiManager manager, Lexer lexer, CharSequence buffer, int startOffset, int endOffset, int state, CharTable table) {
        if (lexer == null) {
            lexer = new JavaLexer(LanguageLevelProjectExtension.getInstance((Project)manager.getProject()).getLanguageLevel());
        }
        FilterLexer filterLexer = new FilterLexer(lexer, (FilterLexer.Filter)new FilterLexer.SetFilter(StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET));
        if (state < 0) {
            filterLexer.start(buffer, startOffset, endOffset);
        } else {
            filterLexer.start(buffer, startOffset, endOffset, state);
        }
        JavaParsingContext context = new JavaParsingContext(table, LanguageLevelProjectExtension.getInstance((Project)manager.getProject()).getLanguageLevel());
        FileElement dummyRoot = DummyHolderFactory.createHolder(manager, null, context.getCharTable()).getTreeElement();
        CompositeElement root = context.getStatementParsing().parseType((Lexer)filterLexer);
        if (root != null) {
            dummyRoot.rawAddChildren(root);
        }
        if (filterLexer.getTokenType() == JavaTokenType.ELLIPSIS) {
            dummyRoot.rawAddChildren(ParseUtil.createTokenElement((Lexer)filterLexer, context.getCharTable()));
            filterLexer.advance();
        }
        if (filterLexer.getTokenType() != null) {
            CompositeElement errorElement = Factory.createErrorElement(JavaErrorMessages.message("unexpected.tokens", new Object[0]));
            while (filterLexer.getTokenType() != null) {
                TreeElement token = ParseUtil.createTokenElement(lexer, context.getCharTable());
                errorElement.rawAddChildren(token);
                filterLexer.advance();
            }
            dummyRoot.rawAddChildren(errorElement);
        }
        ParseUtil.insertMissingTokens(dummyRoot, lexer, startOffset, endOffset, state, WhiteSpaceAndCommentsProcessor.INSTANCE, context);
        return dummyRoot.getFirstChildNode();
    }
}

