/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.parsing;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.impl.source.ParsingContext;
import com.intellij.psi.impl.source.parsing.ParseUtil;
import com.intellij.psi.impl.source.parsing.TokenProcessor;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;

public class WhiteSpaceAndCommentsProcessor
implements TokenProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.parsing.WhiteSpaceAndCommentsProcessor");
    public static final TokenProcessor INSTANCE = new WhiteSpaceAndCommentsProcessor();
    private final TokenSet myWhitespaceSet;

    public WhiteSpaceAndCommentsProcessor() {
        this(StdTokenSets.WHITE_SPACE_OR_COMMENT_BIT_SET);
    }

    public WhiteSpaceAndCommentsProcessor(TokenSet whitespaceSet) {
        this.myWhitespaceSet = whitespaceSet;
    }

    @Override
    public TreeElement process(Lexer lexer, ParsingContext context) {
        TreeElement first = null;
        TreeElement last = null;
        while (this.isTokenValid(lexer.getTokenType())) {
            TreeElement tokenElement = this.createToken(lexer, context);
            IElementType type = lexer.getTokenType();
            if (!this.myWhitespaceSet.contains(type)) {
                LOG.error("Missed token should be white space or comment:" + tokenElement);
                throw new RuntimeException();
            }
            if (last != null) {
                last.setTreeNext(tokenElement);
                tokenElement.setTreePrev(last);
                last = tokenElement;
            } else {
                first = last = tokenElement;
            }
            lexer.advance();
        }
        return first;
    }

    protected TreeElement createToken(Lexer lexer, ParsingContext context) {
        return ParseUtil.createTokenElement(lexer, context.getCharTable());
    }

    @Override
    public boolean isTokenValid(IElementType tokenType) {
        return tokenType != null && this.myWhitespaceSet.contains(tokenType);
    }
}

