/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.quickFix.FileReferenceQuickFixProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFileReferenceHelper
extends FileReferenceHelper {
    @Override
    public List<? extends LocalQuickFix> registerFixes(HighlightInfo info, FileReference reference) {
        return FileReferenceQuickFixProvider.registerQuickFix(info, reference);
    }

    @Override
    public PsiFileSystemItem findRoot(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper.findRoot must not be null");
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile contentRootForFile = index.getSourceRootForFile(file);
        if (contentRootForFile == null) {
            contentRootForFile = index.getContentRootForFile(file);
        }
        if (contentRootForFile != null) {
            return PsiManager.getInstance((Project)project).findDirectory(contentRootForFile);
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<PsiFileSystemItem> getRoots(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper.getRoots must not be null");
        }
        Collection<PsiFileSystemItem> collection = PsiFileReferenceHelper.getContextsForModule(module, "", module.getModuleWithDependenciesScope());
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper.getRoots must not return null");
        }
        return collection;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Collection<PsiFileSystemItem> getContexts(Project project, @NotNull VirtualFile file) {
        Collection<PsiFileSystemItem> collection;
        Module module;
        String path;
        block9: {
            int len$;
            ContentEntry[] arr$;
            VirtualFile root;
            block10: {
                block7: {
                    PsiFileSystemItem parent;
                    block8: {
                        if (file == null) {
                            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper.getContexts must not be null");
                        }
                        PsiFileSystemItem item = this.getPsiFileSystemItem(project, file);
                        if (item == null || (parent = item.getParent()) == null) break block7;
                        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
                        VirtualFile parentFile = parent.getVirtualFile();
                        assert (parentFile != null);
                        root = index.getSourceRootForFile(parentFile);
                        if (root == null || (path = VfsUtil.getRelativePath((VirtualFile)parentFile, (VirtualFile)root, (char)'.')) == null || (module = ModuleUtil.findModuleForFile((VirtualFile)file, (Project)project)) == null) break block8;
                        OrderEntry orderEntry = ModuleRootManager.getInstance((Module)module).getFileIndex().getOrderEntryForFile(file);
                        if (!(orderEntry instanceof ModuleSourceOrderEntry)) break block9;
                        arr$ = ((ModuleSourceOrderEntry)orderEntry).getRootModel().getContentEntries();
                        len$ = arr$.length;
                        break block10;
                    }
                    collection = Collections.singleton(parent);
                    if (collection == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper.getContexts must not return null");
                    return collection;
                }
                collection = Collections.emptyList();
                if (collection == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper.getContexts must not return null");
                return collection;
            }
            block0: for (int i$ = 0; i$ < len$; ++i$) {
                ContentEntry e = arr$[i$];
                for (SourceFolder sf : e.getSourceFolders()) {
                    String s;
                    if (sf.getFile() != root || (s = sf.getPackagePrefix()).length() <= 0) continue;
                    path = s + "." + path;
                    continue block0;
                }
            }
        }
        if ((collection = PsiFileReferenceHelper.getContextsForModule(module, path, module.getModuleWithDependenciesScope())) == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper.getContexts must not return null");
        return collection;
    }

    @Override
    public boolean isMine(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper.isMine must not be null");
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return index.isInSourceContent(file);
    }

    @Override
    @NotNull
    public String trimUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper.trimUrl must not be null");
        }
        String string = url.trim();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper.trimUrl must not return null");
        }
        return string;
    }

    static Collection<PsiFileSystemItem> getContextsForModule(@NotNull Module module, @NotNull String packageName, @Nullable GlobalSearchScope scope) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper.getContextsForModule must not be null");
        }
        if (packageName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper.getContextsForModule must not be null");
        }
        List<PsiFileSystemItem> result = null;
        Query<VirtualFile> query = DirectoryIndex.getInstance(module.getProject()).getDirectoriesByPackageName(packageName, false);
        PsiManager manager = null;
        for (VirtualFile file : query) {
            PsiDirectory psiDirectory;
            if (scope != null && !scope.contains(file)) continue;
            if (result == null) {
                result = new ArrayList<PsiFileSystemItem>();
                manager = PsiManager.getInstance((Project)module.getProject());
            }
            if ((psiDirectory = manager.findDirectory(file)) == null) continue;
            result.add((PsiFileSystemItem)psiDirectory);
        }
        return result != null ? result : Collections.emptyList();
    }
}

