/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlMarkupDecl;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlEntityRefImpl
extends XmlElementImpl
implements XmlEntityRef {
    private static final Key<Map<String, CachedValue<XmlEntityDecl>>> XML_ENTITY_DECL_MAP = Key.create((String)"XML_ENTITY_DECL_MAP");
    @NonNls
    private static final String GT_ENTITY = "&gt;";
    @NonNls
    private static final String QUOT_ENTITY = "&quot;";
    private static final Key<String> EVALUATION_IN_PROCESS = Key.create((String)"EvalKey");
    private static final Key<Boolean> DISABLE_ENTITY_EXPAND = Key.create((String)"disable.entity.expand");

    public XmlEntityRefImpl() {
        super(XmlElementType.XML_ENTITY_REF);
    }

    public XmlEntityDecl resolve(PsiFile targetFile) {
        String text = this.getText();
        if (text.equals(GT_ENTITY) || text.equals(QUOT_ENTITY)) {
            return null;
        }
        return XmlEntityRefImpl.resolveEntity(this, text, targetFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlEntityDecl getCachedEntity(PsiFile file, String name) {
        CachedValue<XmlEntityDecl> cachedValue;
        Object object = PsiLock.LOCK;
        synchronized (object) {
            Map<String, CachedValue<XmlEntityDecl>> cachingMap = XmlEntityRefImpl.getCachingMap((PsiElement)file);
            cachedValue = cachingMap.get(name);
        }
        return cachedValue != null ? (XmlEntityDecl)cachedValue.getValue() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cacheParticularEntity(PsiFile file, final XmlEntityDecl decl) {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            final Map<String, CachedValue<XmlEntityDecl>> cachingMap = XmlEntityRefImpl.getCachingMap((PsiElement)file);
            final String name = decl.getName();
            if (cachingMap.containsKey(name)) {
                return;
            }
            cachingMap.put(name, (CachedValue<XmlEntityDecl>)CachedValuesManager.getManager((Project)file.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<XmlEntityDecl>(){

                public CachedValueProvider.Result<XmlEntityDecl> compute() {
                    if (decl.isValid() && name.equals(decl.getName())) {
                        return new CachedValueProvider.Result((Object)decl, new Object[]{decl});
                    }
                    cachingMap.put(name, null);
                    return new CachedValueProvider.Result(null, null);
                }
            }, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlEntityDecl resolveEntity(XmlElement element, String text, PsiFile targetFile) {
        CachedValue value;
        XmlDocument document;
        if (targetFile instanceof XmlFile && (document = ((XmlFile)targetFile).getDocument()) != null && document.getUserData(DISABLE_ENTITY_EXPAND) != null) {
            return null;
        }
        String entityName = text.substring(1, text.length() - 1);
        PsiFile targetElement = targetFile != null ? targetFile : element;
        Object object = PsiLock.LOCK;
        synchronized (object) {
            Map<String, CachedValue<XmlEntityDecl>> map = XmlEntityRefImpl.getCachingMap((PsiElement)targetElement);
            value = map.get(entityName);
            PsiFile containingFile = element.getContainingFile();
            if (value == null) {
                PsiManager manager = element.getManager();
                if (manager == null) {
                    return (XmlEntityDecl)XmlEntityRefImpl.resolveEntity((PsiElement)targetElement, entityName, containingFile).getValue();
                }
                value = CachedValuesManager.getManager((Project)manager.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<XmlEntityDecl>((PsiElement)targetElement, entityName, containingFile){
                    final /* synthetic */ PsiElement val$targetElement;
                    final /* synthetic */ String val$entityName;
                    final /* synthetic */ PsiFile val$containingFile;
                    {
                        this.val$targetElement = psiElement;
                        this.val$entityName = string;
                        this.val$containingFile = psiFile;
                    }

                    public CachedValueProvider.Result<XmlEntityDecl> compute() {
                        return XmlEntityRefImpl.resolveEntity(this.val$targetElement, this.val$entityName, this.val$containingFile);
                    }
                });
                map.put(entityName, (CachedValue<XmlEntityDecl>)value);
            }
        }
        return (XmlEntityDecl)value.getValue();
    }

    private static Map<String, CachedValue<XmlEntityDecl>> getCachingMap(PsiElement targetElement) {
        HashMap map = (HashMap)targetElement.getUserData(XML_ENTITY_DECL_MAP);
        if (map == null) {
            map = new HashMap();
            targetElement.putUserData(XML_ENTITY_DECL_MAP, map);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CachedValueProvider.Result<XmlEntityDecl> resolveEntity(final PsiElement targetElement, final String entityName, PsiFile contextFile) {
        if (targetElement.getUserData(EVALUATION_IN_PROCESS) != null) {
            return new CachedValueProvider.Result(null, new Object[]{targetElement});
        }
        try {
            XmlElementDescriptor descriptor;
            XmlDocument document;
            XmlTag rootTag;
            targetElement.putUserData(EVALUATION_IN_PROCESS, (Object)"");
            final ArrayList<Object> deps = new ArrayList<Object>();
            final XmlEntityDecl[] result = new XmlEntityDecl[]{null};
            PsiElementProcessor processor = new PsiElementProcessor(){

                public boolean execute(PsiElement element) {
                    XmlEntityDecl entityDecl;
                    String declName;
                    if (element instanceof XmlDoctype) {
                        XmlMarkupDecl markupDecl;
                        XmlFile xmlFile;
                        XmlDoctype xmlDoctype = (XmlDoctype)element;
                        String dtdUri = XmlUtil.getDtdUri(xmlDoctype);
                        if (dtdUri != null && (xmlFile = XmlUtil.findNamespace((PsiFile)XmlUtil.getContainingFile(element), dtdUri)) != null && xmlFile != targetElement) {
                            deps.add(xmlFile);
                            if (!XmlUtil.processXmlElements((XmlElement)xmlFile, this, true)) {
                                return false;
                            }
                        }
                        if ((markupDecl = xmlDoctype.getMarkupDecl()) != null && !XmlUtil.processXmlElements((XmlElement)markupDecl, this, true)) {
                            return false;
                        }
                    } else if (element instanceof XmlEntityDecl && (declName = (entityDecl = (XmlEntityDecl)element).getName()).equals(entityName)) {
                        result[0] = entityDecl;
                        return false;
                    }
                    return true;
                }
            };
            deps.add(targetElement);
            boolean notfound = PsiTreeUtil.processElements((PsiElement)targetElement, (PsiElementProcessor)processor);
            if (notfound && contextFile != targetElement && contextFile != null && contextFile.isValid()) {
                notfound = PsiTreeUtil.processElements((PsiElement)contextFile, (PsiElementProcessor)processor);
            }
            if (notfound && targetElement instanceof XmlFile && deps.size() == 1 && ((XmlFile)targetElement).getFileType() != StdFileTypes.DTD && (rootTag = (document = ((XmlFile)targetElement).getDocument()).getRootTag()) != null && document.getUserData(DISABLE_ENTITY_EXPAND) == null && (descriptor = rootTag.getDescriptor()) != null && !(descriptor instanceof AnyXmlElementDescriptor)) {
                XmlFile descriptorFile;
                PsiElement element = descriptor.getDeclaration();
                PsiFile containingFile = element != null ? element.getContainingFile() : null;
                XmlFile xmlFile = descriptorFile = containingFile instanceof XmlFile ? (XmlFile)containingFile : null;
                if (descriptorFile != null && !descriptorFile.getName().equals(((XmlFile)targetElement).getName() + ".dtd")) {
                    deps.add(descriptorFile);
                    XmlUtil.processXmlElements((XmlElement)descriptorFile, processor, true);
                }
            }
            CachedValueProvider.Result result2 = new CachedValueProvider.Result((Object)result[0], ArrayUtil.toObjectArray(deps));
            return result2;
        }
        finally {
            targetElement.putUserData(EVALUATION_IN_PROCESS, null);
        }
    }

    public XmlTag getParentTag() {
        XmlElement parent = (XmlElement)this.getParent();
        if (parent instanceof XmlTag) {
            return (XmlTag)parent;
        }
        return null;
    }

    public XmlTagChild getNextSiblingInTag() {
        PsiElement nextSibling = this.getNextSibling();
        if (nextSibling instanceof XmlTagChild) {
            return (XmlTagChild)nextSibling;
        }
        return null;
    }

    public XmlTagChild getPrevSiblingInTag() {
        PsiElement prevSibling = this.getPrevSibling();
        if (prevSibling instanceof XmlTagChild) {
            return (XmlTagChild)prevSibling;
        }
        return null;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders(this, XmlEntityRef.class);
        if (psiReferenceArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlEntityRefImpl.getReferences must not return null");
        }
        return psiReferenceArray;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/xml/XmlEntityRefImpl.accept must not be null");
        }
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlElement((XmlElement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyEntityCaches(PsiFile file, PsiFile context) {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            Map<String, CachedValue<XmlEntityDecl>> cachingMap = XmlEntityRefImpl.getCachingMap((PsiElement)file);
            for (Map.Entry<String, CachedValue<XmlEntityDecl>> entry : XmlEntityRefImpl.getCachingMap((PsiElement)context).entrySet()) {
                cachingMap.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public static void setNoEntityExpandOutOfDocument(XmlDocument doc, boolean b) {
        if (b) {
            doc.putUserData(DISABLE_ENTITY_EXPAND, (Object)Boolean.TRUE);
        } else {
            doc.putUserData(DISABLE_ENTITY_EXPAND, null);
        }
    }
}

