/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.encapsulateFields;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldsDescriptor;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldsViewDescriptor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EncapsulateFieldsProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.encapsulateFields.EncapsulateFieldsProcessor");
    private PsiClass myClass;
    @NotNull
    private final EncapsulateFieldsDescriptor myDescriptor;
    private PsiField[] myFields;
    private HashMap<String, PsiMethod> myNameToGetter;
    private HashMap<String, PsiMethod> myNameToSetter;

    public EncapsulateFieldsProcessor(Project project, @NotNull EncapsulateFieldsDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/encapsulateFields/EncapsulateFieldsProcessor.<init> must not be null");
        }
        super(project);
        this.myDescriptor = descriptor;
        this.myFields = this.myDescriptor.getSelectedFields();
        this.myClass = this.myFields[0].getContainingClass();
    }

    @Override
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usages) {
        PsiField[] fields = new PsiField[this.myFields.length];
        System.arraycopy(this.myFields, 0, fields, 0, this.myFields.length);
        return new EncapsulateFieldsViewDescriptor(fields);
    }

    @Override
    protected String getCommandName() {
        return RefactoringBundle.message((String)"encapsulate.fields.command.name", (Object[])new Object[]{UsageViewUtil.getDescriptiveName((PsiElement)this.myClass)});
    }

    @Override
    protected boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        MultiMap conflicts = new MultiMap();
        PsiMethod[] getterPrototypes = this.myDescriptor.getGetterPrototypes();
        PsiMethod[] setterPrototypes = this.myDescriptor.getSetterPrototypes();
        this.checkExistingMethods(getterPrototypes, (MultiMap<PsiElement, String>)conflicts, true);
        this.checkExistingMethods(setterPrototypes, (MultiMap<PsiElement, String>)conflicts, false);
        Collection classes = ClassInheritorsSearch.search((PsiClass)this.myClass).findAll();
        for (int i = 0; i < this.myFields.length; ++i) {
            PsiField field = this.myFields[i];
            HashSet<PsiMethod> setters = new HashSet<PsiMethod>();
            HashSet<PsiMethod> getters = new HashSet<PsiMethod>();
            for (PsiClass aClass : classes) {
                PsiMethod setterOverrider;
                PsiMethod getterOverrider;
                PsiMethod psiMethod = getterOverrider = getterPrototypes != null ? aClass.findMethodBySignature(getterPrototypes[i], false) : null;
                if (getterOverrider != null) {
                    getters.add(getterOverrider);
                }
                if ((setterOverrider = setterPrototypes != null ? aClass.findMethodBySignature(setterPrototypes[i], false) : null) == null) continue;
                setters.add(setterOverrider);
            }
            if (getters.isEmpty() && setters.isEmpty()) continue;
            block2: for (PsiReference reference : ReferencesSearch.search((PsiElement)field)) {
                PsiElement place = reference.getElement();
                LOG.assertTrue(place instanceof PsiReferenceExpression);
                PsiExpression qualifierExpression = ((PsiReferenceExpression)place).getQualifierExpression();
                PsiClass ancestor = qualifierExpression == null ? (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)place, PsiClass.class, (boolean)false) : PsiUtil.resolveClassInType((PsiType)qualifierExpression.getType());
                boolean isGetter = !PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)place));
                for (PsiMethod overridden : isGetter ? getters : setters) {
                    if (!InheritanceUtil.isInheritorOrSelf((PsiClass)this.myClass, (PsiClass)ancestor, (boolean)true)) continue;
                    conflicts.putValue((Object)overridden, (Object)("There is already a " + CommonRefactoringUtil.htmlEmphasize((String)RefactoringUIUtil.getDescription((PsiElement)overridden, true)) + " which would hide generated " + (isGetter ? "getter" : "setter") + " for " + place.getText()));
                    continue block2;
                }
            }
        }
        return this.showConflicts((MultiMap<PsiElement, String>)conflicts);
    }

    private void checkExistingMethods(PsiMethod[] prototypes, MultiMap<PsiElement, String> conflicts, boolean isGetter) {
        if (prototypes == null) {
            return;
        }
        for (PsiMethod prototype : prototypes) {
            PsiType prototypeReturnType = prototype.getReturnType();
            PsiMethod existing = this.myClass.findMethodBySignature(prototype, true);
            if (existing != null) {
                PsiType returnType = existing.getReturnType();
                if (RefactoringUtil.equivalentTypes(prototypeReturnType, returnType, this.myClass.getManager())) continue;
                String descr = PsiFormatUtil.formatMethod((PsiMethod)existing, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)259, (int)2);
                String message = isGetter ? RefactoringBundle.message((String)"encapsulate.fields.getter.exists", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)descr), CommonRefactoringUtil.htmlEmphasize((String)prototype.getName())}) : RefactoringBundle.message((String)"encapsulate.fields.setter.exists", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)descr), CommonRefactoringUtil.htmlEmphasize((String)prototype.getName())});
                conflicts.putValue((Object)existing, (Object)message);
                continue;
            }
            block1: for (PsiClass containingClass = this.myClass.getContainingClass(); containingClass != null && existing == null; containingClass = containingClass.getContainingClass()) {
                existing = containingClass.findMethodBySignature(prototype, true);
                if (existing == null) continue;
                for (PsiReference reference : ReferencesSearch.search((PsiElement)existing)) {
                    PsiElement place = reference.getElement();
                    LOG.assertTrue(place instanceof PsiReferenceExpression);
                    PsiExpression qualifierExpression = ((PsiReferenceExpression)place).getQualifierExpression();
                    PsiClass inheritor = qualifierExpression == null ? (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)place, PsiClass.class, (boolean)false) : PsiUtil.resolveClassInType((PsiType)qualifierExpression.getType());
                    if (!InheritanceUtil.isInheritorOrSelf((PsiClass)inheritor, (PsiClass)this.myClass, (boolean)true)) continue;
                    conflicts.putValue((Object)existing, (Object)("There is already a " + CommonRefactoringUtil.htmlEmphasize((String)RefactoringUIUtil.getDescription((PsiElement)existing, true)) + " which would be hidden by generated " + (isGetter ? "getter" : "setter")));
                    continue block1;
                }
            }
        }
    }

    @Override
    @NotNull
    protected UsageInfo[] findUsages() {
        boolean findGet = this.myDescriptor.isToEncapsulateGet();
        boolean findSet = this.myDescriptor.isToEncapsulateSet();
        PsiModifierList newModifierList = null;
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myProject);
        if (!this.myDescriptor.isToUseAccessorsWhenAccessible()) {
            PsiElementFactory factory = facade.getElementFactory();
            try {
                PsiField field = factory.createField("a", PsiType.INT);
                this.setNewFieldVisibility(field);
                newModifierList = field.getModifierList();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        PsiMethod[] getterPrototypes = this.myDescriptor.getGetterPrototypes();
        PsiMethod[] setterPrototypes = this.myDescriptor.getSetterPrototypes();
        ArrayList<MyUsageInfo> array = new ArrayList<MyUsageInfo>();
        PsiField[] fields = this.myFields;
        for (int i = 0; i < fields.length; ++i) {
            PsiField field = fields[i];
            for (PsiReference reference : ReferencesSearch.search((PsiElement)field)) {
                if (!(reference instanceof PsiReferenceExpression)) continue;
                PsiReferenceExpression ref = (PsiReferenceExpression)reference;
                if (findGet && this.isUsedInExistingAccessor(getterPrototypes[i], (PsiElement)ref) || findSet && this.isUsedInExistingAccessor(setterPrototypes[i], (PsiElement)ref) || !findGet && !PsiUtil.isAccessedForWriting((PsiExpression)ref) || (!findSet || field.hasModifierProperty("final")) && !PsiUtil.isAccessedForReading((PsiExpression)ref)) continue;
                if (!this.myDescriptor.isToUseAccessorsWhenAccessible()) {
                    PsiClass accessObjectClass = null;
                    PsiExpression qualifier = ref.getQualifierExpression();
                    if (qualifier != null) {
                        accessObjectClass = (PsiClass)PsiUtil.getAccessObjectClass((PsiExpression)qualifier).getElement();
                    }
                    if (facade.getResolveHelper().isAccessible((PsiMember)field, newModifierList, (PsiElement)ref, accessObjectClass, null)) continue;
                }
                MyUsageInfo usageInfo = new MyUsageInfo((PsiJavaCodeReferenceElement)ref, i);
                array.add(usageInfo);
            }
        }
        UsageInfo[] usageInfos = array.toArray(new MyUsageInfo[array.size()]);
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages(usageInfos);
        if (usageInfoArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/refactoring/encapsulateFields/EncapsulateFieldsProcessor.findUsages must not return null");
        }
        return usageInfoArray;
    }

    @Override
    protected void refreshElements(PsiElement[] elements) {
        LOG.assertTrue(elements.length == this.myFields.length);
        for (int idx = 0; idx < elements.length; ++idx) {
            PsiElement element = elements[idx];
            LOG.assertTrue(element instanceof PsiField);
            this.myFields[idx] = (PsiField)element;
        }
        this.myClass = this.myFields[0].getContainingClass();
    }

    @Override
    protected void performRefactoring(UsageInfo[] usages) {
        if (this.myDescriptor.getFieldsVisibility() != null) {
            for (PsiField field : this.myFields) {
                this.setNewFieldVisibility(field);
            }
        }
        this.myNameToGetter = new HashMap();
        this.myNameToSetter = new HashMap();
        for (int i = 0; i < this.myFields.length; ++i) {
            PsiMethod[] prototypes;
            DocCommentPolicy<PsiDocComment> commentPolicy = new DocCommentPolicy<PsiDocComment>(this.myDescriptor.getJavadocPolicy());
            PsiField field = this.myFields[i];
            PsiDocComment docComment = field.getDocComment();
            if (this.myDescriptor.isToEncapsulateGet()) {
                prototypes = this.myDescriptor.getGetterPrototypes();
                assert (prototypes != null);
                PsiMethod getter = this.addOrChangeAccessor(prototypes[i], this.myNameToGetter);
                if (docComment != null) {
                    PsiDocComment getterJavadoc = (PsiDocComment)getter.addBefore((PsiElement)docComment, getter.getFirstChild());
                    commentPolicy.processNewJavaDoc(getterJavadoc);
                }
            }
            if (this.myDescriptor.isToEncapsulateSet() && !field.hasModifierProperty("final")) {
                prototypes = this.myDescriptor.getSetterPrototypes();
                assert (prototypes != null);
                this.addOrChangeAccessor(prototypes[i], this.myNameToSetter);
            }
            if (docComment == null) continue;
            commentPolicy.processOldJavaDoc(docComment);
        }
        HashMap usagesInFiles = new HashMap();
        for (UsageInfo usage : usages) {
            PsiElement element = usage.getElement();
            if (element == null) continue;
            PsiFile file = element.getContainingFile();
            ArrayList<MyUsageInfo> usagesInFile = (ArrayList<MyUsageInfo>)usagesInFiles.get(file);
            if (usagesInFile == null) {
                usagesInFile = new ArrayList<MyUsageInfo>();
                usagesInFiles.put(file, usagesInFile);
            }
            usagesInFile.add((MyUsageInfo)usage);
        }
        for (List usageInfos : usagesInFiles.values()) {
            UsageInfo[] infos = usageInfos.toArray(new MyUsageInfo[usageInfos.size()]);
            RefactoringUtil.sortDepthFirstRightLeftOrder(infos);
            for (UsageInfo info : infos) {
                this.processUsage((MyUsageInfo)info);
            }
        }
    }

    private void setNewFieldVisibility(PsiField field) {
        try {
            if (this.myDescriptor.getFieldsVisibility() != null) {
                field.normalizeDeclaration();
                PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)this.myDescriptor.getFieldsVisibility(), (boolean)true);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private PsiMethod addOrChangeAccessor(PsiMethod prototype, HashMap<String, PsiMethod> nameToAncestor) {
        PsiMethod existing;
        PsiMethod result = existing = this.myClass.findMethodBySignature(prototype, false);
        try {
            if (existing == null) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)prototype, (String)this.myDescriptor.getAccessorsVisibility(), (boolean)true);
                result = (PsiMethod)this.myClass.add((PsiElement)prototype);
            }
            nameToAncestor.put((Object)prototype.getName(), (Object)result);
            return result;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private boolean isUsedInExistingAccessor(PsiMethod prototype, PsiElement element) {
        PsiMethod existingAccessor = this.myClass.findMethodBySignature(prototype, false);
        if (existingAccessor != null) {
            for (PsiElement parent = element; parent != null; parent = parent.getParent()) {
                if (!existingAccessor.equals(parent)) continue;
                return true;
            }
        }
        return false;
    }

    private void processUsage(MyUsageInfo usage) {
        boolean processSet;
        PsiField field = this.myFields[usage.fieldIndex];
        boolean processGet = this.myDescriptor.isToEncapsulateGet();
        boolean bl = processSet = this.myDescriptor.isToEncapsulateSet() && !field.hasModifierProperty("final");
        if (!processGet && !processSet) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
        try {
            PsiReferenceExpression expr = (PsiReferenceExpression)usage.getElement();
            if (expr == null) {
                return;
            }
            PsiElement parent = expr.getParent();
            if (parent instanceof PsiAssignmentExpression && expr.equals(((PsiAssignmentExpression)parent).getLExpression())) {
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
                if (assignment.getRExpression() == null) {
                    return;
                }
                PsiJavaToken opSign = assignment.getOperationSign();
                IElementType opType = opSign.getTokenType();
                if (opType == JavaTokenType.EQ) {
                    if (!processSet) {
                        return;
                    }
                    int fieldIndex = usage.fieldIndex;
                    PsiExpression setterArgument = assignment.getRExpression();
                    PsiMethodCallExpression methodCall = this.createSetterCall(fieldIndex, setterArgument, expr);
                    if (methodCall != null) {
                        assignment.replace((PsiElement)methodCall);
                    }
                } else if (opType == JavaTokenType.ASTERISKEQ || opType == JavaTokenType.DIVEQ || opType == JavaTokenType.PERCEQ || opType == JavaTokenType.PLUSEQ || opType == JavaTokenType.MINUSEQ || opType == JavaTokenType.LTLTEQ || opType == JavaTokenType.GTGTEQ || opType == JavaTokenType.GTGTGTEQ || opType == JavaTokenType.ANDEQ || opType == JavaTokenType.OREQ || opType == JavaTokenType.XOREQ) {
                    PsiMethodCallExpression setExpr;
                    int fieldIndex;
                    PsiMethodCallExpression getterCall;
                    String opName = opSign.getText();
                    LOG.assertTrue(StringUtil.endsWithChar((CharSequence)opName, (char)'='));
                    opName = opName.substring(0, opName.length() - 1);
                    PsiReferenceExpression getExpr = expr;
                    if (processGet && (getterCall = this.createGetterCall(fieldIndex = usage.fieldIndex, expr)) != null) {
                        getExpr = getterCall;
                    }
                    String text = "a" + opName + "b";
                    PsiBinaryExpression binExpr = (PsiBinaryExpression)factory.createExpressionFromText(text, (PsiElement)expr);
                    binExpr = (PsiBinaryExpression)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)binExpr);
                    binExpr.getLOperand().replace((PsiElement)getExpr);
                    binExpr.getROperand().replace((PsiElement)assignment.getRExpression());
                    if (processSet) {
                        setExpr = this.createSetterCall(usage.fieldIndex, (PsiExpression)binExpr, expr);
                    } else {
                        text = "a = b";
                        PsiAssignmentExpression assignment1 = (PsiAssignmentExpression)factory.createExpressionFromText(text, null);
                        assignment1 = (PsiAssignmentExpression)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)assignment1);
                        assignment1.getLExpression().replace((PsiElement)expr);
                        assignment1.getRExpression().replace((PsiElement)binExpr);
                        setExpr = assignment1;
                    }
                    assignment.replace((PsiElement)setExpr);
                }
            } else if (RefactoringUtil.isPlusPlusOrMinusMinus(parent)) {
                PsiMethodCallExpression setExpr;
                int fieldIndex;
                PsiMethodCallExpression getterCall;
                PsiJavaToken sign = parent instanceof PsiPrefixExpression ? ((PsiPrefixExpression)parent).getOperationSign() : ((PsiPostfixExpression)parent).getOperationSign();
                IElementType tokenType = sign.getTokenType();
                PsiReferenceExpression getExpr = expr;
                if (processGet && (getterCall = this.createGetterCall(fieldIndex = usage.fieldIndex, expr)) != null) {
                    getExpr = getterCall;
                }
                String text = tokenType == JavaTokenType.PLUSPLUS ? "a+1" : "a-1";
                PsiBinaryExpression binExpr = (PsiBinaryExpression)factory.createExpressionFromText(text, null);
                binExpr = (PsiBinaryExpression)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)binExpr);
                binExpr.getLOperand().replace((PsiElement)getExpr);
                if (processSet) {
                    int fieldIndex2 = usage.fieldIndex;
                    setExpr = this.createSetterCall(fieldIndex2, (PsiExpression)binExpr, expr);
                } else {
                    text = "a = b";
                    PsiAssignmentExpression assignment = (PsiAssignmentExpression)factory.createExpressionFromText(text, null);
                    assignment = (PsiAssignmentExpression)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)assignment);
                    assignment.getLExpression().replace((PsiElement)expr);
                    assignment.getRExpression().replace((PsiElement)binExpr);
                    setExpr = assignment;
                }
                parent.replace((PsiElement)setExpr);
            } else {
                if (!processGet) {
                    return;
                }
                PsiMethodCallExpression methodCall = this.createGetterCall(usage.fieldIndex, expr);
                if (methodCall != null) {
                    expr.replace((PsiElement)methodCall);
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private PsiMethodCallExpression createSetterCall(int fieldIndex, PsiExpression setterArgument, PsiReferenceExpression expr) throws IncorrectOperationException {
        PsiMethod targetMethod;
        String[] setterNames = this.myDescriptor.getSetterNames();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)expr.getProject()).getElementFactory();
        String setterName = setterNames[fieldIndex];
        String text = setterName + "(a)";
        PsiExpression qualifier = expr.getQualifierExpression();
        if (qualifier != null) {
            text = "q." + text;
        }
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)factory.createExpressionFromText(text, (PsiElement)expr);
        methodCall = (PsiMethodCallExpression)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)methodCall);
        methodCall.getArgumentList().getExpressions()[0].replace((PsiElement)setterArgument);
        if (qualifier != null) {
            methodCall.getMethodExpression().getQualifierExpression().replace((PsiElement)qualifier);
        }
        if ((methodCall = this.checkMethodResolvable(methodCall, targetMethod = (PsiMethod)this.myNameToSetter.get((Object)setterName), expr)) == null) {
            VisibilityUtil.escalateVisibility((PsiMember)this.myFields[fieldIndex], (PsiElement)expr);
        }
        return methodCall;
    }

    @Nullable
    private PsiMethodCallExpression createGetterCall(int fieldIndex, PsiReferenceExpression expr) throws IncorrectOperationException {
        PsiMethod targetMethod;
        String[] getterNames = this.myDescriptor.getGetterNames();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)expr.getProject()).getElementFactory();
        String getterName = getterNames[fieldIndex];
        String text = getterName + "()";
        PsiExpression qualifier = expr.getQualifierExpression();
        if (qualifier != null) {
            text = "q." + text;
        }
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)factory.createExpressionFromText(text, (PsiElement)expr);
        methodCall = (PsiMethodCallExpression)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)methodCall);
        if (qualifier != null) {
            methodCall.getMethodExpression().getQualifierExpression().replace((PsiElement)qualifier);
        }
        if ((methodCall = this.checkMethodResolvable(methodCall, targetMethod = (PsiMethod)this.myNameToGetter.get((Object)getterName), expr)) == null) {
            VisibilityUtil.escalateVisibility((PsiMember)this.myFields[fieldIndex], (PsiElement)expr);
        }
        return methodCall;
    }

    @Nullable
    private PsiMethodCallExpression checkMethodResolvable(PsiMethodCallExpression methodCall, PsiMethod targetMethod, PsiReferenceExpression context) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)targetMethod.getProject()).getElementFactory();
        PsiElement resolved = methodCall.getMethodExpression().resolve();
        if (resolved != targetMethod) {
            PsiClass containingClass;
            if (resolved instanceof PsiMethod) {
                containingClass = ((PsiMethod)resolved).getContainingClass();
            } else if (resolved instanceof PsiClass) {
                containingClass = (PsiClass)resolved;
            } else {
                return null;
            }
            if (containingClass != null && containingClass.isInheritor(this.myClass, false)) {
                PsiExpression newMethodExpression = factory.createExpressionFromText("super." + targetMethod.getName(), (PsiElement)context);
                methodCall.getMethodExpression().replace((PsiElement)newMethodExpression);
            } else {
                methodCall = null;
            }
        }
        return methodCall;
    }

    private static class MyUsageInfo
    extends UsageInfo {
        public final int fieldIndex;

        public MyUsageInfo(PsiJavaCodeReferenceElement ref, int fieldIndex) {
            super((PsiQualifiedReference)ref);
            this.fieldIndex = fieldIndex;
        }
    }
}

