/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.migration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.migration.EditMigrationEntryDialog;
import com.intellij.refactoring.migration.MigrationMap;
import com.intellij.refactoring.migration.MigrationMapEntry;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.Table;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class EditMigrationDialog
extends DialogWrapper {
    private JTable myTable;
    private JButton myEditButton;
    private JButton myAddButton;
    private JButton myRemoveButton;
    private JButton myMoveUpButton;
    private JButton myMoveDownButton;
    private JTextField myNameField;
    private JTextArea myDescriptionTextArea;
    private final Project myProject;
    private final MigrationMap myMigrationMap;

    public EditMigrationDialog(Project project, MigrationMap migrationMap) {
        super(project, true);
        this.myProject = project;
        this.myMigrationMap = migrationMap;
        this.setHorizontalStretch(1.2f);
        this.setTitle(RefactoringBundle.message((String)"edit.migration.map.title"));
        this.init();
        this.validateOKButton();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    private void validateOKButton() {
        boolean isEnabled = true;
        if (this.myNameField.getText().trim().length() == 0) {
            isEnabled = false;
        } else if (this.myMigrationMap.getEntryCount() == 0) {
            isEnabled = false;
        }
        this.setOKActionEnabled(isEnabled);
    }

    public String getName() {
        return this.myNameField.getText();
    }

    public String getDescription() {
        return this.myDescriptionTextArea.getText();
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = new Insets(4, 4, 4, 4);
        gbConstraints.fill = 3;
        gbConstraints.weightx = 0.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.anchor = 13;
        JLabel promptLabel = new JLabel(RefactoringBundle.message((String)"migration.map.name.prompt"));
        panel.add((Component)promptLabel, gbConstraints);
        gbConstraints.fill = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.myNameField = new JTextField(this.myMigrationMap.getName());
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                EditMigrationDialog.this.validateOKButton();
            }
        });
        panel.add((Component)this.myNameField, gbConstraints);
        gbConstraints.fill = 3;
        gbConstraints.weightx = 0.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.gridwidth = -1;
        gbConstraints.anchor = 13;
        JLabel descriptionPromptLabel = new JLabel(RefactoringBundle.message((String)"migration.map.description.label"));
        panel.add((Component)descriptionPromptLabel, gbConstraints);
        gbConstraints.fill = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        this.myDescriptionTextArea = new JTextArea(this.myMigrationMap.getDescription(), 3, 40);
        this.myDescriptionTextArea.setLineWrap(true);
        this.myDescriptionTextArea.setWrapStyleWord(true);
        JScrollPane scrollPane = new JScrollPane(this.myDescriptionTextArea);
        scrollPane.setBorder(null);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setVerticalScrollBarPolicy(21);
        this.myDescriptionTextArea.setFont(this.myNameField.getFont());
        this.myDescriptionTextArea.setBackground(this.myNameField.getBackground());
        scrollPane.setBorder(this.myNameField.getBorder());
        panel.add((Component)scrollPane, gbConstraints);
        return panel;
    }

    protected JComponent createCenterPanel() {
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.setBorder(IdeBorderFactory.createBorder());
        tablePanel.add((Component)this.createTable(), "Center");
        JPanel tableButtonsPanel = new JPanel();
        tableButtonsPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        tableButtonsPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 2;
        gbConstraints.insets = new Insets(5, 0, 5, 0);
        this.myAddButton = new JButton(RefactoringBundle.message((String)"migration.add.button"));
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditMigrationDialog.this.validateOKButton();
            }
        });
        tableButtonsPanel.add((Component)this.myAddButton, gbConstraints);
        this.myEditButton = new JButton(RefactoringBundle.message((String)"migration.edit.button"));
        tableButtonsPanel.add((Component)this.myEditButton, gbConstraints);
        this.myRemoveButton = new JButton(RefactoringBundle.message((String)"migration.remove.button"));
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditMigrationDialog.this.validateOKButton();
            }
        });
        tableButtonsPanel.add((Component)this.myRemoveButton, gbConstraints);
        this.myMoveUpButton = new JButton(RefactoringBundle.message((String)"migration.move.up.button"));
        tableButtonsPanel.add((Component)this.myMoveUpButton, gbConstraints);
        this.myMoveDownButton = new JButton(RefactoringBundle.message((String)"migration.move.down.button"));
        tableButtonsPanel.add((Component)this.myMoveDownButton, gbConstraints);
        gbConstraints.weighty = 1.0;
        tableButtonsPanel.add((Component)new JPanel(), gbConstraints);
        tablePanel.add((Component)tableButtonsPanel, "East");
        this.myEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EditMigrationDialog.this.edit();
            }
        });
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EditMigrationDialog.this.addRow();
            }
        });
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EditMigrationDialog.this.removeRow();
            }
        });
        this.myMoveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EditMigrationDialog.this.moveUp();
            }
        });
        this.myMoveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                EditMigrationDialog.this.moveDown();
            }
        });
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                EditMigrationDialog.this.enableButtons();
            }
        });
        this.enableButtons();
        return tablePanel;
    }

    private void edit() {
        EditMigrationEntryDialog dialog = new EditMigrationEntryDialog(this.myProject);
        int selected = this.myTable.getSelectedRow();
        if (selected < 0) {
            return;
        }
        MigrationMapEntry entry = this.myMigrationMap.getEntryAt(selected);
        dialog.setEntry(entry);
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        dialog.updateEntry(entry);
        AbstractTableModel model = (AbstractTableModel)this.myTable.getModel();
        model.fireTableRowsUpdated(selected, selected);
    }

    private void addRow() {
        EditMigrationEntryDialog dialog = new EditMigrationEntryDialog(this.myProject);
        MigrationMapEntry entry = new MigrationMapEntry();
        dialog.setEntry(entry);
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        dialog.updateEntry(entry);
        this.myMigrationMap.addEntry(entry);
        AbstractTableModel model = (AbstractTableModel)this.myTable.getModel();
        model.fireTableRowsInserted(this.myMigrationMap.getEntryCount() - 1, this.myMigrationMap.getEntryCount() - 1);
        this.myTable.setRowSelectionInterval(this.myMigrationMap.getEntryCount() - 1, this.myMigrationMap.getEntryCount() - 1);
    }

    private void removeRow() {
        int selected = this.myTable.getSelectedRow();
        if (selected < 0) {
            return;
        }
        this.myMigrationMap.removeEntryAt(selected);
        AbstractTableModel model = (AbstractTableModel)this.myTable.getModel();
        model.fireTableRowsDeleted(selected, selected);
        if (selected >= this.myMigrationMap.getEntryCount()) {
            --selected;
        }
        if (selected >= 0) {
            this.myTable.setRowSelectionInterval(selected, selected);
        }
    }

    private void moveUp() {
        int selected = this.myTable.getSelectedRow();
        if (selected < 1) {
            return;
        }
        MigrationMapEntry entry = this.myMigrationMap.getEntryAt(selected);
        MigrationMapEntry previousEntry = this.myMigrationMap.getEntryAt(selected - 1);
        this.myMigrationMap.setEntryAt(previousEntry, selected);
        this.myMigrationMap.setEntryAt(entry, selected - 1);
        AbstractTableModel model = (AbstractTableModel)this.myTable.getModel();
        model.fireTableRowsUpdated(selected - 1, selected);
        this.myTable.setRowSelectionInterval(selected - 1, selected - 1);
    }

    private void moveDown() {
        int selected = this.myTable.getSelectedRow();
        if (selected >= this.myMigrationMap.getEntryCount() - 1) {
            return;
        }
        MigrationMapEntry entry = this.myMigrationMap.getEntryAt(selected);
        MigrationMapEntry nextEntry = this.myMigrationMap.getEntryAt(selected + 1);
        this.myMigrationMap.setEntryAt(nextEntry, selected);
        this.myMigrationMap.setEntryAt(entry, selected + 1);
        AbstractTableModel model = (AbstractTableModel)this.myTable.getModel();
        model.fireTableRowsUpdated(selected, selected + 1);
        this.myTable.setRowSelectionInterval(selected + 1, selected + 1);
    }

    private JScrollPane createTable() {
        final String[] names = new String[]{RefactoringBundle.message((String)"migration.type.column.header"), RefactoringBundle.message((String)"migration.old.name.column.header"), RefactoringBundle.message((String)"migration.new.name.column.header")};
        AbstractTableModel dataModel = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return 3;
            }

            @Override
            public int getRowCount() {
                return EditMigrationDialog.this.myMigrationMap.getEntryCount();
            }

            @Override
            public Object getValueAt(int row, int col) {
                String suffix;
                MigrationMapEntry entry = EditMigrationDialog.this.myMigrationMap.getEntryAt(row);
                if (col == 0) {
                    if (entry.getType() == 0 && entry.isRecursive()) {
                        return RefactoringBundle.message((String)"migration.package.with.subpackages");
                    }
                    if (entry.getType() == 0 && !entry.isRecursive()) {
                        return RefactoringBundle.message((String)"migration.package");
                    }
                    return RefactoringBundle.message((String)"migration.class");
                }
                String string = suffix = entry.getType() == 0 ? ".*" : "";
                if (col == 1) {
                    return entry.getOldName() + suffix;
                }
                return entry.getNewName() + suffix;
            }

            @Override
            public String getColumnName(int column) {
                return names[column];
            }

            public Class getColumnClass(int c) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
            }
        };
        this.myTable = new Table((TableModel)dataModel);
        this.myTable.setSelectionMode(0);
        this.myTable.setPreferredScrollableViewportSize(new Dimension(300, this.myTable.getRowHeight() * 10));
        return ScrollPaneFactory.createScrollPane((JComponent)this.myTable);
    }

    private void enableButtons() {
        int selectedIndex = this.myTable.getSelectedRow();
        this.myEditButton.setEnabled(selectedIndex != -1);
        this.myRemoveButton.setEnabled(selectedIndex != -1);
        this.myMoveDownButton.setEnabled(selectedIndex != -1 && selectedIndex < this.myTable.getRowCount() - 1);
        this.myMoveUpButton.setEnabled(selectedIndex > 0);
    }
}

