/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesHandlerBase;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesImpl;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesToNewDirectoryDialog;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveDirectoryWithClassesProcessor;
import com.intellij.refactoring.util.RadioUpDownListener;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.containers.HashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class MovePackagesHandler
extends MoveClassesOrPackagesHandlerBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveClassesOrPackages.MovePackagesHandler");

    @Override
    public boolean canMove(PsiElement[] elements, PsiElement targetContainer) {
        for (PsiElement element : elements) {
            if (MovePackagesHandler.isPackageOrDirectory(element)) continue;
            return false;
        }
        return super.canMove(elements, targetContainer);
    }

    @Override
    public boolean isValidTarget(PsiElement psiElement) {
        return MovePackagesHandler.isPackageOrDirectory(psiElement);
    }

    @Override
    public void doMove(Project project, PsiElement[] elements, PsiElement targetContainer, final MoveCallback callback) {
        if (MovePackagesHandler.canMoveOrRearrangePackages(elements)) {
            final PsiDirectory[] directories = new PsiDirectory[elements.length];
            System.arraycopy(elements, 0, directories, 0, directories.length);
            SelectMoveOrRearrangePackageDialog dialog = new SelectMoveOrRearrangePackageDialog(project, directories, targetContainer == null);
            dialog.show();
            if (!dialog.isOK()) {
                return;
            }
            if (dialog.isPackageRearrageSelected()) {
                MoveClassesOrPackagesImpl.doRearrangePackage(project, directories);
                return;
            }
            if (dialog.isMoveDirectory()) {
                if (targetContainer instanceof PsiDirectory) {
                    JavaRefactoringSettings refactoringSettings = JavaRefactoringSettings.getInstance();
                    MoveDirectoryWithClassesProcessor processor = new MoveDirectoryWithClassesProcessor(project, directories, (PsiDirectory)targetContainer, refactoringSettings.RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE, refactoringSettings.RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE, true, callback);
                    processor.run();
                } else {
                    MoveClassesOrPackagesToNewDirectoryDialog dlg = new MoveClassesOrPackagesToNewDirectoryDialog(directories[0], new PsiElement[2], false, callback){

                        @Override
                        protected void performRefactoring(Project project, PsiDirectory targetDirectory, PsiPackage aPackage, boolean searchInComments, boolean searchForTextOccurences) {
                            MoveDirectoryWithClassesProcessor processor = new MoveDirectoryWithClassesProcessor(project, directories, targetDirectory, searchInComments, searchForTextOccurences, true, callback);
                            processor.run();
                        }
                    };
                    dlg.show();
                }
                return;
            }
        }
        super.doMove(project, elements, targetContainer, callback);
    }

    private static boolean canMoveOrRearrangePackages(PsiElement[] elements) {
        if (elements.length == 0) {
            return false;
        }
        Project project = elements[0].getProject();
        if (ProjectRootManager.getInstance((Project)project).getContentSourceRoots().length == 1) {
            return false;
        }
        for (PsiElement element : elements) {
            if (!(element instanceof PsiDirectory)) {
                return false;
            }
            PsiDirectory directory = (PsiDirectory)element;
            if (RefactoringUtil.isSourceRoot(directory)) {
                return false;
            }
            PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (aPackage == null) {
                return false;
            }
            if ("".equals(aPackage.getQualifiedName())) {
                return false;
            }
            VirtualFile sourceRootForFile = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex().getSourceRootForFile(directory.getVirtualFile());
            if (sourceRootForFile != null) continue;
            return false;
        }
        return true;
    }

    private static class SelectMoveOrRearrangePackageDialog
    extends DialogWrapper {
        private JRadioButton myRbMovePackage;
        private JRadioButton myRbRearrangePackage;
        private JRadioButton myRbMoveDirectory;
        private final PsiDirectory[] myDirectories;
        private final boolean myRearrangePackagesEnabled;

        public SelectMoveOrRearrangePackageDialog(Project project, PsiDirectory[] directories) {
            this(project, directories, true);
        }

        public SelectMoveOrRearrangePackageDialog(Project project, PsiDirectory[] directories, boolean rearrangePackagesEnabled) {
            super(project, true);
            this.myDirectories = directories;
            this.myRearrangePackagesEnabled = rearrangePackagesEnabled;
            this.setTitle(RefactoringBundle.message((String)"select.refactoring.title"));
            this.init();
        }

        protected JComponent createNorthPanel() {
            return new JLabel(RefactoringBundle.message((String)"what.would.you.like.to.do"));
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myRbMovePackage;
        }

        protected String getDimensionServiceKey() {
            return "#com.intellij.refactoring.move.MoveHandler.SelectRefactoringDialog";
        }

        protected JComponent createCenterPanel() {
            String moveDescription;
            JPanel panel = new JPanel(new BorderLayout());
            HashSet packages = new HashSet();
            for (PsiDirectory directory : this.myDirectories) {
                packages.add((Object)JavaDirectoryService.getInstance().getPackage(directory).getQualifiedName());
            }
            LOG.assertTrue(this.myDirectories.length > 0);
            LOG.assertTrue(packages.size() > 0);
            if (packages.size() > 1) {
                moveDescription = RefactoringBundle.message((String)"move.packages.to.another.package", (Object[])new Object[]{packages.size()});
            } else {
                String qName = (String)packages.iterator().next();
                moveDescription = RefactoringBundle.message((String)"move.package.to.another.package", (Object[])new Object[]{qName});
            }
            this.myRbMovePackage = new JRadioButton();
            this.myRbMovePackage.setText(moveDescription);
            this.myRbMovePackage.setSelected(true);
            String rearrangeDescription = this.myDirectories.length > 1 ? RefactoringBundle.message((String)"move.directories.to.another.source.root", (Object[])new Object[]{this.myDirectories.length}) : RefactoringBundle.message((String)"move.directory.to.another.source.root", (Object[])new Object[]{this.myDirectories[0].getVirtualFile().getPresentableUrl()});
            this.myRbRearrangePackage = new JRadioButton();
            this.myRbRearrangePackage.setText(rearrangeDescription);
            this.myRbRearrangePackage.setVisible(this.myRearrangePackagesEnabled);
            String moveDirectoryDescription = this.myDirectories.length > 1 ? "Move everything from " + this.myDirectories.length + " directories to another directory" : "Move everything from " + this.myDirectories[0].getVirtualFile().getPresentableUrl() + " to another directory";
            this.myRbMoveDirectory = new JRadioButton();
            this.myRbMoveDirectory.setMnemonic('d');
            this.myRbMoveDirectory.setText(moveDirectoryDescription);
            ButtonGroup gr = new ButtonGroup();
            gr.add(this.myRbMovePackage);
            gr.add(this.myRbRearrangePackage);
            gr.add(this.myRbMoveDirectory);
            new RadioUpDownListener(this.myRbMovePackage, this.myRbRearrangePackage, this.myRbMoveDirectory);
            Box box = Box.createVerticalBox();
            box.add(Box.createVerticalStrut(5));
            box.add(this.myRbMovePackage);
            box.add(this.myRbRearrangePackage);
            box.add(this.myRbMoveDirectory);
            panel.add((Component)box, "Center");
            return panel;
        }

        public boolean isPackageRearrageSelected() {
            return this.myRbRearrangePackage.isSelected();
        }

        public boolean isMoveDirectory() {
            return this.myRbMoveDirectory.isSelected();
        }
    }
}

