/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.refactoring.rename.ResolvableCollisionUsageInfo;
import com.intellij.util.IncorrectOperationException;

public class ClassHidesImportedClassUsageInfo
extends ResolvableCollisionUsageInfo {
    private final PsiClass myHiddenClass;
    private final PsiJavaCodeReferenceElement myCollisionReference;

    public ClassHidesImportedClassUsageInfo(PsiJavaCodeReferenceElement collisionReference, PsiClass renamedClass, PsiClass hiddenClass) {
        super((PsiElement)collisionReference, (PsiElement)renamedClass);
        this.myHiddenClass = hiddenClass;
        this.myCollisionReference = collisionReference;
    }

    private boolean isResolvable() {
        return this.myHiddenClass.getQualifiedName() != null;
    }

    public void resolveCollision() throws IncorrectOperationException {
        if (!this.myCollisionReference.isValid()) {
            return;
        }
        PsiManager manager = this.myCollisionReference.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        if (!this.isResolvable()) {
            return;
        }
        String qName = this.myHiddenClass.getQualifiedName();
        if (this.myCollisionReference instanceof PsiReferenceExpression) {
            this.myCollisionReference.replace((PsiElement)factory.createExpressionFromText(qName, (PsiElement)this.myCollisionReference));
        } else {
            this.myCollisionReference.replace((PsiElement)factory.createFQClassNameReferenceElement(qName, this.myCollisionReference.getResolveScope()));
        }
    }
}

