/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.util.XmlTagUtilBase;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameDialog
extends RefactoringDialog {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.RenameDialog");
    private SuggestedNameInfo mySuggestedNameInfo;
    private JLabel myNameLabel;
    private NameSuggestionsField myNameSuggestionsField;
    private JCheckBox myCbSearchInComments;
    private JCheckBox myCbSearchTextOccurences;
    private final JLabel myNewNamePrefix;
    private final String myHelpID;
    private final PsiElement myPsiElement;
    private final PsiElement myNameSuggestionContext;
    private final Editor myEditor;
    private static final String REFACTORING_NAME = RefactoringBundle.message((String)"rename.title");
    private NameSuggestionsField.DataChanged myNameChangedListener;
    private final Map<AutomaticRenamerFactory, JCheckBox> myAutomaticRenamers;

    public RenameDialog(@NotNull Project project, @NotNull PsiElement psiElement, @Nullable PsiElement nameSuggestionContext, Editor editor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/rename/RenameDialog.<init> must not be null");
        }
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/rename/RenameDialog.<init> must not be null");
        }
        super(project, true);
        this.myNewNamePrefix = new JLabel("");
        this.myAutomaticRenamers = new HashMap<AutomaticRenamerFactory, JCheckBox>();
        assert (psiElement.isValid());
        this.myPsiElement = psiElement;
        this.myNameSuggestionContext = nameSuggestionContext;
        this.myEditor = editor;
        this.setTitle(REFACTORING_NAME);
        this.createNewNameComponent();
        this.init();
        this.myNameLabel.setText("<html>" + XmlTagUtilBase.escapeString((String)RefactoringBundle.message((String)"rename.0.and.its.usages.to", (Object[])new Object[]{this.getFullName()}), (boolean)false) + "</html>");
        boolean toSearchInComments = this.isToSearchInCommentsForRename();
        this.myCbSearchInComments.setSelected(toSearchInComments);
        if (this.myCbSearchTextOccurences.isEnabled()) {
            boolean toSearchForTextOccurences = this.isToSearchForTextOccurencesForRename();
            this.myCbSearchTextOccurences.setSelected(toSearchForTextOccurences);
        }
        this.validateButtons();
        this.myHelpID = RenamePsiElementProcessor.forElement(psiElement).getHelpID(psiElement);
    }

    protected void dispose() {
        this.myNameSuggestionsField.removeDataChangedListener(this.myNameChangedListener);
        super.dispose();
    }

    protected boolean isToSearchForTextOccurencesForRename() {
        return RenamePsiElementProcessor.forElement(this.myPsiElement).isToSearchForTextOccurrences(this.myPsiElement);
    }

    protected boolean isToSearchInCommentsForRename() {
        return RenamePsiElementProcessor.forElement(this.myPsiElement).isToSearchInComments(this.myPsiElement);
    }

    private String getFullName() {
        String name = UsageViewUtil.getDescriptiveName(this.myPsiElement);
        return (UsageViewUtil.getType(this.myPsiElement) + " " + name).trim();
    }

    private void createNewNameComponent() {
        String[] suggestedNames = this.getSuggestedNames();
        this.myNameSuggestionsField = new NameSuggestionsField(suggestedNames, this.myProject, (FileType)FileTypes.PLAIN_TEXT, this.myEditor);
        if (this.myPsiElement instanceof PsiFile && this.myEditor == null) {
            this.myNameSuggestionsField.selectNameWithoutExtension();
        }
        this.myNameChangedListener = new NameSuggestionsField.DataChanged(){

            @Override
            public void dataChanged() {
                RenameDialog.this.validateButtons();
            }
        };
        this.myNameSuggestionsField.addDataChangedListener(this.myNameChangedListener);
        this.myNameSuggestionsField.getComponent().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RenameDialog.this.completeVariable(RenameDialog.this.myNameSuggestionsField.getEditor());
            }
        }, KeyStroke.getKeyStroke(32, 2), 2);
    }

    public String[] getSuggestedNames() {
        NameSuggestionProvider[] providers;
        ArrayList<String> result = new ArrayList<String>();
        for (NameSuggestionProvider provider : providers = (NameSuggestionProvider[])Extensions.getExtensions((ExtensionPointName)NameSuggestionProvider.EP_NAME)) {
            SuggestedNameInfo info = provider.getSuggestedNames(this.myPsiElement, this.myNameSuggestionContext, result);
            if (info == null) continue;
            this.mySuggestedNameInfo = info;
        }
        if (result.size() == 0) {
            result.add(UsageViewUtil.getShortName(this.myPsiElement));
        }
        return ArrayUtil.toStringArray(result);
    }

    private void completeVariable(Editor editor) {
        NameSuggestionProvider provider;
        String prefix = this.myNameSuggestionsField.getEnteredName();
        Collection items = null;
        NameSuggestionProvider[] arr$ = (NameSuggestionProvider[])Extensions.getExtensions((ExtensionPointName)NameSuggestionProvider.EP_NAME);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (items = (provider = arr$[i$]).completeName(this.myPsiElement, this.myNameSuggestionContext, prefix)) == null; ++i$) {
        }
        if (items != null) {
            LookupElement[] lookupItems = items.toArray(new LookupElement[items.size()]);
            editor.getCaretModel().moveToOffset(prefix.length());
            editor.getSelectionModel().removeSelection();
            LookupManager.getInstance(this.myProject).showLookup(editor, lookupItems, prefix);
        }
    }

    public String getNewName() {
        return this.myNameSuggestionsField.getEnteredName().trim();
    }

    public boolean isSearchInComments() {
        return this.myCbSearchInComments.isSelected();
    }

    public boolean isSearchInNonJavaFiles() {
        return this.myCbSearchTextOccurences.isSelected();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameSuggestionsField.getFocusableComponent();
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        panel.setBorder(IdeBorderFactory.createBorder());
        gbConstraints.insets = new Insets(4, 8, 4, 8);
        gbConstraints.weighty = 0.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 1;
        this.myNameLabel = new JLabel();
        panel.add((Component)this.myNameLabel, gbConstraints);
        gbConstraints.insets = new Insets(4, 8, 4, "".equals(this.myNewNamePrefix.getText()) ? 0 : 1);
        gbConstraints.gridwidth = 1;
        gbConstraints.fill = 0;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridx = 0;
        gbConstraints.anchor = 17;
        panel.add((Component)this.myNewNamePrefix, gbConstraints);
        gbConstraints.insets = new Insets(4, 8, 4, 8);
        gbConstraints.gridwidth = 2;
        gbConstraints.fill = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridx = 0;
        gbConstraints.weighty = 1.0;
        panel.add((Component)this.myNameSuggestionsField.getComponent(), gbConstraints);
        gbConstraints.insets = new Insets(4, 8, 4, 8);
        gbConstraints.gridwidth = 1;
        gbConstraints.gridx = 0;
        gbConstraints.weighty = 0.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        this.myCbSearchInComments = new NonFocusableCheckBox();
        this.myCbSearchInComments.setText(RefactoringBundle.getSearchInCommentsAndStringsText());
        this.myCbSearchInComments.setSelected(true);
        panel.add((Component)this.myCbSearchInComments, gbConstraints);
        gbConstraints.insets = new Insets(4, 8, 4, 8);
        gbConstraints.gridwidth = 0;
        gbConstraints.gridx = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        this.myCbSearchTextOccurences = new NonFocusableCheckBox();
        this.myCbSearchTextOccurences.setText(RefactoringBundle.getSearchForTextOccurrencesText());
        this.myCbSearchTextOccurences.setSelected(true);
        panel.add((Component)this.myCbSearchTextOccurences, gbConstraints);
        if (!TextOccurrencesUtil.isSearchTextOccurencesEnabled(this.myPsiElement)) {
            this.myCbSearchTextOccurences.setEnabled(false);
            this.myCbSearchTextOccurences.setSelected(false);
            this.myCbSearchTextOccurences.setVisible(false);
        }
        for (AutomaticRenamerFactory factory : (AutomaticRenamerFactory[])Extensions.getExtensions(AutomaticRenamerFactory.EP_NAME)) {
            if (!factory.isApplicable(this.myPsiElement) || factory.getOptionName() == null) continue;
            gbConstraints.insets = new Insets(4, 8, 4, 8);
            gbConstraints.gridwidth = this.myAutomaticRenamers.size() % 2 == 0 ? 1 : 0;
            gbConstraints.gridx = this.myAutomaticRenamers.size() % 2;
            gbConstraints.weightx = 1.0;
            gbConstraints.fill = 1;
            NonFocusableCheckBox checkBox = new NonFocusableCheckBox();
            checkBox.setText(factory.getOptionName());
            checkBox.setSelected(factory.isEnabled());
            panel.add((Component)checkBox, gbConstraints);
            this.myAutomaticRenamers.put(factory, (JCheckBox)checkBox);
        }
        return panel;
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(this.myHelpID);
    }

    @Override
    protected void doAction() {
        LOG.assertTrue(this.myPsiElement.isValid());
        String newName = this.getNewName();
        this.performRename(newName);
    }

    public void performRename(String newName) {
        RenamePsiElementProcessor elementProcessor = RenamePsiElementProcessor.forElement(this.myPsiElement);
        elementProcessor.setToSearchInComments(this.myPsiElement, this.isSearchInComments());
        if (this.myCbSearchTextOccurences.isEnabled()) {
            elementProcessor.setToSearchForTextOccurrences(this.myPsiElement, this.isSearchInNonJavaFiles());
        }
        if (this.mySuggestedNameInfo != null) {
            this.mySuggestedNameInfo.nameChoosen(newName);
        }
        RenameProcessor processor = new RenameProcessor(this.getProject(), this.myPsiElement, newName, this.isSearchInComments(), this.isSearchInNonJavaFiles());
        for (Map.Entry<AutomaticRenamerFactory, JCheckBox> e : this.myAutomaticRenamers.entrySet()) {
            e.getKey().setEnabled(e.getValue().isSelected());
            if (!e.getValue().isSelected()) continue;
            processor.addRenamerFactory(e.getKey());
        }
        this.invokeRefactoring(processor);
    }

    @Override
    protected void canRun() throws ConfigurationException {
        if (!this.areButtonsValid()) {
            throw new ConfigurationException("'" + StringUtil.first((String)this.getNewName(), (int)10, (boolean)true) + "' is invalid identifier");
        }
    }

    @Override
    protected boolean areButtonsValid() {
        String newName = this.getNewName();
        return RenameUtil.isValidName(this.myProject, this.myPsiElement, newName);
    }
}

