/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.RefactoringDescriptionLocation;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class RefactoringUIUtil {
    private RefactoringUIUtil() {
    }

    public static String getDescription(@NotNull PsiElement element, boolean includeParent) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/util/RefactoringUIUtil.getDescription must not be null");
        }
        return ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)(includeParent ? RefactoringDescriptionLocation.WITH_PARENT : RefactoringDescriptionLocation.WITHOUT_PARENT));
    }

    public static void processIncorrectOperation(final Project project, IncorrectOperationException e) {
        int index;
        String message = e.getMessage();
        int n = index = message != null ? message.indexOf("java.io.IOException") : -1;
        if (index > 0) {
            message = message.substring(index + "java.io.IOException".length());
        }
        final String s = message;
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                Messages.showMessageDialog((Project)project, (String)s, (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon());
            }
        });
    }

    public static String calculatePsiElementDescriptionList(PsiElement[] elements) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < elements.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(UsageViewUtil.getType(elements[i]));
            buffer.append(" ");
            buffer.append(UsageViewUtil.getDescriptiveName(elements[i]));
        }
        return buffer.toString();
    }
}

