/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiNonJavaFileReferenceProcessor;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.refactoring.util.NonCodeSearchDescriptionLocation;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TextOccurrencesUtil {
    private TextOccurrencesUtil() {
    }

    public static void addTextOccurences(@NotNull PsiElement element, @NotNull String stringToSearch, @NotNull GlobalSearchScope searchScope, final @NotNull List<UsageInfo> results, @NotNull UsageInfoFactory factory) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/util/TextOccurrencesUtil.addTextOccurences must not be null");
        }
        if (stringToSearch == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/util/TextOccurrencesUtil.addTextOccurences must not be null");
        }
        if (searchScope == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/refactoring/util/TextOccurrencesUtil.addTextOccurences must not be null");
        }
        if (results == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/refactoring/util/TextOccurrencesUtil.addTextOccurences must not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/refactoring/util/TextOccurrencesUtil.addTextOccurences must not be null");
        }
        TextOccurrencesUtil.processTextOccurences(element, stringToSearch, searchScope, new Processor<UsageInfo>(){

            public boolean process(UsageInfo t) {
                results.add(t);
                return true;
            }
        }, factory);
    }

    public static void processTextOccurences(@NotNull PsiElement element, @NotNull String stringToSearch, @NotNull GlobalSearchScope searchScope, final @NotNull Processor<UsageInfo> processor, final @NotNull UsageInfoFactory factory) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/util/TextOccurrencesUtil.processTextOccurences must not be null");
        }
        if (stringToSearch == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/util/TextOccurrencesUtil.processTextOccurences must not be null");
        }
        if (searchScope == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/refactoring/util/TextOccurrencesUtil.processTextOccurences must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/refactoring/util/TextOccurrencesUtil.processTextOccurences must not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/refactoring/util/TextOccurrencesUtil.processTextOccurences must not be null");
        }
        PsiSearchHelper helper = element.getManager().getSearchHelper();
        helper.processUsagesInNonJavaFiles(element, stringToSearch, new PsiNonJavaFileReferenceProcessor(){

            public boolean process(PsiFile psiFile, int startOffset, int endOffset) {
                UsageInfo usageInfo = factory.createUsageInfo((PsiElement)psiFile, startOffset, endOffset);
                return usageInfo == null || processor.process((Object)usageInfo);
            }
        }, searchScope);
    }

    private static boolean processStringLiteralsContainingIdentifier(@NotNull String identifier, @NotNull SearchScope searchScope, PsiSearchHelper helper, final Processor<PsiElement> processor) {
        if (identifier == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/util/TextOccurrencesUtil.processStringLiteralsContainingIdentifier must not be null");
        }
        if (searchScope == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/util/TextOccurrencesUtil.processStringLiteralsContainingIdentifier must not be null");
        }
        TextOccurenceProcessor occurenceProcessor = new TextOccurenceProcessor(){

            public boolean execute(PsiElement element, int offsetInElement) {
                ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(element.getLanguage());
                ASTNode node = element.getNode();
                if (node != null && definition.getStringLiteralElements().contains(node.getElementType())) {
                    return processor.process((Object)element);
                }
                return true;
            }
        };
        return helper.processElementsWithWord(occurenceProcessor, searchScope, identifier, (short)4, true);
    }

    public static boolean processUsagesInStringsAndComments(@NotNull PsiElement element, final @NotNull String stringToSearch, final boolean ignoreReferences, final @NotNull PairProcessor<PsiElement, TextRange> processor) {
        Processor<PsiElement> commentOrLiteralProcessor;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/util/TextOccurrencesUtil.processUsagesInStringsAndComments must not be null");
        }
        if (stringToSearch == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/util/TextOccurrencesUtil.processUsagesInStringsAndComments must not be null");
        }
        if (processor == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/refactoring/util/TextOccurrencesUtil.processUsagesInStringsAndComments must not be null");
        }
        PsiManager manager = element.getManager();
        PsiSearchHelper helper = manager.getSearchHelper();
        SearchScope scope = element.getUseScope();
        return TextOccurrencesUtil.processStringLiteralsContainingIdentifier(stringToSearch, scope = scope.intersectWith((SearchScope)GlobalSearchScope.projectScope((Project)manager.getProject())), helper, commentOrLiteralProcessor = new Processor<PsiElement>(){

            public boolean process(PsiElement literal) {
                return TextOccurrencesUtil.processTextIn(literal, stringToSearch, ignoreReferences, (PairProcessor<PsiElement, TextRange>)processor);
            }
        }) && helper.processCommentsContainingIdentifier(stringToSearch, scope, (Processor)commentOrLiteralProcessor);
    }

    public static void addUsagesInStringsAndComments(@NotNull PsiElement element, @NotNull String stringToSearch, final @NotNull List<UsageInfo> results, final @NotNull UsageInfoFactory factory) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/util/TextOccurrencesUtil.addUsagesInStringsAndComments must not be null");
        }
        if (stringToSearch == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/util/TextOccurrencesUtil.addUsagesInStringsAndComments must not be null");
        }
        if (results == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/refactoring/util/TextOccurrencesUtil.addUsagesInStringsAndComments must not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/refactoring/util/TextOccurrencesUtil.addUsagesInStringsAndComments must not be null");
        }
        TextOccurrencesUtil.processUsagesInStringsAndComments(element, stringToSearch, false, new PairProcessor<PsiElement, TextRange>(){

            public boolean process(PsiElement commentOrLiteral, TextRange textRange) {
                UsageInfo usageInfo = factory.createUsageInfo(commentOrLiteral, textRange.getStartOffset(), textRange.getEndOffset());
                if (usageInfo != null) {
                    results.add(usageInfo);
                }
                return true;
            }
        });
    }

    private static boolean processTextIn(PsiElement scope, String stringToSearch, boolean ignoreReferences, PairProcessor<PsiElement, TextRange> processor) {
        String text = scope.getText();
        for (int offset = 0; offset < text.length() && (offset = text.indexOf(stringToSearch, offset)) >= 0; ++offset) {
            char c;
            PsiReference referenceAt = scope.findReferenceAt(offset);
            if (!ignoreReferences && referenceAt != null && referenceAt.resolve() != null || offset > 0 && Character.isJavaIdentifierPart(c = text.charAt(offset - 1)) && c != '$' && (offset < 2 || text.charAt(offset - 2) != '\\') || offset + stringToSearch.length() < text.length() && Character.isJavaIdentifierPart(c = text.charAt(offset + stringToSearch.length())) && c != '$') continue;
            TextRange textRange = new TextRange(offset, offset + stringToSearch.length());
            if (!processor.process((Object)scope, (Object)textRange)) {
                return false;
            }
            offset += stringToSearch.length();
        }
        return true;
    }

    public static boolean isSearchTextOccurencesEnabled(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/util/TextOccurrencesUtil.isSearchTextOccurencesEnabled must not be null");
        }
        return ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)NonCodeSearchDescriptionLocation.NON_JAVA) != null;
    }

    public static interface UsageInfoFactory {
        public UsageInfo createUsageInfo(@NotNull PsiElement var1, int var2, int var3);
    }
}

