/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.wrapreturnvalue;

import com.intellij.ide.util.PackageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.RefactorJBundle;
import com.intellij.refactoring.psi.PropertyUtils;
import com.intellij.refactoring.psi.TypeParametersVisitor;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.refactoring.util.FixableUsagesRefactoringProcessor;
import com.intellij.refactoring.wrapreturnvalue.ReturnValueBeanBuilder;
import com.intellij.refactoring.wrapreturnvalue.WrapReturnValueUsageViewDescriptor;
import com.intellij.refactoring.wrapreturnvalue.usageInfo.ChangeReturnType;
import com.intellij.refactoring.wrapreturnvalue.usageInfo.ReturnWrappedValue;
import com.intellij.refactoring.wrapreturnvalue.usageInfo.UnwrapCall;
import com.intellij.refactoring.wrapreturnvalue.usageInfo.WrapReturnValue;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class WrapReturnValueProcessor
extends FixableUsagesRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance((String)"com.siyeh.rpp.wrapreturnvalue.WrapReturnValueProcessor");
    private final PsiMethod method;
    private final String className;
    private final String packageName;
    private final boolean myCreateInnerClass;
    private final PsiField myDelegateField;
    private final String myQualifiedName;
    private final boolean myUseExistingClass;
    private final List<PsiTypeParameter> typeParams;
    @NonNls
    private final String unwrapMethodName;

    public WrapReturnValueProcessor(String className, String packageName, PsiMethod method, boolean useExistingClass, boolean createInnerClass, PsiField delegateField) {
        super(method.getProject());
        this.method = method;
        this.className = className;
        this.packageName = packageName;
        this.myCreateInnerClass = createInnerClass;
        this.myDelegateField = delegateField;
        this.myQualifiedName = StringUtil.getQualifiedName((String)packageName, (String)className);
        this.myUseExistingClass = useExistingClass;
        HashSet<PsiTypeParameter> typeParamSet = new HashSet<PsiTypeParameter>();
        TypeParametersVisitor visitor = new TypeParametersVisitor(typeParamSet);
        PsiTypeElement returnTypeElement = method.getReturnTypeElement();
        assert (returnTypeElement != null);
        returnTypeElement.accept((PsiElementVisitor)visitor);
        this.typeParams = new ArrayList<PsiTypeParameter>(typeParamSet);
        this.unwrapMethodName = useExistingClass ? this.calculateUnwrapMethodName() : "getValue";
    }

    private String calculateUnwrapMethodName() {
        PsiClass existingClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(this.myQualifiedName, GlobalSearchScope.allScope((Project)this.myProject));
        if (existingClass != null) {
            if (TypeConversionUtil.isPrimitiveWrapper((String)this.myQualifiedName)) {
                PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory().createType(existingClass));
                assert (unboxedType != null);
                return unboxedType.getCanonicalText() + "Value()";
            }
            PsiMethod getter = PropertyUtils.findGetterForField(this.myDelegateField);
            return getter != null ? getter.getName() : "";
        }
        return "";
    }

    @Override
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo[] usageInfos) {
        return new WrapReturnValueUsageViewDescriptor(this.method, usageInfos);
    }

    @Override
    public void findUsages(@NotNull List<FixableUsageInfo> usages) {
        if (usages == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/wrapreturnvalue/WrapReturnValueProcessor.findUsages must not be null");
        }
        this.findUsagesForMethod(this.method, usages);
        for (PsiMethod overridingMethod : OverridingMethodsSearch.search((PsiMethod)this.method)) {
            this.findUsagesForMethod(overridingMethod, usages);
        }
    }

    private void findUsagesForMethod(PsiMethod psiMethod, List<FixableUsageInfo> usages) {
        for (PsiReference reference : ReferencesSearch.search((PsiElement)psiMethod, (SearchScope)psiMethod.getUseScope())) {
            PsiElement referenceElement = reference.getElement();
            PsiElement parent = referenceElement.getParent();
            if (!(parent instanceof PsiCallExpression)) continue;
            usages.add(new UnwrapCall((PsiCallExpression)parent, this.unwrapMethodName));
        }
        String returnType = this.calculateReturnTypeString();
        usages.add(new ChangeReturnType(psiMethod, returnType));
        psiMethod.accept((PsiElementVisitor)new ReturnSearchVisitor(usages, returnType, psiMethod));
    }

    private String calculateReturnTypeString() {
        String qualifiedName = StringUtil.getQualifiedName((String)this.packageName, (String)this.className);
        StringBuilder returnTypeBuffer = new StringBuilder(qualifiedName);
        if (!this.typeParams.isEmpty()) {
            returnTypeBuffer.append('<');
            returnTypeBuffer.append(StringUtil.join(this.typeParams, (Function)new Function<PsiTypeParameter, String>(){

                public String fun(PsiTypeParameter typeParameter) {
                    String paramName = typeParameter.getName();
                    LOG.assertTrue(paramName != null);
                    return paramName;
                }
            }, (String)","));
            returnTypeBuffer.append('>');
        }
        return returnTypeBuffer.toString();
    }

    @Override
    protected boolean preprocessUsages(Ref<UsageInfo[]> refUsages) {
        MultiMap conflicts = new MultiMap();
        PsiClass existingClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(this.myQualifiedName, GlobalSearchScope.allScope((Project)this.myProject));
        if (this.myUseExistingClass) {
            if (existingClass == null) {
                conflicts.putValue((Object)existingClass, (Object)RefactorJBundle.message("could.not.find.selected.wrapping.class", new Object[0]));
            } else {
                PsiMethod[] constructors;
                boolean foundConstructor = false;
                final HashSet<PsiType> returnTypes = new HashSet<PsiType>();
                returnTypes.add(this.method.getReturnType());
                PsiCodeBlock methodBody = this.method.getBody();
                if (methodBody != null) {
                    methodBody.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                        public void visitReturnStatement(PsiReturnStatement statement) {
                            super.visitReturnStatement(statement);
                            if (PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class) != WrapReturnValueProcessor.this.method) {
                                return;
                            }
                            PsiExpression returnValue = statement.getReturnValue();
                            if (returnValue != null) {
                                returnTypes.add(returnValue.getType());
                            }
                        }
                    });
                }
                block0: for (PsiMethod constructor : constructors = existingClass.getConstructors()) {
                    PsiParameter[] parameters = constructor.getParameterList().getParameters();
                    if (parameters.length != 1) continue;
                    final PsiParameter parameter = parameters[0];
                    PsiType parameterType = parameter.getType();
                    for (PsiType returnType : returnTypes) {
                        if (TypeConversionUtil.isAssignable((PsiType)parameterType, (PsiType)returnType)) continue;
                        continue block0;
                    }
                    PsiCodeBlock body = constructor.getBody();
                    LOG.assertTrue(body != null);
                    final boolean[] found = new boolean[1];
                    body.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
                            PsiExpression rExpression;
                            super.visitAssignmentExpression(expression);
                            PsiExpression lExpression = expression.getLExpression();
                            if (lExpression instanceof PsiReferenceExpression && ((PsiReferenceExpression)lExpression).resolve() == WrapReturnValueProcessor.this.myDelegateField && (rExpression = expression.getRExpression()) instanceof PsiReferenceExpression && ((PsiReferenceExpression)rExpression).resolve() == parameter) {
                                found[0] = true;
                            }
                        }
                    });
                    if (!found[0]) continue;
                    foundConstructor = true;
                    break;
                }
                if (!foundConstructor) {
                    conflicts.putValue((Object)existingClass, (Object)"Existing class does not have appropriate constructor");
                }
            }
            if (this.unwrapMethodName.length() == 0) {
                conflicts.putValue((Object)existingClass, (Object)"Existing class does not have getter for selected field");
            }
        } else if (existingClass != null) {
            conflicts.putValue((Object)existingClass, (Object)RefactorJBundle.message("there.already.exists.a.class.with.the.selected.name", new Object[0]));
        }
        return this.showConflicts((MultiMap<PsiElement, String>)conflicts);
    }

    @Override
    protected void performRefactoring(UsageInfo[] usageInfos) {
        if (!this.myUseExistingClass && !this.buildClass()) {
            return;
        }
        super.performRefactoring(usageInfos);
    }

    private boolean buildClass() {
        block6: {
            String classString;
            PsiManager manager = this.method.getManager();
            Project project = this.method.getProject();
            ReturnValueBeanBuilder beanClassBuilder = new ReturnValueBeanBuilder();
            beanClassBuilder.setCodeStyleSettings(project);
            beanClassBuilder.setTypeArguments(this.typeParams);
            beanClassBuilder.setClassName(this.className);
            beanClassBuilder.setPackageName(this.packageName);
            beanClassBuilder.setStatic(this.myCreateInnerClass && this.method.hasModifierProperty("static"));
            PsiType returnType = this.method.getReturnType();
            beanClassBuilder.setValueType(returnType);
            try {
                classString = beanClassBuilder.buildBeanClass();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return false;
            }
            try {
                PsiJavaFile psiFile = (PsiJavaFile)PsiFileFactory.getInstance((Project)project).createFileFromText(this.className + ".java", classString);
                CodeStyleManager codeStyleManager = manager.getCodeStyleManager();
                if (this.myCreateInnerClass) {
                    PsiClass containingClass = this.method.getContainingClass();
                    PsiElement innerClass = containingClass.add((PsiElement)psiFile.getClasses()[0]);
                    JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(innerClass);
                    break block6;
                }
                PsiFile containingFile = this.method.getContainingFile();
                PsiDirectory containingDirectory = containingFile.getContainingDirectory();
                Module module = ModuleUtil.findModuleForPsiElement((PsiElement)containingFile);
                PsiDirectory directory = PackageUtil.findOrCreateDirectoryForPackage(module, this.packageName, containingDirectory, true);
                if (directory != null) {
                    PsiElement shortenedFile = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)psiFile);
                    PsiElement reformattedFile = codeStyleManager.reformat(shortenedFile);
                    directory.add(reformattedFile);
                    break block6;
                }
                return false;
            }
            catch (IncorrectOperationException e) {
                LOG.info((Throwable)e);
                return false;
            }
        }
        return true;
    }

    @Override
    protected String getCommandName() {
        PsiClass containingClass = this.method.getContainingClass();
        return RefactorJBundle.message("wrapped.return.command.name", this.className, containingClass.getName(), Character.valueOf('.'), this.method.getName());
    }

    private class ReturnSearchVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final List<FixableUsageInfo> usages;
        private final String type;
        private final PsiMethod myMethod;

        ReturnSearchVisitor(List<FixableUsageInfo> usages, String type, PsiMethod psiMethod) {
            this.usages = usages;
            this.type = type;
            this.myMethod = psiMethod;
        }

        public void visitReturnStatement(PsiReturnStatement statement) {
            PsiMethodCallExpression callExpression;
            super.visitReturnStatement(statement);
            if (PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class) != this.myMethod) {
                return;
            }
            PsiExpression returnValue = statement.getReturnValue();
            if (WrapReturnValueProcessor.this.myUseExistingClass && returnValue instanceof PsiMethodCallExpression && (callExpression = (PsiMethodCallExpression)returnValue).getArgumentList().getExpressions().length == 0) {
                PsiType qualifierType;
                PsiExpression qualifier;
                PsiReferenceExpression callMethodExpression = callExpression.getMethodExpression();
                String methodName = callMethodExpression.getReferenceName();
                if (Comparing.strEqual((String)WrapReturnValueProcessor.this.unwrapMethodName, (String)methodName) && (qualifier = callMethodExpression.getQualifierExpression()) != null && (qualifierType = qualifier.getType()) != null && qualifierType.getCanonicalText().equals(WrapReturnValueProcessor.this.myQualifiedName)) {
                    this.usages.add(new ReturnWrappedValue(statement));
                    return;
                }
            }
            this.usages.add(new WrapReturnValue(statement, this.type));
        }
    }
}

