/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.WalkingState;
import com.intellij.psi.util.PsiUtil;
import com.intellij.slicer.SliceLeafAnalyzer;
import com.intellij.slicer.SliceLeafValueClassNode;
import com.intellij.slicer.SliceLeafValueRootNode;
import com.intellij.slicer.SliceManager;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceRootNode;
import com.intellij.slicer.SliceUsage;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.FactoryMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SliceNullnessAnalyzer {
    private static void groupByNullness(NullAnalysisResult result, SliceRootNode oldRoot, Map<SliceNode, NullAnalysisResult> map) {
        SliceRootNode root = SliceNullnessAnalyzer.createNewTree(result, oldRoot, map);
        SliceUsage rootUsage = (SliceUsage)((Object)((SliceNode)oldRoot.myCachedChildren.get(0)).getValue());
        SliceManager.getInstance(root.getProject()).createToolWindow(true, root, true, SliceManager.getElementDescription(null, rootUsage.getElement(), " Grouped by Nullness"));
    }

    public static SliceRootNode createNewTree(NullAnalysisResult result, SliceRootNode oldRoot, Map<SliceNode, NullAnalysisResult> map) {
        SliceRootNode root = oldRoot.copy();
        assert (oldRoot.myCachedChildren.size() == 1);
        SliceNode oldRootStart = (SliceNode)oldRoot.myCachedChildren.get(0);
        root.setChanged();
        root.targetEqualUsages.clear();
        root.myCachedChildren = new ArrayList();
        SliceNullnessAnalyzer.createValueRootNode(result, oldRoot, map, root, oldRootStart, "Null Values", NullAnalysisResult.NULLS);
        SliceNullnessAnalyzer.createValueRootNode(result, oldRoot, map, root, oldRootStart, "NotNull Values", NullAnalysisResult.NOT_NULLS);
        SliceNullnessAnalyzer.createValueRootNode(result, oldRoot, map, root, oldRootStart, "Other Values", NullAnalysisResult.UNKNOWNS);
        return root;
    }

    private static void createValueRootNode(NullAnalysisResult result, SliceRootNode oldRoot, final Map<SliceNode, NullAnalysisResult> map, SliceRootNode root, SliceNode oldRootStart, String nodeName, final int group) {
        Collection<PsiElement> groupedByValue = result.groupedByValue[group];
        if (groupedByValue.isEmpty()) {
            return;
        }
        SliceLeafValueClassNode valueRoot = new SliceLeafValueClassNode(root.getProject(), root, nodeName);
        root.myCachedChildren.add(valueRoot);
        THashSet uniqueValues = new THashSet(groupedByValue, SliceLeafAnalyzer.LEAF_ELEMENT_EQUALITY);
        for (final PsiElement expression : uniqueValues) {
            SliceNode newRoot = SliceLeafAnalyzer.filterTree(oldRootStart, new NullableFunction<SliceNode, SliceNode>(){

                public SliceNode fun(SliceNode oldNode) {
                    if (oldNode.getDuplicate() != null) {
                        return null;
                    }
                    for (PsiElement nullSuspect : SliceNullnessAnalyzer.group(oldNode, map, group)) {
                        if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)nullSuspect, (PsiElement)expression)) continue;
                        return oldNode.copy();
                    }
                    return null;
                }
            }, new PairProcessor<SliceNode, List<SliceNode>>(){

                public boolean process(SliceNode node, List<SliceNode> children) {
                    if (!children.isEmpty()) {
                        return true;
                    }
                    PsiElement element = ((SliceUsage)((Object)node.getValue())).getElement();
                    if (element == null) {
                        return false;
                    }
                    return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)element, (PsiElement)expression);
                }
            });
            valueRoot.myCachedChildren.add(new SliceLeafValueRootNode(root.getProject(), expression, valueRoot, Collections.singletonList(newRoot), ((SliceUsage)((Object)oldRoot.getValue())).params));
        }
    }

    public static void startAnalyzeNullness(final AbstractTreeStructure treeStructure, final Runnable finish) {
        final SliceRootNode root = (SliceRootNode)treeStructure.getRootElement();
        final Ref leafExpressions = Ref.create(null);
        final Map<SliceNode, NullAnalysisResult> map = SliceNullnessAnalyzer.createMap();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(root.getProject(), "Expanding all nodes... (may very well take the whole day)", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/slicer/SliceNullnessAnalyzer$3.run must not be null");
                }
                NullAnalysisResult l = SliceNullnessAnalyzer.calcNullableLeaves(root, treeStructure, map);
                leafExpressions.set((Object)l);
            }

            public void onCancel() {
                finish.run();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess() {
                try {
                    NullAnalysisResult leaves = (NullAnalysisResult)leafExpressions.get();
                    if (leaves == null) {
                        return;
                    }
                    SliceNullnessAnalyzer.groupByNullness(leaves, root, map);
                }
                finally {
                    finish.run();
                }
            }
        });
    }

    public static Map<SliceNode, NullAnalysisResult> createMap() {
        return new FactoryMap<SliceNode, NullAnalysisResult>(){

            protected NullAnalysisResult create(SliceNode key) {
                return new NullAnalysisResult();
            }

            protected Map<SliceNode, NullAnalysisResult> createMap() {
                return new THashMap(TObjectHashingStrategy.IDENTITY);
            }
        };
    }

    private static NullAnalysisResult node(SliceNode node, Map<SliceNode, NullAnalysisResult> nulls) {
        return nulls.get(node);
    }

    private static Collection<PsiElement> group(SliceNode node, Map<SliceNode, NullAnalysisResult> nulls, int group) {
        return nulls.get((Object)node).groupedByValue[group];
    }

    @NotNull
    public static NullAnalysisResult calcNullableLeaves(@NotNull SliceNode root, @NotNull AbstractTreeStructure treeStructure, final Map<SliceNode, NullAnalysisResult> map) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/slicer/SliceNullnessAnalyzer.calcNullableLeaves must not be null");
        }
        if (treeStructure == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/slicer/SliceNullnessAnalyzer.calcNullableLeaves must not be null");
        }
        final SliceLeafAnalyzer.SliceNodeGuide guide = new SliceLeafAnalyzer.SliceNodeGuide(treeStructure);
        WalkingState<SliceNode> walkingState = new WalkingState<SliceNode>((WalkingState.TreeGuide)guide){

            public void visit(@NotNull SliceNode element) {
                if (element == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/slicer/SliceNullnessAnalyzer$5.visit must not be null");
                }
                element.calculateDupNode();
                SliceNullnessAnalyzer.node(element, map).clear();
                SliceNode duplicate = element.getDuplicate();
                if (duplicate != null) {
                    SliceNullnessAnalyzer.node(element, map).add(SliceNullnessAnalyzer.node(duplicate, map));
                } else {
                    SliceUsage sliceUsage = (SliceUsage)((Object)element.getValue());
                    final PsiElement value = sliceUsage.getElement();
                    DfaUtil.Nullness nullness = (DfaUtil.Nullness)((Object)ApplicationManager.getApplication().runReadAction((Computable)new Computable<DfaUtil.Nullness>(){

                        public DfaUtil.Nullness compute() {
                            return SliceNullnessAnalyzer.checkNullness(value);
                        }
                    }));
                    if (nullness == DfaUtil.Nullness.NULL) {
                        SliceNullnessAnalyzer.group(element, map, NullAnalysisResult.NULLS).add(value);
                    } else if (nullness == DfaUtil.Nullness.NOT_NULL) {
                        SliceNullnessAnalyzer.group(element, map, NullAnalysisResult.NOT_NULLS).add(value);
                    } else {
                        Collection<? extends AbstractTreeNode> children = element.getChildren();
                        if (children.isEmpty()) {
                            SliceNullnessAnalyzer.group(element, map, NullAnalysisResult.UNKNOWNS).add(value);
                        }
                        super.visit((Object)element);
                    }
                }
            }

            public void elementFinished(@NotNull SliceNode element) {
                if (element == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/slicer/SliceNullnessAnalyzer$5.elementFinished must not be null");
                }
                SliceNode parent = guide.getParent(element);
                if (parent != null) {
                    SliceNullnessAnalyzer.node(parent, map).add(SliceNullnessAnalyzer.node(element, map));
                }
            }
        };
        walkingState.visit((Object)root);
        NullAnalysisResult nullAnalysisResult = SliceNullnessAnalyzer.node(root, map);
        if (nullAnalysisResult == null) {
            throw new IllegalStateException("@NotNull method com/intellij/slicer/SliceNullnessAnalyzer.calcNullableLeaves must not return null");
        }
        return nullAnalysisResult;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static DfaUtil.Nullness checkNullness(PsiElement element) {
        DfaUtil.Nullness result;
        DfaUtil.Nullness nullness;
        PsiElement value = element;
        if (value instanceof PsiExpression) {
            value = PsiUtil.deparenthesizeExpression((PsiExpression)((PsiExpression)value));
        }
        if (value instanceof PsiLiteralExpression) {
            nullness = ((PsiLiteralExpression)value).getValue() == null ? DfaUtil.Nullness.NULL : DfaUtil.Nullness.NOT_NULL;
            if (nullness == null) throw new IllegalStateException("@NotNull method com/intellij/slicer/SliceNullnessAnalyzer.checkNullness must not return null");
            return nullness;
        }
        if (value instanceof PsiNewExpression) {
            nullness = DfaUtil.Nullness.NOT_NULL;
            if (nullness == null) throw new IllegalStateException("@NotNull method com/intellij/slicer/SliceNullnessAnalyzer.checkNullness must not return null");
            return nullness;
        }
        if (value instanceof PsiThisExpression) {
            nullness = DfaUtil.Nullness.NOT_NULL;
            if (nullness == null) throw new IllegalStateException("@NotNull method com/intellij/slicer/SliceNullnessAnalyzer.checkNullness must not return null");
            return nullness;
        }
        if (value instanceof PsiMethodCallExpression) {
            PsiMethod method = ((PsiMethodCallExpression)value).resolveMethod();
            if (method != null && AnnotationUtil.isNotNull((PsiModifierListOwner)method)) {
                nullness = DfaUtil.Nullness.NOT_NULL;
                if (nullness == null) throw new IllegalStateException("@NotNull method com/intellij/slicer/SliceNullnessAnalyzer.checkNullness must not return null");
                return nullness;
            }
            if (method != null && AnnotationUtil.isNullable((PsiModifierListOwner)method)) {
                nullness = DfaUtil.Nullness.NULL;
                if (nullness == null) throw new IllegalStateException("@NotNull method com/intellij/slicer/SliceNullnessAnalyzer.checkNullness must not return null");
                return nullness;
            }
        }
        if (value instanceof PsiBinaryExpression && ((PsiBinaryExpression)value).getOperationTokenType() == JavaTokenType.PLUS) {
            nullness = DfaUtil.Nullness.NOT_NULL;
            if (nullness == null) throw new IllegalStateException("@NotNull method com/intellij/slicer/SliceNullnessAnalyzer.checkNullness must not return null");
            return nullness;
        }
        PsiElement context = value;
        if (value instanceof PsiReference) {
            PsiElement resolved = ((PsiReference)value).resolve();
            if (resolved instanceof PsiCompiledElement) {
                resolved = resolved.getNavigationElement();
            }
            value = resolved;
        }
        if (value instanceof PsiParameter && ((PsiParameter)value).getDeclarationScope() instanceof PsiCatchSection) {
            nullness = DfaUtil.Nullness.NOT_NULL;
            if (nullness == null) throw new IllegalStateException("@NotNull method com/intellij/slicer/SliceNullnessAnalyzer.checkNullness must not return null");
            return nullness;
        }
        if ((value instanceof PsiLocalVariable || value instanceof PsiParameter) && (result = DfaUtil.checkNullness((PsiVariable)value, context)) != DfaUtil.Nullness.UNKNOWN) {
            nullness = result;
            if (nullness == null) throw new IllegalStateException("@NotNull method com/intellij/slicer/SliceNullnessAnalyzer.checkNullness must not return null");
            return nullness;
        }
        if (value instanceof PsiModifierListOwner) {
            if (AnnotationUtil.isNotNull((PsiModifierListOwner)((PsiModifierListOwner)value))) {
                nullness = DfaUtil.Nullness.NOT_NULL;
                if (nullness == null) throw new IllegalStateException("@NotNull method com/intellij/slicer/SliceNullnessAnalyzer.checkNullness must not return null");
                return nullness;
            }
            if (AnnotationUtil.isNullable((PsiModifierListOwner)((PsiModifierListOwner)value))) {
                nullness = DfaUtil.Nullness.NULL;
                if (nullness == null) throw new IllegalStateException("@NotNull method com/intellij/slicer/SliceNullnessAnalyzer.checkNullness must not return null");
                return nullness;
            }
        }
        if (value instanceof PsiEnumConstant) {
            nullness = DfaUtil.Nullness.NOT_NULL;
            if (nullness == null) throw new IllegalStateException("@NotNull method com/intellij/slicer/SliceNullnessAnalyzer.checkNullness must not return null");
            return nullness;
        }
        nullness = DfaUtil.Nullness.UNKNOWN;
        if (nullness != null) return nullness;
        throw new IllegalStateException("@NotNull method com/intellij/slicer/SliceNullnessAnalyzer.checkNullness must not return null");
    }

    public static class NullAnalysisResult {
        public static int NULLS = 0;
        public static int NOT_NULLS = 1;
        public static int UNKNOWNS = 2;
        public final Collection<PsiElement>[] groupedByValue = new Collection[]{new THashSet(), new THashSet(), new THashSet()};

        public void clear() {
            for (Collection<PsiElement> elements : this.groupedByValue) {
                elements.clear();
            }
        }

        public void add(NullAnalysisResult duplicate) {
            for (int i = 0; i < this.groupedByValue.length; ++i) {
                Collection<PsiElement> elements = this.groupedByValue[i];
                Collection<PsiElement> other = duplicate.groupedByValue[i];
                elements.addAll(other);
            }
        }
    }
}

