/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.slicer.SliceLeafAnalyzer;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceNullnessAnalyzer;
import com.intellij.slicer.SliceTreeStructure;
import com.intellij.slicer.SliceUsage;
import java.util.Comparator;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;

public class SliceTreeBuilder
extends AbstractTreeBuilder {
    public final boolean splitByLeafExpressions;
    public final boolean dataFlowToThis;
    public volatile boolean analysisInProgress;
    public static final Comparator<NodeDescriptor> SLICE_NODE_COMPARATOR = new Comparator<NodeDescriptor>(){

        @Override
        public int compare(NodeDescriptor o1, NodeDescriptor o2) {
            PsiFile file2;
            if (!(o1 instanceof SliceNode) || !(o2 instanceof SliceNode)) {
                return AlphaComparator.INSTANCE.compare(o1, o2);
            }
            SliceNode node1 = (SliceNode)o1;
            SliceNode node2 = (SliceNode)o2;
            SliceUsage usage1 = (SliceUsage)((Object)node1.getValue());
            SliceUsage usage2 = (SliceUsage)((Object)node2.getValue());
            PsiElement element1 = usage1.getElement();
            PsiElement element2 = usage2.getElement();
            PsiFile file1 = element1 == null ? null : element1.getContainingFile();
            PsiFile psiFile = file2 = element2 == null ? null : element2.getContainingFile();
            if (file1 == null) {
                return file2 == null ? 0 : 1;
            }
            if (file2 == null) {
                return -1;
            }
            if (file1 == file2) {
                return element1.getTextOffset() - element2.getTextOffset();
            }
            return Comparing.compare((Comparable)((Object)file1.getName()), (Comparable)((Object)file2.getName()));
        }
    };

    public SliceTreeBuilder(JTree tree, Project project, boolean dataFlowToThis, SliceNode rootNode, boolean splitByLeafExpressions) {
        super(tree, (DefaultTreeModel)tree.getModel(), (AbstractTreeStructure)new SliceTreeStructure(project, rootNode), SLICE_NODE_COMPARATOR, false);
        this.dataFlowToThis = dataFlowToThis;
        this.splitByLeafExpressions = splitByLeafExpressions;
        this.initRootNode();
    }

    public SliceNode getRootSliceNode() {
        return (SliceNode)this.getTreeStructure().getRootElement();
    }

    protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
        return false;
    }

    public void switchToSplittedNodes(AbstractTreeStructure treeStructure) {
        this.analysisInProgress = true;
        SliceLeafAnalyzer.startAnalyzeValues(this.getTreeStructure(), new Runnable(){

            @Override
            public void run() {
                SliceTreeBuilder.this.analysisInProgress = false;
            }
        });
    }

    public void switchToLeafNulls() {
        this.analysisInProgress = true;
        SliceNullnessAnalyzer.startAnalyzeNullness(this.getTreeStructure(), new Runnable(){

            @Override
            public void run() {
                SliceTreeBuilder.this.analysisInProgress = false;
            }
        });
    }
}

